#!/usr/bin/perl
##############################################################################
# Cliff's Hangman Version 1.0                                                #
# Copyright 1998 Shaven Ferret Productions                                   #
# Created 10/18/98                                                           #
# Available at http://www.shavenferret.com/scripts                           #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1998 Shaven Ferret Productions All Rights Reserved.              #
#                                                                            #
# This script can be used\modified free of charge as long as you don't       #
# change this header, the part that makes the return link, and any parts     #
# that call the part that makes the return link.  If you really need to      #
# remove the return link, go to                                              #
# http://www.shavenferret.com/scripts/register.shtml .  By using this script #
# you agree to indemnify me from any liability that might arise from its use.#
#                                                                            #
# Redistributing\selling the code for this program without prior written     #
# consent is expressly forbidden.                                            #
##############################################################################

# If the text file containing the words and phrases that will be used in the
# game are not in the same directory as this script, enter the server path
# (not the URL) to the file.
$wordfile = "hangman.txt";

# If these words involve a common theme, enter that here.
$clue = "words that could be found on page 363 of my dictionary";

# Set the next variable to the URL of the directory that contains the images.
# Do not include a trailing slash.
$imagedir = "/images";

##############################################################################
# Congratulations!  You've finished defining the variables.  If you want to, #
# you can continue screwing with the script, but it isn't necessary.         #
##############################################################################

open(FILE,"$wordfile");
@words = <FILE>;
close(FILE);

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
        ($name, $value) = split(/=/, $pair);
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ s/\n/ /g;
        $FORM{$name} = $value;
}
print "Content-type: text/html\n\n";
if ($FORM{'action'}) { &start; }
unless ($FORM{'word'}) { &start; }
else { &guess; }

sub start {
        srand();
        $FORM{'word'} = int(rand($#words+1));
        print "<html><head><title>Hangman</title></head><body bgcolor=\"#FFFFFF\" text=\"#FFFFFF\" link=\"#FF0000\" vlink=\"#CC0000\">\n";
        print "<h1><font color=\"#000000\">Hangman</font></h1>\n";
        chomp($words[$FORM{'word'}]);
        @word_chars = split(//, $words[$FORM{'word'}]);
        $words[$FORM{'word'}] =~ tr/A-Z/a-z/;
        @l_word_chars = split(//, $words[$FORM{'word'}]);
        @wrong = ();
        @right = ();
	$FORM{'wrong'} = "";
	$FORM{'right'} = "";
        &makepage;
}

sub makepage {
        print "<form method=\"POST\">\n";
        print "<input type=\"hidden\" name=\"word\" value=\"$FORM{'word'}\">\n";
        print "<input type=\"hidden\" name=\"wrong\" value=\"$FORM{'wrong'}\">\n";                 
        print "<input type=\"hidden\" name=\"right\" value=\"$FORM{'right'}\">\n";                 
        print "<center><table width=\"580\" border=\"5\" bgcolor=\"#000000\"><tr><td>\n";
        if ($won) { print "<center><h1>You Won!!!</h1><input type=\"submit\" value=\" Play Again \" name=\"action\"></center>\n"; } 
        if ($lost) { print "<center><h1>You Lost...</h1>The word was <b>$words[$FORM{'word'}]</b><input type=\"submit\" value=\" Play Again \" name=\"action\"></center>\n"; }
        if ($clue) { print "<center><b>This word would fit in the catagory of: <i>$clue</i></b></center>\n"; }
        print "<table cols=\"2\"><tr><td valign=\"top\">\n";
        print "<center><img src=\"$imagedir/gallows.gif\" height=\"60\" width=\"295\"></center>\n";
        if ($#wrong >= 0) { print "<center><img src=\"$imagedir/head.gif\" height=\"105\" width=\"70\"></center>\n"; }
        if ($#wrong == 1) { print "<center><img src=\"$imagedir/torso.gif\" height=\"296\" width=\"158\"></center>\n"; }
        if ($#wrong == 2) { print "<center><img src=\"$imagedir/l_arm.gif\" height=\"296\" width=\"41\"><img src=\"$imagedir/torso.gif\" height=\"296\" width=\"158\"><img src=\"$imagedir/black.gif\" height=\"296\" width=\"41\"></center>\n"; }
        if ($#wrong >= 3) { print "<center><img src=\"$imagedir/l_arm.gif\" height=\"296\" width=\"41\"><img src=\"$imagedir/torso.gif\" height=\"296\" width=\"158\"><img src=\"$imagedir/r_arm.gif\" height=\"296\" width=\"41\"></center>\n"; }
        if ($#wrong == 4) { print "<center><img src=\"$imagedir/l_leg.gif\" height=\"255\" width=\"72\"><img src=\"$imagedir/black.gif\" height=\"255\" width=\"72\"></center>\n"; }
        if ($#wrong >= 5) { print "<center><img src=\"$imagedir/l_leg.gif\" height=\"255\" width=\"72\"><img src=\"$imagedir/r_leg.gif\" height=\"255\" width=\"72\"></center>\n"; }
        if ($#wrong == 6) { print "<center><img src=\"$imagedir/l_foot.gif\" height=\"19\" width=\"96\"><img src=\"$imagedir/black.gif\" height=\"19\" width=\"96\"></center>\n"; }
        if ($#wrong == 7) { print "<center><img src=\"$imagedir/l_foot.gif\" height=\"19\" width=\"96\"><img src=\"$imagedir/r_foot.gif\" height=\"19\" width=\"96\"></center>\n"; }
        print "</td><td valign=\"top\"><u><b>Word or phrase</b></u><br><tt>\n";
        for ($i = 0; $i <= $#word_chars; $i++) {
                my $guess = 0;
                if ($word_chars[$i] =~ /(\W|\s)/) { print "<b>$word_chars[$i]</b>"; }
                else {
			$guessed = 0;
                        foreach $guess(@right) {
                                if ($guess eq $l_word_chars[$i]) { $guessed = -1; }
                        }
                        if ($guessed == -1) { print "<b>$word_chars[$i]</b>"; }
                        else { print "_"; }
                }
        }
        print "</tt><p>Correct Guesses:<br>\n";
        foreach $guess(@right) { print "$guess "; }
        print "<p>Incorrect Guesses:<br>\n";
        foreach $guess(@wrong) { print "$guess "; }
        unless ($won == -1 || $lost == -1) {
                print "<p>Guess a letter or number:";
                print "<center><input type=\"text\" name=\"guess\" size=\"1\"> <input type=\"submit\" value=\"Guess!\"></center>\n";
        }
        print "</td></tr></table></td></tr></table>\n";
        print "<center><hr width=\"70%\"><font color=\"#000000\">Hangman s";
        print "cript by <a href=\"http://www.shavenferret.com/cliff/\" tar";
        print "get=\"new\">Cliff(tm)</a>, <a ";
        print "href=\"http://www.shavenferret.com\" target=\"new\">Shaven ";
        print "Ferret Productions</a>, and can be found at <a href=\"http:";
        print "//www.shavenferret.com/scripts\" target=\"new\">http://www.";
        print "shavenferret.com/scripts</a>.</font><hr width=\"70%\"></center>\n";
        print "</form></body></html>\n";
        exit;
}

sub guess {
        if ($FORM{'guess'} =~ /(\W|\s)/) {
                print "<html><head><title>Please guess a letter or number</title></head><body bgcolor=\"#FF0000\" text=\"#FFFFFF\" link=\"#0000FF\" vlink=\"#0000CC\">\n";
                print "<h1><font color=\"#000000\">Please guess a letter or number.</font></h1>\n";
                &makepage;                
        }
        chomp($words[$FORM{'word'}]);
        @word_chars = split(//, $words[$FORM{'word'}]);
        $words[$FORM{'word'}] =~ tr/A-Z/a-z/;
        @l_word_chars = split(//, $words[$FORM{'word'}]);
        @wrong = split(//, $FORM{'wrong'});
        @right = split(//, $FORM{'right'});
        foreach $char(@wrong) { if ($char eq $FORM{'guess'}) { $guessed = -1; } }
        foreach $char(@right) { if ($char eq $FORM{'guess'}) { $guessed = -1; } }
        if ($guessed == -1) {
                print "<html><head><title>You already guessed that one, genius boy</title></head><body bgcolor=\"#FF0000\" text=\"#FFFFFF\" link=\"#0000FF\" vlink=\"#0000CC\">\n";
                print "<h1><font color=\"#000000\">Try a letter you haven't guessed...</font></h1>\n";
                &makepage;
        }
        foreach $char(@l_word_chars) { if ($char eq $FORM{'guess'}) { $guessed = -1; } }
        if ($guessed == -1) {
                push(@right,$FORM{'guess'});
                $FORM{'right'} = $FORM{'guess'} . $FORM{'right'};
                print "<html><head><title>Correct!</title></head><body bgcolor=\"#00FF00\" text=\"#FFFFFF\" link=\"#FF0000\" vlink=\"#CC0000\">\n";
                print "<h1><font color=\"#000000\">Correct!</font></h1>\n";
                $won = -1;
                foreach $char(@l_word_chars) {
                        $done = 0;
                        foreach $char2(@right) { if ($char eq $char2) { $done = 1; } }
                        if ($char =~ /(\W|\s)/) { $done = 1; }
                        if ($done == 0) { $won = 0; }
                }
                &makepage;
        }
        else {
                push(@wrong,$FORM{'guess'});
                $FORM{'wrong'} = $FORM{'guess'} . $FORM{'wrong'};
                if ($#wrong == 7) { $lost = -1; }
                print "<html><head><title>Wrong.</title></head><body bgcolor=\"#FF0000\" text=\"#FF0000\" link=\"#0000FF\" vlink=\"#0000CC\">\n";
	        print "<h1><font color=\"#000000\">Wrong.</font></h1>\n";
                &makepage;
        }
}
