#! /usr/bin/perl
######################################################################
# Basic Text Clock (SSI)                  Version 1.02               #
# Copyright 1999 Frederic TYNDIUK (FTLS)  All Rights Reserved.       #
# E-Mail: tyndiuk@ftls.org                Script License: GPL        #
# Created  05/30/98                       Last Modified 08/20/99     #
# Scripts Archive at:                     http://www.ftls.org/cgi/   #
######################################################################
# Function :                                                         #
# Display a clock                                                    #
######################################################################
##################### license & copyright header #####################
#                                                                    #
#                 Copyright (c) 1999 TYNDIUK Frederic                #
#                                                                    #
#  This program is free software; you can redistribute it and/or     #
#  modify it under the terms of the GNU General Public License as    #
#  published by the Free Software Foundation; either version 2 of    #
#  the License, or (at your option) any later version.               #
#                                                                    #
#  This program is distributed in the hope that it will be useful,   #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of    #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     #
#  GNU General Public License for more details.                      #
#                                                                    #
#  You should have received a copy of the GNU General Public License #
#  along with this program in the file 'COPYING'; if not, write to   #
#  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,  #
#  Boston, MA 02111-1307, USA, or contact the author:                #
#                                                                    #
#                              TYNDIUK Frederic <tyndiuk@ftls.org>   #
#                                       <http://www.ftls.org/>       #
#                                                                    #
################### end license & copyright header ###################
######################################################################
# Necessary Variables:                                               #
# The following variables should be set to define the locations      #
# and URLs of various files, as explained in the documentation.      #

$PrintDate = 1;  # En: Display date? 1 Yes, 0 No (ex: Sonntag, May 30 1999)
                 # Fr: Affiche la date? 1 Oui, 0 Non (ex: Sonntag, May 30 1999)

$PrintTime = 1;  # En: Display time? 1 Yes, 0 No (ex: 15:30:00)
                 # Fr: Affiche l'heure? 1 Oui, 0 Non (ex: 15:30:00)

$Lang = "En";	 # Chose Language (Fr: French, Se: Swedish, Other: English)
				 # Changer de langue (Fr: Francais, Se: Suedoi, Autre: Anglais)
				 # Swedish version by rask,  http://www.angen.net/~rask/

# Nothing Below this line needs to be altered!                       #
######################################################################

if ($Lang eq "Fr") {
	@WeekDays = ('Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi');
	@Months = ('Janvier','F&eacute;vrier','Mars','Avril','Mai','Juin','Juillet','Ao&ucirc;t','Septembre','Octobre','Novembre','Decembre');
} elsif ($Lang eq "Se") {
	@WeekDays = ('S&ouml;ndag','M&aring;ndag','Tisdag','Onsdag','Torsdag','Fredag','S&ouml;ndag');
	@Months = ('Januari','Februari','Mars','April','Maj','Juni','Juli','Augusti','September','Oktober','November','December');
} else {
	@WeekDays = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
	@Months = ('January','February','March','April','May','June','July','August','September','October','November','December');
}

print "Content-type: text/html\n\n";	

($Sec,$Min,$Hour,$Day,$Month,$Year,$Week_Day) = (localtime); 
$Year += 1900;
if ($Sec  < 10) { $Sec = "0".$Sec; }
if ($Min  < 10) { $Min = "0".$Min; }
if ($Hour < 10) { $Hour = "0".$Hour; }
if ($Day < 10) { $Day = "0".$Day; }

if ($PrintDate) {
	if ($Lang eq "Fr") {
		print $WeekDays[$Week_Day]." ".$Day." ".$Months[$Month]." ".$Year."\n";
	} else {
		print $WeekDays[$Week_Day].", ".$Months[$Month].", ".$Day." ".$Year."\n";
	}
}
if ($PrintTime) {
	print "$Hour:$Min:$Sec\n";
}
