#!/usr/local/bin/perl
# ^^^^^^^^^^^^^^^^^^^ This is the path to your Perl, in most cases, this will work,
#                     sometimes the admin changes it to something else.
#                     First try using this path, if fails, ask your admin.

#This script is copyright (c) 1999-2000 www.MainCentral.com. All Rights Reserved.

#You may modify and distribute this script as long as this header is above all.
#Please visit http://www.MainCentral.com
#Copyright Notice:
#	This script may only be used if the copyright, and footers are intact.

#Script name: Sig Fig Date
#Version: 1.1
#Description: This program uses SSI to print a date and time into your site with very customizable formats.

print "Content-Type: text/html\n\n"; #Some servers require you to print a header in SSI.  If you server echo's this, then just comment it, or remove this line.
#Configuration

#Offset localtime/server time. set to -3 to subtract 3 hours
$OffSet = 0;

#The format of how to print the date - Refer to readme.txt for more information and ALL tags.
$dateformat = "The time is: -hour12:-minute:-second <BR> Light: -ampm <BR> The date is: -dayname, -monthname -daynum, y-sigyeark";

#Defines the word for AM - You can put something like "morning" or "am" or "AM" or anything.
$am = "Morning";

#Defines the word for PM - You can put something like "evening" or "pm" or "PM" or anything.
$pm = "Afternoon";


# That's It! - END to configuration! - Do not modify anything below.


&GetDate;
&PrintDate;

sub GetDate {
	$ampm = "$am";
	($second,$minute,$hour24,$daynum,$monthnum,$year,$wday,$yday,$isdst)=localtime(time+(3600*$OffSet));
	$wday--;
	$year+=1900;
	@month = ("January","February","March","April","May","June","July","August","September","October","November","December");
	@wday = ("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday");
	$dayname = @wday[$wday];
	$monthname = @month[$monthnum];
	$monthnum++;
	$sigyear = $year / 1000;
	$hour12 = $hour24;
	$hour12 = ($hour24 - 12) if ($hour24 > 12);
	$ampm = $pm if ($hour24 > 12);
	$second = "0$second" if (length($second) == 1);
	$minute = "0$minute" if (length($minute) == 1);
	$at =		$year * ((($monthnum -1) * 30) + $daynum) + $hour24;
	$total =	$year *	365 + 24;
	$peryear = $year + ($at / $total);
	$done = int(($at / $total) * 100);
	$left = int(100 - $done);

}
sub PrintDate {
	$dateformat =~ s/\-hour24/$hour24/ig;
	$dateformat =~ s/\-hour12/$hour12/ig;
	$dateformat =~ s/\-ampm/$ampm/ig;
	$dateformat =~ s/\-minute/$minute/ig;
	$dateformat =~ s/\-second/$second/ig;
	$dateformat =~ s/\-dayname/$dayname/ig;
	$dateformat =~ s/\-daynum/$daynum/ig;
	$dateformat =~ s/\-monthname/$monthname/ig;
	$dateformat =~ s/\-monthnum/$monthnum/ig;
	$dateformat =~ s/\-year/$year/ig;
	$dateformat =~ s/\-sigyear/$sigyear/ig;
	$dateformat =~ s/\-peryear/$peryear/ig;
	$dateformat =~ s/\-done/$done/ig;
	$dateformat =~ s/\-left/$left/ig;
	print $dateformat;
}