#!/usr/bin/perl
# Last Modified Walker 1.0
# Copyright 2001 KMR Enterprises
# Scripted by TDavid @ http://www.tdscripts.com/
#
# Created: 2/19/2001
# Last Modified: 2/19/2001
# 
# Description: This script will walk a directory and add
# the last modified date to the very bottom next to the </body>
# tag of any HTML/PHTML/SHTML/HTM page. Do NOT use this for 
# adding last updated to any other page or it will erase your HTML code
# You may customize the format of the last modified message.
#
# If you use this, please put up a reciprocal link
# to http://www.tdscripts.com/
#
# The author is not responsible for the use or misuse
# of this code. It is freeware, use freely, just don't
# claim that it is your own code or remove this header
# or try to sell it somewhere.

# INSTRUCTIONS
# In the directory where you want to change the files
# make sure you set the permissions to chmod 666 for each file
# and make the directory itself 777

# Change to the path to the directory you want to walk through
$datadir = "/YOUR/PATH/TO/WWW/your_directory";

# Change to the URL to the server path above (OPTIONAL) - NO trailing slash
$urlpath = 'http://www.yourdomain.com/your_directory';

# Put all pages in here that you do NOT want to have the script change
@dontchange = ('testing.html', 'testhtm.htm', 'testp.phtml', 'tests.shtml');

#############################################################
print "Content-type: text/html\n\n";
opendir(THEDIR, "$datadir") || &file_error("Could not open the datadir: <b>$datadir</b>");
@filenames = readdir(THEDIR);
closedir(THEDIR);

$sizeof = $#dontchange;
foreach $name (@filenames) {
   @extension = split(/\./, $name);
   $setflag = 0;
   $i=0;
   while ($i < $sizeof) {
      if ($extension[1] =~ /(html|htm|shtml|phtml)/)  {
           $setflag = 1;
           if($name eq $dontchange[$i]) {
               $setflag = 0;
               last;
           }
       }
   $i++;
   }
   if ($setflag == 1) {
      &file_change($name); 
      $setflag = 0;
   }
}

sub file_change {
print "Modifying ... <a href=\"$urlpath/$_[0]\" target=\"new\"><b>$_[0]</b> [VIEW]</a><br>";
# go get the page and prepare to change it
open(FILEHANDLE, "<$datadir/$_[0]") || &file_error("Could not open the file: <b>$datadir/$_[0]</b>");
@contents = <FILEHANDLE>;
@info = stat FILEHANDLE;
@date = localtime($info[9]);
close(FILEHANDLE);

$year = sprintf("%d-%d-%d\n",$date[4]+1,$date[3],$date[5]+1900);
$time = "$date[2]:$date[1]";
$lastmodified = "$year $time";
$newhtml = '<!--swapstart -->';

## CUSTOMIZATION REQUIRED! ##
# CHANGE the format below to what you want to swap out -- be sure to backslash any double quotes
$newhtml .= "<font face=\"Arial\"><small>Copyright 1999-2001 All Rights Reserved <em>Last Modified $lastmodified</em></font></small>
</body>";

## (end) CUSTOMIZATION ##

$sflag = 0;
    foreach $html (@contents) {
        if($html =~ /<\!--swapstart -->/i) {
           $html =~ s/(<\!--swapstart -->.+)//i;
           $sflag = 1;
        }
        if($html =~ /<\/body>/) {
           $html =~ s/<\/body>/$newhtml/i;
           $sflag = 0;
        }
        if($sflag) { $html = ''; }
     }

open(FILEHANDLE, ">$datadir/$_[0]") || &file_error("Could not open the datadir: <b>$datadir/$_[0]</b>");
print FILEHANDLE @contents;
close(FILEHANDLE);
}

sub file_error {
print "$_[0] check that the permissions are 666 for files and 777 for the directory<p>";
}