package RandomBanner::DisplayBannerAction;

# Copyright (C) 1994 - 2001  eXtropia.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.

use strict;
use Extropia::Base qw(_rearrange _rearrangeAsHash);
use Extropia::Action;

use vars qw(@ISA);
@ISA = qw(Extropia::Action);

sub execute {
    my $self = shift;
    my ($params) = _rearrangeAsHash([
        -APPLICATION_OBJECT,
        -BANNER_VIEW_NAME,
        -IMAGE_KEY
            ],
            [
        -APPLICATION_OBJECT,
        -BANNER_VIEW_NAME,
        -IMAGE_KEY
            ],
        @_
    );

    my $app              = $params->{-APPLICATION_OBJECT};
    my $banner_view_name = $params->{-BANNER_VIEW_NAME};
    my $image_key        = $params->{-IMAGE_KEY};

    my $random_number = int(rand(3));
    my @keys          = keys(%$image_key);
    my $random_key    = $keys[$random_number];

    $app->setAdditionalViewDisplayParam(
        -PARAM_NAME  => '-LINK_URL',
        -PARAM_VALUE => $image_key->{$random_key}
    );

    $app->setAdditionalViewDisplayParam(
        -PARAM_NAME  => '-IMAGE_URL',
        -PARAM_VALUE => $random_key
    );

    $app->setNextViewToDisplay(
        -VIEW_NAME => $banner_view_name
    );

    return 1;
}
