package MLM::ProcessMailSendAction;

# Copyright (C) 1994 - 2001 eXtropia.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.

use strict;
use Extropia::Base qw(_rearrange _rearrangeAsHash);
use Extropia::Action;

use vars qw(@ISA);
@ISA = qw(Extropia::Action);

sub execute {
    my $self = shift;
    my ($params) = _rearrangeAsHash([
        -ALLOW_LIST_MAILINGS_FLAG,
        -APPLICATION_OBJECT,
        -AUTH_MANAGER_CONFIG_PARAMS,
        -CGI_OBJECT,
        -DATASOURCE_CONFIG_PARAMS,
        -DATA_HANDLER_MANAGER_CONFIG_PARAMS,
        -MAIL_CONFIG_PARAMS,
        -MAIL_SEND_PARAMS,
        -REQUIRE_AUTH_FOR_SENDING_MAIL_FLAG,
        -SEND_MAIL_FORM_VIEW_NAME,
        -SEND_MAIL_ACKNOWLEDGEMENT_VIEW_NAME,
            ],
            [
        -APPLICATION_OBJECT
            ],
        @_
    );

    my $app = $params->{-APPLICATION_OBJECT};
    my $cgi = $params->{-CGI_OBJECT};

    if (defined($cgi->param('submit_send_mail')) &&
        $params->{-ALLOW_LIST_MAILINGS_FLAG}) {

        if ($params->{-REQUIRE_AUTH_FOR_SENDING_MAIL_FLAG}) {
            if ($params->{-AUTH_MANAGER_CONFIG_PARAMS}) {
                my $auth_manager = Extropia::AuthManager->create(@{$params->{-AUTH_MANAGER_CONFIG_PARAMS}})
                    or die("Whoopsy!  I was unable to construct the " .
                           "Authentication object. " .
                          "Please contact the webmaster."
                );
                $auth_manager->authenticate();
            }
            else {
                die('You have set -REQUIRE_AUTH_FOR_SENDING_MAIL_FLAG to 1 ' .
                    ' in the application executable, but you have not ' .
                    ' defined -AUTH_MANAGER_CONFIG_PARAMS in the ' .
                    '@ACTION_HANDLER_ACTION_PARAMS array ' .
                    'in the application executable. This action ' .
                    ' cannot procede unless you do both.'
                );
            }
        }

        my $log_object;
        if ($params->{-LOG_CONFIG_PARAMS}) {
            $log_object = Extropia::Log->create(@{$params->{-LOG_CONFIG_PARAMS}})
                or die("Whoopsy!  I was unable to construct the " .
                       "Log object. Please " .
                       "contact the webmaster."
            );
        }

        my @dhm_config_params = _rearrange([
            -SEND_MAIL_FORM_DHM_CONFIG_PARAMS
               ],
               [
            -SEND_MAIL_FORM_DHM_CONFIG_PARAMS
                ],
            @{$params->{-DATA_HANDLER_MANAGER_CONFIG_PARAMS}}
        );

        my $send_form_dhm_config_params = shift (@dhm_config_params);

        if ($send_form_dhm_config_params) {
            my $data_handler_success = $app->handleIncomingData(
                -CGI_OBJECT                 => $params->{-CGI_OBJECT},
                -LOG_OBJECT                 => $log_object,
                -DATA_HANDLER_CONFIG_PARAMS => $send_form_dhm_config_params
            );

            if (!$data_handler_success) {
                $app->setNextViewToDisplay(
                    -VIEW_NAME => $params->{-SEND_MAIL_FORM_VIEW_NAME}
                );

                my $error;
                foreach $error ($app->getDataHandlerErrors()) {
                   $self->addError($error);
                }
                return 1;
            }
        }

        my @config_params = _rearrange([
            -BASIC_DATASOURCE_CONFIG_PARAMS
                ],
                [
            -BASIC_DATASOURCE_CONFIG_PARAMS
                ],
            @{$params->{-DATASOURCE_CONFIG_PARAMS}}
        );

        my $datasource_config_params = shift (@config_params);
           
        if (!$datasource_config_params) {
            die('You must specify a configuration for ' .
                '-BASIC_DATASOURCE_CONFIG_PARAMS in order to ' .
                'use loadData(). You may do so in the ' .
                '@ACTION_HANDLER_ACTION_PARAMS array ' .
                'in the application executable'
            );
        }

        my $search_ds = Extropia::DataSource->create(
            @$datasource_config_params
        );

        if ($search_ds->getErrorCount()) {
            die("Whoopsy!  I was unable to construct the " .
               "DataSource object in the do() method of " .
               "MLM.pm. Please contact the webmaster." .
                $search_ds->getLastError()->getMessage()
            );
        }

        my $record_set = $search_ds->search(
            -SEARCH => ""
        );

        if ($search_ds->getErrorCount()) {
           $app->setNextViewToDisplay(
                -VIEW_NAME => $params->{-SEND_MAIL_FORM_VIEW_NAME}
           );
           $self->addError($search_ds->getLastError());
           return 1;
        }

        $record_set->moveFirst();

        my @to_list;
        while (!$record_set->endOfRecords()) {
           push (@to_list, $record_set->getField('email'));
           $record_set->moveNext();
        }

        my @send_params = _rearrange([
            -SEND_EVENT_MAIL_SEND_PARAMS
                ],
                [
            -SEND_EVENT_MAIL_SEND_PARAMS
                ],
           @{$params->{-MAIL_SEND_PARAMS}}
        );

        my $mail_send_params = shift (@send_params);

        if (!$mail_send_params) {
            die('You must specify a configuration for ' .
                '-BASIC_DATASOURCE_CONFIG_PARAMS in order to ' .
                'use loadData(). You may do so in the ' .
                '@ACTION_HANDLER_ACTION_PARAMS array ' .
                'in the application executable'
            );
        }

        my $to;
        foreach $to (@to_list) {
            my $success = $app->sendMail(
                -MAIL_CONFIG_PARAMS => $params->{-MAIL_CONFIG_PARAMS},
                -TO                 => $to,
                -BODY               => $cgi->param('body'),
                -SUBJECT            => $cgi->param('subject'),
                @$mail_send_params
            );
        }

        $app->setNextViewToDisplay(
            -VIEW_NAME => $params->{-SEND_MAIL_ACKNOWLEDGEMENT_VIEW_NAME}
        );

        return 1;
    }

    return 0;
}

