package DisplayAddFormAction;

# Copyright (C) 1994 - 2001  eXtropia.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.

use strict;
use Extropia::Base qw(_rearrange _rearrangeAsHash);
use Extropia::Action;

use vars qw(@ISA);
@ISA = qw(Extropia::Action);

sub execute {
    my $self = shift;
    my ($params) = _rearrangeAsHash([
        -ADD_FORM_VIEW_NAME,
        -ALLOW_ADDITIONS_FLAG,
        -APPLICATION_OBJECT,
        -AUTH_MANAGER_CONFIG_PARAMS,
        -CGI_OBJECT,
        -REQUIRE_AUTH_FOR_ADDING_FLAG,
        -VIEW_DISPLAY_PARAMS
            ],
            [
        -ADD_FORM_VIEW_NAME,
        -APPLICATION_OBJECT,
        -CGI_OBJECT
            ],
        @_
    );

    my $cgi = $params->{-CGI_OBJECT};
    my $app = $params->{-APPLICATION_OBJECT};

    if (defined($cgi->param('display_add_form'))) {

        if (!$params->{-ALLOW_ADDITIONS_FLAG}) {
            die ('Sorry, but you are not allowed to perform additions. ' .
                 'To enable additions, you must set -ALLOW_ADDITIONS_FLAG ' .
                 'in the @ACTION_HANDLER_ACTION_PARAMS array ' .
                 'in the application executable to 1'
            );
        }

        elsif ($params->{-REQUIRE_AUTH_FOR_ADDING_FLAG}) {
            if ($params->{-AUTH_MANAGER_CONFIG_PARAMS}) {
                my $auth_manager = Extropia::AuthManager->create(@{$params->{-AUTH_MANAGER_CONFIG_PARAMS}})
                    or die("Whoopsy!  I was unable to construct the " .
                           "Authentication object in the new() method of WebDB.pm. " .
                           "Please contact the webmaster."
                    );
                $auth_manager->authenticate();
            }
            else {
                die('You have set -REQUIRE_AUTH_FOR_ADDING_FLAG to 1 ' .
                    ' in the application executable, but you have not ' .
                    ' defined -AUTH_MANAGER_CONFIG_PARAMS in the ' .
                    '@ACTION_HANDLER_ACTION_PARAMS array ' .
                    'in the application executable. This action ' .
                    ' cannot procede unless you do both.'
                );
            }
        }

        $app->setNextViewToDisplay(
            -VIEW_NAME => $params->{-ADD_FORM_VIEW_NAME}
        );

        return 1;
    }

    return 0;
}
