package Calendar::DisplayMainViewAction;

# Copyright (C) 1994 - 2001  eXtropia.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.

use strict;
use Extropia::Base qw(_rearrange _rearrangeAsHash);
use Extropia::Action;

use vars qw(@ISA);
@ISA = qw(Extropia::Action);

sub execute {
    my $self = shift;
    my ($params) = _rearrangeAsHash([
        -APPLICATION_OBJECT,
        -CGI_OBJECT,
        -DATASOURCE_CONFIG_PARAMS,
        -DEFAULT_VIEW_NAME
            ],
            [
        -APPLICATION_OBJECT,
        -CGI_OBJECT,
        -DATASOURCE_CONFIG_PARAMS,
        -DEFAULT_VIEW_NAME
            ],
        @_
    );

    my $app = $params->{'-APPLICATION_OBJECT'};
    my $cgi = $params->{'-CGI_OBJECT'};

    my @config_params = _rearrange([
        -BASIC_DATASOURCE_CONFIG_PARAMS
            ],
            [
        -BASIC_DATASOURCE_CONFIG_PARAMS
            ],
        @{$params->{'-DATASOURCE_CONFIG_PARAMS'}}
    );

    my $datasource_config_params = shift (@config_params);

    if ($cgi->param('display_main_calendar_view')) {
        my $record_set = $app->loadData((
            -KEY_FIELD                   => $params->{'-KEY_FIELD'},
            -DATASOURCE_CONFIG_PARAMS    => $datasource_config_params,
            -CGI_OBJECT                  => $params->{'-CGI_OBJECT'},
            -SESSION_OBJECT              => $params->{'-SESSION_OBJECT'}
        ));

        $app->setAdditionalViewDisplayParam(
            -PARAM_NAME  => "-RECORD_SET",
            -PARAM_VALUE => $record_set
        );


        $app->setAdditionalViewDisplayParam(
            -PARAM_NAME  => "-VIEW_NAME",
            -PARAM_VALUE => $params->{'-DEFAULT_VIEW_NAME'}
        );
        return 1;
    }

    return 0;
}
