package BugTracker::PopulateInputWidgetDefinitionListWithUsersWidgetAction;

# Copyright (C) 1994 - 2001  eXtropia.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.

use strict;
use Extropia::Base qw(_rearrange _rearrangeAsHash);
use Extropia::Action;

use vars qw(@ISA);
@ISA = qw(Extropia::Action);

sub execute {
    my $self = shift;
    my ($params) = _rearrangeAsHash([
        -ALLOW_USERNAME_FIELD_TO_BE_SEARCHED,
        -APPLICATION_OBJECT,
        -CGI_OBJECT,
        -DATASOURCE_CONFIG_PARAMS,
        -ENABLE_SORTING_FLAG,
        -KEY_FIELD,
        -LAST_RECORD_ON_PAGE,
        -MAX_RECORDS_PER_PAGE,
        -REQUIRE_MATCHING_USERNAME_FOR_SEARCHING_FLAG,
        -REQUIRE_MATCHING_GROUP_FOR_SEARCHING_FLAG,
        -SIMPLE_SEARCH_STRING,
        -SESSION_OBJECT,
        -SORT_DIRECTION,
        -SORT_FIELD1,
        -SORT_FIELD2,
        -VIEW_DISPLAY_PARAMS
            ],
            [
        -APPLICATION_OBJECT
            ],
        @_
    );

    my $app = $params->{-APPLICATION_OBJECT};
    my $cgi = $params->{-CGI_OBJECT};

    $cgi->param(
        -NAME  => 'raw_search',
        -VALUE => "developer_status=='1' OR developer_status=='0'"
    );

    my @config_params = _rearrange([
        -AUTH_USER_DATASOURCE_CONFIG_PARAMS
            ],
            [
        -AUTH_USER_DATASOURCE_CONFIG_PARAMS
            ],
        @{$params->{-DATASOURCE_CONFIG_PARAMS}}
    );

    my $datasource_config_params = shift (@config_params);

    my $record_set = $app->loadData((
        -ENABLE_SORTING_FLAG         => $params->{-ENABLE_SORTING_FLAG},
        -ALLOW_USERNAME_FIELD_TO_BE_SEARCHED => $params->{-ALLOW_USERNAME_FIELD_TO_BE_SEARCHED},
        -KEY_FIELD                   => $params->{-KEY_FIELD},
        -DATASOURCE_CONFIG_PARAMS    => $datasource_config_params,
        -SORT_DIRECTION              => $params->{-SORT_DIRECTION},
        -SORT_FIELD1                 => $params->{-SORT_FIELD1},
        -SORT_FIELD2                 => $params->{-SORT_FIELD2},
        -MAX_RECORDS_PER_PAGE        => $params->{-MAX_RECORDS_PER_PAGE},
        -LAST_RECORD_ON_PAGE         => $params->{-LAST_RECORD_ON_PAGE},
        -SIMPLE_SEARCH_STRING        => $params->{-SIMPLE_SEARCH_STRING},
        -CGI_OBJECT                  => $params->{-CGI_OBJECT},
        -SESSION_OBJECT              => $params->{-SESSION_OBJECT},
        -REQUIRE_MATCHING_USERNAME_FOR_SEARCHING_FLAG => $params->{-REQUIRE_MATCHING_USERNAME_FOR_SEARCHING_FLAG},
        -REQUIRE_MATCHING_GROUP_FOR_SEARCHING_FLAG => $params->{-REQUIRE_MATCHING_GROUP_FOR_SEARCHING_FLAG}
    ));

    my @users;
    $record_set->moveFirst();
    while (!$record_set->endOfRecords()) {
        my $username = $record_set->getField('username');
        push (@users, $username);
        $record_set->moveNext();
    }

    my @view_display_params = @{$params->{-VIEW_DISPLAY_PARAMS}};

    my @new_view_display_params;
    my $found = 0;
    my $found_index = 0;
    my $i;
    my $input_widget_config;
    for ($i=0; $i<@view_display_params; $i++) {
        if ($found) {
            $found = 0;
            $input_widget_config = $view_display_params[$i];
        }
        push (@new_view_display_params, $view_display_params[$i]);

        if ($view_display_params[$i] eq "-INPUT_WIDGET_DEFINITIONS") {
            $found_index = $i+1; 
            $found = 1; 
        }
    }

    my @input_widget_config_params = _rearrange([
        -BASIC_INPUT_WIDGET_DEFINITIONS,
            ],
            [
        -BASIC_INPUT_WIDGET_DEFINITIONS,
            ],
        @$input_widget_config
    );

    my $input_widget_definitions = shift (@input_widget_config_params);

    my @reporter_widget = (
        -DISPLAY_NAME => 'Reported by:',
        -TYPE         => 'popup_menu',
        -NAME         => 'reporter',
        -VALUES       => \@users
    );

    $$input_widget_definitions{'reporter'} = \@reporter_widget;

    my @new_value = (
        -BASIC_INPUT_WIDGET_DEFINITIONS => $input_widget_definitions
    );

    push (@input_widget_config_params, @new_value);

    $new_view_display_params[$found_index] = $input_widget_config;

    $app->{-VIEW_DISPLAY_PARAMS} = \@new_view_display_params;

    $cgi->param(
        -NAME  => 'raw_search',
        -VALUE => ""
    );

    return 2;
}
