#!/usr/bin/perl
##############################################################################
# Cliff's Really Nifty Guestbook Version 2.04                                # 
# Copyright 1998 Shaven Ferret Productions                                   #
# Created 6/4/98       Last Modified 1/03/2000                               #
# Available at http://www.shavenferret.com/scripts                           #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1998 Shaven Ferret Productions All Rights Reserved.              #
#                                                                            #
# This script can be used\modified free of charge as long as you don't       #
# change this header or any of the parts that give me credit for writing     #
# this.  By using this script you agree to indemnify me from any liability   #
# that might arise from its use.  In simple English, if this script somehow  #
# makes your computer run amuck and kill the pope, it's not my fault.        #
#                                                                            #
#                                                                            #
# Redistributing\selling the code for this program without prior written     #
# consent is expressly forbidden.                                            #
##############################################################################

# Define the variables

# set this to the PATH (not url) to the guestbook data file (gbook.txt)
$datafile = "gbook.txt";

# Enter the location of your mail program
$mailprogram = "/usr/lib/sendmail -t";

##############################################################################
# Congratulations!  You've finished defining the variables.  If you want to, #
# you can continue screwing with the script, but it isn't necessary.         #
##############################################################################

# Get the settings from the data file.

open (DATA, "$datafile");
@data = <DATA>;
close(DATA);
chomp($data[0]);
($signhtml,$pagetitle,$background,$link,$alink,$vlink,$text,$bgcolor,$images,$names,$addimage,$shownum,$preview,$rname,$remail,$rcomments,$youremail,$notify1,$notify2,$password,$maxnum,$showstats) = split(/\|/, shift(@data));

# Get the submitted data

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
        ($name, $value) = split(/=/, $pair);
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        $value =~ s/\s/ /g;
        $value =~ s/<([^>]|\n)*>//g;
        $value =~ s/<//g;
        $value =~ s/>//g;
        $FORM{$name} = $value;
}

# Decide what to do

print "Content-type: text/html\n\n";
if ($FORM{'action'} eq "sign1") { &sign1; }
if ($FORM{'action'} eq "sign2") { &sign2; }
if ($FORM{'action'} eq "preview") { &preview; }
if ($FORM{'action'} eq "admin") { &admin; }
if ($FORM{'action'} eq "delete") { &delete; }
if ($FORM{'action'} eq "report") { &report; }
if ($FORM{'action'} eq "modify") { &modify; }
if ($FORM{'action'} eq "setup") { &setup; }
if ($FORM{'action'} eq "approved") { &approved; }
if ($FORM{'action'} eq "add_image") { &add_image; }
if ($FORM{'action'} eq "remove_image") { &remove_image; }
else { &view; }

sub view {
        print "<html><head><title>$pagetitle</title>\n";
        &body;
        &sig;
        if ($signhtml == 1) { &signhtml; }
        else {
                print "<center><form method=\"POST\"><input type=\"hidden\" ";
                print "name=\"action\" value=\"sign1\"><input type=\"submit\"";
                print " value=\" Sign my Guestbook! \"></form></center><p>\n";
        }
        unless ($FORM{'start'}) { $FORM{'start'} = 0; }
        if ($shownum == -1) { $shownum = $#data; }
        $last = $FORM{'start'} + $shownum;        
        if ($last > $#data) { $last = $#data; }
        $i = $FORM{'start'} + 1;
        $j = $last + 1;
        print "<i>Entries $i to $j:</i><p>\n";
        $i = 0;
        for ($i = $FORM{'start'}; $i <= $last; $i++) {
                $html = &viewhtml($data[$i]);
                print "$html";
        }
        if ($FORM{'start'} > 0) {                
                $i = $FORM{'start'} - $shownum - 1;
                if ($i < 0) {
                        $i = 0;
                        $j = $FORM{'start'} + 1;
                }
                else { $j = $shownum + 1; }
                print "<form method=\"POST\"><input type=\"hidden\" name=\"start\" value=\"$i\">\n";
                print "<input type=\"submit\" value=\" Last $j Entries \"></form>\n";
        }
        if ($last < $#data) {
                $last++;
                $FORM{'start'} = ($#data + 1) - $last;
                if ($FORM{'start'} > $shownum) { $FORM{'start'} = $shownum + 1; }
                print "<form method=\"POST\"><input type=\"hidden\" name=\"start\" value=\"$last\">\n";
                print "<input type=\"submit\" value=\" Next $FORM{'start'} Entries \"></form>\n";
        }            
        if ($showstats) { &stats; }
        &sig;
        print "<center><form method=\"POST\"><input type=\"hidden\" name=\"action\" value=\"admin\">\n";
        print "<b>Administration</b><br>Password:<input type=\"password\" name=\"password\">\n";
        print "<br><input type=\"submit\" value=\" Enter \"></form></body></html>\n";
        exit;
}

sub signhtml {

        # This sub creates the html used to sign your guestbook.  If you want
        # to edit this, see the readme.txt file

        print "<form method=\"POST\">\n";
        if ($preview) { print "<input type=\"hidden\" name=\"action\" value=\"preview\">\n"; }
        else { print "<input type=\"hidden\" name=\"action\" value=\"sign2\">\n"; }
        print "<center><table width=\"500\" border=\"5\"><tr><td>\n";
        print "<table cols=\"2\"><tr><td align=\"right\">What's your name?</td>\n";
        print "<td><input type=\"text\" name=\"name\"></td></tr>\n";
        print "<tr><td align=\"right\">What's your e-mail address?</td>\n";
        print "<td><input type=\"text\" name=\"email\"></td></tr>\n";
        print "<tr><td align=\"right\">What's your web page called?<br><i><center>Leave this blank if you don't have one</center></i></td>\n";
        print "<td><input type=\"text\" name=\"title\"></td></tr>\n";
        print "<tr><td align=\"right\">What's your web page's URL?<br><i><center>Leave this blank if you don't have one</center></i></td>\n";
        print "<td><input type=\"text\" name=\"url\" value=\"http://\"></td></tr>\n";
        print "<tr><td align=\"right\">Please rate the content of my page:</td>\n";
        print "<td><select name=\"content\">\n";
        for ($i = 1; $i < 10; $i++) { print "<option>$i"; }
        print "<option selected>10</select></td></tr>\n";
        print "<tr><td align=\"right\">Please rate the design of my page:</td>\n";
        print "<td><select name=\"design\">\n";
        for ($i = 1; $i < 10; $i++) { print "<option>$i"; }
        print "<option selected>10</select></td></tr>\n";
        if ($images) {
                @urls = split(/\t/,$images);
                @names = split(/\t/,$names);
                print "<tr><td align=\"right\">Please select an image</td>\n";
                print "<td><select name=\"image\"><option selected value=\"\">No image\n";
                $num = 0;
                foreach $name(@names) {
                        print "<option value=\"$urls[$num]\">$name\n";
                        $num++;
                }
                if ($addimage) {
                        print "<option value=\"other\">Something else\n</select></td></tr>\n";
                        print "<tr><td align=\"right\">If you answered other above, enter the\n";
                        print "full URL of the image you want to use:<br><center><i>All images\n";
                        print "will be resized to 590 X 138 Pixels</i></center></b></td>\n";
                        print "<td><input type=\"text\" name=\"other\" value=\"http://\"></td></tr>\n";
                }
                else { print "</select></td></tr>\n"; }
        }
        elsif ($addimage) {
                print "<tr><td align=\"right\">If you'd like to add an image, enter the\n";
                print "full URL of the image you want to use:<br><center><i>All images\n";
                print "will be resized to 590 X 138 Pixels</i></center></b></td>\n";
                print "<td><input type=\"text\" name=\"other\" value=\"http://\"></td></tr>\n";
        }
        print "<tr><td align=\"right\">Are you male of female?</td>\n";
        print "<td><select name=\"gender\"><option selected>male<option>female</select></td></tr>\n";
        print "<tr><td align=\"right\">How old are you?</td>\n";
        print "<td><select name=\"age\"><option value=\"0\">Under 18\n";
        print "<option value=\"1\">18-27\n";
        print "<option value=\"2\">28-37\n";
        print "<option value=\"3\">38-47\n";
        print "<option value=\"4\">48-57\n";
        print "<option value=\"5\">58-67\n";
        print "<option value=\"6\">Over 67\n";
        print "</select></td></tr>\n";
        print "<tr><td align=\"right\">Please enter some comments:</td>\n";
        print "<td><textarea name=\"comments\" cols=\"25\" rows=\"5\" wrap=\"soft\"></textarea></td></tr>\n";
        print "<tr><td align=\"right\"><input type=\"submit\" value=\" Sign! \"></td>\n";
        print "<td><input type=\"reset\"></td></tr>\n";
        print "</table></td></tr></table></center></form>\n";
}

sub body {
        print "<body ";
        if ($background) { print "background=\"$background\" "; }
        print "bgcolor=\"$bgcolor\" link=\"$link\" alink=\"$alink\" ";
        print "vlink=\"$vlink\" text=\"$text\">\n";
}

sub sig {
# Please DON'T change this sub, or any place where it is called
        print "<center><hr width=\"400\">Guestbook Script by <a href=\"h";
        print "ttp://www.shavenferret.com/cliff/\" target=\"new\">Cliff</a>, <a";
        print " href=\"http://www.shavenferret.com\" target=\"new\">Shav";
        print "en Ferret Productions</a>, and available @ <a href=\"http";
        print "://www.shavenferret.com/scripts/\" target=\"new\">http://";
        print "www.shavenferret.com/scripts/</a><hr width=\"400\"></cent";
        print "er>\n";
}

sub viewhtml {

        # Get the data and change it into what we want to show

        $line = shift(@_);
        ($name,$email,$title,$url,$image,$content,$design,$comments,$gender,$age,$date,$time) = split(/\|/, $line);
        if ($url =~ /^(f|ht)tp:\/\/\w+\.\w\w+/) { $title = "<a href=\"$url\">$title</a>"; }
        else { $title = "I don't have a web page"; }
        if ($image !~ /^(f|ht)tp:\/\/\w+\.\w\w+.*\.(jpg|bmp|gif)/) { $image = ""; }
        if ($email =~ /\w+@\w+\.\w\w+/ && $name) { $hello = "Hello, my name is <a href=\"mailto:$email\">$name</a>"; }
        elsif ($email =~ /\w+@\w+\.\w\w+/) { $hello = "Hello, my e-mail address is <a href=\"mailto:$email\">$email</a>"; }
        elsif ($name) { $hello = "Hello, my name is $name"; }
        else { $hello = "I prefer to remain anonymous."; }
        if ($content == 8) { $content = "an 8"; }
        else { $content = "a $content"; }
        if ($design == 8) { $design = "an 8"; }
        else { $design = "a $design"; }
        if ($age == 0) { $age = "under 18"; }
        if ($age == 1) { $age = "in the 18 to 27 age group"; }
        if ($age == 2) { $age = "in the 28 to 37 age group"; }
        if ($age == 3) { $age = "in the 38 to 47 age group"; }
        if ($age == 4) { $age = "in the 48 to 57 age group"; }
        if ($age == 5) { $age = "in the 58 to 67 age group"; }
        if ($age == 6) { $age = "over 67"; }

        # define the html

        $html = "<center><table border=\"5\" width=\"600\"><tr><td>\n";
        $html .= "<center><h1>$title</h1></center><table cols=\"2\" border=\"1\" cellspacing=\"5\"><tr><td>$hello.\n";
        $html .= "I stopped by to sign this thing on $date at $time.\n";
        $html .= "I am $gender and $age.  On a scale of 1 to 10, I would\n";
        $html .= "give your page $content in content and $design in design.\n";
        $html .= "</td><td>$comments</td></tr></table>\n";
        if ($image) { $html .= "<center><img src=\"$image\" height=\"138\" width=\"590\"></center>\n"; }
        $html .= "</td></tr></table></center><p>\n";
        return($html);
}

sub sign1 {
        print "<html><head><title>Sign my guestbook</title></head>\n";
        &body;
        &sig;
        &signhtml;
        &sig;
        print "</body></html>\n";
        exit;
}

sub preview {
        &check;
        print "<html><head><title>Preview your entry...</title></head>\n";
        &body;
        print "<h1>Preview your entry...</h1>\n";
        print "<form method=\"POST\"><input type=\"hidden\" name=\"action\" value=\"sign2\">\n";
        print "This is how your entry will look.  If that's ok with you,\n";
        print "click <input type=\"submit\" value=\" this button. \">  Otherwise,\n";
        print "click back and try again.<p>\n";
        @send = ("name","email","title","url","content","design","gender","age","comments");
        foreach $line(@send) { print "<input type=\"hidden\" name=\"$line\" value=\"$FORM{$line}\">\n"; }
        if ($FORM{'image'} ne "other" && $FORM{'image'}) { $image = $FORM{'image'}; }
        else { $image = $FORM{'other'}; }
        print "<input type=\"hidden\" name=\"image\" value=\"$image\">\n";
        ($date,$time) = &gettime;
        $html = &viewhtml("$FORM{'name'}|$FORM{'email'}|$FORM{'title'}|$FORM{'url'}|$image|$FORM{'content'}|$FORM{'design'}|$FORM{'comments'}|$FORM{'gender'}|$FORM{'age'}|$date|$time");
        print "$html</form></body></html>\n";
        exit;
}

sub gettime {
        ($sec,$min,$hour,$day,$mon,$year) = (localtime(time))[0,1,2,3,4,5];
        $mon++;
	$year += 1900; 
        $date = "$mon/$day/$year";
        $time = "$hour:$min:$sec";
        return ($date,$time);
}

sub check {
        if ($rname && ! $FORM{'name'}) {
                print "<html><head><title>Please enter your name</title></head>\n";
                &body;
                print "<h1>Name required</h1>Please click back and enter your name.\n";
                print "</body></html>\n";
                exit;
        }
        if ($remail && $FORM{'email'} !~ /\w+@\w+\.\w\w+/) {
                print "<html><head><title>Please enter your e-mail address</title></head>\n";
                &body;
                print "<h1>E-mail required</h1>Please click back and enter your e-mail address.\n";
                print "</body></html>\n";
                exit;                
        }
        if ($rcomments && ! $FORM{'comments'}) {
                print "<html><head><title>Please enter some comments</title></head>\n";
                &body;
                print "<h1>Comments required</h1>Please click back and enter some comments.\n";
                print "</body></html>\n";
                exit;                
        }
}

sub sign2 {
        &check;
        ($date,$time) = &gettime;
        splice (@data,0,0,"$FORM{'name'}|$FORM{'email'}|$FORM{'title'}|$FORM{'url'}|$FORM{'image'}|$FORM{'content'}|$FORM{'design'}|$FORM{'comments'}|$FORM{'gender'}|$FORM{'age'}|$date|$time\n");
        unless ($maxnum == -1) { while ($#data > $maxnum) { splice(@data,$#data,1); } }
        &writedata;
        print "<html><head><title>Thank You!</title></head>\n";
        &body;
        print "<h1>Thanks for signing!</h1>Thank your for signing my guestbook.\n";
        print "</body></html>\n";
        if ($notify1 && $youremail) {
                open (MAIL,"|$mailprogram");
                print MAIL "To: $youremail\n";
                print MAIL "From: $FORM{'email'}\n";
                print MAIL "Subject: Use of guestbook\n";
                $html = &viewhtml("$FORM{'name'}|$FORM{'email'}|$FORM{'title'}|$FORM{'url'}|$FORM{'image'}|$FORM{'content'}|$FORM{'design'}|$FORM{'comments'}|$FORM{'gender'}|$FORM{'age'}|$date|$time");                
                $html =~ s/<([^>]|\n)*>//g;
                $html =~ s/<//g;
                $html =~ s/>//g;
                print MAIL "$html\n";
                close(MAIL);
        }
        exit;
}

sub admin {
        &checkpassword;
        print "<html><head><title>Administration</title></head>\n";
        &body;
        print "<center><a href=\"http://www.cgi-resources.com/rate?01812\">Rate\n";
        print "this Script @ The CGI Resource Index</a></center>\n";
        print "<h1>Administration</h1><center><hr width=\"400\"><h2>Bug Report</h2>\n";
        print "If you've found a bug, or you have a suggestion, please enter it\n";
        print "in the box below<br><form method=\"POST\"><input type=\"hidden\" name=\"action\" value=\"report\">\n";
        print "<textarea name=\"bug\" cols=\"30\" rows=\"5\" wrap=\"soft\"></textarea><br>and\n";
        print "click <input type=\"submit\" value=\" This Button \"></form>\n";
        print "<hr width=\"400\"></center>\n";
        if (@data) {
                print "<h2>Delete/Edit Signings</h2>\n";
                print "So as not to make this page too big, this feature\n";
                print "is on it's own page.  Click <form method=\"POST\">\n";
                print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
                print "<input type=\"hidden\" name=\"action\" value=\"approved\">\n";
                print "<input type=\"submit\" value=\" this button \"> to go there</form>\n";

        }
        if ($images) {
                print "<h2>Remove images</h2><form method=\"POST\">\n";
                print "Check off what you want to remove, and click delete.<br>\n";
                print "<input type=\"hidden\" name=\"action\" value=\"remove_image\">\n";
                print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
                @x = split(/\t/, $images);
                @y = split(/\t/, $names);
                $num = 0;
                foreach $line(@x) {
                        print "<input type=\"checkbox\" name=\"$num\" value=\"delete\">";
                        print "<a href=\"$line\">$y[$num]</a><br>\n";
                        $num++;
                }
                print "<input type=\"submit\" value=\" Delete \">*<input type=\"reset\">\n";
                print "</form>\n";
        }
        print "<h2>Add an image</h2><form method=\"POST\">\n";
        print "<input type=\"hidden\" name=\"action\" value=\"add_image\">\n";
        print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
        print "<table width=\"400\"><tr><td align=\"right\">Image's URL:</td>\n";
        print "<td><input type=\"text\" name=\"url\" value=\"http://\"></td></tr>\n";
        print "<tr><td align=\"right\">Description of image</td><td>\n";
        print "<input type=\"text\" name=\"desc\"></td></tr><tr><td align=\"right\">\n";
        print "<input type=\"submit\" value=\"add\"></td><td><input type=\"reset\"></td>\n";
        print "</tr></table></form>\n";
        print "<h2>Options</h2><center><form method=\"POST\">\n";
        print "<input type=\"hidden\" name=\"action\" value=\"setup\">\n";
        print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
        print "<table border=\"5\" width=\"500\"><tr><td>\n";
        print "<table cols=\"2\">\n";
        print "<tr><td align=\"right\">What is your guestbook's title?</td>\n";
        print "<td><input type=\"text\" name=\"title\" value=\"$pagetitle\"></td></tr>\n";
        print "<tr><td align=\"right\">Should I put the sign guestbook form on your guestbook, or should I just put a link to it?</td>\n";
        print "<td><select name=\"signhtml\"><option value=\"0\"";
        if ($signhtml) { print ">Just a link<option value=\"1\" selected>Use the form</select></td></tr>\n"; }
        else { print " selected>Just a link<option value=\"1\">Use the form</select></td></tr>\n"; }
        print "<tr><td align=\"right\">Should I let people use their own image when signing?</td>\n";
        print "<td><select name=\"addimage\"><option value=\"0\"";
        if ($addimage) { print ">No<option value=\"1\" selected>Yes</select></td></tr>\n"; }
        else { print " selected>No<option value=\"1\">Yes</select></td></tr>\n"; }
        print "<tr><td align=\"right\">Should I show people a preview of their entry before adding it?</td>\n";
        print "<td><select name=\"preview\"><option value=\"0\"";
        if ($preview) { print ">No<option value=\"1\" selected>Yes</select></td></tr>\n"; }
        else { print " selected>No<option value=\"1\">Yes</select></td></tr>\n"; }
        print "<tr><td align=\"right\">Should I show make the user enter their name in order to sign?</td>\n";
        print "<td><select name=\"rname\"><option value=\"0\"";
        if ($rname) { print ">No<option value=\"1\" selected>Yes</select></td></tr>\n"; }
        else { print " selected>No<option value=\"1\">Yes</select></td></tr>\n"; }
        print "<tr><td align=\"right\">Should I show make the user enter their e-mail address in order to sign?</td>\n";
        print "<td><select name=\"remail\"><option value=\"0\"";
        if ($remail) { print ">No<option value=\"1\" selected>Yes</select></td></tr>\n"; }
        else { print " selected>No<option value=\"1\">Yes</select></td></tr>\n"; }
        print "<tr><td align=\"right\">Should I show make the user enter comments in order to sign?</td>\n";
        print "<td><select name=\"rcomments\"><option value=\"0\"";
        if ($rcomments) { print ">No<option value=\"1\" selected>Yes</select></td></tr>\n"; }
        else { print " selected>No<option value=\"1\">Yes</select></td></tr>\n"; }
        print "<tr><td align=\"right\">Should I put the statistics at the bottom of the guestbook?</td>\n";
        print "<td><select name=\"stats\"><option value=\"0\"";
        if ($showstats) { print ">No<option value=\"1\" selected>Yes</select></td></tr>\n"; }
        else { print " selected>No<option value=\"1\">Yes</select></td></tr>\n"; }
        print "<tr><td align=\"right\">If you want a background image, enter it's URL:</td>\n";
        print "<td><input type=\"text\" name=\"background\" value=\"$background\"></td></tr>\n";
        print "<tr><td align=\"right\">What color should the links be?</td>\n";
        print "<td><input type=\"text\" name=\"link\" value=\"$link\" size=\"7\"></td></tr>\n";
        print "<tr><td align=\"right\">What color should the active links be?</td>\n";
        print "<td><input type=\"text\" name=\"alink\" value=\"$alink\" size=\"7\"></td></tr>\n";
        print "<tr><td align=\"right\">What color should the visited links be?</td>\n";
        print "<td><input type=\"text\" name=\"vlink\" value=\"$vlink\" size=\"7\"></td></tr>\n";
        print "<tr><td align=\"right\">What color should the text be?</td>\n";
        print "<td><input type=\"text\" name=\"text\" value=\"$text\" size=\"7\"></td></tr>\n";
        print "<tr><td align=\"right\">What color should the background be?</td>\n";
        print "<td><input type=\"text\" name=\"bgcolor\" value=\"$bgcolor\" size=\"7\"></td></tr>\n";             
        $shownum++;
        print "<tr><td align=\"right\">How many entries should I display on each page?  Enter 0 if you want me to display them all.</td>\n";
        print "<td><input type=\"text\" name=\"shownum\" value=\"$shownum\" size=\"3\"></td></tr>\n";
        $maxnum++;
        print "<tr><td align=\"right\">How many entries should I keep before I start deleting the oldest?  Enter 0 if you want me to keep them all.</td>\n";
        print "<td><input type=\"text\" name=\"maxnum\" value=\"$maxnum\" size=\"3\"></td></tr>\n";
        print "<tr><td align=\"right\">What's your e-mail address?</td>\n";
        print "<td><input type=\"text\" name=\"youremail\" value=\"$youremail\"></td></tr>\n";        
        print "<tr><td align=\"right\">Should I e-mail you the entry whenever someone signs?</td>\n";
        print "<td><select name=\"notify1\"><option value=\"0\"";
        if ($notify1) { print ">No<option value=\"1\" selected>Yes</select></td></tr>\n"; }
        else { print " selected>No<option value=\"1\">Yes</select></td></tr>\n"; }
        print "<tr><td align=\"right\">Should I e-mail you the entry whenever someone incorrectly guesses your password?</td>\n";
        print "<td><select name=\"notify2\"><option value=\"0\"";
        if ($notify2) { print ">No<option value=\"1\" selected>Yes</select></td></tr>\n"; }
        else { print " selected>No<option value=\"1\">Yes</select></td></tr>\n"; }
        print "<tr><td align=\"right\">What password do you want to use?</td>\n";
        print "<td><input type=\"text\" name=\"pw\" value=\"$FORM{'password'}\"></td></tr>\n";
        print "<tr><td align=\"right\"><input type=\"submit\" value=\" Submit \"></td>\n";
        print "<td><input type=\"reset\"></td></tr></table></td></tr></table></form></center>\n";
        &stats;
        print "</body></html>\n";
        exit;
}

sub checkpassword {
        if ($FORM{'password'} eq "") {
                print "<html><head><title>You need a password for that!</title></head>\n";
                print "I'm sorry, but you need the password to do that.</body></html>\n";
                exit;
        }
        elsif ($FORM{'password'} ne $password) {
                if (($ENV{'REMOTE_HOST'} eq $ENV{'REMOTE_ADDR'}) && ($ENV{'REMOTE_ADDR'} =~ /(\d+)\.(\d+)\.(\d+)\.(\d+)/)) {
                        $Address = pack('C4', $1, $2, $3, $4);
                        $DNS_Address = (gethostbyaddr($Address, 2))[0];
                        $ENV{'REMOTE_HOST'} = $DNS_Address if $DNS_Address;
                }
                print "<html><head><title>Bad password</title></head>\n";
                &body();
                print "<h1>Bad Password</h1><br>\n";
                print "The password you entered, $FORM{'password'}, is incorrect.\n";
                if ($notify2 == 1 && $youremail) {
                        ($data,$time) = &gettime;
                        print "The following information has been mailed to the owner\n";
                        print "of this Guestbook.<ul>\n";
                        print "<li>Date/Time: $date/$time\n";
                        print "<li>Domain: $ENV{'REMOTE_HOST'}\n";
                        print "<li>IP Address: $ENV{'REMOTE_ADDR'}";
                        print "<li>Password: $FORM{'password'}\n";
                        print "</ul></body></html>\n";
                        open (MAIL,"|$mailprogram");
                        print MAIL "To: $youremail\n";
                        print MAIL "From: hell.if\@i.know\n";
                        print MAIL "Subject: Attempted hack\n\n";
                        print MAIL "Someone has tried to guess your password for your\n";
                        print MAIL "guestbook!  The following information was logged:\n";
                        print MAIL "* Date/Time: $date/$time\n";
                        print MAIL "* Domain: $ENV{'REMOTE_HOST'}\n";
                        print MAIL "* IP Address: $ENV{'REMOTE_ADDR'}\n";
                        print MAIL "* Password: $FORM{'password'}\n";
                        close (MAIL);
                }
                exit;
        }
}

sub report {
        open (MAIL,"|$mailprogram");
        print MAIL "To: clifftm\@shavenferret.com\n";
        print MAIL "From: $youremail\n";
        print MAIL "Subject: Bug Report\\Suggestion for Guestbook\n";
        print MAIL "bug\\suggestion\\comment:\n";
        print MAIL "$FORM{'bug'}\n";
        close (MAIL);
        print "<html><head><title>Thanks for your feedback!</title></head>\n";
        print "<h1>Thanks for your feedback!</h1>I'll check it out as soon\n";
        print "as possible.  Please click back\n";
        exit;
}

sub setup {
        &checkpassword;
        $FORM{'maxnum'}--;
        $FORM{'shownum'}--;
        open (FILE,">$datafile");
        print FILE "$FORM{'signhtml'}|$FORM{'title'}|$FORM{'background'}|$FORM{'link'}|$FORM{'alink'}|$FORM{'vlink'}|$FORM{'text'}|$FORM{'bgcolor'}|$images|$names|$FORM{'addimage'}|$FORM{'shownum'}|$FORM{'preview'}|$FORM{'rname'}|$FORM{'remail'}|$FORM{'rcomments'}|$FORM{'youremail'}|$FORM{'notify1'}|$FORM{'notify2'}|$FORM{'pw'}|$FORM{'maxnum'}|$FORM{'stats'}\n";                                              
        unless ($maxnum == -1) { while ($#data > $maxnum) { unshift(@data); } }
        foreach $line(@data) { print FILE "$line"; }
        close(FILE);
        open (DATA, "$datafile");
        @data = <DATA>;
        close(DATA);
        chomp($data[0]);
        ($signhtml,$pagetitle,$background,$link,$alink,$vlink,$text,$bgcolor,$images,$names,$addimage,$shownum,$preview,$rname,$remail,$rcomments,$youremail,$notify1,$notify2,$password,$maxnum,$showstats) = split(/\|/, shift(@data));
        print "<html><head><title>Configuration Updated</title></head>\n";
        &body;
        print "The new setup has been accepted.  To go back, click <form method=\"POST\">\n";
        print "<input type=\"hidden\" name=\"action\" value=\"admin\">\n";
        print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'pw'}\">\n";
        print "<input type=\"submit\" value=\" this button \"></form></body></html>\n";
        exit;
}

sub stats {
        print "<center><table width=\"400\" border=\"5\"><tr><td><center>\n";
        print "<h1>Statistics</h1><table cols=\"2\"><tr><td align=\"right\">\n";
        $i = $#data + 1;
        foreach $line(@data) {
                chomp($line);
                ($name,$email,$title,$url,$image,$content,$design,$comments,$gender,$age,$date,$time) = split(/\|/, $line);
                $rcontent += $content;
                $rdesign += $design;
                if ($gender eq "male") { $rmale++; }
                else { $rfemale++; }
                $rage[$age]++;
        }
        print "Number of guestbook signings:</td><td>$i</td></tr>\n";
        print "</table><b>Gender</b><table cols=\"2\"><tr><td align=\"right\">\n";
        $j = sprintf("%.2f",($rmale / $i) * 100);
        print "Male:</td><td>$rmale ($j%)</td></tr>\n";
        print "<tr><td align=\"right\">Female:</td>\n";
        $j = sprintf("%.2f",($rfemale / $i) * 100);
        print "<td>$rfemale ($j%)</td></tr></table>\n";
        print "<b>Age</b><table cols=\"2\"><tr><td align=\"right\">\n";
        $j = sprintf("%.2f",($rage[0] / $i) * 100);
        print "Under 18:</td><td>$rage[0] ($j%)</td></tr>\n";
        print "<tr><td align=\"right\">18-27\n";
        $j = sprintf("%.2f",($rage[1] / $i) * 100);
        print "</td><td>$rage[1] ($j%)</td></tr>\n";
        print "<tr><td align=\"right\">28-37\n";
        $j = sprintf("%.2f",($rage[2] / $i) * 100);
        print "</td><td>$rage[2] ($j%)</td></tr>\n";
        print "<tr><td align=\"right\">38-47\n";
        $j = sprintf("%.2f",($rage[3] / $i) * 100);
        print "</td><td>$rage[3] ($j%)</td></tr>\n";
        print "<tr><td align=\"right\">48-57\n";
        $j = sprintf("%.2f",($rage[4] / $i) * 100);
        print "</td><td>$rage[4] ($j%)</td></tr>\n";
        print "<tr><td align=\"right\">58-67\n";
        $j = sprintf("%.2f",($rage[5] / $i) * 100);
        print "</td><td>$rage[5] ($j%)</td></tr>\n";
        print "<tr><td align=\"right\">Over 67\n";
        $j = sprintf("%.2f",($rage[6] / $i) * 100);
        print "</td><td>$rage[6] ($j%)</td></tr></table>\n";
        print "<b>Rating</b><table cols=\"2\"><tr><td align=\"right\">\n";
        $j = sprintf("%.2f",$rdesign / $i);
        print "Design:</td><td>$j</td></tr>\n";
        print "<tr><td align=\"right\">Content:</td>\n";
        $j = sprintf("%.2f",$rcontent / $i);
        print "<td>$j</td></tr></table></td></tr></table>\n";
        print "</center>\n";
}

sub delete {
        &checkpassword;
        splice(@data,$FORM{'num'},1,());
        &writedata;
        print "<html><head><title>Entry Deleted</title></head>\n";
        &body;
        print "<h1>Entry Deleted</h1>The entry has been deleted.  To\n";
        print "go back, click <form method=\"POST\"><input type=\"hidden\"";
        print " name=\"action\" value=\"approved\"><input type=\"hidden\"";
        print " name=\"password\" value=\"$FORM{'password'}\">\n";
        print "<input type=\"submit\" value=\" this button \"></form>\n";
        print "</body></html>\n";
        exit;
}

sub modify {
        &checkpassword;
        $line = "$FORM{'name'}|$FORM{'email'}|$FORM{'title'}|$FORM{'url'}|$FORM{'image'}|$FORM{'content'}|$FORM{'design'}|$FORM{'comments'}|$FORM{'gender'}|$FORM{'age'}|$FORM{'date'}|$FORM{'time'}\n";
        splice(@data,$FORM{'num'},1,($line));
        &writedata;
        print "<html><head><title>Entry Modified</title></head>\n";
        &body;
        print "<h1>Entry Modified</h1>The entry has been modified.  To\n";
        print "go back, click <form method=\"POST\"><input type=\"hidden\"";
        print " name=\"action\" value=\"admin\"><input type=\"hidden\"";
        print " name=\"password\" value=\"$FORM{'password'}\">\n";
        print "<input type=\"submit\" value=\" this button \"></form>\n";
        print "</body></html>\n";
        exit;
}

sub writedata {
        open (FILE,">$datafile");
        print FILE "$signhtml|$pagetitle|$background|$link|$alink|$vlink|$text|$bgcolor|$images|$names|$addimage|$shownum|$preview|$rname|$remail|$rcomments|$youremail|$notify1|$notify2|$password|$maxnum|$stats\n";
        foreach $line(@data) { print FILE "$line"; }
}

sub approved {
                print "<html><head><title>Delete\\Modify Entries</title></head>\n";
                &body;
                $countnum = 0;
                foreach $line(@data) {
                        chomp($line);
                        ($name,$email,$title,$url,$image,$content,$design,$comments,$gender,$age,$date,$time) = split(/\|/, $line);
                        print "<form method=\"POST\"><input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
                        print "<input type=\"hidden\" name=\"num\" value=\"$countnum\">\n";
                        print "<center><table border=\"5\" width=\"500\"><tr><td>\n";
                        print "<table cols=\"2\"><tr><td align=\"right\">Name:</td>\n";
                        print "<td><input type=\"text\" name=\"name\" value=\"$name\"></td></tr>\n";
                        print "<tr><td align=\"right\">E-mail:</td>\n";
                        print "<td><input type=\"text\" name=\"email\" value=\"$email\"></td></tr>\n";
                        print "<tr><td align=\"right\">Web Page Title:</td>\n";
                        print "<td><input type=\"text\" name=\"title\" value=\"$title\"></td></tr>\n";
                        print "<tr><td align=\"right\">Web Page URL:</td>\n";
                        print "<td><input type=\"text\" name=\"url\" value=\"$url\"></td></tr>\n";
                        print "<tr><td align=\"right\">Image URL:</td>\n";
                        print "<td><input type=\"text\" name=\"image\" value=\"$image\"></td></tr>\n";
                        print "<tr><td align=\"right\">Content Rating:</td>\n";
                        print "<td><select name=\"content\">\n";
                        for ($i = 1; $i < 11; $i++) {
                                print "<option value=\"$i\"";
                                if ($i == $content) { print " selected"; }
                                print ">$i\n";
                        }
                        print "</select></td></tr><tr><td align=\"right\">Design Rating:</td>\n";
                        print "<td><select name=\"design\">\n";
                        for ($i = 1; $i < 11; $i++) {
                                print "<option value=\"$i\"";
                                if ($i == $design) { print " selected"; }
                                print ">$i\n";
                        }
                        print "</select></td></tr><tr><td align=\"right\">Gender:</td>\n";
                        print "<td><select name=\"gender\"><option\n";
                        if ($gender eq "male") { print " selected>male<option>female</select></td></tr>"; }
                        else { print ">male<option selected>female</select></td></tr>\n"; }
                        print "<tr><td align=\"right\">Age:</td>\n";
                        print "<td><select name=\"age\">\n";
                        for ($i = 0; $i < 7; $i++) {
                                print "<option ";
                                if ($i == $age) { print "selected "; }
                                if ($i == 0) { print "value=\"0\">Under 18\n"; }
                                if ($i == 1) { print "value=\"1\">18-27\n"; }
                                if ($i == 2) { print "value=\"2\">28-37\n"; }
                                if ($i == 3) { print "value=\"3\">38-47\n"; }
                                if ($i == 4) { print "value=\"4\">48-57\n"; }
                                if ($i == 5) { print "value=\"5\">58-67\n"; }
                                if ($i == 6) { print "value=\"6\">Over 67\n"; }
                        }
                        print "</select></td></tr>\n";
                        print "<tr><td align=\"right\">Date:</td>\n";
                        print "<td><input type=\"text\" name=\"date\" value=\"$date\"></td></tr>\n";
                        print "<tr><td align=\"right\">Time:</td>\n";
                        print "<td><input type=\"text\" name=\"time\" value=\"$time\"></td></tr>\n";
                        print "<tr><td align=\"right\">Comments:</td>\n";
                        print "<td><textarea name=\"comments\" rows=\"5\" cols=\"20\" wrap=\"soft\">$comments</textarea></td></tr>\n";
                        print "<tr><td align=\"right\">What should I do?</td>\n";
                        print "<td><input checked type=\"radio\" name=\"action\" value=\"modify\">Edit this entry<br>\n";
                        print "<input type=\"radio\" name=\"action\" value=\"delete\">Delete this entry</td></tr>\n";
                        print "<tr><td align=\"right\"><input type=\"submit\" value=\" Do it! \"></td>\n";
                        print "<td><input type=\"reset\"></td></tr></table></td></tr></table></form><p>\n";
                        print "<center><hr width=\"400\"></center>\n";
                        $countnum++;
                }
                exit;
}

sub add_image {
        &checkpassword;
        if ($images) { $images .= "\t"; $names .= "\t"; }
        $images .= "$FORM{'url'}";
        $names .= "$FORM{'desc'}";
        &writedata;
        print "<html><head><title>Image Added</title></head>\n";
        &body;
        print "The image has been added. To go back, click <form method=\"POST\">\n";
        print "<input type=\"hidden\" name=\"action\" value=\"admin\">\n";
        print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
        print "<input type=\"submit\" value=\" this button \"></form></body></html>\n";
        exit;
}

sub remove_image {
        &checkpassword;
        @tx = split(/\t/, $images);
        @ty = split(/\t/, $names);
        $images = "";
        $names = "";
        $num = 0;
        for ($i = 0; $i <= $#tx; $i++) {
                unless ($FORM{$i}) {
                        unless ($num == 0) { $images .= "\t"; $names .= "\t"; }
                        $images .= "$tx[$i]"; $names .= "$ty[$i]";
                        $num++;
                }
        }
        print "<html><head><title>Image Removed</title></head>\n";
        &body;
        &writedata;
        print "The image has been removed. To go back, click <form method=\"POST\">\n";
        print "<input type=\"hidden\" name=\"action\" value=\"admin\">\n";
        print "<input type=\"hidden\" name=\"password\" value=\"$FORM{'password'}\">\n";
        print "<input type=\"submit\" value=\" this button \"></form></body></html>\n";
        exit;
}
