#!/usr/bin/perl

################################################################################
#
#	GuestBook release 4 (Sat 19 Jan 2002 18:17:41)
#
#	Copyright (C) 2002 [Rainman]. All rights reserved.
#
#	E-mail: rainman@id.ru
#		webmaster@lasource.r2.ru
#
#	Site  : www.lasource.r2.ru
#
################################################################################





##### CONFIGURATION SECTION ####################################################

# ABSOLUTE path (the last slash is required!!!) to your CGI-BIN directory.
$RootDir = '/var/www/html/cgi-bin/';

# The following files should have 0666 permissions (and the password file should
# be only world readable). Feel free to change paths and filenames as  you like.
$GB_File = $RootDir . 'guestbook/guestbook.dat';
$LG_File = $RootDir . 'guestbook/guestbook.log';
$IP_File = $RootDir . 'guestbook/guestbook.ips';
$PW_File = $RootDir . 'guestbook/passwd';

# Is required only for sending notification messages (optional).
$Mailer = '/usr/lib/sendmail -t';

# Some identification values.
$BrowserTitle = 'GuestBook AC';
$GuestBookName = 'My GuestBook';
$AdministratorName = 'Admin';
$AdministratorMail = 'admin@site.ru';
$AdministratorSays = 'Thank you for visiting my website';

# Various interface colors.
$ac_bg_color = '"#CCCCCC"';
$table_bg_color = '"#EEEEEE"';
$text_color = '"#000000"';
$comment_color = '"#FF0000"';

# Number of guestbook records displayed per page.
$RecordsPerPage = 10;

# Write all transactions to the special log file. I think, it is rather useful
# for security and statistic purposes.
$LogEnabled = 1;

# Log size measured in KBytes,
$LogSize = 32;

# Send visitor a short message and thank him for visiting your site.
# Requires sendmail access.
$SendMail = 0;

# Defines the time (in seconds), when a visitor is not allowed to send more messages 
# from one IP.
$TimeOut = 60;

# Locale settings (please note the difference of used quotes!!!).
$LC_Modify_Comment = '"Modify"';
$LC_Remove_Comment = '" "';
$LC_Ask_Password = " :";
$LC_Access_Denied = "  !";
$LC_Send_Password = '"!"';

################################################################################





##### SOURCE CODE SECTION ######################################################

# Derived and system variables (not the subject of change, sir!).
$domain = 'http://'.$ENV{'SERVER_NAME'};
$path = $ENV{'DOCUMENT_ROOT'};
$referrer = $ENV{'HTTP_REFERER'};
$cgiurl = $domain.$ENV{'SCRIPT_NAME'};
$ip = $ENV{'REMOTE_ADDR'}; 

################################################################################

&date;
&cl_read;
if ($INPUT{'REMOVE'}) { &remove; &ac_main;}
if ($INPUT{'COMMENT'}) { &addcomment; &ac_main;}
if ($INPUT{'SENDPASS'}) { &admin; }
if ($INPUT{'ADD'}) { &editbook; &mail;}
&showbook;
exit;

################################################################################

sub cl_read 
{
 # Parse command line and extract some useful things.
 if ($ENV{'QUERY_STRING'}) 
    {
     $namevalues = $ENV{'QUERY_STRING'};
    }
 else
    {
     read (STDIN, $namevalues, $ENV{'CONTENT_LENGTH'});
    }

 @pairs = split(/&/, $namevalues);

 foreach $pair (@pairs) 
    {
     ($name, $value) = split(/=/, $pair);
     $value =~ tr/+/ /;
     $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
     $value =~ s/<!--(.|\n)*-->//g;

     if ($name eq 'showbook') 
        {
	 &showbook ($value);
	}
     
     if ($name eq 'admin') 
        {
	 &adminpass;
	}
	
     if ($name eq 'add') 
        {
	 &create;
	}
          
     $value =~ s/<([^>]|\n)*>//g;
     $INPUT{$name} = $value;
    }
}

################################################################################

sub WriteLog
{
 my ($LogType, $LogMessage) = @_;
 
 if ($LogEnabled)
    {    
     $CTime = localtime(time);
     
     # Now we check, if the log file is too large.
     $FSize = (-s "$LG_File");
     if ($FSize > ($LogSize*1024))
        {		       
         open (LOG, ">$LG_File");
	}
     else
        {
	 open (LOG, ">>$LG_File");
	}
		
     print LOG ("$CTime\t[$LogType] $LogMessage\n");
     close (LOG);
    } 
}

################################################################################

sub date 
{ 
 ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime (time);
 @months = ("01","02","03","04","05","06","07","08","09","10","11","12"); 

 if ($sec < 10) {$sec = "0$sec";}
 if ($min < 10) {$min = "0$min";}
 if ($hour < 10) {$hour = "0$hour";}
 if ($mday < 10) {$mday = "0$mday";}

 $year = $year+1900;   
 $date = "$mday/@months[$mon]/$year"; 
 $time = "$hour:$min";
} 
 
################################################################################

sub mail
{
 if ($SendMail == 0) 
    {
     &showbook;
    }
    
 open (MAIL, "|$Mailer");
 print MAIL "To: $email\n";
 print MAIL "From: $AdministratorMail\n";
 print MAIL "Subject: $GuestBookName message\n\n";
 print MAIL "Hello  $name,\n$AdministratorSays\n";
 close (MAIL);
}

################################################################################

sub editbook 
{
 $num = 0;
 $counter = 0;

 $name = $INPUT{'NAME'}; 
 $email = $INPUT{'EMAIL'};
 $site = $INPUT{'SITE'};
 $city = $INPUT{'CITY'};
 $comments = $INPUT{'COMMENTS'};

 $enter = '
';
 $replace = '';
 $comments =~ s/$enter/$replace/g;

 # We don't allow user to send messages twice (and therefore dublicate them).
 open IP_FILE, "$IP_File" or die "ERROR: could not open $IP_File !";
 @IPs = <IP_FILE>;
 close (IP_FILE);

 $unix_time = time;
 open IP_NEW_FILE, ">$IP_File" or die "ERROR: could not open $IP_File !";
 if (@IPs > 0) 
    {
     foreach $ip_line (@IPs) 
	{
         @ip_entries = split (" ", $ip_line);	 
         $ip_entry = $ip_entries [0];	
	 $ip_time = $ip_entries [1];	
	 
         if (($unix_time - $ip_time) < $TimeOut)
            {
	     print IP_NEW_FILE ("$ip_line");
	     if ("$ip_entry" eq "$ip")
	        {
                 &showbook;
		} 
	    }
	}
    } 
 print IP_NEW_FILE ("$ip $unix_time\n");    
 close (IP_NEW_FILE);
  
 # Check if all of the fields were filled correctly.
 if ($name eq '') { $num = ($num + 1); }
 if ($email eq '') { $num = ($num + 1); }
 if ($comments eq '') { $num = ($num + 1); }

 if ($num ne 0) 
    {
     print ("Content-type: text/html\n\n");
     print ("<html>\n");
     print ("<META HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">\n");
     print ("<center><H2>ERROR!</H2>\n\n");
     print ("<font face=\"Arial, sans-serif\" size=2 color=\"\#0000FF\"><b>\n");
     print ("More information required:<br></b></font>\n");
     print ("<font face=\"Arial, sans-serif\" size=2 color=\"\#FF0000\"><b>\n");
     print ("$num field(s) are empty!<br><FORM>\n");
     print ("<input type=\"button\" VALUE=\"\" onClick=\"history.go(-1)\"></FORM></center></html>\n");
     exit;
    }

 # Open guestbook database file and read all available records.
 open FILE, "$GB_File" or die "ERROR: could not open $GB_File !";
 @lines = <FILE>;
 close (FILE);

 # Getting array length and maximum record ID. 
 @Header = split ("_", $lines [0]);
 $counter = $Header [1] + 1;

 # Now we add a new record.
 open GUEST,">$GB_File" or die "ERROR: could not open $GB_File !";

 if (length ($site))
    {
     if (index ($site, "http://"))
        {
	 $site = "http://" . $site;
	}
     print GUEST ("<!--\_$counter\_1\_-->");
    }
 else
    {
     print GUEST ("<!--\_$counter\_0\_-->");
    }
     
 if ($city ne '')
    {
     print GUEST ("<b>:&nbsp;$name&nbsp;($city)<br>E-mail: <a href=\"mailto:$email\">$email</a>");
    }
 else 
    {
     print GUEST ("<b>:&nbsp;$name<br>E-mail: <a href=\"mailto:$email\">$email</a>"); 
    }
    
 if (length ($site) > 7)
    {
     print GUEST ("<br>: <a href=\"$site\" target=\"_blank\">$site</a>");
    }
    
 print GUEST ("</b><br>$comments<br><font color=\"\#999999\"><i> $date  $time</i></font>\n");
 
 # If there are some other records, we add them too.
 if (@lines > 0) 
    {
     foreach $line (@lines) 
	{
	 print GUEST ("$line");
	}
    } 

 # Close guestbook database file.
 close (GUEST);

 # Add notice to the log (if neccesary). 
 &WriteLog ("*", "Record by $name ($email) with ID=$counter was added from $ip");
}

################################################################################

sub create
{
 print ("Content-type: text/html\n\n");
 open (HEADER, "header.html");
 print <HEADER>;
 close (HEADER);

 print ("<blockquote>\n");
 print ("<font face=\"Arial, sans-serif\" size=\"2\">\n");
 print ("<b> :</b><br><i>(,  ,     )</i>\n");
 print ("<form method=\"post\" action=\"$cgiurl\">\n");
 print (":<br><input type=\"text\" name=\"NAME\" size=\"32\" maxlength=\"255\"><br><br>\n");
 print ("E-mail:<br><input type=\"text\" name=\"EMAIL\" maxlength=\"255\" size=\"32\"><br><br>\n");
 print ("*:<br><input type=\"text\" name=\"SITE\" size=\"32\" maxlength=\"255\" value=\"http://\"><br><br>\n");
 print ("*:<br><input type=\"text\" name=\"CITY\" size=\"32\" maxlength=\"255\"><br><br>\n");
 print (":<br><textarea name=\"COMMENTS\" cols=\"32\" rows=\"8\" wrap=\"VIRTUAL\"></textarea><br><br>\n");
 print ("<input type=\"submit\" name=\"ADD\" value=\"!\"><input type=\"reset\" value=\"?\">\n");
 print ("</form></font>\n");
 print ("</blockquote><br><br>\n");

 open (FOOTER, "footer.html");
 print <FOOTER>;
 close (FOOTER);

 exit;
}

################################################################################

sub showbook 
{
 my ($nRecords) = @_;
 
 print ("Content-type: text/html\n\n");

 open (HEADER, "header.html");
 print <HEADER>;
 close (HEADER);

 print ("<div align=\"center\"><font face=\"Arial, sans-serif\", size=\"2\">");
 print ("<a href=\"$cgiurl?add\">  </a>\n");
 print ("</font></div>\n<blockquote><font face=\"Arial, sans-serif\", size=\"2\">\n");

 open FILE, "$GB_File" or die "ERROR: could not open $GB_File !";
 @lines = <FILE>;
 close(FILE);
 
 if (@lines >0)
    {
     for ($nI = $nRecords; $nI < ((@lines<$RecordsPerPage) ? @lines : $nRecords+$RecordsPerPage); $nI++)
         {
	  print ("<p align=\"justify\">$lines[$nI]</p><br><br>");     
	 }
     
     if (@lines > $RecordsPerPage)
        {
	 print ("<br><br><center>|");
	 for ($nJ = 0; $nJ*$RecordsPerPage < @lines; $nJ++)
	     {
	      if ($nRecords == $nJ*$RecordsPerPage)
	         {
	          print ("&nbsp;&nbsp;<b>", $nJ+1, "</b>&nbsp;&nbsp;|");
		 }
	      else
	         {
	          print ("&nbsp;&nbsp;<b><a href=\"$cgiurl?showbook=", $nJ*$RecordsPerPage, "\">", $nJ+1, "</a></b>&nbsp;&nbsp;|");		 
		 }
	     }
	 print ("</center>\n");	     
	}
    } 
 else 
    {
     print ("<br><br><center>    !</center>\n");
    }

 print ("</font></blockquote>\n");

 open (FOOTER, "footer.html");
 print <FOOTER>;
 close (FOOTER);

 exit;
}

################################################################################

sub remove
{
 $removedate = $INPUT{'RECORD'};

 open FILE, "$GB_File" or die "ERROR: could not open $GB_File !";
 @lines = <FILE>;
 close(FILE);

 open GUEST,">$GB_File" or die "ERROR: could not open $GB_File !";
 
 foreach $line (@lines)
    {
     @rementry = split ("_", $line);
     $remrecord = $rementry[1];

     if ($remrecord eq $removedate)
        {
	 &WriteLog ("*", "Record with ID=$removedate was successfully removed");
        }
     else 
        {
	 print GUEST ("$line");
	}
    }
 close (GUEST);
}

################################################################################

sub addcomment
{
 $nRecord = $INPUT{'RECORD'};
 $NewComment = $INPUT{'ADMIN_COMMENTS'};

 open (FILE, "$GB_File");
 @lines = <FILE>;
 close(FILE);

 open GUEST, ">$GB_File" or die "ERROR: could not open $GB_File !";
 foreach $line (@lines) 
    {
     @comentry = split ("_", $line);
     $nCurrent = $comentry[1];

     if ($nCurrent eq $nRecord)
        {
	 # Find previous comment, if any.
	 $Offset = index ($line, "<br><font color=$comment_color>");
	 if ($Offset == -1)
	    {
	     $Offset = length ($line)-1;
	    }	    
         # Cut the line and write it back.
	 $tmpline = substr ($line, 0, $Offset);
	 if (length ($NewComment))
	    {
	     print GUEST ("$tmpline<br><font color=$comment_color>$AdministratorName:&nbsp;$NewComment&nbsp;</font>\n"); 
	    }
	 else
	    {
	     print GUEST ("$tmpline\n");
	    }      
	}
     else 
        {
	 print GUEST ("$line");
	}
    }
 close (GUEST);
}

################################################################################

sub adminpass 
{
 print ("Content-type: text/html\n\n");
 print ("<html>\n");
 print ("<head>\n");
 print ("<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
 print ("<title>$BrowserTitle</title></head>\n");
 print ("<body bgcolor=$ac_bg_color text=$text_color><center>\n");
 print ("<font face=\"Arial, sans-serif\"  size=\"+3\">$GuestBookName Administration Console</font>\n");
 print ("<hr width=\"100%\" noshade><br><br><font face=\"Arial, sans-serif\" size=\"2\"><b>\n");
 print ("$LC_Ask_Password</b></font>\n");
 print ("<br><form method=post action=\"$cgiurl\">\n");
 print ("<input type=\"PASSWORD\" name=\"PASSWORD\" size=32>\n");
 print ("<input type=\"SUBMIT\" name=\"SENDPASS\" value=$LC_Send_Password></form>\n");
 print ("</center></body>\n");
 print ("</html>\n");

 exit;
}

################################################################################

sub admin 
{
 open PASSWD, "$PW_File" or die "ERROR: could not open password file !";
 $adminpass = <PASSWD>;
 close(PASSWD);

 $password = $INPUT{'PASSWORD'};
 
 if ($adminpass ne $password)
    {
     &WriteLog ("!", "AC login with PASS=$password failed from $ip");
     
     print ("Content-type: text/html\n\n");
     print ("<html>\n");
     print ("<head>\n");
     print ("<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
     print ("<title>$BrowserTitle</title></head>\n");
     print ("<body bgcolor=$ac_bg_color text=$text_color><center>\n");
     print ("<font face=\"Arial, sans-serif\"  size=\"\+3\">$GuestBookName Administration Console</font>\n");
     print ("<hr width=\"100%\" noshade><br><br><font face=\"Arial, sans-serif\" size=\"2\"><b>\n");
     print ("<H2><font color=\"\#FF0000\">$LC_Access_Denied</font></H2></body>\n\n");
     exit;
    }

 &WriteLog ("*", "AC login succeeded from $ip");
 
 &ac_main;
}

################################################################################

sub ac_main 
{
 open FILE, "$GB_File" or die "ERROR: could not open $GB_File !";
 @lines = <FILE>;
 close(FILE);

 print ("Content-type: text/html\n\n");
 print ("<html>\n");
 print ("<head>\n");
 print ("<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
 print ("<title>$BrowserTitle</title></head>\n");
 print ("<body bgcolor=$ac_bg_color text=$text_color><center>\n");
 print ("<font face=\"Arial, sans-serif\"  size=\"\+3\">$GuestBookName Administration Console</font>\n");
 print ("<hr width=\"100%\" noshade><br><br>\n");
 print ("<font face=\"Arial, sans-serif\"  size=\"2\">\n");

 foreach $line (@lines)
    {
     # Parse header information.
     @Header = split ("_", $line);
     $CurrentRecord = $Header[1];
     $HasSite = $Header[2];
    
     # Parse record information and display it.
     @CurrentLine = split ("<br>", $line);
     @Name = split("&nbsp;", $CurrentLine[0]); 
     $GuestName = $Name[1];
     $GuestMail = $CurrentLine [1];	
     
     # It is nessasary to extract bare comment from HTML code.
     if ($HasSite eq 1)
	{
	 $GuestMessage = $CurrentLine [3];	
	 $PrevComment = $CurrentLine [5];
	}
     else
        {
	 $GuestMessage = $CurrentLine [2];	
	 $PrevComment = $CurrentLine [4];
	}
     @CommentLine = split ("&nbsp;", $PrevComment);
     $PrevComment = $CommentLine [1];
     	
     # Fill the table row.
     print ("<table width=\"90%\" border=1 cellspacing=0 cellpadding=5>\n");
     print ("<tr bgcolor=$table_bg_color>\n");     
     print ("<td colspan=2 align=center valign=middle>$GuestName ($GuestMail)</td>\n");
     print ("</tr>\n");     

     print ("<tr>\n");     
     print ("<td colspan=2 align=center valign=top><p align=\"justify\">$GuestMessage</p></td>\n");
     print ("</tr>\n");     

     print ("<tr>\n");      
     print ("<td align=center valign=middle>");
     print ("<FORM method=post action=\"$cgiurl\">\n");
     print ("<input type=\"HIDDEN\" NAME=\"RECORD\" VALUE=\"$CurrentRecord\">\n");
     print ("<input type=\"SUBMIT\" NAME=\"REMOVE\" VALUE=$LC_Remove_Comment></td>");
     print ("<td align=center valign=middle>");
     print ("<input type=\"text\"  name=\"ADMIN_COMMENTS\" size=\"32\" maxlength=\"4096\" value=\"$PrevComment\">");
     print ("<input type=\"SUBMIT\" NAME=\"COMMENT\" VALUE=$LC_Modify_Comment></FORM>");
     print ("</td>\n</tr>\n");
     print ("</table>\n<br><br>\n");
    }

 print ("</font>\n");
 print ("<br><br><a href=\"$cgiurl\" target=\"_blank\">Watch results</a> (new window)<br><br><hr width=\"100%\" noshade>\n");
 print ("</body>\n");
 print ("</html>\n");

 exit;
}

################################################################################
