############################################################################
#                                                                          #
# New() & Delete() & Edit()         Version 1.0		                   #
# :  ..            romane@matrixchat.ru                   #
#  3/10/01                     6/28/01          #
#                                                                          #
# :       .htaccess   ,      #
#                                              #
#                                                                          #
#  :							   #
#                &New($login,$password,$path,$authtext);		   #
#                &Edit($login_old,$login,$password,$path);		   #
#                &Delete($login,$path);					   #
#                                                                          #
# :    $login     - ,                  #
#                             : $login = "nickname";                 #
#                $password  - ,                #
#                             : $password = "password";              #
#                $path      - ,     ,   #
#                                      #
#                             : $path = "/users/temp/";              #
#                $login_old - ,   ,   #
#                                                           #
#                $authtext  - ,  ,       #
#                                		   #	
#			      "-",    (") () #
#                                  (')      #
#                             : $authtext = "Dangeon Zone";          #
#                                                                          #
# :                              #
#                                                                          #
#  :                                                           #
# #!/usr/local/bin/perl                                                    #
# require 'htaccess.pl';                                                   #
# print "Content-type: text/plain\n\n";                                    #
#       								   #
# &New('test','password','/users/temp/','My Test');                        #
# &Edit('test','test_new','password_new','/users/temp/');                  #
# Delete('test_new','/users/temp/');                                       #
#                                                                          #
############################################################################

sub New{
 local($login,$password,$path,$authtext) = @_;
 &DeSpace($login,$password,$path,$authtext);

 $path .= '/' if $path !~ /\/$/;
 $authtext =~ s/"/'/g;
 $enc_pass = &Encrypt($password);

 open(PASS, ">>".$path.".htpasswd");
 print PASS "$login:$enc_pass\n";
 close(PASS);
	
 if(! -e $path.".htaccess"){
  open(LOG, ">".$path.".htaccess");
  flock LOG,2;
print LOG qq[AuthUserFile $path.htpasswd
AuthGroupFile /dev/null
AuthName "$authtext"
AuthType Basic

<Limit GET POST>
require user $login
</Limit>];

  close(LOG);
 }
 else{
  local $line;

  open(OLD, $path.".htaccess");
  local @file = <OLD>;
  close(OLD);

  open(LOG, ">".$path.".htaccess");
  flock LOG, 2;
  for($i=0;$i<=$#file-1;$i++){
   chomp($file[$i]);
   print LOG $file[$i]."\n";
  }
  print LOG "require user $login\n";
  print LOG $file[$#file];
  close(LOG);
 }
}

sub Edit{
 local($login_old,$login,$password,$path) = @_;
 &DeSpace($login_old,$login,$password,$path);

 $path .= '/' if $path !~ /\/$/;
 $new_login = "require user $login\n";
 $enc_pass = &Encrypt($password);
 $new_password = "$login:$enc_pass\n"; 

 open(OLD, $path.".htaccess");
 local @file = <OLD>;
 close(OLD);

 open(LOG, ">".$path.".htaccess");
 flock LOG, 2;
 for($i=0;$i<=$#file-1;$i++){
  chomp($file[$i]);
  print LOG $file[$i]."\n" if $file[$i] ne "require user $login_old";
 }
 print LOG $new_login;
 print LOG $file[$#file];
 close(LOG);

 open(OLD, $path.".htpasswd");
 local @file = <OLD>;
 close(OLD);

 open(PASS, ">".$path.".htpasswd");
 flock PASS, 2;
 for($i=0;$i<=$#file;$i++){
  chomp($file[$i]);
  print PASS $file[$i]."\n" if $file[$i] !~ /$login_old:/;
 }
 print PASS $new_password;
 close(PASS);
}

sub Delete{
 local($login,$path) = @_;
 &DeSpace($login,$path);

 $path .= '/' if $path !~ /\/$/;

 open(OLD, $path.".htaccess");
 local @file = <OLD>;
 close(OLD);

 open(LOG, ">".$path.".htaccess");
 flock LOG, 2;
 for($i=0;$i<=$#file;$i++){
  chomp($file[$i]);
  print LOG $file[$i]."\n" if $file[$i] ne "require user $login";
 }
 close(LOG);

 open(OLD, $path.".htpasswd");
 local @file = <OLD>;
 close(OLD);

 open(PASS, ">".$path.".htpasswd");
 flock PASS, 2;
 for($i=0;$i<=$#file;$i++){
  chomp($file[$i]);
  print PASS $file[$i]."\n" if $file[$i] !~ /$login:/;
 }
 close(PASS);
}

sub Encrypt{
 my $str = shift;
 my @salt_chars = ('A'..'Z', 0..9, 'a'..'z','.','/');
 my $salt = join '',@salt_chars[rand 64, rand 64];
 my $encrypted = crypt($str,$salt);
 return $encrypted;
}

sub DeSpace{
 my $str = shift;
 $str =~ s/^\s+//;
 $str =~ s/\s+$//;
 return $str;
}
1;



