#############################################################################
#                                                                           #
# format_date()                     Version 1.5                             #
# : Craig Patchett             craig@patchett.com                      #
#  8/15/96                     6/27/01           #
#                                                                           #
# Copyright 1997 Craig Patchett & Matthew Wright.  All Rights Reserved.     #
# This subroutine is part of The CGI/Perl Cookbook from John Wiley & Sons.  #
# License to use this program or install it on a server (in original or     #
# modified form) is granted only to those who have purchased a copy of The  #
# CGI/Perl Cookbook. (This notice must remain as part of the source code.)  #
#                                                                           #
# :                                              #
#                                                                           #
#  : &format_date($date[, $format, $gmt]);                      #
#                                                                           #
# :    $date -   ,    ,              # 
#			   Perl- time()                              #
#                          : 839120118                                #
#                                                                           #
#									    #	
#                $format -  ,     #
#	                   .        #
#			   -,      #
#			    ,    ,   #
#			      .        #
#			   -      #
#		              $date.		    #
#			   : ' <weekday>, <df> <month>, <year>'#
#                                                                           #
#                $gmt -      ,   ,#
#			           #
#			      (GMT). (       #
#			   ,        # 
#			    $date_format,              # 
#			      )                #
#                          : 'GMT'                                    #
#									    #
#                                                                           #
# -:  							    #
#    :      						    #
#    <h>  ,      (: 6, 12)   		    #
#    <0h> ,       (: 06, 12)   		    #
#    <mh> ,       (: 06, 23)   		    #
#    <n>  ,    (: 6, 35)    		    #
#    <0n> ,      (: 06, 35)   		    #
#    <s>  ,   (: 6, 35)    		    #
#    <0s> ,     (: 06, 35)   		    #
#    *<ap> am/pm        	    		    #
#    *<ap.> a.m./p.m.             		    #
#    <time> ,       (: 6:12 p.m.)   	    #
#    *<timesec> ,     (: 6:12:14 p.m.)	    #  
#    <mtime> ,  ,    (: 18:12)     #  
#    *<mtimesec> ,  ,    (:18:12:14)#
#    :                                                        #
#    <m> ,      (: 6, 12)      		    #  
#    <0m> ,      (: 06,12)      		    #
#    *<mon> (3- )   (: Jan) 	    #
#    *<month>    	  (: January)        	    #
#    <d>  ,    (: 6, 23) 		    #
#    <0d>  ,    (: 06, 23) 	    #
#    *<df>  ,         (: 23rd)   	    	    #
#    <wd>   (0-6, 0-)          	    		    #
#    *<wday> (3- )    (: Fri)   #
#    *<weekday>     (: Friday)   		    #
#    <yr>            (: 96)               	    #
#    <year>       (: 1996)        	    #
#    <yd>  ,    (: 6, 300)		    #
#    <0yd>  ,    (: 006, 300) 	    #
#    *<ydf>  ,           (: 300th)  	    	    #
#     :					            #
#    *<dst> 'dst',   ,   ,		    #
#                  					    #
#    *<dstnot> 'not',     ,   ,       #
#                          				    #
# 		      :'Daylight saving time is <dstnot> in effect' #
#   :  ,  ,  :   #
#                     ,    #
#                     .        #
#               : <AM>   AM  PM,    am  pm   #
#                                                                           #
#                <m>  <0m>    (:),  ,  #
#                    ,  .           #
#               : '<h>:<m>' -  ,   '<h>:<n>'             #
#                                                                           #
# :   ,    ,     #
#         	   ,   date     #
#		 .					    #
#                   							    #
#                    -   #
#		(  )        #
#		      ,         #
#		      				    # 
#                       						    #  
#                 ('')   ,           #
#		 $date    0.			    #
#		(      	    #
#		  $date  )			    #
#                                                                           #
#  :						    #		
#		 @DAYS   -      ,	    #
#			     ,   .     #
#			    @DAYS ,   .   #
#                @MONTHS -     ,         # 
#			     .   				    #
#			    @MONTHS ,   . #
#                                                                           #
#  :                                                            #
# #!/usr/local/bin/perl                                                     #
# require 'formdate.pl';                                                    #
# print "Content-type: text/plain\n\n";                                     #
# $date = time;								    #
# $date_format = 'Today is <weekday>, the <df> of <month>, <year>';         #
# if($formatted_date = &format_date($date,$date_format)){		    #	
#  print $formatted_date;					            #
# } else {                                                                  #
#  print " ";						    #
# }                                                                         #
#                                                                           #
#############################################################################


sub format_date{
 #  
 local($date, $format, $gmt) = @_;
 local(@suffix) = ('th', 'st', 'nd', 'rd');
 local(%date_vars, $result, $var, $upper, $last_digit, $suffix);
 local($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
    
 #    
 if(!@DAYS){
  @DAYS = ('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
 }
 if(!@MONTHS){
  @MONTHS = ('January', 'February', 'March', 'April', 'May', 'June',  
             'July', 'August', 'September', 'October', 'November',
	     'December');
 }

 #          GMT
 if(!$date){ return ($format ? '' : %date_vars); }
 if($gmt){ ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = gmtime($date); }
 else{ ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($date); }
    
 #   
 $date_vars{'mh'} = sprintf("%02d", $hour);
 $date_vars{'mtime'} = sprintf("%02d:%02d", $hour, $min);
 $date_vars{'mtimesec'} = sprintf("%02d:%02d:%02d", $hour, $min, $sec);
 $date_vars{'ap'} = ($hour > 12) ? 'pm' : 'am';
 $date_vars{'ap.'} = ($hour > 12) ? 'p.m.' : 'a.m.';
 if($hour > 12){ $hour -= 12; }
 elsif($hour == 0){ $hour = 12; }
 $date_vars{'h'} = $hour;
 $date_vars{'0h'} = sprintf("%02d", $hour);
 $date_vars{'n'} = $min;
 $date_vars{'0n'} = sprintf("%02d", $min);
 $date_vars{'s'} = $sec;
 $date_vars{'time'} = sprintf("%d:%02d %s", $hour, $min, $date_vars{'ap.'});
 $date_vars{'timesec'} = sprintf("%d:%02d:%02d %s", $hour, $min, $sec, $date_vars{'ap.'});
 $date_vars{'0s'} = sprintf("%02d", $sec);
 $date_vars{'m'} = $mon + 1;
 $date_vars{'0m'} = sprintf("%02d", $mon + 1);
 $date_vars{'mon'} = substr($MONTHS[$mon], 0, 3);
 $date_vars{'month'} = $MONTHS[$mon];
 $date_vars{'d'} = $mday;
 $date_vars{'0d'} = sprintf("%02d", $mday);
 $last_digit = substr($mday, -1);
 if((($mday < 11) || ($mday > 20)) && $last_digit < 4){
  $date_vars{'df'} = $mday . $suffix[$last_digit];
 } else { $date_vars{'df'} = $mday . 'th'; }
 $date_vars{'wd'} = $wday;
 $date_vars{'wday'} = substr($DAYS[$wday], 0, 3);
 $date_vars{'weekday'} = $DAYS[$wday];
 $year = sprintf("%02d", $year);
 $date_vars{'yr'} = $year % 100;
 $date_vars{'year'} = 1900 + $year;
 $date_vars{'yd'} = $yday;
 $date_vars{'0yd'} = sprintf("%03d", $yday);
 $last_digit = substr($yday, -1);
 if((($yday % 100 < 11) || ($yday % 100 > 20)) && $last_digit < 4){
  $date_vars{'ydf'} = $yday . $suffix[$last_digit];
 } else { $date_vars{'ydf'} = $yday . 'th'; }
 $date_vars{'dst'} = $isdst ? 'dst' : '';
 $date_vars{'dstnot'} = $isdst ? '' : 'not ';

 #     
 while($format =~ /<([^>]+)>/){
  #        
  $_ = $1;
  $upper = tr/A-Z/a-z/;
        
  #   <m>     
  if(substr($_, -1) eq 'm'){
   if($` eq ':'){ substr($_, -1) = 'n'; }
  }

  #     ,       
  if($upper){ 
   $var = $date_vars{$_};
   $var =~ tr/a-z/A-Z/;
   $result .= $` . $var;
  } else { $result .= $`.$date_vars{$_}; }
        
  #       
  $format = $';
 }

 #  
 $result .= $format;
    
 #   ,   ,   -
 if($result){ $result; }
 else{ %date_vars; }
}

1;
