#!/usr/bin/perl
##############################################################################
# Cliff's Pic-Post Script Version 4.08                                       # 
# Copyright 1998 Shaven Ferret Productions                                   #
# Created 6/21/98                    Last Modified 09/28/99                  #
# Available at http://www.shavenferret.com/scripts                           #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1998 Shaven Ferret Productions All Rights Reserved.              #
#                                                                            #
# This script can be used\modified free of charge as long as you don't       #
# change this header, or the parts of this script that generate the return   #
# link\form.  If you really need to remove these, go to                      #
# http://www.shavenferret.com/scripts/register.shtml .  By using this script #
# you agree to indemnify me from any liability that might arise from its use.#
#                                                                            #
# Redistributing\selling the code for this program without prior written     #
# consent is expressly forbidden.                                            #
##############################################################################

require "ppsetup.cgi";
require "pp-lib.cgi";
&start;

if ($FORM{'action'} eq "rate") { &rateimage; }
elsif ($FORM{'action'} eq "preview") { &preview; }
elsif ($FORM{'action'} eq "post") { &post; }
elsif ($FORM{'action'} eq "search") { &search; }
elsif ($FORM{'action'} eq "random") { &random; }
else { &submit; }

sub rateimage {
        open(FILE,"$datadir/r$FORM{'image'}.txt");
        my $junk = <FILE>;
        close(FILE);
        ($total,$votes,$last) = split(/\|/,$junk);        
        if ($last eq $ENV{'REMOTE_ADDR'}) { &error("You just rated this image."); }
        if ($FORM{'rating'} > 10 || $FORM{'rating'} < 1) { &error("You're trying to cheat, aren't you?"); }
        $total += $FORM{'rating'};
        $votes++;
        open(FILE,">$datadir/r$FORM{'image'}.txt");
        print FILE "$total|$votes|$ENV{'REMOTE_ADDR'}";
        close(FILE);
        &top("Thank you!","STDOUT");
        print "Your rating of $FORM{'rating'} has been recorded.  Please click <a href=\"$posturl/$FORM{'image'}$ex\">\n";
        print "back</a>.$cfont</body></html>\n";
        if ($eachrate) { &update; }
        exit;
}

sub submit {
        &top("Add your link and image.","STDOUT");
        print "$posthead<h2>Step 1:</h2>\n";
        if ($link) {
                print "We require a return link.  Please copy and paste the\n";
                print "following HTML into your web page:<center><br><form><textarea name=\"x\" cols=\"60\" rows=\"5\">\n";
                print "$link</textarea></form></center><br>In case you're wondering, that\n";
                print "HTML will look like this:<p>$link<p><form method=\"POST\" action=\"$scripturl\">\n";
                print "<table cols=\"2\">\n";
                &textrow ("<a href=\"#1\">Enter the URL of the page with my link here</a>:","link_url","21","http://",-1);
                $html .= "</table>\n";
                if ($link =~ /$counturl\?/) { $html .= "Please note that I do list sites by the amount a return traffic I receive from them, so you will receive more hits if you give me a good link.\n"; }
                $html .= "<h2>Step 2:</h2>\n";
        }
        else { $html .= "<form method=\"POST\" action=\"$scripturl\">\n"; }
        $html .= "Please fill out the following information about the picture you\n";
        $html .= "wish to post.<p>\n";
        $html .= "<center><table width=\"550\" border=\"5\"><tr><td>\n";
        if ($rules) { $html .= "<center><b>Rules: $rules</b></center>\n"; }
        $html .= "<table cols=\"2\">\n";        
        &textrow("<a href=\"#2\">URL of image</a>:","image_url","21","http://",-1);
        if ($hw) {
                &textrow("Height of image in pixels:","height","4","",-1);
                &textrow("Width of image in pixels:","width","4","",-1);
        }
        if ($#image_types > 0) {
                $html .= "<tr><td align=\"right\">$font"."<a href=\"#3\">Type of image</a>:$cfont</td><td><select name=\"image_type\">\n";
                foreach $type(@image_types) { $html .= "<option>$type\n"; }
                $html .= "</select></td></tr>\n";
        }       
        &textrow("<a href=\"#4\">Describe the image</a>:","image_desc","21","",-1);
        $html .= "</table></td></tr></table><hr width=\"400\"></center><h2>Step ";
        if ($link) { $html .= "3:</h2>\n"; }
        else { $html .= "2:</h2>\n"; }
        $html .= "Please fill out the following information about your site.<p><center>\n";
        $html .= "<table width=\"550\" border=\"5\"><tr><td><table cols=\"2\"><tr>\n";
        &textrow("Enter the URL of your main page:","site_url","21","http://",-1);
        &textrow("<a href=\"#5\">Enter your site's name</a>:","site_name","21","",-1);
        if ($type_of_link != 0) {
                &textrow("Please enter the URL of your site's banner:","banner_url","21","http://",-1);
                if ($hw2) {
                        &textrow("Please enter your banner's height in pixels:","banner_height","3","80",-1);
                        &textrow("Please enter your banner's width in pixels:","banner_width","3","468",-1);
                }
        }
        if ($type_of_link != 1) { &textrow("<a href=\"#6\">Please enter a description of your site</a>:","site_desc","21","",-1); } 
        if ($type_of_link == 2) { &yesno("Would you like me to use your banner or your description for your return link?","link_choice","1","Banner","Description",-1); }
        &textrow("<a href=\"#7\">Your E-mail address</a>:","email","21","",-1);
        unless ($showhints) {
                $html =~ s/<a href="#\d+">//ig;
                $html =~ s/<\/a>//ig;
        }
        print "$html";
        print "</table></td></tr></table><hr width=\"400\"></center><h2>Step ";
        if ($link) { print "4:</h2>\n"; }
        else { print "3:</h2>\n"; }
        print "<input type=\"hidden\" name=\"action\" value=\"preview\">\n";
        print "Please make sure all of the information is correct and click\n";
        print "<input type=\"submit\" value=\" This Button \"></form><center>\n";
        print "<hr width=\"70%\">Pic-Post script by <a href=\"http";
        print "://www.shavenferret.com/cliff/\" target=\"new\">Cliff(tm)</a>, <a ";
        print "href=\"http://www.shavenferret.com\" target=\"new\">Shaven ";
        print "Ferret Productions</a>, and can be found at <a href=\"http:";
        print "//www.shavenferret.com/scripts\" target=\"new\">http://www.";
        print "shavenferret.com/scripts</a>.<hr width=\"70%\"></center>\n";
        if ($showhints) {
                print "<h1>Stuff you should know before posting</h1>\n";
                if ($link) {
                        print "<a name=\"1\"><h2>About your return link</h2></a><ul>\n";
                        print "<li>This script lets me lock out and blacklist certain sites.\n";
                        print "If you take down my link after a few days, put my link on a page\n";
                        print "with no links to it, or do some other sleazy thing then there's a good\n";
                        print "chance that you will be locked out from this, and several other\n";
                        print "pic-post sites.\n";
                        if($link =~ /$counturl\?/) {
                                print "<li>I list sites by the amount of return traffic they send\n";
                                print "me, as well as chronologically,\n";
                                unless ($norate) { print "by rating,\n"; }
                                print "and by section.\n";
                                print "If you give me a good link, more people will see your image,\n";
                                print "and you will receive more traffic.\n";
                        }
                        print "</ul>\n";
                }
                print "<a name=\"2\"><h2>About your image</h2></a><ul>\n";
                unless ($norate) {
                        print "<li>This script allows users to rate images on a scale of\n";
                        print "1 to 10, and view them accordingly.  If you post a good image,\n";
                        print "more people will see it.</li>\n";
                }
                print "<li>People are more likely to click through to your site if\n";
                print "they like the image.</li>\n";
                print "<li>This script allows me to report child pornography with the\n";
                print "click of a button.  If you try to post child pornography, you can\n";
                print "expect it to be reported to the authorities in your country immediately.</li></ul>\n";
                        if ($image_types > 0) {
                        print "<a name=\"3\"><h2>About your category</h2></a><ul>\n";
                        print "<li>I can easily move your category to another section if\n";
                        print "I feel that it doesn't belong where you put it.</li>\n";
                        print "<li>If I'm feeling vindictive, I can just delete your image\n";
                        print "if I feel you've placed it in the wrong category.</li></ul>\n";
                }
                print "<a name=\"4\"><h2>About your image's description</h2></a><ul>\n";
                print "<li>Please do not use all caps.  I can convert your image's\n";
                print "description to all lower case with the click of a button.</li>\n";
                print "<li>This is what people click on, so be as graphic as possible.</li>\n";
                print "Do not, however, lie.  If you do, I can change your image's description\n";
                print "to the filename of the image, which will probably get you a lot less hits.</li></ul>\n";
                print "<a name=\"5\"><h2>About your site's name</h2></a><ul>\n";
                print "<li>Please do not use all caps.  I can convert your site's\n";
                print "name to all lower case with the click of a button.</li></ul>\n";
                if ($type_of_link != 1) {
                        print "<a name=\"6\"><h2>About your site's description</h2></a><ul>\n";
                        print "<li>Please do not use all caps.  I can convert your site's\n";
                        print "description to all lower case with the click of a button.</li></ul>\n";
                }
                print "<a name=\"7\"><h2>About your e-mail address</h2></a><ul>\n";
                print "<li>This is for internal use only, and will not be made\n";
                print "publically available.</li></ul>\n";
        }
        print "$postfoot$cfont</body></html>\n";
        exit;
}

sub preview {
        &checkme;
        if ($FORM{'banner_url'}) { &top("Preview your image and banner","STDOUT"); }
        else { &top("Preview your image","STDOUT"); }
        print "<form method=\"POST\">\n";
        print "<input type=\"hidden\" name=\"action\" value=\"post\">\n";
        @forminputs = ("image_type","image_url","height","width","image_desc","site_url","site_name","site_desc","email","link_url","banner_url","banner_height","banner_width","link_choice");
        foreach $forminput(@forminputs) { print "<input type=\"hidden\" name=\"$forminput\" value=\"$FORM{$forminput}\">\n"; }
        print "Your image will look like this:<p><center><img src=\"$FORM{'image_url'}\"";
        if ($hw) { print " height=\"$FORM{'height'}\" width=\"$FORM{'width'}\""; }
        print "><p></center>\n";
        print "Your banner will look like this:<p><center><a href=\"$FORM{'site_url'}\" target=\"new\"><img src=\"$FORM{'banner_url'}\" border=\"0\"";
        if ($hw2) { print " height=\"$FORM{'banner_height'}\" width=\"$FORM{'banner_width'}\""; }
        print "></a><p>\n";
        print "</center>If that looks ok, click <input type=\"submit\" value=\" this button \">\n";
        print "$cfont</form></body></html>\n";
}

sub post {
        &checkme;
        open(FILE,"$datadir/auto.txt");
        @autos = <FILE>;
        close(FILE);
        foreach $auto(@autos) {
                chomp($auto);
                if ($FORM{'site_url'} =~ /$auto/) { $approval = 0; }
        }
        &gettime;
        if ($lwp && $checkapprove) {
                $searchlink =~ s/\s+/ /g;
                $searchlink =~ tr/A-Z/a-z/;
                $searchlink = quotemeta($searchlink);
                $page = get($FORM{'link_url'});
                $page =~ s/\s+/ /g;
                $page =~ tr/A-Z/a-z/;
                if (length($pptitle) > 37) { $title = substr($pptitle,0,36); }
                else { $title = $pptitle; }
                $temp =~ s/\s+/ /g; $temp =~ tr/A-Z/a-z/;
                $temp = quotemeta("[<a href=\"$counturl?$mainurl\" target=\"new\"><font color=\"#FFFFFF\">$title</font></a>]");
                unless ($page =~ /$searchlink/ || $page =~ /$temp/) { &error("Please add my link to your <a href=\"$FORM{'link_url'}\">links page</a>."); }
        }
        if ($approval) {
                unless ($FORM{'test'}) {
                        open(FILE,">>$datadir/approve.txt");
                        print FILE "$FORM{'image_type'}|$FORM{'image_url'}|$FORM{'height'}|$FORM{'width'}|$FORM{'image_desc'}|$FORM{'site_url'}|$FORM{'site_name'}|$FORM{'site_desc'}|$FORM{'email'}|$FORM{'link_url'}|$date|$time|$FORM{'banner_url'}|$FORM{'banner_height'}|$FORM{'banner_width'}|$FORM{'link_choice'}|$ENV{'REMOTE_ADDR'}|\n";
                        close(FILE);
                }
                if ($notify1 && $youremail && $FORM{'test'} != -1) {
                        open (MAIL,"|$mailprogram -t");
                        print MAIL "To: $youremail\n";
                        print MAIL "From: $FORM{'email'}\n";
                        print MAIL "Subject: Posted Pic Needs Your Approval\n";
                        print MAIL "Hello.  On $date at $time $FORM{'email'}\n";
                        print MAIL "stopped by your Pic-Post site and posted a picture.\n";
                        print MAIL "Please stop by your page at $adminurl\n";
                        print MAIL "and approve it sometime.\n";
                        close (MAIL);
                }
                &top("Thank you!","STDOUT");
                if ($FORM{'javascript'}) {
                        print "<script language=\"JavaScript\"><!--\n";
                        print "//--></script>\n";
                        
                }
                print "Thank you for your post!  I will check it out and let you know as soon as possible.\n";
                if ($moreposts) { &moreposts; }
                print "</body></html>\n";
                exit;
        }
        else {
                unless ($FORM{'test'}) {
                        open(FILE,"$datadir/posts.txt");
                        @lines = <FILE>;
                        close(FILE);
                        if (@lines) { &getimage(0); }
                        else { $index_num = -1; }
                        $index_num++;        
                        splice(@lines,0,0,"$FORM{'image_type'}|$FORM{'image_url'}|$FORM{'height'}|$FORM{'width'}|$FORM{'image_desc'}|$FORM{'site_url'}|$FORM{'site_name'}|$FORM{'site_desc'}|$FORM{'email'}|$FORM{'link_url'}|$date|$time|$FORM{'banner_url'}|$FORM{'banner_height'}|$FORM{'banner_width'}|$FORM{'link_choice'}|$ENV{'REMOTE_ADDR'}|$index_num\n");
                        open(FILE,">$datadir/c$index_num.txt");
                        print FILE "0|0";
                        close(FILE);
                        open(FILE,">$datadir/r$index_num.txt");
                        print FILE "5|1|";
                        close(FILE);
                }
                &top("Image posted","STDOUT");
                print "The image has been posted and can be found at <a href=\"$posturl/$index_num$ex\">$posturl/$index_num$ex</a>.\n";
                if ($moreposts) { &moreposts; }
                print "$cfont</body></html>\n";
                unless ($FORM{'test'}) {
                        &checkpersite($FORM{'site_url'});
                        open(FILE,">$datadir/posts.txt");
                        foreach $line(@lines) { print FILE "$line"; }
                        close(FILE);
                        $FORM{'rr'} = -1;
                        if ($link =~ /$counturl\?/) { $FORM{'rt'} = -1; }
                        $FORM{'rp'} = -1;
                        &update;
                }
                exit;                                         
        }
}

sub checkme {
        if ($#image_types > 0) {
                unless ($FORM{'image_type'}) { &error("Please select a category for your image."); }
                unless (@temp = grep(/$FORM{'image_type'}/,@image_types)) { &error("I don't have a $FORM{'image_type'} category."); }
        }
        unless ($FORM{'image_url'} =~ /^http\:\/\/.+\.\w\w+\/.+/) { &error("The <a href=\"$FORM{'image_url'}\">image URL</a> appears to be invalid."); }
        if ($hw && ($FORM{'height'} < 1 || $FORM{'width'} < 1)) { &missing("the height and width of the image"); }
        unless ($FORM{'image_desc'}) { &missing("a description of the image"); }
        unless ($FORM{'site_url'} =~ /^http\:\/\/.+\.\w\w+.*/) { &error("The <a href=\"$FORM{'site_url'}\">site URL</a> appears to be invalid."); }
        unless ($FORM{'site_name'}) { &missing("your site's name"); }
        unless ($FORM{'email'} =~ /.+\@.+\.\w\w+/) { &error("The e-mail address <a href=\"mailto:$FORM{'email'}\">$FORM{'email'}</a> appears to be invalid."); }
        if ($link && $FORM{'link_url'} !~ /^http\:\/\/.+\.\w\w+.*/) { &error("The <a href=\"$FORM{'link_url'}\">return link URL</a> appears to be invalid."); }
        if (($type_of_link == 0 || $type_of_link == 3) || ($type_of_link == 2 && $FORM{'link_choice'} == 0)) {
                unless ($FORM{'site_desc'}) { &missing("a description of your site"); }
        }
        if (($type_of_link == 1 || $type_of_link == 3) || ($type_of_link == 2 && $FORM{'link_choice'} == 1)) {
                unless ($FORM{'banner_url'} =~ /^http\:\/\/.+\.\w\w+\/.+/) { &error("The URL <a href=\"$FORM{'banner_url'}\">$FORM{'banner_url'}</a> appears to be invalid."); }
                if ($hw2) { unless ($FORM{'banner_height'} > 0 && $FORM{'banner_width'} > 0) { &missing("the height and width of your banner"); } }
        }        
        open(FILE,"$datadir/lock.txt");
        my @locks = <FILE>;
        close(FILE);
        my $temp = "$FORM{'image_type'}$FORM{'image_url'}$FORM{'image_desc'}$FORM{'site_url'}$FORM{'site_name'}$FORM{'site_desc'}$FORM{'email'}$FORM{'link_url'}$FORM{'banner_url'}";
        $temp =~ tr/A-Z/a-z/;
        foreach $lock(@locks) {
                chomp($lock);
                $lock =~ tr/A-Z/a-z/;
                $testlock = quotemeta($lock);
                if ($temp =~ /$testlock/) { &error("I have locked out the text <i>$lock</i>."); }
        }
        if ($samedomain) {
                my @temp = split(/\//, $FORM{'image_url'});
                if ($FORM{'site_url'} !~ /$temp[2]/ || ($link && $FORM{'link_url'} !~ /$temp[2]/) || (($type_of_link == 1 || $type_of_link == 3 || ($type_of_link == 2 && $FORM{'link_choice'} == 1)) && $FORM{'banner_url'} !~ /$temp[2]/)) { &error("To prevent bandwidth theft, all the URLs that you give me must contain the same domain."); }
        }
        @ix = ("approve","posts");
        foreach $filename(@ix) {
                open(FILE,"$datadir/$filename.txt");
                my @lines = <FILE>;
                close(FILE);
                for ($i = 0; $i <= $#lines; $i++) {
                        ($image_type,$image_url,$height,$width,$image_desc,$site_url,$site_name,$site_desc,$email,$link_url,$odate,$otime,$banner_url,$banner_height,$banner_width,$link_choice,$posters_ip,$index_num) = split(/\|/,$lines[$i]);
                        if ($image_url eq $FORM{'image_url'}) { &error("That image has already been posted."); }
                }
        }
}

sub moreposts {
        print "<p><center><table width=\"500\" border=\"5\" bgcolor=\"#FF0000\">\n";
        print "<tr><td><center>$font<font color=\"#000000\">The owner of this pic-post\n";
        print "page is using Cliff's ever-so-wonderful &quot;Get More Posts&quot;\n";
        print "system.  What does this mean to you?  Well, simply that you can easily\n";
        print "post the image that you just posted here to other pic-post sites without\n";
        print "having to fill out all the information again.  If you'd like to do this now,\n";
        print "please click<form method=\"POST\" action=\"http://www.shavenferret.com/cgi-bin/post.cgi\">\n";
        @checkthese = ("image_type","image_url","height","width","image_desc","site_url","site_name","site_desc","email","banner_url","banner_height","banner_width","link_choice","link_url");
        foreach $check(@checkthese) { print "<input type=\"hidden\" name=\"$check\" value=\"$FORM{$check}\">\n"; }
        print "<input type=\"hidden\" name=\"from\" value=\"$mainurl\">\n";
        print "<input type=\"submit\" value=\" This Button \"></form></td></tr></table>\n";
}

sub search {
        unless ($FORM{'text'}) { &error("Please enter some terms you want to search for."); }
        $FORM{'text'} =~ tr/A-Z/a-z/;
        $FORM{'text'} =~ s/ not / -/ig;
        $FORM{'text'} =~ s/ and / \+/ig;
        $FORM{'text'} =~ s/ or / /ig;
        $FORM{'text'} =~ s/\s+/ /g;
        @temp = split(/\"/, $FORM{'text'});
        if ($keepsearch) {
                open(FILE,"$datadir/search.txt");
                my @searches = <FILE>;
                close(FILE);
                for($i = 0; $i <= $#searches; $i++) {
                        @stuff = split(/\|/, $searches[$i]);
                        if ($stuff[0] eq $FORM{'text'}) {
                                chomp($stuff[1]);
                                $stuff[1]++;
                                $searches[$i] = "$stuff[0]|$stuff[1]\n";
                                $found = -1;
                        }
                }
                unless ($found) { splice(@searches,0,0,"$FORM{'text'}|1\n"); }
                open(FILE,">$datadir/search.txt");
                foreach $search(@searches) { print FILE "$search"; }
                close(FILE);
        }
        for ($i = 0; $i <= $#temp; $i++) {
                $sign = "";
                if ($temp[$i]) {
                        if (substr($temp[$i],-1,1) eq "+" || substr($temp[$i],-1,1) eq "-") { $sign = substr($temp[$i],-1,1); chop($temp[$i]); }
                        @terms = split(/ /, $temp[$i]);        
                        foreach $term(@terms) {
                                $term =~ s/\s//ig;
                                if (substr($term,0,1) eq "+") {
                                        $term = substr($term,1,length($term)-1);
                                        push(@must,$term);
                                }
                                elsif (substr($term,0,1) eq "-") {
                                        $term = substr($term,1,length($term)-1);
                                        push(@cant,$term);
                                }
                                else { push(@should,$term); }
                        }
                }
                $i++;
                if ($temp[$i]) {
                        if ($sign eq "+") { push(@must,$temp[$i]); }
                        elsif ($sign eq "-") { push(@cant,$temp[$i]); }
                        else { push(@should,$temp[$i]); }
                }
        }
        open(FILE,"$datadir/posts.txt");
        @lines = <FILE>;
        close(FILE);
        if (@should) {
                for ($i = 0; $i <= $#lines; $i++) {
                        $lines[$i] =~ tr/A-Z/a-z/;
                        foreach $term(@should) {
                                if ($lines[$i] =~ /$term/) { push(@found,"$i"); last }
                        }
                }
        }
        else {  for ($i = 0; $i <= $#lines; $i++) { $lines[$i] =~ tr/A-Z/a-z/; $found[$i] = "$i"; } }
        if (@must) {
                for ($i = $#found; $i >= 0; $i--) {
                        foreach $term(@must) { unless ($lines[$found[$i]] =~ /$term/) { splice(@found,$i,1); last } }
                }
        }
        if (@cant) {
                for ($i = $#found; $i >= 0; $i--) {
                        foreach $term(@cant) { if ($lines[$found[$i]] =~ /$term/) { splice(@found,$i,1); last } }
                }
        }
        unless (@found) {
                &top("No results","STDOUT");
                print "I'm sorry, but your search turned up no results.  Please\n";
                print "click back and try again.$cfont</body></html>\n";
                exit;
        }
        if ($#image_types > 0) {
                for ($i = 0; $i <= $#image_types; $i++) {
                        $temp = $image_types[$i];
                        $temp =~ tr/A-Z/a-z/;
                        $TYPE{$temp} = $i;
                }
        }
        &top("$pptitle - Results - $FORM{'text'}","STDOUT","","",-1);
        print "<center>$head<br>";
        &banners("STDOUT");
        print "<h1><a href=\"$mainurl\">$pptitle</a> - Results - <i>$FORM{'text'}</i></h1>\n";
        &jump("STDOUT");
        &sig("STDOUT");
        print "<center><table width=\"550\" border=\"5\"><tr><td>\n";
        unless ($#image_types <= 0) {
                print "<table cols=\"3\"><tr><td width=\"150\"><center>$font\n";
                print "category$cfont</center></td><td width=\"340\">\n";
        }
        else { print "<table cols=\"2\"><tr><td width=\"490\">\n"; }
        print "$font<center>Description</center>$cfont</td>\n";
        print "<td width=\"50\">$font<center>\n";
        unless ($norate) { print "Rating"; }
        else { print "Posted on.."; }
        print "</center>$cfont</td></tr>\n";
        unless ($#image_types <= 0) { for ($i = 0; $i <= $#image_types; $i++) { $TYPE{$type} = $i; } }
        for ($postnum = 0; $postnum <= $#found; $postnum++) {
                &getimage($found[$postnum]);
                unless ($#image_types <= 0) { print "<tr><td width=\"150\">$font<center><a href=\"$posturl/i$TYPE{$image_type}-0$ex\">$image_type</a></center>$cfont</td><td width=\"340\">\n"; }
                else { print "<tr><td width=\"490\">\n"; }
                print "$font<center><a href=\"$posturl/$index_num$ex\">$image_desc</a></center>$cfont</td>\n";
                unless ($norate) {
                        open(FILE,"$datadir/r$index_num.txt");
                        my $temp = <FILE>;
                        close(FILE);
                        ($total,$votes,$junk) = split(/\|/,$temp);
                        my $rating = sprintf("%.2f", $total / $votes);
                        print "<td width=\"50\">$font<center>$rating</center>$cfont</td></tr>\n";
                }
                else { print "<td width=\"50\">$font<center>$odate</center>$cfont</td></tr>\n"; }
        }
        print "</table></td></tr></table>\n";
        &searchwindow("STDOUT");
        &sig("STDOUT");
        &banners("STDOUT");
        print "<br>$foot$cfont</body></html>";
        exit;
}

sub random {
        open(FILE,"$datadir/posts.txt");
        @lines = <FILE>;
        close(FILE);
        srand;
        $i = int(rand($#lines));
        &getimage($i);
        print "Location: $posturl/$index_num$ex\n\n";
}
