import java.applet.*;
import java.awt.*;
import java.util.*;

public class colorbook extends Applet 
{
    private Color current_color=Color.black;
    private Button clear_button;
    private Choice picture_choices;
    private Image image;
    private CheckboxGroup cbgroup;

    public void init() 
    {
		Color background = Color.white;
	   clear_button = new Button("Clear");
	   clear_button.setForeground(Color.black);
	   add(clear_button);
	   cbgroup = new CheckboxGroup();
	   Checkbox b;
   	   add(b = new Checkbox(null, cbgroup, true));
	   b.setBackground(background);
	   add(b = new Checkbox(null, cbgroup, false));
	   b.setBackground(Color.black);
	   add(b = new Checkbox(null, cbgroup, false));
	   b.setBackground(Color.red);
	   add(b = new Checkbox(null, cbgroup, false));
	   b.setBackground(Color.yellow);
	   add(b = new Checkbox(null, cbgroup, false));
	   b.setBackground(Color.green);
	   add(b = new Checkbox(null, cbgroup, false));
	   b.setBackground(Color.blue);
	   add(b = new Checkbox(null, cbgroup, true));
	   b.setBackground(Color.lightGray);

	   current_color=b.getBackground();

	   picture_choices = new Choice();
	   picture_choices.addItem("Page 1");
	   picture_choices.addItem("Page 2");
	   picture_choices.addItem("Page 3");
	   picture_choices.addItem("Page 4");
	   picture_choices.addItem("Page 5");
	   picture_choices.addItem("Page 6");
	   picture_choices.addItem("Page 7");
	   picture_choices.addItem("Page 8");
	   picture_choices.addItem("Page 9");
	   picture_choices.setForeground(Color.black);
	   picture_choices.setBackground(Color.lightGray);
	   add(new Label("Pictures"));
	   add(picture_choices);
	
	   setBackground(background);
	   image = getImage(getDocumentBase(), "page1.gif");
    }

   public static void main(String args[]) 
   {
   	Frame f = new Frame("Coloring Book");
	colorbook colorbook_object = new colorbook();
	colorbook_object.init();
	colorbook_object.start();

	f.add("Center", colorbook_object);
	f.resize(400, 400);
	f.show();
   }

    public boolean mouseDown(Event e, int x, int y)
    {
	mouseDrag(e,x,y);
	return true;
    }

    public boolean mouseDrag(Event e, int x, int y)
    {
	if (e.y > 50)
	{
		Graphics g = this.getGraphics();
		g.setColor(current_color);
		g.fillOval(e.x, e.y, 12, 12);
		update(getGraphics());;
	}
	return true;
    }

    public boolean action(Event e, Object arg) 
    {
	if (e.id == Event.WINDOW_DESTROY)
	{
         	System.exit(0);
	}
   	else if (e.target instanceof Checkbox) 
	{
		current_color = ((Component)e.target).getBackground();
	       setForeground(current_color);
	}
	else if (e.target instanceof Choice)
	{
	       String choice = (String)arg;

	       if(arg.equals("Page 1")) image = getImage(getDocumentBase(),"page1.gif");
        	 else if(arg.equals("Page 2"))    image = getImage(getDocumentBase(),"page2.gif");
	         else if(arg.equals("Page 3"))    image = getImage(getDocumentBase(),"page3.gif");
        	 else if(arg.equals("Page 4"))    image = getImage(getDocumentBase(),"page4.gif");
	         else if(arg.equals("Page 5"))    image = getImage(getDocumentBase(),"page5.gif");
        	 else if(arg.equals("Page 6"))    image = getImage(getDocumentBase(),"page6.gif");
	         else if(arg.equals("Page 7"))    image = getImage(getDocumentBase(),"page7.gif");
        	 else if(arg.equals("Page 8"))    image = getImage(getDocumentBase(),"page8.gif");
	         else if(arg.equals("Page 9"))    image = getImage(getDocumentBase(),"page9.gif");
	      clear();
   	}
	else if (e.target == clear_button)  
	{
		clear();
	}
	else
	{
	       return super.action(e,arg);
	}

	return true;
   }

	public void update(Graphics g)
	{
		Graphics offScreenGraphics = g.create();
		paint(offScreenGraphics);
		g = offScreenGraphics.create();
	}

   public void clear()
   {
	   Graphics g = getGraphics();
		Color fg = getForeground();
		g.setColor(getBackground());
		g.fillRect(0,0, size().width, size().height);
		g.setColor(fg);
		paint(g);
   }

   public void paint(Graphics g)
   {
      g.drawImage(image,0,50,this);
   }

}




