#!/usr/bin/perl 

require 'cgi-lib.pl';
require 'postcard.setup';
$| = 1;

&ReadParse(*input);

#===== Assign variables =====
$date = `$date_command +"%D"`; 
$date =~ s/\n*$//;
$current_date = $date;
$test = 0;
$time = time;
$cardlist_temp = "$cardlist" . "_" . "temp";

   if ($input{'preview'} ne "")      {
	print &PrintHeader;
	&check_required;
	&select_card_number;
	&print_preview;        }
  elsif ($input{'submit'} ne "")	 {
        print &PrintHeader;
        &send_card;
        &delete_old_cards;   }
  elsif ($ENV{'QUERY_STRING'} ne "") {
        print &PrintHeader;
        &pickup_card;        }

#===== Delete old cards =====
sub delete_old_cards	{
  $current_time = time;
  $delete_date = $current_time - ($days * 86400); 

 open (TEMP, ">$cardlist_temp") || die ("Could not open $cardlist_temp");
    flock (TEMP, 2);
 open (CARD, "$cardlist") || die ("Could not open $cardlist");
    flock (CARD, 2);
	while (<CARD>)	{
	($number, $from, $from_email, $message, $to, $image, $date_time, $date) = split(/\|/, $_);
    if ($delete_date < $date_time)	{
	print TEMP "$_";	}
	}
    flock (CARD, 8);
    flock (TEMP, 8);
 close (TEMP);
 close (CARD);
 rename ($cardlist_temp, $cardlist);
}

#===== Check for blank fields =====
sub check_required	{ 
if ($input{'address'} eq "")     {&error;  
  print "    You must specify <b>To Email</b> field in order for this postcard to be sent.\n\n";
  print "    Now, go back, enter the email of the <b>recipient</b> and then submit the postcard again.";
    exit;  }
if ($input{'name'} eq "")        {&error;
  print "    You must specify <b>To Name</b> field in order for this postcard to be sent.\n\n";
  print "    Now, go back, enter the name of the <b>recipient</b> and then submit the postcard again.";
    exit;  }
if ($input{'sender'} eq "")      {&error;
  print "    You must specify <b>From Name</b> field in order for this postcard to be sent.\n\n";
  print "    Now, go back, enter the name of the <b>sender</b> and then submit the postcard again.";
    exit;  }
if ($input{'senderemail'} eq "") {&error;
  print "    You must specify <b>From Email</b> field in order for this postcard to be sent.\n\n";
  print "    Now, go back, enter <b>your email address</b> and then submit the postcard again.";
    exit;  }
}

sub error {
  print "<body bgcolor=#F0F0F0 text=#323232> \n";
  print "<p>&nbsp</p> \n";
  print "<p><font size=2 face=Verdana,Arial,Helvetica> \n";
  print "<b>PostMan says:<font color=#FF0000> <blink>Didn't you forget something ?</blink></b></font></p> \n";
  print "<p>&nbsp</p> \n";
  print "<p><font size=3 face=Verdana,Arial,Helvetica><pre>\n";
          }

#===== Preview card =====
sub print_preview	{
 open (PAGE, "$preview_postcard") || die ("I am sorry, but I was unable to open the file $preview_postcard.");
	while (<PAGE>)		{
	s/%%date%%/$date/g;
	s/%%name%%/$input{'name'}/g;
	s/%%sender%%/$input{'sender'}/g;
	s/%%message%%/$input{'message'}/g;
	s/%%address%%/$input{'address'}/g;
	s/%%senderemail%%/$input{'senderemail'}/g;
	s/%%pickup%%/$pickup/g;
	s/%%company%%/$company/g;
	s/%%image%%/$imagedir$image/g;
	print $_;
	}
	close (PAGE);
}

sub select_card_number {
   $image = $input{'card_number'};
}

#===== Send the card =====
sub send_card	{
   srand (time|$$);
    $userid = int (rand(1000));
    $userid .= "$$";

 open (PAGE, "$thank_you") || die ("I am sorry, but I was unable to open the file $thank_you.");
   while (<PAGE>)	   {
	s/%%name%%/$input{'name'}/g;
	s/%%pickup%%/$pickup/g;
	print $_;      }
 close (PAGE);

 open (DATABASE, ">>$cardlist") || die ("I am sorry, but I was unable to open the file.");

#===== Remove any pipe symbols from input =====
    $input{'sender'} =~ s/\|//g;
    $input{'message'} =~ s/\|//g;
    $input{'name'} =~ s/\|//g; 
    $input{'senderemail'} =~ s/\|//g;
    $input{'message'} =~ s/\s+/ /g;

    flock (DATABASE, 2);

      print DATABASE "$userid\|$input{'sender'}\|$input{'senderemail'}\|$input{'message'}\|";
      print DATABASE "$input{'name'}\|$input{'card_number'}\|$time\|$date\n";

    flock (DATABASE, 8);
 close (DATABASE);

#===== Send e-mail to recipient =====
 open (MAIL, "|$mailprog $input{'address'}") || die "Can't open $mailprog!\n";
	print MAIL "Reply-to: $input{'senderemail'}\n";
	print MAIL "From: $input{'senderemail'}\n";
	print MAIL "To: $input{'address'}\n";
	print MAIL "Subject: $subject\n\n";
 open (PAGE, "$mail_message") || die ("I am sorry, but I was unable to open the file $thank_you.");
	while (<PAGE>)		{
	s/%%sender%%/$input{'sender'}/g;
	s/%%userid%%/$userid/g;
	s/%%pickup%%/$pickup/g;
	s/%%company%%/$company/g;
	print MAIL $_;
	}
 close (PAGE);
 close (MAIL);
}

#===== Pick up the card =====
sub pickup_card {
 open (DATABASE, "$cardlist") || &CgiDie ("I am sorry, but I was not able to open the data file.");
   flock (DATABASE, 2);
	@list = <DATABASE>;
   flock (DATABASE, 8);
  close (DATABASE);
foreach $list (@list) {
($userid, $sender, $senderemail, $message, $name, $image, $date_time, $date) = split 
(/\|/, $list);

 if ($input{'id_num'} eq $userid && $input{'id_num'} ne "") 
   { $test = 1;
     &print_html;
     &notify;  }
                      }
 if ($test == 0) { &invalid_id; }
}

#===== Show the real postcard ======
sub print_html {
open (PAGE, "$show_postcard") || die ("I am sorry, but I was unable to open the file $thank_you.");
	while (<PAGE>)		{
	s/%%sender%%/$sender/g;
	s/%%date%%/$date/g;
	s/%%name%%/$name/g;
	s/%%message%%/$message/g;
	s/%%image%%/$image/g;
	s/%%pickup%%/$pickup/g;
	s/%%company%%/$company/g;
	print  $_;
			}
close (PAGE);
}

#===== Send e-mail to sender ======
sub notify {
$date =~ s/\n*$//;
  open (MAIL, "|$mailprog $senderemail") || die "Can't open $mailprog!\n";
   print MAIL "Reply-to: $reply_to\n";
   print MAIL "From: $reply_to\n";
   print MAIL "To: $senderemail\n";
   print MAIL "Subject: Postcard Picked-up\n\n";
   print MAIL "The postcard you sent to $name, was picked up on $date.\n\n";
   print MAIL "Thank you for using $company.";
  close (MAIL);
}

#==== Invalid user message =====
sub invalid_id {
print <<EOT;
Sorry, but you have entered an invalid card ID number. Please use the back button 
on your browser to re-enter the correct card ID.
EOT
exit;
}

