#!/usr/bin/perl
my $inifile = "postcard.ini";

use CGI_Lite;
use Text::Template;
use IniConf;
use Mail::Sendmail;
use strict;

my ($VERSION, $cfg, $cgi, $cardfile, 
	$form, %Actions, $routine,
	$path, $template, $details,
	$fill_in, $filled,
	); 

$VERSION = '2.01';
$cfg = IniConf -> new(-file => $inifile);
$cgi = new CGI_Lite;

print "Content-type: text/html\r\n\r\n";
$form = $cgi->parse_form_data;
$path = $cfg->val('Config', 'Path');

%Actions = (Default => \&New,
			New     => \&New,
			Preview => \&Preview,
			Send    => \&Send,
			Fetch   => \&Fetch,
			);

$routine = (defined($Actions{$form->{action}})) ?
			 $Actions{$form->{action}} :
			 $Actions{Default} ;
($template, $details) = $routine->($cfg, $cgi, $form);
$fill_in = new Text::Template ( TYPE => 'FILE',
		SOURCE => $path . "/" . $template . ".html");
$filled = $fill_in->fill_in( HASH => [ $form, $details ],
			DELIMITERS => [ '[##', '##]' ]
			);
print $filled;
#############################

sub New	{
	my ($cfg, $cgi, $form) = @_;
	my ($template, $details);

	$template = 'postcard';
	$details = {};
	return ($template, $details);
} # End sub New

sub Preview {
	my ($cfg, $cgi, $form) = @_;
	my ($template);

	$form->{message} =~ s/\n/<br>/g;
	$form->{message} =~ s/\r//g;
	$form->{ImageURL} = $cfg->val('Config', 'ImageURL');
	
	$template = 'preview';
	return ($template, $form);
} # End sub Preview

sub Send {
	my ($cfg, $cgi, $form) = @_;
	my ($template, %mail, $emailTemp, $body,
		$path, $email, $cardfile,
		$word, $card, $date, $subject,
		);

	$path = $cfg->val('Config', 'Path');
	$email = $cfg->val('Config', 'email');
	$form->{URL} = $cfg->val('Config', 'URL');
	$cardfile = $cfg->val('Config', 'cardfile');

	# Save the card
	$word = KeyWord();
	$date = time;
	$form->{keyword} = $word;
	$card = join '~~~', 
		$word, $form->{from}, $form->{replyto}, $form->{picture},
		$form->{message}, $date;
	open (CARDS, ">>$cardfile");
	print CARDS "$card\n";
	close CARDS;

	# Send the notification
	$emailTemp = new Text::Template ( TYPE => 'FILE',
		SOURCE => $path . "/" . $email );
	$body = $emailTemp->fill_in( HASH => [ $form ],
			DELIMITERS => [ '[##', '##]' ]
			);
	$subject = $cfg->val('Config', 'Subject');

	%mail = ( To => $form->{to},
			  From => $form->{replyto},
			  Subject => $subject,
			  Message => $body,
			);
	sendmail(%mail) or $form->{error} = $Mail::Sendmail::error;
	$template = $form->{error} ? 'error' : 'sent';

	return ($template, $form);
} # End sub Send

sub Fetch {
	my ($cfg, $cgi, $form) = @_;
	my ($template, $details, $cardfile, $card, $found,
		);

	if ($form->{keyword})	{
		$cardfile = $cfg->val('Config', 'cardfile');
		open (CARDS, $cardfile);
		while ($card = <CARDS>)	{
			if ($card =~ /^$form->{keyword}~~~/)	{
				chomp $card;
				@$details{'word', 'from', 'replyto', 'picture', 'message', 'date'}
					= split /~~~/, $card;
				$found = 1;
				$details->{ImageURL} = $cfg->val('Config', 'ImageURL');
				last;
			} # End if
		} # End while
		close CARDS;
		$template = $found ? 'fetchcard' : 'keyword';
	} else {
		$template = 'keyword';
	} # End if..else keyword
	return ($template, $details);	
} # End sub Fetch

sub KeyWord	{
	my @a=(0..9,'a'..'z');
	my $word = join '', map { $a[int rand @a] } (0..2);
	$word = time . $word . $$;
	return $word;
}
