#!c:/perl/bin/perl

##############################################################################
# MTVWebdesign freecards                      Version 3.0
# admin.cgi: The admin script - installation script
# Copyright 1999-2000 Maarten Veerman mtveerman@mindless.com
# MTVWebdesign:    http://mtvwebdesign.hypermart.net/ (http://mtvwebdesign.hypermart.net/scripts/)
##############################################################################
# COPYRIGHT NOTICE
# Copyright 1999-2000 Maarten Veerman  All Rights Reserved.
#
# You should have downloaded this script from RegNow, since you bought it
# from MTVWebdesign. If you  didn't received this script by mail,
# directely from MTVWebdesign, but through an other source,
# please contact MTVWebdesign at abuse@mtvwebdesign.hypermart.net
#
# freEcards may be used and modified so long as this
# copyright notice and the comments above remain intact.  By using this
# code you agree to indemnify Maarten Veerman from any liability that
# might arise from its use.
#
# Selling the code for this program without prior written content is
# expressly forbidden.  In other words, please ask first before you try and
# make money off of my program in any way.
#
# Obtain permission before redistributing this software over the Internet or
# in any other medium. In all cases copyright and header must remain intact
#
# Please send bug-reports to cgi-bugs@mtvwebdesign.hypermart.net
##############################################################################

%languages = (
	"English" => "en",
	"Dutch" => "nl",
	"Spanish" => "es",
	"Italian" => "it",
	"German" => "de",
	"Estonian" => "et",
	"Polish" => "pl",
	"French" => "fr",
);

#$color = "#BCEDF5";
$color = "#BBADFA";


CONFIG: {
	
	if (-e "./freecards.cgi") {
		$no_eng_req=1;
		require "./freecards.cgi";
	}
	elsif (-e "./freecards.pl") {
		$no_eng_req=1;
		require "./freecards.pl";
	}
	else {
		$firsttime = "1";
		&DoCheck;
	}
	
	if ($mtvwebdesignlib) {
		require $mtvwebdesignlib;
	}
	elsif (-e "./mtvwebdesign.lib") {
		require "./mtvwebdesign.lib";
	}
	else {
		&errors("I cannot find mtvwebdesign.lib, please upload it to the same directory as this script.");
	}
	
}

MAIN: {
	&DoConfig;
	&getinput;
	&GetCookies;
	
	$FORM{'action'} = $FORM{'a'} || $FORM{'action'};
	
	if ($firsttime && $FORM{'action'} ne "install") {
		&setup;
	}
	elsif ($firsttime && $FORM{'action'} eq "install") {
		&install;
	}
	elsif (!$Cookies{'loggedin'} && $FORM{'action'} ne "login") {
		&login;
	}
	elsif ($FORM{'action'} eq "login") {
		&check_login;
	}
	elsif ($FORM{'action'} eq "logout") {
		&logout;
	}
	elsif ($FORM{'action'} eq "setup") {
		&setup;
	}
	elsif ($FORM{'action'} eq "advsetup") {
		&advsetup;
	}
	elsif ($FORM{'action'} eq "plugins") {
		&plugins;
	}
	elsif ($FORM{'action'} eq "pgen") {
		&pgen;
	}
	elsif ($FORM{'action'} eq "pgennow") {
		&pgennow;
	}
	elsif ($FORM{'action'} eq "install") {
		&install;
	}
	elsif ($FORM{'action'} eq "search") {
		&search;
	}
	elsif ($FORM{'action'} eq "activedesks") {
		&activedesks;
	}
	elsif ($FORM{'action'} eq "tosend") {
		&tosend;
	}
	elsif ($FORM{'action'} eq "email") {
		&email;
	}
	elsif ($FORM{'action'} eq "emailnow") {
		&emailnow;
	}
	elsif ($FORM{'action'} eq "help") {
		&help;
	}
	elsif ($FORM{'action'} eq "viewstructure") {
		&viewstructure;
	}
	else {
		&mainpage;
	}
	
	exit;
	
	
}

sub DoConfig {
	
	$ENV{'SERVER_NAME'} = $ENV{'HTTP_HOST'} || $ENV{'SERVER_NAME'};
	
}

sub DoCheck {
	
	#This sub will check for files we need.
	
	&errors("I cannot find dbUnder.lib, please upload it to the same directory as this script.") unless (-e "./dbUnder.lib");
	&errors("I cannot find freecards_eng.lib, please upload it to the same directory as this script.") unless (-e "./freecards_eng.lib");
	&errors("I cannot find the english language pack (en.lng), please upload it to the same directory as this script.") unless (-e "./en.lng" || -e "./languagepacks/en.lng");
	
}

sub errors {
	local($error) = @_;
	
	my $id = time * $$;
	
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>An error Occured</title></head>
	<body>
	<h2>An error occured</h2>
	$error
	<center><a href="$ENV{'SCRIPT_NAME'}?$id">Click here to try again</a>
	</body>
	</html>
	~;
	exit;
}

sub login {
	local($warn) = @_;
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>Login</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<form action="$ENV{'SCRIPT_NAME'}" method="post">
	<input type="hidden" name="action" value="login">
	<input type="hidden" name="id" value="$id">
	<table cellpadding="4" cellspacing="0" border="1" bordercolor="$color" align="center">
	<tr><td align="center"><font size="+1"><b>Login</b></font><br>
	~;
	&warn($warn);
	print qq~
	</td></tr>
	<tr><td bgcolor="$color"><table>
	<tr><td>Please enter your username</td><td><input type="text" name="webmasterusername"></td></tr>
	<tr><td>Please enter your password</td><td><input type="password" name="webmasterpass"></td></tr>
	</table></td></tr>
	<tr><td align="center"><input type="submit"></td></tr>
	</table>
	</form>
	</body>
	</html>
	~;
	exit;
}

sub check_login {
	
	if (lc $FORM{'webmasterusername'} ne lc $webmasterusername) { &login("The username is incorrect"); }
	elsif (lc $FORM{'webmasterpass'} ne lc $webmasterpass) { &login("The password is incorrect"); }
	else {
		&SetCookies("loggedin","1");
	}
	
	&mainpage;
}

sub mainpage {
	local($warn) = @_;
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>Mainpage</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
	<tr>
	<td align="center"><b><font size="+1">Mainpage</font></b>
	~;
	&warn($warn);
	print qq~
	</td>
	</tr>
	<tr><td bgcolor="$color"><table>
	<tr><td colspan="4" align="center">
	<a href="$ENV{'SCRIPT_NAME'}?a=email&id=$id">Email all active users</a><p>
	<a href="$ENV{'SCRIPT_NAME'}?a=activedesks&id=$id">View active postcard desks</a><br>
	<a href="$ENV{'SCRIPT_NAME'}?a=search&id=$id">Search a card</a>
	~;
	if ($tosend_plugin) {
		print qq~
		<br><a href="$ENV{'SCRIPT_NAME'}?a=tosend&id=$id">Look in the tosend database</a>
		~;
	}
	print qq~
	<p><a href="$ENV{'SCRIPT_NAME'}?a=logout&id=$id">Logout</a><p>
	
	</td></tr>
	<tr>
	<td><font size="-1"><a href="$ENV{'SCRIPT_NAME'}?a=setup&id=$id">Setup the script</a></font></td>
	<td><font size="-1"><a href="$ENV{'SCRIPT_NAME'}?a=advsetup&id=$id">Advanced setup</a></font></td>
	<td><font size="-1"><a href="$ENV{'SCRIPT_NAME'}?a=plugins&id=$id">Install plugins</a></font></td>
	<td><font size="-1"><a href="$ENV{'SCRIPT_NAME'}?a=pgen&id=$id">Install page generator</font></td>
	</tr>
	<tr><td colspan="4" align="center"><font size="-1"><a href="$ENV{'SCRIPT_NAME'}?a=viewstructure&id=$id">Directory Structure</a></font></td></tr>
	
	</table>
	</td></tr>
	<tr><td align="center">
	<font size="1">Copyright \&copy\; 2000 <a href="http://mtvwebdesign.hypermart.net">MTVWebdesign software</a></font>
	</td></tr>
	</table>
	</body>
	</html>
	~;
	exit;
}

sub setup {
	
	local($warn) = @_;
	
	if ($firsttime) { $warn.= "<p>freEcards setup determined some file locations automatically. You can change all these settings in the <i>Advanced Setup</i> page. You can install the plugins later, in the </i>Plugin Installation</i> page."; }
	
	print "Content-type: text/html\n\n";
	
	print qq~
	<html>
	<head><title>FreEcards setup</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<form action="$ENV{'SCRIPT_NAME'}" method="post">
	<input type="hidden" name="action" value="install">
	<input type="hidden" name="id" value="$id">
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
	<tr>
	<td colspan="3" align="center"><b><font size="+1">freEcards setup</font></b><br><a href="$ENV{'SCRIPT_NAME'}?id=$id">Back to mainpage</a>
	~;
	&warn($warn);
	print qq~
	</td>
	</tr>
	<tr><td bgcolor="$color"><table>
	~;
	
	$webmasterusername = $FORM{'$webmasterusername'} || $webmasterusername;
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$webmasterusername" target="_blank">?</a> 1.</td><td>Please enter a username for accessing the databases directory</td><td><input type="text" name="\$webmasterusername" value="$webmasterusername"></td></tr>
	~;
	
	$webmasterpass = $FORM{'$webmasterpass'} || $webmasterpass;
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$webmasterpass" target="_blank">?</a> 2.</td><td>Please enter a password to access this administration script and the databases directory</td><td><input type="text" name="\$webmasterpass" value="$webmasterpass"></td></tr>
	~;
	
	$webmasteremail = $FORM{'$webmasteremail'} || $webmasteremail;
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$webmasteremail" target="_blank">?</a> 3.</td><td>Please enter your email address</td><td><input type="text" name="\$webmasteremail" value="$webmasteremail"></td></tr>
	~;
	
	$servicename = $FORM{'$servicename'} || $servicename || "freEcards";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$servicename" target="_blank">?</a> 4.</td><td>Please enter the name of the service</td><td><input type="text" name="\$servicename" value="$servicename"></td></tr>
	~;
	
	$servicelocation = $FORM{'$servicelocation'} || $servicelocation || "http://" . $ENV{'SERVER_NAME'};
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$servicelocation" target="_blank">?</a> 5.</td><td>Please enter the location of the service</td><td><input type="text" name="\$servicelocation" value="$servicelocation"></td></tr>
	~;
	
	$perlpath = "$^X";
	
	if ((!($perlpath)) || (lc $perlpath eq 'perl')) {
		$perlpath = `which perl`;
	}
	if ((!($perlpath)) || (lc $perlpath eq 'perl')) {
		$perlpath = `which perl5`;
	}
	if ((!($perlpath)) || (lc $perlpath eq 'perl')) {
		$perlpath = "/usr/local/bin/perl";
	}
	
	$perlpath =~ s/\\/\//g;
	
	$perl = $FORM{'$perl'} || $perl || $perlpath;
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$perl" target="_blank">?</a> 6.</td><td>Please enter the path to perl on your server</td><td><input type="text" name="\$perl" value="$perl"></td></tr>
	~;
	
	$mailprog =~ s/\|(.*?)\s-t/$1/i;
	
	$sendmail = `whereis sendmail` || `which sendmail`;
	if (!($sendmail)) {
		$sendmail = "/usr/bin/sendmail";
	}
	
	$mailprog = $FORM{'$mailprog'} || $mailprog || $sendmail;
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$mailprog" target="_blank">?</a> 7.</td><td>Please enter the location of your mail program</td><td><input type="text" name="\$mailprog" value="$mailprog"></td></tr>
	~;
	
	undef $selected;
	$cgiext = $FORM{'$cgiext'} || $cgiext || ".cgi";
	if ($cgiext eq ".pl") { $selected = " selected"; }
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$cgiext" target="_blank">?</a> 8.</td><td>Please select the extention for perl scripts on your server</td><td><select name="\$cgiext">
	<OPTION value=".cgi">.CGI
	<OPTION value=".pl"$selected>.PL
	</select></td></tr>
	~;
	
	@suparts = split(/\//,$ENV{'SCRIPT_NAME'});
	pop @suparts;
	push @suparts, "freecards.cgi";
	$script_url = 'http://' . $ENV{'SERVER_NAME'} . ($ENV{'SERVER_PORT'} != 80 ? ":$ENV{'SERVER_PORT'}" : '') . (join "\/", @suparts);
	
	$script_location = $FORM{'$script_location'} || $script_location || $script_url;
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$script_location" target="_blank">?</a> 9.</td><td>Please enter the URL to the freecards script</td><td><input type="text" name="\$script_location" value="$script_location"></td></tr>
	~;
	
	$example_carddesk = $FORM{'$example_carddesk'} || $example_carddesk || "http://mtvwebdesign.hypermart.net/freecards";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$example_carddesk" target="_blank">?</a> 10.</td><td>Please enter the URL to the example postcard desk</td><td><input type="text" name="\$example_carddesk" value="$example_carddesk"></td></tr>
	~;
	
	$std_lng = $FORM{'$std_lng'} || $std_lng || "en";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$std_lng" target="_blank">?</a> 11.</td><td>Please set the default language</td><td><select name="\$std_lng">
	~;
	foreach $lng (sort keys %languages) {
		undef $selected;
		if ($languages{$lng} eq $std_lng) { $selected = " selected"; }
		print qq~<OPTION value="$languages{$lng}"$selected>$lng\n~;
	}
	print qq~
	</select></td></tr>
	~;
	
	$max_recipients = $FORM{'$max_recipients'} || $max_recipients || "10";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$max_recipients" target="_blank">?</a> 12.</td><td>Please enter the maximum number of recipients a person is allowed to send a card to at once</td><td><input type="text" size="2" name="\$max_recipients" value="$max_recipients"></td></tr>
	~;
	
	$elapsed_days = $FORM{'$elapsed_days'} || $elapsed_days || "21";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$elapsed_days" target="_blank">?</a> 13.</td><td>Please enter the number of days cards are stored in the database</td><td><input type="text" size="2" name="\$elapsed_days" value="$elapsed_days"></td></tr>
	~;
	
	$elapsed_days_two = $FORM{'$elapsed_days_two'} || $elapsed_days_two || "2";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$elapsed_days_two" target="_blank">?</a> 14.</td><td>Please enter the number of days cards which are already viewed once are stored in the database</td><td><input type="text" size="2" name="\$elapsed_days_two" value="$elapsed_days_two"></td></tr>
	~;
	
	$elapsed_days_urls = $FORM{'$elapsed_days_urls'} || $elapsed_days_urls || "5";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$elapsed_days_urls" target="_blank">?</a> 15.</td><td>Please enter the number of days postcard desks are stored in the URLS database</td><td><input type="text" size="2" name="\$elapsed_days_urls" value="$elapsed_days_urls"></td></tr>
	~;
	
	if ($firsttime) { $send_old_cards = "0"; }
	else { $send_old_cards = $FORM{'$send_old_cards'} || $send_old_cards; }
	
	undef $selected;
	if ($send_old_cards) { $selected = " selected"; }
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$send_old_cards" target="_blank">?</a> 16.</td><td>Do you want to send cards which were not picked up by email?</td><td><select name="\$send_old_cards">
	<option value="2">NO
	<option value="1"$selected>YES
	</select></td></tr>
	~;
	
	if ($firsttime) { $send_welcome_email = "1"; }
	else { $send_welcome_email = $FORM{'$send_welcome_email'} || $send_welcome_email; }
	
	undef $selected;
	if ($send_welcome_email eq "1") { $selected = " selected"; }
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$send_welcome_email" target="_blank">?</a> 17.</td><td>Do you want to send a welcome email to new users?</td><td><select name="\$send_welcome_email">
	<option value="2">NO
	<option value="1"$selected>YES
	</select></td></tr>
	~;
	
	if ($firsttime) { $add_footer = "1"; }
	else { $add_footer = $FORM{'$add_footer'} || $add_footer; }
	
	undef $selected;
	if ($add_footer eq "1") { $selected = " selected"; }
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$add_footer" target="_blank">?</a> 18.</td><td>Do you want to add a footer to each email?</td><td><select name="\$add_footer">
	<option value="2">NO
	<option value="1"$selected>YES
	</select></td></tr>
	~;
	
	$bgcolor = $FORM{'$bgcolor'} || $bgcolor || "#FFFFFF";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$bgcolor" target="_blank">?</a> 19.</td><td>Please specify the background color of the default page</td><td><input type="text" name="\$bgcolor" value="$bgcolor" size="7"></td></tr>
	~;
	
	$background =$FORM{'$background'} || $background;
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$background" target="_blank">?</a> 20.</td><td>Please enter the URL to a background image for the default page (not required)</td><td><input type="text" name="\$background" value="$background"></td></tr>
	~;
	
	$link_color = $FORM{'$link_color'} || $link_color || "#0080C0";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$link_color" target="_blank">?</a> 21.</td><td>Please specify the link color of the default page</td><td><input type="text" name="\$link_color" value="$link_color" size="7"></td></tr>
	~;
	
	$vlink_color = $FORM{'$vlink_color'} || $vlink_color ||"#8080C0";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$vlink_color" target="_blank">?</a> 22.</td><td>Please specify the visited link color of the default page</td><td><input type="text" name="\$vlink_color" value="$vlink_color" size="7"></td></tr>
	~;
	
	$alink_color = $FORM{'$alink_color'} || $alink_color || "#FF0000";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$alink_color" target="_blank">?</a> 23.</td><td>Please specify the active link color of the default page</td><td><input type="text" name="\$alink_color" value="$alink_color" size="7"></td></tr>
	~;
	
	$text_color = $FORM{'$text_color'} || $text_color || "#004080";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$text_color" target="_blank">?</a> 24.</td><td>Please specify the text color of the default page</td><td><input type="text" name="\$text_color" value="$text_color" size="7"></td></tr>
	~;
	
	$postcard_bgcolor = $FORM{'$postcard_bgcolor'} || $postcard_bgcolor || "#FFFFFF";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$postcard_bgcolor" target="_blank">?</a> 25.</td><td>Please specify the background color of the postcard on the default page</td><td><input type="text" name="\$postcard_bgcolor" value="$postcard_bgcolor" size="7"></td></tr>
	~;
	
	$postcard_text_color = $FORM{'$postcard_text_color'} || $postcard_text_color || "#004080";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$postcard_text_color" target="_blank">?</a> 26.</td><td>Please specify the text color of the postcard on the default page</td><td><input type="text" name="\$postcard_text_color" value="$postcard_text_color" size="7"></td></tr>
	~;
	
	print qq~
	</table>
	</td></tr>
	<td colspan="3" align="center"><input type="submit"></td>
	</tr>
	</table>
	</form>
	~;
	
	print qq~
	</body>
	</html>
	~;
	exit;
}

sub install {
	
	# We create an array called @file, which we pint to the file later....
	
	$perl = $FORM{'$perl'} || $perl;
	if ($perl) {
		push @files, "\#\!$perl\n\n";
	}
	else {
		&setup("Please enter the location to perl on your server");
		exit;
	}
	
	$webmasterusername = $FORM{'$webmasterusername'} || $webmasterusername;
	if ($webmasterusername) {
		push @file, "\$webmasterusername = \"$webmasterusername\"\;\n";
	}
	else {
		&setup("Please enter a username");
	}
	
	$webmasterpass = $FORM{'$webmasterpass'} || $webmasterpass;
	if ($webmasterpass) {
		push @file, "\$webmasterpass = \"$webmasterpass\"\;\n";
	}
	else {
		&setup("Please enter a password");
	}
	
	$webmasteremail = $FORM{'$webmasteremail'} || $webmasteremail;
	$emailcheck = &CheckMail($webmasteremail);
	if ($emailcheck) { &setup("$emailcheck is not a valid email address."); }
	push @file, "\$webmasteremail = \'$webmasteremail\'\;\n";
	
	$servicename = $FORM{'$servicename'} || $servicename || "freEcards";
	push @file, "\$servicename = \"$servicename\"\;\n";
	
	$servicelocation = $FORM{'$servicelocation'} || $servicelocation || "http://" . $ENV{'SERVER_NAME'};
	push @file, "\$servicelocation = \"$servicelocation\"\;\n\n";
	
	$cgiext = $FORM{'$cgiext'} || $cgiext || ".cgi";
	push @file, "\$cgiext = \"$cgiext\"\;\n";
	push @file, "\$perl = \"$perl\"\;\n";
	
	$mailprog =~ s/\|(.*?)\s-t/$1/i;
	$mailprog = $FORM{'$mailprog'} || $mailprog || &setup("Please enter the location to your email program on your server.");
	push @file, "\$mailprog = \"\|$mailprog -t\"\;\n";
	
	@suparts = split(/\//,$ENV{'SCRIPT_NAME'});
	pop @suparts;
	push @suparts, "freecards.cgi";
	$script_url = 'http://' . $ENV{'SERVER_NAME'} . ($ENV{'SERVER_PORT'} != 80 ? ":$ENV{'SERVER_PORT'}" : '') . (join "\/", @suparts);

$FORM{'$script_location'} =~ s/\.cgi$/$cgiext/i;
$FORM{'$script_location'} =~ s/\.pl$/$cgiext/i;
	
	$script_location = $FORM{'$script_location'} || $script_location || $script_url;
	push @file, "\$script_location = \"$script_location\"\;\n";
	
	$example_carddesk = $FORM{'$example_carddesk'} || $example_carddesk || "http://mtvwebdesign.hypermart.net/freecards";
	push @file, "\$example_carddesk = \"$example_carddesk\"\;\n\n";
	
	
	$bgcolor = $FORM{'$bgcolor'} || $bgcolor || "#FFFFFF";
	push @file, "\$bgcolor = \"$bgcolor\"\;\n";
	$background =$FORM{'$background'} || $background;
	push @file, "\$background = \"$background\"\;\n";
	$link_color = $FORM{'$link_color'} || $link_color || "#0080C0";
	push @file, "\$link_color = \"$link_color\"\;\n";
	$vlink_color = $FORM{'$vlink_color'} || $vlink_color ||"#8080C0";
	push @file, "\$vlink_color = \"$vlink_color\"\;\n";
	$alink_color = $FORM{'$alink_color'} || $alink_color || "#FF0000";
	push @file, "\$alink_color = \"$alink_color\"\;\n";
	$text_color = $FORM{'$text_color'} || $text_color || "#004080";
	push @file, "\$text_color = \"$text_color\"\;\n";
	$postcard_bgcolor = $FORM{'$postcard_bgcolor'} || $postcard_bgcolor || "#FFFFFF";
	push @file, "\$postcard_bgcolor = \"$postcard_bgcolor\"\;\n";
	$postcard_text_color = $FORM{'$postcard_text_color'} || $postcard_text_color || "#004080";
	push @file, "\$postcard_text_color = \"$postcard_text_color\"\;\n\n";
	
	$std_lng = $FORM{'$std_lng'} || $std_lng || "en";
	push @file, "\$std_lng = \"$std_lng\"\;\n\n";
	
	$max_recipients = $FORM{'$max_recipients'} || $max_recipients || "10";
	push @file, "\$max_recipients = \"$max_recipients\"\;\n";
	$elapsed_days = $FORM{'$elapsed_days'} || $elapsed_days || "21";
	push @file, "\$elapsed_days = \"$elapsed_days\"\;\n";
	$elapsed_days_two = $FORM{'$elapsed_days_two'} || $elapsed_days_two || "2";
	push @file, "\$elapsed_days_two = \"$elapsed_days_two\"\;\n";
	$elapsed_days_urls = $FORM{'$elapsed_days_urls'} || $elapsed_days_urls || "5";
	push @file, "\$elapsed_days_urls = \"$elapsed_days_urls\"\;\n";
	
	if ($FORM{'$send_old_cards'} == 1) {
		$send_old_cards = "1";
	}
	elsif ($FORM{'$send_old_cards'} == 2) {
		$send_old_cards = "0";
	}
	elsif ($send_old_cards) {
		$send_old_cards = $send_old_cards;
	}
	else {
		$send_old_cards = "0";
	}
	push @file, "\$send_old_cards = \"$send_old_cards\"\;\n\n";
	
	if ($FORM{'$send_welcome_email'} == 1) {
		$send_welcome_email = "1";
	}
	elsif ($FORM{'$send_welcome_email'} == 2) {
		$send_welcome_email = "0";
	}
	elsif (defined $send_welcome_email) {
		$send_welcome_email = $send_welcome_email;
	}
	else {
		$send_welcome_email = "1";
	}
	push @file, "\$send_welcome_email = \"$send_welcome_email\"\;\n";
	
	
	if ($FORM{'$add_footer'} == 1) {
		$add_footer = "1";
	}
	elsif ($FORM{'$add_footer'} == 2) {
		$add_footer = "0";
	}
	elsif (defined $add_footer) {
		$add_footer = $add_footer;
	}
	else {
		$add_footer = "1";
	}
	push @file, "\$add_footer = \"$add_footer\"\;\n";
	
	
	# Autoconfigured / Advanced:
	
	@suparts = split(/\//,$ENV{'SCRIPT_NAME'});
	pop @suparts;
	push @suparts, "images";
	$img_loc = 'http://' . $ENV{'SERVER_NAME'} . ($ENV{'SERVER_PORT'} != 80 ? ":$ENV{'SERVER_PORT'}" : '') . (join "\/", @suparts);
	
	$image_locations = $FORM{'$image_locations'} || $image_locations || $img_loc;
	push @file, "\$image_locations = \"$image_locations\"\;\n";
	
	$stamp_image = $FORM{'$stamp_image'} || $stamp_image || "stamp.gif";
	push @file, "\$stamp_image = \"$stamp_image\"\;\n";
	
	$logo_image = $FORM{'$logo_image'} || $logo_image || "logo.gif";
	push @file, "\$logo_image = \"$logo_image\"\;\n";
	
	$line_image = $FORM{'$line_image'} || $line_image || "blackpix.gif";
	push @file, "\$line_image = \"$line_image\"\;\n";
	
	$noimg_image = $FORM{'$noimg_image'} || $noimg_image || "noimg.gif";
	push @file, "\$noimg_image = \"$noimg_image\"\;\n";
	
	$pixel = $FORM{'$pixel'} || $pixel || "pixel.gif";
	push @file, "\$pixel = \"$pixel\"\;\n";
	
	$mtvwebdesignlib = $FORM{'$mtvwebdesignlib'} || $mtvwebdesignlib || "./mtvwebdesign.lib";
	push @file, "\$mtvwebdesignlib = \"$mtvwebdesignlib\"\;\n";
	
	$dbdir = $FORM{'$dbdir'} || $dbdir || "./databases";
	push @file, "\$dbdir = \"$dbdir\"\;\n";
	$dbdir =~ s/\/$|\\$//igs;
	mkdir($dbdir, 0777);
	
	$dbunder = $FORM{'$dbunder'} || $dbunder || "./dbUnder.lib";
	push @file, "\$dbunder = \"$dbunder\"\;\n";
	
	$languagepack_dir = $FORM{'$languagepack_dir'} || $languagepack_dir || "./languagepacks";
	push @file, "\$languagepack_dir = \"$languagepack_dir\"\;\n";
	$languagepack_dir =~ s/\/$|\\$//igs;
	mkdir($languagepack_dir, 0777);
	$olden = "./en.lng";
	$newen = $languagepack_dir;
	if ($newen !~ /\/$/) { $newen .= "/"; }
	$newen .= "en.lng";
	rename($olden,$newen);
	
	$terms_dir = $FORM{'$terms_dir'} || $terms_dir || "./terms";
	push @file, "\$terms_dir = \"$terms_dir\"\;\n";
	$terms_dir =~ s/\/$|\\$//igs;
	mkdir($terms_dir, 0777);
	
	$maintenance_file = $FORM{'$maintenance_file'} || $maintenance_file || "./stop.txt";
	push @file, "\$maintenance_file = \"$maintenance_file\"\;\n";
	
	if ($FORM{'$web_email'}) {
		@web_email = split(/\,/,$FORM{'$web_email'});
		foreach $email (@web_email) {
			$email =~ s/\s|\r|\n//igs;
		}
		$web_email = join "\'\,\'",@web_email;
		$web_email = "\'$web_email\'";
	}
	elsif (@web_email) {
		$web_email = join "\'\,\'",@web_email;
		$web_email = "\'$web_email\'";
	}
	else {
		$web_email = "\'$webmasteremail\'";
	}
	push @file, "\@web_email = ($web_email)\;\n";

if (defined $FORM{'$getpic_script'}) {
	$getpic_script = $FORM{'$getpic_script'};
}
elsif(defined $getpic_script) {
	$getpic_script = $getpic_script;
}	
else {
	@suparts = split(/\//,$ENV{'SCRIPT_NAME'});
	pop @suparts;
	push @suparts, "getpic$cgiext";
	$getpic_loc = 'http://' . $ENV{'SERVER_NAME'} . ($ENV{'SERVER_PORT'} != 80 ? ":$ENV{'SERVER_PORT'}" : '') . (join "\/", @suparts);

	$getpic_script = $getpic_loc;
}
	push @file, "\$getpic_script = \"$getpic_script\"\;\n";
	
	@suparts = split(/\//,$ENV{'SCRIPT_NAME'});
	pop @suparts;
	push @suparts, "pgen$cgiext";
	$pgen_loc = 'http://' . $ENV{'SERVER_NAME'} . ($ENV{'SERVER_PORT'} != 80 ? ":$ENV{'SERVER_PORT'}" : '') . (join "\/", @suparts);
	
	$pgen_location = $FORM{'$pgen_location'} || $pgen_location || $pgen_loc;
	push @file, "\$pgen_location = \"$pgen_location\"\;\n";
	
	if ($FORM{'$referers'}) {
		@referers = split(/\,/,$FORM{'$referers'});
		foreach $ref (@referers) {
			$ref =~ s/\s|\r|\n//igs;
		}
		$referers = join "\'\,\'",@referers;
		$referers = "\'$referers\'";
	}
	elsif (@referers) {
		$referers = join "\'\,\'",@referers;
		$referers = "\'$referers\'";
	}
	else {
		$referers = "\"\"";
	}
	push @file, "\@referers = ($referers)\;\n";
	
	$plugin_dir = $FORM{'$plugin_dir'} || $plugin_dir || "./plugins";
	push @file, "\$plugin_dir = \"$plugin_dir\"\;\n";
	$plugin_dir =~ s/\/$|\\$//igs;
	mkdir($plugin_dir, 0777);

if (defined $FORM{'$sendpics_plugin'}) { $sendpics_plugin = $FORM{'$sendpics_plugin'}; }
	$sendpics_plugin = $FORM{'$sendpics_plugin'} || $sendpics_plugin || "";
	push @file, "\$sendpics_plugin = \"$sendpics_plugin\"\;\n";

if (defined $FORM{'$tosend_plugin'}) { $tosend_plugin = $FORM{'$tosend_plugin'}; }	
	$tosend_plugin = $FORM{'$tosend_plugin'} || $tosend_plugin || "";
	push @file, "\$tosend_plugin = \"$tosend_plugin\"\;\n";

if (defined $FORM{'$layout_plugin'}) { $layout_plugin = $FORM{'$layout_plugin'}; }	
	$layout_plugin = $FORM{'$layout_plugin'} || $layout_plugin || "";
	push @file, "\$layout_plugin = \"$layout_plugin\"\;\n";

if (defined $FORM{'$filestore_plugin'}) { $filestore_plugin = $FORM{'$filestore_plugin'}; }	
	$filestore_plugin = $FORM{'$filestore_plugin'} || $filestore_plugin || "";
	push @file, "\$filestore_plugin = \"$filestore_plugin\"\;\n";
	
	$path_to_image_dir = $FORM{'$path_to_image_dir'} || $path_to_image_dir || "./images";
	push @file, "\$path_to_image_dir = \"$path_to_image_dir\"\;\n\n";
	$path_to_image_dir =~ s/\/$|\\$//igs;
	mkdir($path_to_image_dir, 0777);
	
	if ($FORM{'$send_old_cards_as_html'} == 1) {
		$send_old_cards_as_html = "1";
	}
	elsif ($FORM{'$send_old_cards_as_html'} == 2) {
		$send_old_cards_as_html = "0";
	}
	elsif ($send_old_cards_as_html) {
		$send_old_cards_as_html = $send_old_cards_as_html;
	}
	else {
		$send_old_cards_as_html = "0";
	}
	push @file, "\$send_old_cards_as_html = \"$send_old_cards_as_html\"\;\n";
	
	if ($FORM{'$allow_sending_html_cards'} == 1) {
		$allow_sending_html_cards = "1";
	}
	elsif ($FORM{'$allow_sending_html_cards'} == 2) {
		$allow_sending_html_cards = "0";
	}
	elsif ($allow_sending_html_cards) {
		$allow_sending_html_cards = $allow_sending_html_cards;
	}
	else {
		$allow_sending_html_cards = "0";
	}
	push @file, "\$allow_sending_html_cards = \"$allow_sending_html_cards\"\;\n";
	
	if ($FORM{'$all_as_html'} == 1) {
		$all_as_html = "1";
	}
	elsif ($FORM{'$all_as_html'} == 2) {
		$all_as_html = "0";
	}
	elsif ($all_as_html) {
		$all_as_html = $all_as_html;
	}
	else {
		$all_as_html = "0";
	}
	push @file, "\$all_as_html = \"$all_as_html\"\;\n";
	
	if ($FORM{'$allow_specific_date'} == 1) {
		$allow_specific_date = "1";
	}
	elsif ($FORM{'$allow_specific_date'} == 2) {
		$allow_specific_date = "0";
	}
	elsif ($allow_specific_date) {
		$allow_specific_date = $allow_specific_date;
	}
	else {
		$allow_specific_date = "1";
	}
	push @file, "\$allow_specific_date = \"$allow_specific_date\"\;\n";
	
	$num_days_adv = $FORM{'$num_days_adv'} || $num_days_adv || "28";
	push @file, "\$num_days_adv = \"$num_days_adv\"\;\n";
	
	if ($FORM{'$allow_image_storage'} == 1) {
		$allow_image_storage = "1";
	}
	elsif ($FORM{'$allow_image_storage'} == 2) {
		$allow_image_storage = "0";
	}
	elsif ($allow_image_storage) {
		$allow_image_storage = $allow_image_storage;
	}
	else {
		$allow_image_storage = "0";
	}
	push @file, "\$allow_image_storage = \"$allow_image_storage\"\;\n";
	
	$path_to_storage_dir = $FORM{'$path_to_storage_dir'} || $path_to_storage_dir || "$plugin_dir/stored_images/";
	push @file, "\$path_to_storage_dir = \"$path_to_storage_dir\"\;\n";
	$path_to_storage_dir =~ s/\/$|\\$//igs;
	mkdir($path_to_storage_dir, 0777);
	
	@suparts = split(/\//,$ENV{'SCRIPT_NAME'});
	pop @suparts;
	$pl_dir = $plugin_dir;
	$pl_dir =~ s/\.\/(.*)/$1/;
	push @suparts, "$pl_dir\/stored_images/";
	$utsd_loc = 'http://' . $ENV{'SERVER_NAME'} . ($ENV{'SERVER_PORT'} != 80 ? ":$ENV{'SERVER_PORT'}" : '') . (join "\/", @suparts);
	
	$url_to_storage_dir = $FORM{'$url_to_storage_dir'} || $url_to_storage_dir || $utsd_loc;
	push @file, "\$url_to_storage_dir = \"$url_to_storage_dir\"\;\n";
	
	$max_file_size = $FORM{'$max_file_size'} || $max_file_size || "70000";
	push @file, "\$max_file_size = \"$max_file_size\"\;\n";
	
	$path_to_layouts_dir = $FORM{'$path_to_layouts_dir'} || $path_to_layouts_dir || "$plugin_dir/layouts/";
	push @file, "\$path_to_layouts_dir = \"$path_to_layouts_dir\"\;\n";
	$path_to_layouts_dir =~ s/\/$|\\$//igs;
	mkdir($path_to_layouts_dir, 0777);
	
	if (defined $FORM{'$std_layout'}) {
		$std_layout = $FORM{'$std_layout'};
	}
	elsif ($std_layout) {
		$std_layout = $std_layout;
	}
	else {
		$std_layout = "";
	}
	push @file, "\$std_layout = \"$std_layout\"\;\n";
	
	open(FILE, ">./freecards$cgiext") or die "Cannot create freecards$cgiext: $!";
	print FILE "\#\!$perl\n\n";
	print FILE @file;
	print FILE "\n\n";
	print FILE qq~
	# Now run the script:
	if (!\$no_eng_req) {
		require "./freecards_eng.lib";
	}
	else {
		return 1;
	}
	~;
	close(FILE);
	chmod(0755, "./freecards$cgiext");
	
	# Now we create the .htaccess and .htpasswd files:
	if ($dbdir !~ /\/$/) { $dbdir .= "/"; }
	$htaccess = $dbdir . "\.htaccess";
	$htpasswd = $dbdir . "\.htpasswd";
	
	open(HTA, ">$htaccess") or warn "Cannot create $htaccess. Database directory not password protected: $!";
	print HTA "AuthName freEcards\n";
	print HTA "AuthType Basic\n";
	print HTA "AuthUserFile \.\/\.htpasswd\n";
	print HTA "require valid-user\n";
	close(HTA);
	
	open(HTP, ">$htpasswd") or warn "Cannot create $htpasswd. Database directory not password protected: $!";
	$pass = crypt($FORM{'$webmasterpass'}, Cd);
	print HTP "$webmasterusername\:$pass\n";
	close(HTP);

&creategetpic;	
	
	if ($firsttime) {
		&SetCookies("loggedin","1");
		&firsttimeinstalled;
	}

	&mainpage("Changes in setup changed succesfully.");
	
}

sub warn {
	my ($warn) = @_;
	return unless $warn;
	
	print qq~
	<center><font color="#FF0000"><b>$warn</b></font></center><p>
	~;
	
}

sub firsttimeinstalled {
	print "Content-type: text/html\n\n";
	
	print qq~
	<html>
	<head><title>Script installed</title></head>
	<body>
<basefont size="3" face="Arial,Helvetica,sans-serif">
<table width="60%" border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
<tr><td align="center"><b><font size="+1">Automatic first time installation complete</font></b></td></tr>
<tr><td bgcolor="$color">Although the automatic installation is complete, you still need to upload the rest of the files you found in the ZIP file. If you unzipped the file using it's internal directory structure, you can simply upload the rest of the files to their corresponding structure. By default the structure on your server will look like this:</td></tr>
<tr><td align="center" bgcolor="">

~;
&DirStructure;
print qq~

</td></tr>
<tr><td bgcolor="$color">The text in Bold are directories<br>
The text in Italic are files/directories which were automatically created by the setup program<br>
The underlined files don't exist yet, but you can create them yourself and upload them<p>
Please note that all the plugins are named here. It might be possible that you do not own all the plugins. If you do, you can upload the to the correct directory</td></tr>
<tr><td align="center"><a href="$ENV{'SCRIPT_NAME'}?id=$id">To Mainpage</a></td></tr>
</table>
	</body>
	</html>
	~;
	
	exit;
}

sub advsetup {
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>Advanced setup</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<form action="$ENV{'SCRIPT_NAME'}" method="post">
	<input type="hidden" name="action" value="install">
	<input type="hidden" name="id" value="$id">
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
	<tr>
	<td colspan="3" align="center"><b><font size="+1">Advanced setup</font></b><br><a href="$ENV{'SCRIPT_NAME'}?id=$id">Back to mainpage</a>
	</td>
	</tr>
	<tr><td bgcolor="$color"><table>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$image_locations" target="_blank">?</a> 1.</td><td>Please enter the URL to the image directory</td><td><input type="text" name="\$image_locations" value="$image_locations"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$stamp_image" target="_blank">?</a> 2.</td><td>Please enter the filename of the stamp image</td><td><input type="text" name="\$stamp_image" value="$stamp_image"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$logo_image" target="_blank">?</a> 3.</td><td>Please enter the filename of the logo image</td><td><input type="text" name="\$logo_image" value="$logo_image"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$line_image" target="_blank">?</a> 4.</td><td>Please enter the filename of the line image</td><td><input type="text" name="\$line_image" value="$line_image"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$noimg_image" target="_blank">?</a> 5.</td><td>Please enter the filename of the "noimage" image</td><td><input type="text" name="\$noimg_image" value="$noimg_image"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$pixel" target="_blank">?</a> 6.</td><td>Please enter the filename of the pixel image</td><td><input type="text" name="\$pixel" value="$pixel"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$mtvwebdesignlib" target="_blank">?</a> 7.</td><td>Please enter the path to the mtvwebdesign.lib file</td><td><input type="text" name="\$mtvwebdesignlib" value="$mtvwebdesignlib"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$dbdir" target="_blank">?</a> 8.</td><td>Please enter the path to the directory where the database is stored</td><td><input type="text" name="\$dbdir" value="$dbdir"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$dbunder" target="_blank">?</a> 9.</td><td>Please enter the path to the the dbUnder.lib file</td><td><input type="text" name="\$dbunder" value="$dbunder"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$languagepack_dir" target="_blank">?</a> 10.</td><td>Please enter the path to the directory where the languagepacks are stored</td><td><input type="text" name="\$languagepack_dir" value="$languagepack_dir"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$terms_dir" target="_blank">?</a> 11.</td><td>Please enter the path to the directory where the terms are stored</td><td><input type="text" name="\$terms_dir" value="$terms_dir"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$maintenance_file" target="_blank">?</a> 12.</td><td>Please enter the path to the maintenance file</td><td><input type="text" name="\$maintenance_file" value="$maintenance_file"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$plugin_dir" target="_blank">?</a> 13.</td><td>Please enter the path to the plugins directory</td><td><input type="text" name="\$plugin_dir" value="$plugin_dir"></td></tr>
	~;
	
	$web_email = join ",", @web_email;
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$web_email" target="_blank">?</a> 14.</td><td>Please enter the email address which will have a webmaster effect on the script (seperate by a comma)</td><td><input type="text" name="\$web_email" value="$web_email"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$pgen_location" target="_blank">?</a> 15.</td><td>Please enter the URL to the page generator script</td><td><input type="text" name="\$pgen_location" value="$pgen_location"></td></tr>
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$getpic_script" target="_blank">?</a> 16.</td><td>Do you want the script to fetch images from servers? If so, please verify the location to the script: </td><td><input type="text" name="\$getpic_script" value="$getpic_script"></td></tr>
	~;

	$referers = join ",", @referers;
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$referers" target="_blank">?</a> 17.</td><td>Please enter the domains you want to allow access to the service, leave blank for any domain</td><td><input type="text" name="\$referers" value="$referers"></td></tr>
	~;
	
	print qq~
	</table>
	</td></tr>
	<tr><td colspan="3" align="center">
	<input type="submit">
	</td></tr></table>
	</form>
	</body>
	</html>
	~;
	
}

sub plugins {
	if ($plugin_dir !~ /\/$/) { $plugin_dir .= "\/"; }
	opendir(DIR, $plugin_dir) || die "can't opendir $plugin_dir: $!";
	@dirfiles = grep { /.*?/i && -f "$plugin_dir$_"} readdir(DIR);
	foreach $file (@dirfiles) {
		if ($file =~ /filestore/i) {
			$filestore_plugin = $plugin_dir . $file;
		}
		elsif ($file =~ /layout/i) {
			$layout_plugin = $plugin_dir . $file;
		}
		elsif ($file =~ /sendpics/i) {
			$sendpics_plugin = $plugin_dir . $file;
		}
		elsif ($file =~ /tosend/i) {
			$tosend_plugin = $plugin_dir . $file;
		}
	}
	closedir DIR;
	
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>Plugin Installation</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<form action="$ENV{'SCRIPT_NAME'}" method="post">
	<input type="hidden" name="action" value="install">
	<input type="hidden" name="id" value="$id">
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
	<tr>
	<td colspan="3" align="center"><b><font size="+1">Plugin Installation</font></b><br><a href="$ENV{'SCRIPT_NAME'}?a=help\#\plugin_installation" target="_blank">Where are my plugins?</a><br><br><a href="$ENV{'SCRIPT_NAME'}?id=$id">Back to mainpage</a>
	</td>
	</tr>
	~;
	
	if (!$filestore_plugin && !$layout_plugin && !$sendpics_plugin && !$tosend_plugin) {
		print qq~<tr><td align="center" colspan="3">No plugins found. Please upload your plugins to the plugin directory: $plugin_dir. If this is not the correct directory, please change it here: <input type="text" name="\$plugin_dir" value="$plugin_dir"></td></tr>~;
	}
	else {
		
		if ($filestore_plugin) {
			print qq~
			<tr><td colspan="3"><h3>FileStore plugin</h3>
			Filename: <b>$filestore_plugin</b><p><input type="hidden" name="\$filestore_plugin" value="$filestore_plugin"></td></tr>
			<tr><td bgcolor="$color"><table>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$allow_image_storage" target="_blank">?</a> 1.</td><td>Do you want to allow image storage on your server?</td><td><select name="\$allow_image_storage">
			~;
			
			if ($allow_image_storage) { $selected = " selected"; }
			
			print qq~
			<option value="2">NO
			<option value="1"$selected>YES
			</select></td></tr>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$path_to_storage_dir" target="_blank">?</a> 2.</td><td>Please enter the path to the storage dir</td><td><input type="text" name="\$path_to_storage_dir" value="$path_to_storage_dir"></td></tr>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$url_to_storage_dir" target="_blank">?</a> 3.</td><td>Please enter the URL to the storage dir</td><td><input type="text" name="\$url_to_storage_dir" value="$url_to_storage_dir"></td></tr>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$max_file_size" target="_blank">?</a> 4.</td><td>Please enter the maximum file size in bytes</td><td><input type="text" name="\$max_file_size" value="$max_file_size" size="6"> bytes</td></tr>
			</table></td></tr>
			~;
			
		}
else {
print qq~<input type="hidden" name="\$filestore_plugin" value="">~;
}	
		
		if ($layout_plugin) {
			
			print qq~
			<tr><td colspan="3"><h3>Layout plugin</h3>
			<a href="$ENV{'SCRIPT_NAME'}?a=help\#using_layouts" target="_blank">How to use the layouts plugin?</a><p>
			Filename: <b>$layout_plugin</b><p><input type="hidden" name="\$layout_plugin" value="$layout_plugin"></td></tr>
			<tr><td bgcolor="$color"><table>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$path_to_layouts_dir" target="_blank">?</a> 1.</td><td>Please enter the path to the layouts directory</td><td><input type="text" name="\$path_to_layouts_dir" value="$path_to_layouts_dir"></td></tr>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$std_layout" target="_blank">?</a> 2.</td><td>Please enter the name of your default layout (leave blank to use internal layout)</td><td><input type="text" name="\$std_layout" value="$std_layout"></td></tr>
			</table></td></tr>
			~;
			
		}
else {
print qq~<input type="hidden" name="\$layout_plugin" value="">~;
}
		
		if ($sendpics_plugin) {
			print qq~
			<tr><td colspan="3"><h3>SendPics plugin</h3>
			Filename: <b>$sendpics_plugin</b><p><input type="hidden" name="\$sendpics_plugin" value="$sendpics_plugin"></td></tr>
			<tr><td bgcolor="$color"><table>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$path_to_image_dir" target="_blank">?</a> 1.</td><td>Please enter the path to the directory where the images ($logo_image, $noimg_image, $stamp_image) are located</td><td><input type="text" name="\$path_to_image_dir" value="$path_to_image_dir"></td></tr>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$allow_sending_html_cards" target="_blank">?</a> 2.</td><td>Do you want to allow people sending html cards?</td><td><select name="\$allow_sending_html_cards">
			~;
			undef $selected;
			if ($allow_sending_html_cards) { $selected = " selected"; }
			print qq~
			<option value="2">NO
			<option value="1"$selected>YES
			</select></td></tr>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$all_as_html" target="_blank">?</a> 3.</td><td>Do you want to send all the cards as html?</td><td><select name="\$all_as_html">
			~;
			undef $selected;
			if ($all_as_html) { $selected = " selected"; }
			print qq~
			<option value="2">NO
			<option value="1"$selected>YES
			</select></td></tr>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$send_old_cards_as_html" target="_blank">?</a> 4.</td><td>Do you want to send old cards as html?</td><td><select name="\$send_old_cards_as_html">
			~;
			undef $selected;
			if ($send_old_cards_as_html) { $selected = " selected"; }
			print qq~
			<option value="2">NO
			<option value="1"$selected>YES
			</select></td></tr>
			</table></td></tr>
			~;
			
			
		}
else {
print qq~<input type="hidden" name="\$sendpics_plugin" value="">~;
}
		
		if ($tosend_plugin) {
			print qq~
			<tr><td colspan="3"><h3>ToSend plugin</h3>
			Filename: <b>$tosend_plugin</b><p><input type="hidden" name="\$tosend_plugin" value="$tosend_plugin"></td></tr>
			<tr><td bgcolor="$color"><table>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$allow_specific_date" target="_blank">?</a> 1.</td><td>Do you want to allow people sending cards on a specific date?</td><td><select name="\$allow_specific_date">
			~;
			undef $selected;
			if ($allow_specific_date) { $selected = " selected"; }
			print qq~
			<option value="2">NO
			<option value="1"$selected>YES
			</select></td></tr>
			<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$num_days_adv" target="_blank">?</a> 2.</td><td>Please enter the number of days a card may be send in advance</td><td><input type="text" name="\$num_days_adv" value="$num_days_adv" size="2"></td></tr>
			</table></td></tr>
			~;
			
		}
else {
print qq~<input type="hidden" name="\$tosend_plugin" value="">~;
}
		
	}
	
	print qq~
	<tr><td colspan="3" align="center"><input type="submit"></td></tr>
	</table>
	</form>
	</body>
	</html>
	~;
	exit;
	
}

sub pgen {
	local($warn) = @_;
	
	if (-e "./pgen.cgi") {
		$no_eng_req = "1";
		require "./pgen.cgi";
	}
	elsif (-e "./pgen.pl") {
		$no_eng_req = "1";
		require "./pgen.pl";
	}
	else {
		$pgenfirsttime = "1";
		&errors("I cannot find the pgen_eng.lib file. Please upload the file to the same directory as this script.") if (!-e "./pgen_eng.lib");
		&errors("I cannot find the htmlbuttons.js file. Please upload the file to the same directory as this script.") if (!-e "./htmlbuttons.js");
	}
	
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>Page Generator installation</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<form action="$ENV{'SCRIPT_NAME'}" method="POST">
	<input type="hidden" name="action" value="pgennow">
	<input type="hidden" name="id" value="$id">
	<table cellpadding="4" cellspacing="0" border="1" align="center" bordercolor="$color">
	<tr><td align="center"><font size="+1"><b>Page Generator Installation</b></font><br><a href="$ENV{'SCRIPT_NAME'}?id=$id">Back to mainpage</a>
	~;
	&warn($warn);
	print qq~
	</td></tr>
	<tr><td bgcolor="$color">
	<table>
	~;
	
	@suparts = split(/\//,$ENV{'SCRIPT_NAME'});
	pop @suparts;
	push @suparts, "pgen.$cgiext";
	$pgen_url = 'http://' . $ENV{'SERVER_NAME'} . ($ENV{'SERVER_PORT'} != 80 ? ":$ENV{'SERVER_PORT'}" : '') . (join "\/", @suparts);
	
	$pgen_location = $FORM{'$pgen_location'} || $pgen_location || $pgen_url;
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$pgen_locationb" target="_blank">?</a> 1.</td><td>Please verify the URL to the pgen$cgiext script</td><td><input type="text" name="\$pgen_location" value="$pgen_location"></td></tr>
	~;
	
	@suparts = split(/\//,$ENV{'SCRIPT_NAME'});
	pop @suparts;
	push @suparts, "htmlbuttons.js";
	$javasource_url = 'http://' . $ENV{'SERVER_NAME'} . ($ENV{'SERVER_PORT'} != 80 ? ":$ENV{'SERVER_PORT'}" : '') . (join "\/", @suparts);
	
	$javasource = $FORM{'$javasource'} || $javasource || $javasource_url;

undef $selected;
if ($usetoken) {$selected = " selected"; }
$tokenfile = $FORM{'$tokenfile'} || $tokenfile || "./tokenfile.html";
$token = $FORM{'$token'} || $token || "<!-- TOKEN -->";
	
	print qq~
	<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$javasource" target="_blank">?</a> 2.</td><td>Please verify the URL to the htmlbuttons.js file</td><td><input type="text" name="\$javasource" value="$javasource"></td></tr>
	</table>
	</td></tr>
	<tr><td><b>Page generator layout</b></td></tr>
	<tr><td>By default the page generator question form is a white page with text. If you want to get the page generator question form to match the layout of your site, especially when you are going to run a server, you can set the following options. Please see the manual for an extensive explanation.</td></tr>
<tr><td bgcolor="$color">
<table>
<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$usetoken" target="_blank">?</a> 3.</td><td>Do you want to use a tokenfile?</td><td><select name="\$usetoken"><option value="0">NO<option value="1"$selected>YES</select></td></tr>
<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$tokenfile" target="_blank">?</a> 4.</td><td>Please enter the path to the tokenfile:</td><td><input type="text" name="\$tokenfile" value="$tokenfile"></td></tr>
<tr><td><a href="$ENV{'SCRIPT_NAME'}?a=help\#\$token" target="_blank">?</a> 5.</td><td>Please enter the token (the line which the script will replace with it's output)</td><td><input type="text" name="\$token" value="$token"></td></tr>
</table>
	</td></tr>
	<tr><td align="center"><input type="submit"></td></tr>
	</table>
	</form>
	</body>
	</html>
	~;
	exit;
}

sub pgennow {
	
	push @pgenfile, "\#\!$perl\n\n";
	
	push @pgenfile, "\$servicename = \"$servicename\"\;\n";
	push @pgenfile, "\$servicelocation = \"$servicelocation\"\;\n";
	
	if (!$FORM{'$pgen_location'}) { &pgen("Please enter the URL to the page generator"); }
	push @pgenfile, "\$pgen_location = \"$FORM{'$pgen_location'}\"\;\n";
	
	push @pgenfile, "\$mtvwebdesignlib = \"$mtvwebdesignlib\"\;\n";
	
	if (!$FORM{'$javasource'}) { &pgen("Please enter the URL to the htmlbuttons.js file"); }
	push @pgenfile, "\$javasource = \"$FORM{'$javasource'}\"\;\n";
	
	push @pgenfile, "\$script_location = \"$script_location\"\;\n";
	
	push @pgenfile, "\$webmasteremail = \'$webmasteremail\'\;\n";
	
	push @pgenfile, "\$example_carddesk = \"$example_carddesk\"\;\n";
	
	push @pgenfile, "\$image_locations = \"$image_locations\"\;\n";

	if ($sendpics_plugin && $allow_sending_html_cards) {
		$allow_sending_html_cards = "1";
	}
	else {
		$allow_sending_html_cards = "0";
	}
	
	push @pgenfile, "\$allow_sending_html_cards = \"$allow_sending_html_cards\"\;\n";
	
	if ($tosend_plugin && $allow_specific_date) {
		$allow_specific_date = "1";
	}
	else {
		$allow_specific_date = "0";
	}
	
	push @pgenfile, "\$allow_specific_date = \"$allow_specific_date\"\;\n";
	push @pgenfile, "\$num_days_adv = \"$num_days_adv\"\;\n";
	
	if ($filestore_plugin && $allow_image_storage) {
		$allow_image_storage = "1";
	}
	else {
		$allow_image_storage = "0";
	}
	
	push @pgenfile, "\$allow_image_storage = \"$allow_image_storage\"\;\n\n";
	
	while (($key,$value) = each %languages) {
		$string .= "\"$key\" \=\> \"$value\"\,\n"
	}
	
	push @pgenfile, "\%languages \= \(\n$string\)\;\n\n";
	
	#%layouts = (
	#"0","Standard_layout||std_image",
	#);

	push @pgenfile, "\$usetoken = \"$FORM{'$usetoken'}\"\;\n";
	push @pgenfile, "\$tokenfile = \"$FORM{'$tokenfile'}\"\;\n";
	push @pgenfile, "\$token = \"$FORM{'$token'}\"\;\n";

	
	open(PGEN, ">./pgen$cgiext") or die "Cannot create pgen$cgiext: $!";
	print PGEN @pgenfile;
	
	print PGEN "\n\n";
	
	print PGEN qq~
	# Now run the script:
	if (!\$no_eng_req) {
		require "./pgen_eng.lib";
	}
	else {
		return 1;
	}
	~;
	
	close(PGEN);
	chmod(0755, "./pgen$cgiext");
	
	&mainpage("Page generator installed!");
}

sub search {
	require $dbunder;
	# cardsticketnumbertimefilenamesoundrecipientemailsendersenderemailstatuspage_urltext
	
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>Search cards</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<form action="$ENV{'SCRIPT_NAME'}" method="post">
	<input type="hidden" name="action" value="search">
	<input type="hidden" name="id" value="$id">
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
	<tr>
	<td colspan="3" align="center"><b><font size="+1">Search</font></b><br><a href="$ENV{'SCRIPT_NAME'}?id=$id">Back to mainpage</a></a>
	</td>
	</tr>
	<tr><td bgcolor="$color" align="center">
	<table>
	<tr><td align="center">Search for <input type="text" name="query" value="$FORM{'query'}"> in <select name="cat">
	~;
	
	%cats = (
		"ticketnumber" => "Ticketnumber",
		"filename" => "Filename",
		"sound" => "Sound file",
		"recipient" => "Recipient name",
		"email" => "Recipient email",
		"sender" => "Sender name",
		"senderemail" => "Sender email",
		"page_url" => "Page URL",
		"text" => "Text",
	);
	
	foreach $c (sort {$cats{$a} cmp $cats{$b}} %cats) {
		if ($cats{$c}) {
			undef $selected;
			if ($FORM{'cat'} eq $c) { $selected = " selected"; }
			print "<option value=\"$c\"$selected>$cats{$c}\n";
		}
	}
	
	print qq~
	</select> <input type="submit" value="Go!"></td></tr>
	~;
	
	if ($FORM{'query'}) {
		print qq~<tr><td><b>Results</b></td></tr>~;
		
		&opendb;
		@data = &SelectFromTable_("cards","AND","ticketnumber,time,filename,sound,recipient,email,sender,senderemail,status,page_url,text","$FORM{'cat'}|~i|$FORM{'query'}");
		&closedb;
		
		print qq~<tr><td><table cellspacing="0" border="1" cellpadding="4">~;
		shift @data;
		
		foreach $card (@data) {
			print qq~<tr><Td>~;
			
			($ticketnumber,$time,$filename,$sound,$recipient,$email,$sender,$senderemail,$status,$page_url,$text) = split(/\/,$card);
			
			if ($status) { $status = "Already picked up!"; }
			else { $status = "Still needs to be picked up."; }
			
			print qq~
			<b>Ticketnumber</b>: <a href="$script_location?pa=receive&ticket=$ticketnumber.web">$ticketnumber</a><br>
			<b>Sent from</b>: <a href="$page_url">$page_url</a><br>
			<b>Recipient</b>: $recipient (<a href="mailto:$email">$email</a>)<br>
			<b>Sender</b>: $sender (<a href="mailto:$senderemail">$senderemail</a>)<p>
			<b>Image</b>: <a href="$filename">$filename</a><br>
			<b>Sound</b>: <a href="$sound">$sound</a><br>
			<b>Status</b>: $status<br>
			<b>Text:</b><br>$text
			~;
			
			print qq~</td></tr>~;
		}
		
		print qq~</table></td></tr>~;
		
	}
	
	print qq~
	</table></td></tr>
	</table>
	</form>
	</body>
	</html>
	~;
	exit;
}

sub activedesks {
	require $dbunder;
	# emailtitleurllast_access_timenumber_of_postcardslast_card_datereset_dateimages
	
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>Active postcard desks</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<form action="$ENV{'SCRIPT_NAME'}" method="post">
	<input type="hidden" name="action" value="search">
	<input type="hidden" name="id" value="$id">
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
	<tr>
	<td colspan="3" align="center"><b><font size="+1">Active postcard desks</font></b><br><a href="$ENV{'SCRIPT_NAME'}?id=$id">Back to mainpage</a></a>
	</td>
	</tr>
	<tr><td bgcolor="$color" align="center">
	<table>
	~;
	
	&opendb;
	@data = &SelectFromTable_("urls","AND","email,title,url,last_access_time,number_of_postcards,last_card_date,reset_date");
	&closedb;
	shift @data;
	$num = scalar @data;
	print qq~<tr><td><b>Total of $num active desks</b></td></tr>~;
	
	print qq~<tr><td><table cellspacing="0" border="1" cellpadding="4">~;
	
	foreach $desk (@data) {
		print qq~<tr><td>~;
		
		($email,$title,$url,$last_access_time,$number_of_postcards,$last_card_date,$reset_date) = split(/\/,$desk);
		
		print qq~Name: $title<br>URL: <a href="$url">$url</a><br>Email of owner: <a href="mailto:$email">$email</a><br>
		<b>Number of posts since $reset_date</b>: $number_of_postcards<br><b>Last card sent at:</b> $last_card_date~;
		
		
		print qq~</td></tr>~;
	}
	
	print qq~</table></td></tr>~;
	
	print qq~
	</table></td></tr>
	</table>
	</form>
	</body>
	</html>
	~;
	exit;
}

sub opendb {
	&LockAndOpen_("","freEcards");
	&CreateDatabase_;
}

sub closedb {
	&UnlockAndCommit_;
}

sub tosend {
	require $dbunder;
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>Cards waiting to be send</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<form action="$ENV{'SCRIPT_NAME'}" method="post">
	<input type="hidden" name="action" value="search">
	<input type="hidden" name="id" value="$id">
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
	<tr>
	<td colspan="3" align="center"><b><font size="+1">Cards waiting to be send</font></b><br><a href="$ENV{'SCRIPT_NAME'}?id=$id">Back to mainpage</a></a>
	</td>
	</tr>
	<tr><td bgcolor="$color" align="center">
	<table>
	~;
	
	&opendb;
	@data = &SelectOrderByFromTable_("time_to_send","tosend","*");
	&closedb;
	shift @data;
	$num = scalar @data;
	print qq~<tr><td><b>Total of $num cards waiting</b></td></tr>~;
	
	print qq~<tr><td><table cellspacing="0" border="1" cellpadding="4">~;
	
	foreach $card (@data) {
		print qq~<tr><td>~;
		
		($time_to_send,$filename,$sound,$loop,$recipient,$email,$sender,$senderemail,$status,$sitetitle,$page_url,$pickupurl,$cardclick,$ashtml,$lng,$IP,$layout,$text) = split(/\/,$card);
		
		print qq~
		<b>Sent from</b>: <a href="$page_url">$page_url</a><br>
		<b>Recipient</b>: $recipient (<a href="mailto:$email">$email</a>)<br>
		<b>Sender</b>: $sender (<a href="mailto:$senderemail">$senderemail</a>)<br>
		<b>IP</b>: $IP<br>
		<b>Language</b>: $lng<p>
		<b>Image</b>: <a href="$filename">$filename</a><br>
		<b>Sound</b>: <a href="$sound">$sound</a><br>
		<b>Text:</b><br>$text
		~;
		
		print qq~</td></tr>~;
	}
	
	print qq~</table></td></tr>~;
	
	print qq~
	</table></td></tr>
	</table>
	</form>
	</body>
	</html>
	~;
	exit;
}

sub email {
	
	local($warn) = @_;
	print "Content-type: text/html\n\n";
	print qq~
	<html>
	<head><title>Email active users</title></head>
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	<form action="$ENV{'SCRIPT_NAME'}" method="post">
	<input type="hidden" name="action" value="emailnow">
	<input type="hidden" name="id" value="$id">
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
	<tr>
	<td align="center"><b><font size="+1">Email active users</font></b><br><a href="$ENV{'SCRIPT_NAME'}?id=$id">Back to mainpage</a>
	~;
	&warn($warn);
	print qq~
	</td>
	</tr>
	<tr><td bgcolor="$color"><table>
	
	<tr><td><b>Subject:</b></td><td><input type="text" name="subject" value="$FORM{'subject'}"></td></tr>
	<tr><td colspan="2"><b>Message:</b></td></tr>
	<tr><td colspan="2"><textarea name="body" cols="30" rows="10">$FORM{'body'}</textarea></td></tr>
	
	</table>
	</td></tr>
	<tr><td align="center">
	<input type="submit">
	</td></tr>
	</table>
	</form>
	</body>
	</html>
	~;
	exit;
	
}

sub emailnow {
	if (!$FORM{'subject'}) {&email("Please enter a subject"); }
	if (!$FORM{'body'}) {&email("Please enter a message"); }
	
	require $dbunder;
	
	&opendb;
	@data = &SelectFromTable_("urls","*");
	&closedb;
	
	foreach $user (@data) {
		($email,$title,$url,$last_access_time,$number_of_postcards,$last_card_date,$reset_date,$images) = split(/\/,$user);
		$lcemail = lc $email;
		$toemail{$lcemail} = "$email\$url\$title";
	}
	
	foreach $user (sort keys %toemail) {
		($email,$url,$title) = split(/\/,$toemail{$user});
		
		open(MAIL, "$mailprog") or die "Cannot open $mailprog: $!";
		print MAIL "To: $email\n";
		print MAIL "From: $webmasteremail ($servicename)\n";
		print MAIL "X-Mailer: freEcards admin form\n";
		print MAIL "Subject: $FORM{'subject'}\n\n";
		print MAIL $FORM{'message'};
		print MAIL "\n\n";
		print MAIL "-" x 70 . "\n";
		print MAIL "You are receiving this message because you own a postcard desk located at $url, named $title. This is a service mailing and you cannot unsubscribe from a service mailing.\nWhen you stop using your postcard desk, you won't receive any more mailings.";
		close(MAIL);
		
	}
	
	&mainpage("Emails sent");
	
}

sub help {
	print "Content-type: text/html\n\n";
	print qq~
	<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
	
	<html>
	<head>
	<title>Instllation help for freEcards</title>
	</head>
	
	<body>
	<basefont size="3" face="Arial,Helvetica,sans-serif">
	
	<a name="\$webmasterusername"></a>
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
	<tr><td><b><font size="+1">Webmasterusername</font></b>
	<br><font size="-1">Normal Setup, question 1<br>
	Also see manual at <b>\$webmasterusername</b>
	</font></td></tr>
	<tr><td bgcolor="$color">
	The webmasterusername is just like any other username. After the first setup run, you'll always need this username to login to the admin script. The username is also used in the protection of the database directory.
	</td></tr>
	</table><p>
	
	<a name="\$webmasterpass"></a>
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
	<tr><td><b><font size="+1">Webmasterpassword</font></b>
	<br><font size="-1">Normal Setup, question 2<br>
	Also see manual at <b>\$webmasterpass</b>
	</font></td></tr>
	<tr><td bgcolor="$color">
	This is the password you'll need to access the admin script, together with your username. This password is also used in protecting the database directory.<p><b>Why can I see my password?</b><br>This is because normally you would be the only one who can enter the page, and the only one who know the password. Because of limitations in the PASSWORD input tag (HTML) we decided to do it this way, which makes it easier for you to setup the script.
	</td></tr>
	</table><p>
	
	<a name="\$webmasteremail"></a>
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
	<tr><td><b><font size="+1">Webmasteremail</font></b>
	<br><font size="-1">Normal Setup, question 3<br>
	Also see manual at <b>\$webmasteremail</b>
	</font></td></tr>
	<tr><td bgcolor="$color">
	This is your email address. It's used when sending emails to all the active users, and when new users join the service.
	</td></tr>
	</table><p>
	
	<a name="\$servicename"></a>
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
	<tr><td><b><font size="+1">Servicename</font></b>
	<br><font size="-1">Normal Setup, question 4<br>
	Also see manual at <b>\$servicename</b>
	</font></td></tr>
	<tr><td bgcolor="$color">
	This is the name of your service. I our case it's freEcards. The servicename is used in several things. For example: the email people get when they can pickup a postcard, etc.
	</td></tr>
	</table><p>
	
	<a name="\$servicelocation"></a>
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
	<tr><td><b><font size="+1">Servicelocation</font></b>
	<br><font size="-1">Normal Setup, question 5<br>
	Also see manual at <b>\$servicelocation</b>
	</font></td></tr>
	<tr><td bgcolor="$color">
	This is the URL to the page where people can find information about how to setup their own postcard desk. If you are not going to run the script as a service, this option is not really important. But still, we advice you to just make it point to your homepage.
	</td></tr>
	</table><p>
	
	<a name="\$perl"></a>
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
	<tr><td><b><font size="+1">Location of Perl</font></b>
	<br><font size="-1">Normal Setup, question 6<br>
	Also see manual at <b>\$perl</b>
	</font></td></tr>
	<tr><td bgcolor="$color">
	This is the path to the location where perl is located on your server. Hard? Well, the point is that if you can run the admin script, you already know the location of perl, since you probably neede to change the first line in admin.cgi: #!/usr/local/bin/perl<br>The setup program tries to determine the location itself, if this fails, you need to enter it yourself.
	</td></tr>
	</table><p>
	
	<a name="\$mailprog"></a>
	<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
	<tr><td><b><font size="+1">Location of Mail program</font></b>
	<br><font size="-1">Normal Setup, question 7<br>
	Also see manual at <b>\$mailprog</b>
	</font></td></tr>
	<tr><td bgcolor="$color">
	This is the path to the location where your mailprogram is on your server. Normally SendMail is the mail program (please, don't enter Eudora or MS Outlook Express as your mail program. We mean a command line mail program here.)<br>The setup program automatically places the pipe ( | ) and the -t flag in the mailprogram line, so you don't need to include that. It's just the pure path to your mail program.<br>This script tries to determine the location to sendmail itself. If the location of sendmail is not correct, or if your server is not using sendmail, please change this variable.
		</td></tr>
		</table><p>
		
		<a name="\$cgiext"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">CGI Extention</font></b>
		<br><font size="-1">Normal Setup, question 8<br>
		Also see manual at <b>\$cgiext</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the extention of the freecards file which is generated by the script. Normally servers allow you to run cgi script with a .cgi extention, but on some server you need to change it to .pl. If you are running your admin script with a .cgi extention, you can select .CGI.
		</td></tr>
		</table><p>
		
		<a name="\$script_location"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Script Location</font></b>
		<br><font size="-1">Normal Setup, question 9<br>
		Also see manual at <b>\$script_location</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the URL to the freecards script which is going to be generated by the setup program in the same directory as the admin script. Therefor the setup program tried to make the URL to the script automatically. Please check is this is correct.
		</td></tr>
		</table><p>
		
		<a name="\$example_carddesk"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Example carddesk</font></b>
		<br><font size="-1">Normal Setup, question 10<br>
		Also see manual at <b>\$example_carddesk</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the URL to a page where people can see an example card desk. This is only needed when you are running the script as a service for everybody. The URL you provide here is used in the welcome email.
		</td></tr>
		</table><p>
		
		<a name="\$std_lng"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Default Language</font></b>
		<br><font size="-1">Normal Setup, question 11<br>
		Also see manual at <b>\$std_lng</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the standard (default) language the script should use. Please select the language you like. If you select a language different than English, than please note that you do need to upload the language pack of that language to the language pack directory. You'll also get a list of files you still need to upload after the first setup run.
		</td></tr>
		</table><p>
		
		<a name="\$max_recipients"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Maximum number of recipients</font></b>
		<br><font size="-1">Normal Setup, question 12<br>
		Also see manual at <b>\$max_recipients</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		The user of your script (the one who is sending the card) has the option to enter more than one emailaddress where he/she wants to send the card to. You can limit the number of email address the user can provide here.
		</td></tr>
		</table><p>
		
		<a name="\$elapsed_days"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Elapsed days</font></b>
		<br><font size="-1">Normal Setup, question 13<br>
		Also see manual at <b>\$elapsed_days</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the number of days a card stays in the database when it has not been picked up yet. When a card is send, the card is tagged with the current time. Every time someone picks up a card, that script purges old card. If a card has not been picked up, it'll be stored for the number of days you provide here.
		</td></tr>
		</table><p>
		
		<a name="\$elapsed_days_two"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Elapsed days for viewed cards</font></b>
		<br><font size="-1">Normal Setup, question 14<br>
		Also see manual at <b>\$elapsed_days_two</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This works the same as \$elapsed_days, the only thing is that when a card is viewed, it's again tagged that it has been viewed and it get's a new time. Now, normally a person who saw their card never comes back to see it again. Therefor we have this option to get rid of cards earlier and keeping the database clean. If people do want to see their card again, they can do so in the the number of days you provide here.
		</td></tr>
		</table><p>
		
		<a name="\$elapsed_days_urls"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Elapsed days for active desks</font></b>
		<br><font size="-1">Normal Setup, question 15<br>
		Also see manual at <b>\$elapsed_days_url</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the number of days a postcard desks stays active in the URLs database. If it hasn't been active (no card was sent) in the number of days you provide here, it's deleted from the active postcard desk database, keeping that database clean and so trying to limit the <b>400 Lost File</b> errors when people use the Random Desk function.
		</td></tr>
		</table><p>
		
		<a name="\$send_old_cards"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Send old cards?</font></b>
		<br><font size="-1">Normal Setup, question 16<br>
		Also see manual at <b>\$send_old_cards</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		If set this option to YES, than card that have not been picked up after the number of days you provided in question 13, is send to the user by email.
		</td></tr>
		</table><p>
		
		<a name="\$send_welcome_email"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Send welcome email?</font></b>
		<br><font size="-1">Normal Setup, question 17<br>
		Also see manual at <b>\$send_welcome_email</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		If set this option to YES, than each new user is send a welcome email. A new user is someone who owns a postcard desk which is using your script. This is a very nice option if you run the script as a service.
		</td></tr>
		</table><p>
		
		<a name="\$add_footer"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Add footer?</font></b>
		<br><font size="-1">Normal Setup, question 18<br>
		Also see manual at <b>\$add_footer</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		If set this option to YES, than a footer is added to each outgoing email. The footer is something like:<br>
		<b>This email is powered by freEcards<br>
		Please go to http://mtvwebdesign.hypermart.net to see how to get your own postcard desk on your site for free</b><p>
		Due to the fact the footer is using the laguage packs, you cannot change the footer unless you change the mail variables in the language packs.
		</td></tr>
		</table><p>
		
		<a name="\$bgcolor"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Backgroun Color</font></b>
		<br><font size="-1">Normal Setup, question 19<br>
		Also see manual at <b>\$bgcolor</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the standard background color (HTML Code) of generated pages (preview page, receive page etc.). Although people using your server can set their own colors, some people might not do so.
		</td></tr>
		</table><p>
		
		<a name="\$background"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Background Image</font></b>
		<br><font size="-1">Normal Setup, question 20<br>
		Also see manual at <b>\$background</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		You can set the URL to the background image you want to use on generated pages.
		</td></tr>
		</table><p>
		
		<a name="\$link_color"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Link color</font></b>
		<br><font size="-1">Normal Setup, question 21<br>
		Also see manual at <b>\$link_color</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the HTML code for the color links (anchors) get on generated pages.
		</td></tr>
		</table><p>
		
		<a name="\$vlink_color"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Visited Link color</font></b>
		<br><font size="-1">Normal Setup, question 22<br>
		Also see manual at <b>\$vlink_color</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the HTML code for the color visited links (anchors) get on generated pages.
		</td></tr>
		</table><p>
		
		<a name="\$alink_color"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Active Link color</font></b>
		<br><font size="-1">Normal Setup, question 23<br>
		Also see manual at <b>\$alink_color</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the HTML code for the color active links (anchors) get on generated pages.
		</td></tr>
		</table><p>
		
		<a name="\$text_color"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Text color</font></b>
		<br><font size="-1">Normal Setup, question 24<br>
		Also see manual at <b>\$text_color</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the HTML code for the color text gets on generated pages.
		</td></tr>
		</table><p>
		
		<a name="\$postcard_bgcolor"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Postcard Background color</font></b>
		<br><font size="-1">Normal Setup, question 25<br>
		Also see manual at <b>\$postcard_bgcolor</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the HTML code for the background color at the back of the card on generated pages. With the back of the card we point to the standard layout used by the script. It shows a picture, than an option to click a link to see the back of the card.
		</td></tr>
		</table><p>
		
		<a name="\$postcard_text_color"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Postcard Text color</font></b>
		<br><font size="-1">Normal Setup, question 26<br>
		Also see manual at <b>\$postcard_text_color</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the HTML code for the color text gets at the back of the card on generated pages. With the back of the card we point to the standard layout used by the script. It shows a picture, than an option to click a link to see the back of the card.
		</td></tr>
		</table><p>
		
		<a name="\$image_locations"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Image Locations</font></b>
		<br><font size="-1">Advanced Setup, question 1<br>
		Also see manual at <b>\$image_locations</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the URL to the directoy where the images are stored. The setup script tried to determine the URL itself. Please verify if the URL is correct.
		</td></tr>
		</table><p>
		
		<a name="\$stamp_image"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Stamp image</font></b>
		<br><font size="-1">Advanced Setup, question 2<br>
		Also see manual at <b>\$stamp_image</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the name of the file which is used as the stamp in the internal layout of the script. This file has to be located in the directory specified at \$image_locations.
		</td></tr>
		</table><p>
		
		<a name="\$logo_image"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Logo image</font></b>
		<br><font size="-1">Advanced Setup, question 3<br>
		Also see manual at <b>\$logo_image</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the name of the file which is used as the logo (in the middle on the backside of a card) in the internal layout of the script. This file has to be located in the directory specified at \$image_locations.
		</td></tr>
		</table><p>
		
		<a name="\$line_image"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Line image</font></b>
		<br><font size="-1">Advanced Setup, question 4<br>
		Also see manual at <b>\$line_image</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the name of the file which is used as the line in the internal layout of the script. This file has to be located in the directory specified at \$image_locations. This file is actually just a black pixel which is automatically streched by the script, so it becomes a line. It's also used in the statistics page.
		</td></tr>
		</table><p>
		
		<a name="\$noimg_image"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">"Noimage" image</font></b>
		<br><font size="-1">Advanced Setup, question 5<br>
		Also see manual at <b>\$noimg_image</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the name of the file which is used as the error image when the script cannot fetch a file from a server, or when there was an image given but no BASE_URL set in the postcard desk. This file has to be located in the directory specified at \$image_locations.
		</td></tr>
		</table><p>
		
		<a name="\$pixel"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Pixel image</font></b>
		<br><font size="-1">Advanced Setup, question 6<br>
		Also see manual at <b>\$pixel_image</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the name of the file which is used to show the diagrams in the statistics pages. It's simular to \$line_image, with the only difference that it's a different color. This file has to be located in the directory specified at \$image_locations.
		</td></tr>
		</table><p>
		
		<a name="\$mtvwebdesignlib"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Path to mtvwebdesign.lib</font></b>
		<br><font size="-1">Advanced Setup, question 7<br>
		Also see manual at <b>\$mtvwebdesignlib</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		The is the PATH (not the URL) to the mtvwebdesign.lib file. If the file is in the same directory as the freecards script, you can make this point to "./mtvwebdesign.lib". Else, make sure to enter the correct path. Change this at your own risk.
		</td></tr>
		</table><p>
		
		<a name="\$dbdir"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Database directory</font></b>
		<br><font size="-1">Advanced Setup, question 8<br>
		Also see manual at <b>\$dbdir</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		The is the PATH (not the URL) to the directory where the script will store the databases. The directory is automatically created by the setup program. If the directory is a subdirectory of the directory where the freecards script is located, you can make this point to "./databases". Else, make sure to enter the correct path. Change this at your own risk. If you change this after several month of using the script, you need to move all the files in the old database directory to the new database directory to maintain sent cards.
		</td></tr>
		</table><p>
		
		<a name="\$dbunder"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Path to dbunder.lib</font></b>
		<br><font size="-1">Advanced Setup, question 9<br>
		Also see manual at <b>\$dbunder</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		The is the PATH (not the URL) to the dbunder.lib file. If the file is in the same directory as the freecards script, you can make this point to "./dbunder.lib". Else, make sure to enter the correct path. Change this at your own risk.
		</td></tr>
		</table><p>
		
		<a name="\$languagepack_dir"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Languagepack directory</font></b>
		<br><font size="-1">Advanced Setup, question 10<br>
		Also see manual at <b>\$languagepack_dir</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		The is the PATH (not the URL) to the directory where the languagepacks are stored. The directory is automatically created by the setup program. If the directory is a subdirectory of the directory where the freecards script is located, you can make this point to "./languagepacks". Else, make sure to enter the correct path. Change this at your own risk.
		</td></tr>
		</table><p>
		
		<a name="\$terms_dir"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Terms directory</font></b>
		<br><font size="-1">Advanced Setup, question 11<br>
		Also see manual at <b>\$terms_dir</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		The is the PATH (not the URL) to the directory where the terms (privacy.txt and terms.txt) are stored. The directory is automatically created by the setup program. If the directory is a subdirectory of the directory where the freecards script is located, you can make this point to "./terms". Else, make sure to enter the correct path. Change this at your own risk.
		</td></tr>
		</table><p>
		
		<a name="\$maintenance_file"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Path to maintenace file</font></b>
		<br><font size="-1">Advanced Setup, question 12<br>
		Also see manual at <b>\$maintenance_file</b> and webmaster options.
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the path (not the URL) to the maintenace file. By default this is a location in the same directory as the freecards script is located, "./stop.txt". Every time the script is run, the script will check for the file, and if it exists it'll stop further processing and print the contents of the maintenace file to the browser. This might come in handy when you update the script.
		</td></tr>
		</table><p>
		
		<a name="\$plugin_dir"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Plugins directory</font></b>
		<br><font size="-1">Advanced Setup, question 13<br>
		Also see manual at <b>\$plugin_dir</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		The is the PATH (not the URL) to the directory where the plugins can be found. By default this is a subdirectory called "plugins" of the directory where the script can be found. We advice you not to change this. If you do, make sure to enter a correct path, and run the plugin installation again.
		</td></tr>
		</table><p>
		
		<a name="\$web_email"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Webmaster email address(es)</font></b>
		<br><font size="-1">Advanced Setup, question 14<br>
		Also see manual at <b>\$web_email</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		These are the email addresses (seperated by a comma) which will have a webmaster effect on the script. This means that you immediately see the ticketnumber of the card you've sent in the browser, which saves time.
		</td></tr>
		</table><p>
		
		<a name="\$pgen_location"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">URL to page generator</font></b>
		<br><font size="-1">Advanced Setup, question 15<br>
		Also see manual at <b>\$pgen_location</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the URL to the pgen.cgi (or .pl) file which is created when you install the page generator from the admin mainpage. By default the file is located in the same directory as the freecards script, and the setup program tried to set the URL automatically. Please verify if this is the correct URL.
		</td></tr>
		</table><p>
		
		<a name="\$getpic_script"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Fetch images</font></b>
		<br><font size="-1">Advanced Setup, question 16<br>
		Also see manual at <b>\$getpic_script</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		When you run the script as a service, you might notice that some cards will not be displayed because the server they are on doesn't allow that, like XOOM for example. The getpic script will act as a browser and this way it can get the image from the server. You'll need the LWP module installed, which is normally not a problem. If you don't run the script as a service, you can leave the option blank, else you need to enter (or simply verify) the URL to the getpic.cgi (or .pl) file which is in the same directory as the freecards script.
		</td></tr>
		</table><p>
		
		<a name="\$referers"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Referers</font></b>
		<br><font size="-1">Advanced Setup, question 17<br>
		Also see manual at <b>\$referers</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		This option is only available to you when you decide not to run the script as a service. With this option you can allow only certain server to use your script. For example, if you have the script running on www.domain1.com, and you have a postcard desk on www.domain2.com and www.domain3.com and you don't want somebody on www.domainX.com to be able to use your script, you set this option to: www.domain1.com,www.domain2.com,www.domain3.com
		</td></tr>
		</table><p>
		
		<a name="plugin_installation"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Where are my plugins?</font></b>
		<br><font size="-1">Plugin installation<br>
		Also see manual at <b>plugin installation</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		If you have a plugin, it's very easy to install that plugin. Simply upload the plugin (.pl file) to the plugin directory (as configured in the advanced setup), and run the plugin installation from the admin mainpage. The installation will automatically detect which plugins you have and makes them available for you to configure.
		</td></tr>
		</table><p>
		
		<a name="\$allow_image_storage"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Allow image storage?</font></b>
		<br><font size="-1">FileStore Plugin question 1<br>
		Also see manual at <b>\$allow_image_storage</b> (FileStore Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		If you own the FileStore plugin you can still decide to disallow image storage on your server by setting this option to NO.
		</td></tr>
		</table><p>
		
		<a name="\$path_to_storage_dir"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Path to storage dir</font></b>
		<br><font size="-1">FileStore Plugin question 2<br>
		Also see manual at <b>\$path_to_storage_dir</b> (FileStore Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the path (not the URL) to the directory where the uploaded image will be stored. Please note that this needs to be a directory which is writable by the script. By default this is a directory called "stored_image" in the plugins directory. It might be that you are on a server which doesn't allow you to store images in a directory which is readable by a browser. This is where the getpic (configured in the advanced setup page) can help you out. It'll detect if a file is stored in the \$path_to_storage_dir and will print that file to the browser for you.
		</td></tr>
		</table><p>
		
		<a name="\$url_to_storage_dir"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">URL to storage dir</font></b>
		<br><font size="-1">FileStore Plugin question 3<br>
		Also see manual at <b>\$url_to_storage_dir</b> (FileStore plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the URL to the same directory as you configured in \$path_to_storage_dir.
		</td></tr>
		</table><p>
		
		<a name="\$max_file_size"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Maximum file size</font></b>
		<br><font size="-1">FileStore Plugin question 4<br>
		Also see manual at <b>\$max_file_size</b> (FileStore Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the maximum ammount of data you allow to be send to the script for processing the image. Please note that if you want to allow image of 70Kb, you'll need to enter: 70000. Also note that if you set this option to 70000 that this is not the exact size of the image. It's just the size of the total ammount of data you allow the script to receive, which means that if a user uploads a file, and enters a message of almost 60Kb, he/she only has 10Kb left for the image!
		</td></tr>
		</table><p>
		
		<a name="using_layouts"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Using Layouts</font></b>
		<br><font size="-1">Layout Plugin general question<br>
		Also see manual at <b>using layouts</b> (Layout Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		Using the layout plugin is actually quite easy. Simply create a preview page and a receive page you like to use. Than make sure to enter the following variables somewhere:
		<ul>
		<li><b>\%\%\%HEAD\%\%\%</b> - This will print either "This is what the card will look like" (preview), or "Your postcard" (recieve), also in different languages.
		<li><b>\%\%\%BODYTAG\%\%\%</b> - This will print the body tag (and the colors specified in the postcard desk)
		<li><b>\%\%\%TERMS\%\%\%</b> - This will print a link to the Terms file.
		<li><b>\%\%\%PRIVACY\%\%\%</b> - This will print a link the Privacy file.
		<li><b>\%\%\%BROWSERS\%\%\%</b> - This will print a link to the section which explains which browser can be used
		<li><b>\%\%\%RANDOM\%\%\%</b> - This will print a link to a random postcard desk
		<li><b>\%\%\%IMAGE\%\%\%</b> - This will either print the IMG tag, or html tags for Flash files.
		<li><b>\%\%\%SOUND\%\%\%</b> - This will print the tags needed for the sound file.
		<li><b>\%\%\%TURNIMAGE\%\%\%</b> - This will print the line: Click here to see the back of the card.
		<li><b>\%\%\%BACKBUTTON\%\%\%</b> - This will print a backbutton.
		<li><b>\%\%\%MAILBUTTON\%\%\%</b> - This will print a "Mail Card" button, need in the preview page.
		<li><b>\%\%\%POSTCARD_TEXT\%\%\%</b> - This will print the postcard text.
		<li><b>\%\%\%TO\%\%\%</b> - This will print "To:" in the language needed.
		<li><b>\%\%\%RECIPIENT_NAME\%\%\%</b> - This will print the name of the recipient.
		<li><b>\%\%\%RECIPIENT_EMAIL\%\%\%</b> - This will print the email address of the recipient.
		<li><b>\%\%\%SENDER_NAME\%\%\%</b> - This will print the name of the sender.
		<li><b>\%\%\%SENDER_EMAIL\%\%\%</b> - This will print the email address of the sender.
		<li><b>\%\%\%SIGN_OUT_TEXT\%\%\%</b> - This will print the sign-out-text: Click here to return to the postcard desk to send....
		<li><b>\%\%\%POSTCARD_TEXT_COLOR\%\%\%</b> - This will print the postcard_text_color in HTML values
		<li><b>\%\%\%POSTCARD_BGCOLOR\%\%\%</b> - This will print the postcard background color in HTML values.
		<li><b>\%\%\%PAGE_URL\%\%\%</b> - This will print the URL to the page the card was sent from.
		<li><b>\%\%\%SITETITLE\%\%\%</b> - This will print the title of the site the name was sent from.
		</ul>
		A small example: If you want to create a link back to the site the card was sent from, you can use:<pre>\&lt\;a href="\%\%\%PAGE_URL\%\%\%"\&gt\;\%\%\%SITETITLE\%\%\%\&lt\;/a\&gt\;</pre>
		Now, when you have the layouts ready for use, rename the preview layout to: NAME_preview.html, and the receive layout to: NAME_receive.hmtml (<b>Extention needs to be HTML. HTM will not work)</b>. Than upload the layout to the layout directory which you normally find in the plugins directory. You can than use the layout by setting<pre>\&lt\;input type="hidden" name="layout" value="NAME"\&gt\;</pre>in your postcard desk.<p>
		One last thing: If you use images in your layout, please make the IMG tags point to the FULL URL of the image to get the best results. Also, if you own the SendPics plugin too, you might want to store all you layout image in the directory you specified under \$image_locations (Advanced setup question 1).
		</td></tr>
		</table><p>
		
		<a name="\$path_to_layouts_dir"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Path to layouts dir</font></b>
		<br><font size="-1">Layout Plugin question 1<br>
		Also see manual at <b>\$path_to_layouts_dir</b> (Layout Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the path (not the URL) to the directory where the layouts are stored. By default this is a subdirectory of the plugins directory called "layouts".
		</td></tr>
		</table><p>
		
		<a name="\$std_layout"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Default layout</font></b>
		<br><font size="-1">Layout Plugin question 2<br>
		Also see manual at <b>\$std_layout</b> (Layout Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This can be the NAME of the default layout you which to use. (NAME_preview.html, NAME_receive.html). If you leave this blank, the internal layout is used.
		</td></tr>
		</table><p>
		
		<a name="\$path_to_image_dir"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Path to image dir</font></b>
		<br><font size="-1">SendPics Plugin question 1<br>
		Also see manual at <b>\$path_to_image_dir</b> (SendPics Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This is the path to the directory you specified in the advanced setup under \$image_locations (Advanced setup, question 1).
		</td></tr>
		</table><p>
		
		<a name="\$allow_sending_html_cards"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Allow people to send HTML cards?</font></b>
		<br><font size="-1">SendPics Plugin question 2<br>
		Also see manual at <b>\$allow_sending_html_cards</b> (SendPics Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		Even if you own the SendPics Plugin you can disable the plugin by setting this option to NO.
		</td></tr>
		</table><p>
		
		<a name="\$all_as_html"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">All cards as HTML?</font></b>
		<br><font size="-1">SendPics Plugin question 3<br>
		Also see manual at <b>\$all_as_html</b> (SendPics Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This specifies if you want all the cards to be send as HTML emails. Normally you don't want this because of server load.
		</td></tr>
		</table><p>
		
		<a name="\$send_old_cards_as_html"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Send old cards as HTML</font></b>
		<br><font size="-1">SendPics Plugin question 4<br>
		Also see manual at <b>send_old_cards_as_html</b> (SendPics Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		If you have set the \$send_old_cards (Normal setup, question 16) option, you migth like this option: instead of sending just the text of the card and the link to the image, it'll send the complete page to the person.
		</td></tr>
		</table><p>
		
		<a name="\$allow_specific_date"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Allow specific date?</font></b>
		<br><font size="-1">ToSend Plugin, question 1<br>
		Also see manual at <b>\$allow_specific_date</b> (ToSend Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		Even if you own the ToSend plugin you might want to disable the plugin. You can do so by setting this option to NO.
		</td></tr>
		</table><p>
		
		<a name="\$num_days_adv"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Number of days in advance</font></b>
		<br><font size="-1">ToSend Plugin, question 2<br>
		Also see manual at <b>\$num_days_adv</b> (ToSend Plugin)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This option allows you to set the maximum number of days a person is allowed to send a card in advance. This way you'll keep your database clean, and also you won't have risk of people sending cards over 10 years or something.
		</td></tr>
		</table><p>
		
		<a name="\$pgen_locationb"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">URL to pgen.cgi (or .pl)</font></b>
		<br><font size="-1">Page Generator Installation, question 1<br>
		Also see manual at <b>\$pgen_location</b> (Page Generator Installation)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This should be the URL to the pgen.cgi (or .pl file). This file is located in the same directory as the freecards script. The installation program will try to determine the location itself, please veriy the URL.
		</td></tr>
		</table><p>
		
		<a name="\$javasource"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">URL to htmlbuttons.js</font></b>
		<br><font size="-1">Page Generator Installation, question 2<br>
		Also see manual at <b>\$javasource</b> (Page Generator Installation)
		</font></td></tr>
		<tr><td bgcolor="$color">
		This should be the URL to the htmlbuttons.js file. This file is located in the same directory as the freecards script. The installation program will try to determine the location itself, please veriy the URL.
		</td></tr>
		</table><p>

		<a name="\$usetoken"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Use a tokenfile?</font></b>
		<br><font size="-1">Page Generator Installation, question 3<br>
		Also see manual at <b>Matching site layout with page generator</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
		You can get the page generator to match the layout of your site by using a tokenfile. If you want to use a tokenfile, set this option to YES. Please see the manual for an example.
		</td></tr>
		</table><p>

		<a name="\$tokenfile"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Path to your tokenfile</font></b>
		<br><font size="-1">Page Generator Installation, question 3<br>
		Also see manual at <b>Matching site layout with page generator</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
This should be the path to the file which the page generator can use to give the page generator question form the look and feel of your site. Please see the manual for an example.
		</td></tr>
		</table><p>

		<a name="\$token"></a>
		<table border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color" width="60\%">
		<tr><td><b><font size="+1">Token</font></b>
		<br><font size="-1">Page Generator Installation, question 5<br>
		Also see manual at <b>Matching site layout with page generator</b>
		</font></td></tr>
		<tr><td bgcolor="$color">
This is the line the page generator searches for before it outputs it's contents. Advice: The line needs to be a HTML comment. Please see the manual for an example.
		</td></tr>
		</table><p>
		
		</body>
		</html>
		
		~;
	}

sub creategetpic {

open(GETPIC, ">./getpic$cgiext");

print GETPIC qq~\#\!$perl

	\$no_eng_req=1;
	require "./freecards$cgiext";
~;

print GETPIC q*
	
	$url = $ENV{'QUERY_STRING'};
	
	if ($url =~ /$url_to_storage_dir/i) {
		$url =~ s/$url_to_storage_dir/$path_to_storage_dir/igs;
		$ext = &GetPicGetExt($url);
		print "Content-type: image/$ext\n\n";
		open(IMG, "$url") or die "Cannot open $url: $!";
		while(<IMG>) {
			print $_;
		}
		close(IMG);
	}
	else {
		
		use LWP::Simple;
		
		binmode STDOUT;
		
		$content = get($url);
		
		if ($content) {
			$ext = &GetPicGetExt($url);
			print "Content-type: image/$ext\n\n";
			print $content;
		}
		else {
			if ($path_to_image_dir !~ /\/$/) { $path_to_image_dir .= "\/"; }
			
			$ext = &GetPicGetExt("$path_to_image_dir$noimg_image");
			print "Content-type: image/$ext\n\n";
			open(IMG, "$path_to_image_dir$noimg_image") or die "Cannot open $path_to_image_dir$noimg_image: $!";
			while (<IMG>) {
				print $_;
			}
			close(IMG);
		}
		
	}

sub GetPicGetExt {
	
	my ($file) = @_;
	
	my @parts = split(/\./,$file);
	my $ext = $parts[-1];
	
	$ext = lc $ext;
	
	if ($ext eq "jpg") { $ext = "jpeg"; }
	
	return $ext;
	
}
*;

close(GETPIC);

}

sub DirStructure {

print qq*
<table>
<tr><td><b>Script root/</b></td><td></td><td></td><td></td></tr>
<tr><td></td><td>admin.cgi<br>dbUnder.lib<br><i>freecards.cgi</i><br>freecards_eng.lib<br><i>getpic.cgi</i><br>htmlbuttons.js<br>mtvwebdesign.lib<br><i>pgen.cgi</i><br>pgen_eng.lib</td><td></td><td></td></tr>
<tr><td></td><td valign="top"><b><i>databases/</i></b></td><td><i>database files</i></td><td></td></tr>
<tr><td></td><td valign="top"><b><i>images/</i></b></td><td>blackpix.gif<br>logo.gif<br>noimg.gif<br>pixel.gif<br>stamp.gif</td><td></td></tr>
<tr><td></td><td valign="top"><b><i>languagepacks/</i></b></td><td>de.lng<br>en.lng<br>etc.</td><td></td></tr>
<tr><td></td><td valign="top"><b><i>plugins/</i></b></td><td>filestore.pl<br>layout.pl<br>sendpics.pl<br>tosend.pl</td><td></td></tr>
<tr><td></td><td></td><td valign="top"><b><i>layouts/</i></b></td><td><u>NAME_preview.html</u><br><u>NAME_receive.html</u></td></tr>
<tr><td></td><td></td><td><b><i>stored_images/</i></b></td><td><i>uploaded image files</i></td></tr>
<tr><td></td><td valign="top"><b><i>terms/</i></b></td><td>privacy.txt<br>terms.txt</td><td></td></tr>
</table>
*;

}

sub viewstructure {

print qq*
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<html>
<head>
	<title>Default Directory Structure</title>
</head>

<body>
<basefont size="3" face="Arial,Helvetica,sans-serif">
<table width="60%" border="1" cellspacing="0" cellpadding="4" align="center" bordercolor="$color">
<tr><td align="center"><b><font size="+1">Directory Structure</font></b></td></tr>
<tr><td bgcolor="$color">Below is the default directory structure as set by the script after the first time installation:</td></tr>
<tr><td align="center" bgcolor="">

*;
&DirStructure;
print qq*
</td></tr>
<tr><td bgcolor="$color">The text in Bold are directories<br>
The text in Italic are files/directories which were automatically created by the setup program<br>
The underlined files don't exist yet, but you can create them yourself and upload them<p>
Please note that all the plugins are named here. It might be possible that you do not own all the plugins. If you do, you can upload the to the correct directory</td></tr>

<tr><td align="center"><a href="$ENV{'SCRIPT_NAME'}?id=$id">Back to Mainpage</a></td></tr>
</table>

</body>
</html>
*;

}