#include <sys/types.h>
#include <signal.h>

#include "udm_config.h"
#include "udm_log.h"
#include "udm_signals.h"


#ifdef HAVE_POSIX_SIGNALS
static RETSIGTYPE udm_sig_handler(int signo){
	fprintf(stderr, "\nReceived signal %d - exit!\n", signo);
	exit(1);
}

int UdmInitSigHandlers(UDM_ENV * Env){

    struct  sigaction sa;
    int ret=0;

    sa.sa_handler=udm_sig_handler;
    sa.sa_flags=0;
    sigemptyset(&sa.sa_mask);

    if ((ret=sigaction(SIGTERM, &sa, (struct sigaction *)NULL)))
	UdmLog_noagent(Env, UDM_LOG_WARN, "Can't set sighandler");

    if (ret+=sigaction(SIGINT, &sa, (struct sigaction *)NULL))
	UdmLog_noagent(Env, UDM_LOG_WARN, "Can't set sighandler");
    return(0);
}

#else /* We have no POSIX signals :( */

int UdmInitSigHandlers(UDM_ENV * Env){
    /* FIXME: implement other type of signal routines */
    return(0);
};

#endif /* HAVE_POSIX_SIGNALS */
