#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <ctype.h>

#include "udm_config.h"
#include "udmsearch.h"

/* FIXME Why so many includes here? */

#include "udm_socket.h"
#include "udm_http.h"
#include "udm_xmalloc.h"


#if (WIN32|WINNT)
#define TRIAL
#undef HAVE_PTHREAD
#define POWERED_LOGO "<BR><CENTER><a href=\"http://search.mnogo.ru/\"><IMG BORDER=0 SRC=\"http://search.mnogo.ru/img/mwin.gif\"></A>&nbsp<FONT SIZE=-1>Powered by <A HREF=\"http://search.mnogo.ru/\">mnoGoSearch</A></FONT></CENTER><BR>\n"
#define udm_mutex_t		CRITICAL_SECTION
#define InitMutex(x)		InitializeCriticalSection(x)
#define DestroyMutex(x)	DeleteCriticalSection(x)
#define UDM_MUTEX_LOCK(x)	EnterCriticalSection(x)
#define UDM_MUTEX_UNLOCK(x)	LeaveCriticalSection(x)
#else
#include <unistd.h>
#ifdef HAVE_PTHREAD
#include <pthread.h>
#define udm_mutex_t		pthread_mutex_t
#define InitMutex(x)		pthread_mutex_init(x,NULL)
#define DestroyMutex(x)	pthread_mutex_destroy(x)
#define UDM_MUTEX_LOCK(x)	pthread_mutex_lock(x)
#define UDM_MUTEX_UNLOCK(x)	pthread_mutex_unlock(x)
#else
#define udm_mutex_t		int
#define InitMutex(x)		*(x)=0
#define DestroyMutex(x)
#define UDM_MUTEX_LOCK(x)
#define UDM_MUTEX_UNLOCK(x)
#endif
#endif

#ifdef HAVE_PTHREAD
udm_mutex_t iurl_mut;
#endif


#define NO_TITLE	"No title"
#ifndef UNLIMITED_PS
#ifndef MAX_PS
#define MAX_PS		100
#endif
#endif
#define DEFAULT_PS	20

#define T_STEP		100
#define T_UNKNOWN	 0
#define T_TOP		 1
#define T_BOT		 2
#define T_RESTOP	 3
#define T_RESBOT	 4
#define T_RESULT	 5
#define T_ERROR		 6
#define T_NOTFOUND	 7
#define T_CLONE		 8
#define T_NAVIGATOR	 9
#define T_NAVLEFT	10
#define T_NAVBAR0	11
#define T_NAVBAR1	12
#define T_NAVRIGHT	13
#define T_INCLUDE	14
#define T_NAVLEFT_NOP	15
#define T_NAVRIGHT_NOP	16
#define T_NOQUERY	17
#define T_MAX		18

#define safe_strncpy(dst, src, size) { strncpy((dst), (src), (size)); (dst)[(size)-1] = '\0'; }


struct buf_s {
	char *buf;
	int buf_len;
}buf_out;

#define MAX_URL_INCLUDE	25
struct url_include_s {
	int status;
	int visible;
	int where;
	int ntempl;
#ifdef HAVE_PTHREAD
	pthread_t url_pth;
#endif
	char *buf;
	char *url;
	int offset;
}url_include[MAX_URL_INCLUDE];
static int cur_iurl=-1;

static int lastt[T_MAX] = {
	0,
	T_TOP*T_STEP,
	T_BOT*T_STEP,
	T_RESTOP*T_STEP,
	T_RESBOT*T_STEP,
	T_RESULT*T_STEP,
	T_ERROR*T_STEP,	
	T_NOTFOUND*T_STEP,
	T_CLONE*T_STEP,
	T_NAVIGATOR*T_STEP,
	T_NAVLEFT*T_STEP,
	T_NAVBAR0*T_STEP,
	T_NAVBAR1*T_STEP,
	T_NAVRIGHT*T_STEP,
	T_INCLUDE*T_STEP,
	T_NAVLEFT_NOP*T_STEP,
	T_NAVRIGHT_NOP*T_STEP,
	T_NOQUERY*T_STEP
};
#define TEMPL(x)	(((lastt[x]-x*T_STEP)>format)?x*T_STEP+format:lastt[x]-1)

typedef struct var_struct{
	char *name;
	char *value;
} TVAR;

typedef struct template_struct{
	int where;
	char *str;
} TEMPLATE;

typedef struct dict_struct {
	char lang[3];
	char * path;
} DICT;

static char Targ[UDMSTRSIZ*16]="";
static char *query_words=NULL;
static char ul_str[UDMSTRSIZ]="";
static int iurl_udm_recursion=0;


#define MAXTEMPLATE 1024
static TEMPLATE Template[MAXTEMPLATE];
static int ntemplates=0;

#define MAXVARIABLE	128
TVAR Variables[MAXVARIABLE];
int nVar=0;

#define MAXRANDOM 128
int Randoms[MAXRANDOM];

#define MAXDICT 128
DICT Dict[MAXDICT];
int dict_num=0;

unsigned int group_mask=0;
/* Template variables */
static char href[UDMSTRSIZ]="";
static char fullhref[UDMSTRSIZ]="";
static char *query_form_escaped=NULL;
static char *query_url_escaped=NULL;
static char self[UDMSTRSIZ]="";
static char LightWords[UDMSTRSIZ]="";

static char HLBeg[UDMSTRSIZ]="<b>";
static char HLEnd[UDMSTRSIZ]="</b>";

static int first=0,last=0,work_time=0;
static int num_pages=0, navpage=0, pps=10, is_next=0;
static int format=0, use_clones=1;
static char *mode=NULL;
static char *wmode=NULL;
static char *sort=NULL;
static char *wf=NULL;
static char ul_unescaped[UDMSTRSIZ]="";
static char * ttag=NULL;
static char * category=NULL;

/* time limit vars - needed in PrintOneTemplate */
char *dt_s=NULL, *dp_s=NULL;
char *dx_s=NULL, *dm_s=NULL;
char *dd_s=NULL, *dy_s=NULL;
char *db_s=NULL, *de_s=NULL;

void *get_remote_result(void * Agent);
int get_ind_by_url(char *url, int where, int ntempl);

static int AddVariable(const char *name,const char *value){
	if(nVar<MAXVARIABLE){
		Variables[nVar].name=strdup(name);
		Variables[nVar].value=strdup(value);
		nVar++;
		return(0);
	}
	return(1);
}


static char *hilightcpy(int LCharset, char *dst, char *src, char *w_list, char *start, char *stop) {
	char *t = dst, *s = src, *word = src;
	char real_word[64];

	if (*s) {
		do {
			if (!UdmWordChar(*s, LCharset)) {
				if (word < s) {
					char save = *s;
					*s = 0;
					udm_snprintf(real_word, sizeof(real_word)," %s ", word);
					UdmTolower(real_word,LCharset);
					if (strstr(w_list,real_word)) {
						sprintf(t, "%s%s%s",start, word, stop);
					}else{
						strcpy(t, word);
					}
					t += strlen(t);
					*t++ = *s++ = save;
					word = s;
				}else{
					*t++ = *s++;
					word++;
				}
			}else{
				s++;
			}
		} while (s[-1]);
	}
	*t = 0;
	return dst;
}




static int LoadTemplate(UDM_AGENT * Agent,char *name, char *query_text, int default_where){
FILE *file;
int where=0,variables=0;
char *s,*lasttok=NULL;
char str[BUFSIZ];
char first_letters[128]="";

	file=fopen(name,"r");
	if(!file)return(1);
	where=default_where;

	while((fgets(str,sizeof(str),file))&&(ntemplates<MAXTEMPLATE)){
		if(!UDM_STRNCMP(str,"<!--top-->"))	where=lastt[T_TOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--bottom-->"))	where=lastt[T_BOT]++;
		else
		if(!UDM_STRNCMP(str,"<!--restop-->"))	where=lastt[T_RESTOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--resbot-->"))	where=lastt[T_RESBOT]++;
		else
		if(!UDM_STRNCMP(str,"<!--res-->"))	where=lastt[T_RESULT]++;
		else
		if(!UDM_STRNCMP(str,"<!--notfound-->"))	where=lastt[T_NOTFOUND]++;
		else
		if(!UDM_STRNCMP(str,"<!--error-->"))	where=lastt[T_ERROR]++;
		else
		if(!UDM_STRNCMP(str,"<!--clone-->"))	where=lastt[T_CLONE]++;
		else
		if(!UDM_STRNCMP(str,"<!--navigator-->"))	where=lastt[T_NAVIGATOR]++;
		else
		if(!UDM_STRNCMP(str,"<!--navleft-->"))	where=lastt[T_NAVLEFT]++;
		else
		if(!UDM_STRNCMP(str,"<!--navbar1-->"))	where=lastt[T_NAVBAR1]++;
		else
		if(!UDM_STRNCMP(str,"<!--navbar0-->"))	where=lastt[T_NAVBAR0]++;
		else
		if(!UDM_STRNCMP(str,"<!--navright-->"))	where=lastt[T_NAVRIGHT]++;
		else
		if(!UDM_STRNCMP(str,"<!--navleft_nop-->"))	where=lastt[T_NAVLEFT_NOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--navright_nop-->"))	where=lastt[T_NAVRIGHT_NOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--noquery-->"))	where=lastt[T_NOQUERY]++;
		else
		if(!UDM_STRNCMP(str,"<!--/top-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/bottom-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/restop-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/resbot-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/res-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/notfound-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/error-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/clone-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--variables")){
			where=default_where;
			variables=1;
		}else
		if(!UDM_STRNCMP(str,"<!--/navigator-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navleft-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navbar1-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navbar0-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navright-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navleft_nop-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navright_nop-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/noquery-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"-->")){	
			if(variables){
				where=default_where;
				variables=0;
			}
		}else{
			Template[ntemplates].where=where;
			Template[ntemplates].str=strdup(str);
			ntemplates++;
#ifdef HAVE_PTHREAD				    
			if(!strncasecmp(str,"$iurl(", 6) && !iurl_udm_recursion){
				char *ch;
				size_t len;
				
				if(!(ch=strchr(str,')')))
					continue;
				if (TEMPL(T_RESULT) == where)
					continue;
				if ((len = ch-str-6)<1)
					continue;
				if (cur_iurl<MAX_URL_INCLUDE){
					UDM_MUTEX_LOCK(&iurl_mut);
					cur_iurl++;
            				url_include[cur_iurl].status = 1;
            				url_include[cur_iurl].where = where;
            				url_include[cur_iurl].ntempl = ntemplates-1;
				    	url_include[cur_iurl].url = UdmXmalloc(len+1);
					udm_snprintf(url_include[cur_iurl].url, len+1, "%s", str+6);
					pthread_create(&(url_include[cur_iurl].url_pth), NULL, 
							    &get_remote_result, (void*)Agent);
					
				}
			}else
#endif
			if((variables)&&(s=UdmGetToken(str,"\r\n",&lasttok))){
			        if(!UDM_STRNCASECMP(str,"HLBeg")) {
					memset(HLBeg,0,sizeof(HLBeg));
        				strncpy(HLBeg,UdmTrim(str+5,"= \t\r\n"),sizeof(HLBeg)-1);
        			} else
        			if(!UDM_STRNCASECMP(str,"HLEnd")) {
					memset(HLEnd,0,sizeof(HLEnd));
          				strncpy(HLEnd,UdmTrim(str+5,"= \t\r\n"),sizeof(HLEnd)-1);
        			} else
				if(!UDM_STRNCASECMP(str,"DBAddr"))
					UdmEnvSetDBAddr(Agent->Conf,UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"VarDir"))
					udm_snprintf(Agent->Conf->vardir,sizeof(Agent->Conf->vardir)-1,"%s%s",UdmTrim(str+6," \r\n\t"),UDMSLASHSTR);
				else
				if(!UDM_STRNCASECMP(str,"DataDir"))
					udm_snprintf(Agent->Conf->vardir,sizeof(Agent->Conf->vardir)-1,"%s%s",UdmTrim(str+6," \r\n\t"),UDMSLASHSTR);
				else
				if(!UDM_STRNCASECMP(str,"DBMode"))
					UdmEnvSetDBMode(Agent->Conf,UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"ResultsPerPage"))
					Agent->page_size=atoi(UdmTrim(str+14,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"MinWordLength"))
					Agent->Conf->min_word_len=atoi(UdmTrim(str+13,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"MaxWordLength"))
					Agent->Conf->max_word_len=atoi(UdmTrim(str+13,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"PagesPerScreen"))
					pps=atoi(UdmTrim(str+14,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"Clones")){
					if(!UDM_STRNCASECMP(UdmTrim(str+6,"= \r\t\n"),"no"))
						use_clones=0;
					else
						use_clones=1;
				}else
				if(!UDM_STRNCASECMP(str,"Phrase")){
					if(!UDM_STRNCASECMP(UdmTrim(str+7,"= \r\t\n"),"no"))
						Agent->Conf->use_phrases=0;
					else
						Agent->Conf->use_phrases=1;
				}else
				if(!UDM_STRNCASECMP(str,"CrossWords")){
					if(!UDM_STRNCASECMP(UdmTrim(str+10,"= \r\t\n"),"no"))
						Agent->Conf->use_crossword=0;
					else
						Agent->Conf->use_crossword=1;
				}else
				if(!UDM_STRNCASECMP(str,"Cache")){
					if(!UDM_STRNCASECMP(UdmTrim(str+5,"= \r\t\n"),"no"))
						Agent->cache_mode=UDM_CACHE_DISABLED;
					else
						Agent->cache_mode=UDM_CACHE_ENABLED;
				}else
				if(!UDM_STRNCASECMP(str,"TrackQuery")){
					if(!UDM_STRNCASECMP(UdmTrim(str+10,"= \r\t\n"),"no"));
					else
						Agent->track_mode|=UDM_TRACK_QUERIES;
				}else
				if(!UDM_STRNCASECMP(str,"IspellMode")){
					if(!UDM_STRNCASECMP(UdmTrim(str+10,"= \r\t\n"),"db")) 
					     Agent->Conf->ispell_mode |= UDM_ISPELL_MODE_DB;
					else {
					  Agent->Conf->ispell_mode &= ~UDM_ISPELL_MODE_DB;
					  if(!UDM_STRNCASECMP(UdmTrim(str+10,"= \r\t\n"),"server")) {
					    Agent->Conf->ispell_mode |= UDM_ISPELL_MODE_SERVER;
					    Agent->Conf->spellhost = strdup(UdmTrim(UdmTrim(str+10, "= \r\t\n")+ 6, "= \r\t\n"));
					    /*UdmLoadSpellFromServer(Agent->Conf, Agent->Conf->);*/
					  }
					}
				}else
				if(!UDM_STRNCASECMP(str,"IspellUsePrefixes")){
					if(!UDM_STRNCASECMP(UdmTrim(str+17,"= \r\t\n"),"yes")) 
					     Agent->Conf->ispell_mode |= UDM_ISPELL_USE_PREFIXES;
					else Agent->Conf->ispell_mode &= ~UDM_ISPELL_USE_PREFIXES;
				}else
				if(!UDM_STRNCASECMP(str,"LocalCharset")){
					Agent->Conf->local_charset=UdmGetCharset(UdmTrim(str+12,"= \r\t\n"));
					Agent->charset=Agent->Conf->local_charset;
				}else
				if(!UDM_STRNCASECMP(str,"R")){
					int i,j;
					float frand;
					i=atoi(str+1);
					s=str+1;
					while((*s)&&(isdigit(*s)))s++;
					j=atoi(UdmTrim(s,"= \t\r\n"));
					if((i>=0)&&(i<MAXRANDOM)){
						frand=rand();
						frand=frand/RAND_MAX*j;
						Randoms[i]=frand;
					}
				}else
				if(!UDM_STRNCASECMP(str,"Affix")){
					char lang[20]="";char str1[UDMSTRSIZ]="";
					if((query_text) && (!(Agent->Conf->ispell_mode & UDM_ISPELL_MODE_DB)))
					if(sscanf(str+5,"%s%s",lang,str1)){
						if(*str1=='/')strcpy(str,str1);
						else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
						UdmImportAffixes(Agent->Conf,lang,str,NULL,0);
					}
				}else
				if(!UDM_STRNCASECMP(str,"Spell")){
					char lang[20]="";
					char str1[UDMSTRSIZ]="";
					if(!(Agent->Conf->ispell_mode & UDM_ISPELL_MODE_DB))
					if(sscanf(str+5,"%s%s",lang,str1)){
						if(*str1=='/')strcpy(str,str1);
						else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
						strncpy(Dict[(int)dict_num].lang,lang,2);
						Dict[(int)dict_num].lang[2]=0;
						Dict[(int)dict_num].path=strdup(str);
						dict_num++;
					}
				}else
				if(!UDM_STRNCASECMP(str,"StopwordTable")){
					strcat(Agent->Conf->stop_tables," ");
					strcat(Agent->Conf->stop_tables,str+13);
				}else
				if(!UDM_STRNCASECMP(str,"StopwordFile")){
					char str1[UDMSTRSIZ]="";
					int res;
					
					if(sscanf(str+12,"%s",str1)){
#if (WIN32||WINNT)
						strcpy(str,str1);
#else
						/* Check absolute path */
						if(*str1=='/')strcpy(str,str1);
						else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
#endif

						if((res=UdmFileLoadStopList(Agent->Conf,str))){
							printf("%s\n",Agent->Conf->errstr);
							exit(0);
						}
					}
				}
			}
		}
	}
	fclose(file);
	if(query_text){
		char *w, *lt;
		int i;
		/* If the query is specified we'll compose     */
		/* a string with first letters of every        */
		/* word. It will allow fast Ispell dictionary  */
		/* loading. We'll also compose string          */
		/* with light words and tolower query.         */
		/* As far as search is case insensitive        */
		/* the first thing to do is lo-case query      */
	
		UdmTolower(query_text,Agent->charset);
		strcpy(str,query_text);
		w=UdmGetWord(str,&lt,Agent->charset);
		while(w){
			int len;
			/* Add first letter */
			len=strlen(first_letters);
			first_letters[len]=w[0];
			first_letters[len+1]=0;
			/* Make string with words to be hilighted */
			sprintf(UDM_STREND(LightWords)," %s ",w);
			w=UdmGetWord(NULL,&lt,Agent->charset);
		}
		
		if (!(Agent->Conf->ispell_mode & UDM_ISPELL_MODE_DB)) {
			/* FIXME HIDE */
			for(i=0;i<dict_num;i++){
				if (Agent->Conf->ispell_mode & UDM_ISPELL_USE_PREFIXES) {
				    UdmImportDictionary(Agent->Conf,Dict[i].lang,Dict[i].path,1,"");
				} else {
				    UdmImportDictionary(Agent->Conf,Dict[i].lang,Dict[i].path,1,first_letters);
				}
				free(Dict[i].path);
			}
			if(dict_num)UdmSortDictionary(Agent->Conf);
			UdmSortAffixes(Agent->Conf);
		}
	}
	return(0);
}


static int PrintTemplate(UDM_AGENT * Agent,UDM_DOCUMENT * Doc,char * Target,int where);

static int PrintOneTemplate(UDM_AGENT * Agent,UDM_DOCUMENT * Doc,char * Target,char *s,int where,int ntempl){
	UDM_RESULT *Res=NULL;
	UDM_CATEGORY *c=NULL;
	int rnum,tmp, len;
	char notitle[]=NO_TITLE;
	char buf[UDM_MAXTIMESTRLEN];
	char emptystr[]="";
	char * escstr;

	*Target=0;
	while(*s){
		if((*s=='\\')&&(*(s+1)=='$')){
			sprintf(UDM_STREND(Target),"$");
			s+=2;
			continue;
		}
		if(*s!='$'){
			sprintf(UDM_STREND(Target),"%c",*s);
			s++;
			continue;
		}

		s++;
		switch(*s){
		case 'A': sprintf(UDM_STREND(Target),"%s",self);break;
		case 'Q': sprintf(UDM_STREND(Target),"%s",query_form_escaped?query_form_escaped:"");break;
		case 'q': sprintf(UDM_STREND(Target),"%s",query_url_escaped?query_url_escaped:"");break;
		case 'E': sprintf(UDM_STREND(Target),"%s",UdmDBErrorMsg(Agent->db));break;
		case 'W': sprintf(UDM_STREND(Target),"%s",Agent->wordinfo);break;
		case 'f': sprintf(UDM_STREND(Target),"%d",first);break;
		case 'l': sprintf(UDM_STREND(Target),"%d",last);break;
		case 't': sprintf(UDM_STREND(Target),"%d",Agent->total_found);break;
		case 'm': 
			switch(Agent->search_mode){
				case UDM_MODE_BOOL:
					sprintf(UDM_STREND(Target),"%s","bool");
					break;
				case UDM_MODE_ANY:
					sprintf(UDM_STREND(Target),"%s","any");
					break;
				case UDM_MODE_PHRASE:
					sprintf(UDM_STREND(Target),"%s","phrase");
					break;
				case UDM_MODE_ALL:
				default:
					sprintf(UDM_STREND(Target),"%s","all");
					break;
			}
			break;
		case 's': sprintf(UDM_STREND(Target),"%s",sort?sort:"rate");break;
		case 'o': sprintf(UDM_STREND(Target),"%d",format);break;
		case 'g': {
			if(s[1]=='('){
				char parent[100]="";
				char *ch;
				int level=0;
				int plen;

				if(!(ch=strchr(s,')')))	continue;
				level=atoi(s+2);
				if(ttag){
					strncpy(parent,ttag,sizeof(parent)-1);
					parent[sizeof(parent)-1]=0;
				}
				plen=strlen(parent)-level;
				if(plen>0)parent[plen]='\0';
				else	parent[0]='\0';
				sprintf(UDM_STREND(Target),"%s",parent);
					s=ch;
				}else{
					sprintf(UDM_STREND(Target),"%s",ttag?ttag:"");
				}
			break;
		}
			
		case 'r': {
			s++;
			rnum=atoi(s);
			if((rnum>=0)&&(rnum<MAXRANDOM))
				sprintf(UDM_STREND(Target),"%d",Randoms[rnum]);
			while((*s)&&(isdigit(*(s+1))))
				s++;
			break;
		}
		case 'V': {
			PrintTemplate(Agent,Doc,UDM_STREND(Target),TEMPL(T_NAVIGATOR));
			break;
		}
		case 'D':
			s++;
			switch(*s){
			case 'U':sprintf(UDM_STREND(Target),"%s",Doc?(Doc->url?Doc->url:""):"");break;
			case 'C':sprintf(UDM_STREND(Target),"%s",Doc?(Doc->content_type?Doc->content_type:""):"");break;
			case 'M':UdmTime_t2HttpStr(Doc?Doc->last_mod_time:0, buf); sprintf(UDM_STREND(Target),"%s",buf);break;
			case 'R':sprintf(UDM_STREND(Target),"%d",Doc?Doc->rating:0);break;
			case 'S':sprintf(UDM_STREND(Target),"%d",Doc?Doc->size:0);break;
			case 'N':sprintf(UDM_STREND(Target),"%d",Doc?Doc->order:0);break;
			case 'T':
				escstr=(Doc?UdmHtmlSpecialChars(Doc->title?Doc->title:emptystr):emptystr);
				if (!strcmp(escstr,"-") || !strcmp(escstr,"")) escstr = (Doc?(Doc->url?Doc->url:emptystr):emptystr);
				hilightcpy(Agent->charset,UDM_STREND(Target),escstr[0]?escstr:notitle,LightWords,HLBeg,HLEnd);
				break;
			case 'D':
				escstr=(Doc?UdmHtmlSpecialChars(Doc->description?Doc->description:emptystr):emptystr);
				hilightcpy(Agent->charset,UDM_STREND(Target),escstr,LightWords,HLBeg,HLEnd);
				break;
			case 'K':
				escstr=(Doc?UdmHtmlSpecialChars(Doc->keywords?Doc->keywords:emptystr):emptystr);
				hilightcpy(Agent->charset,UDM_STREND(Target),escstr,LightWords,HLBeg,HLEnd);
				break;
			case 'X':
				escstr=(Doc?UdmHtmlSpecialChars(Doc->text?Doc->text:emptystr):emptystr);
				hilightcpy(Agent->charset,UDM_STREND(Target),escstr,LightWords,HLBeg,HLEnd);
				break;
			case 'E':
				escstr=(Doc?UdmHtmlSpecialChars(Doc->description?(Doc->description[0]?Doc->description:(Doc->text?Doc->text:emptystr)):(Doc->text?Doc->text:emptystr)):emptystr);
				hilightcpy(Agent->charset,UDM_STREND(Target),escstr,LightWords,HLBeg,HLEnd);
				break;
			case 'Y':
				if((c=UdmCatPath(Agent,Doc->category?Doc->category:""))){
					while(c->rec_id){
						sprintf(UDM_STREND(Target)," &gt; <A HREF=\"%s?cat=%s\">%s</A> ",
							self,c->path,c->name);
						c++;
					}
				}
				break;

			default :sprintf(UDM_STREND(Target),"%c",*s);
			}
			break;

		case 'C':
			s++;
			switch(*s){
			case 'L':
			if(use_clones && (Doc?Doc->crc32:0) && ((where/100)==T_RESULT)){
				if((Res=UdmCloneList(Agent,Doc?Doc->crc32:0))){
					int i;
					for(i=0;i<Res->num_rows;i++){
						if(Res->Doc[i].url_id!=Doc->url_id)
							PrintTemplate(Agent,&(Res->Doc[i]),UDM_STREND(Target),TEMPL(T_CLONE));
					}
					UdmFreeResult(Res);
				}
			}
			break;
			
			case 'P':
			if((c=UdmCatPath(Agent,category))){
				while(c->rec_id){
					sprintf(UDM_STREND(Target)," &gt; <A HREF=\"%s?cat=%s\">%s</A> ",
						self,c->path,c->name);
					c++;
				}
			}
			break;
			
			case 'S':
			if((c=UdmCatList(Agent,category))){
				while(c->rec_id){
					sprintf(UDM_STREND(Target),"<A HREF=\"%s?cat=%s\">%s%s</A><BR>",
						self,
						c->link[0]?c->link:c->path,
						c->link[0]?"@ ":"",
						c->name);
					c++;
				}
			}
			break;
			
			default : sprintf(UDM_STREND(Target),"%c",*s);
			}
			
			break;
		
		case 'N':
			s++;
			switch(*s){
			case 'L':
				if(Agent->page_number>0){
					if(Agent->page_number>1)sprintf(fullhref,"%s&np=%d",href,Agent->page_number-1);
					else strcpy(fullhref,href);
					PrintTemplate(Agent,NULL,UDM_STREND(Target),TEMPL(T_NAVLEFT));
				}else{
					PrintTemplate(Agent,NULL,UDM_STREND(Target),TEMPL(T_NAVLEFT_NOP));
				}
				break;
			case 'B':
				for(navpage = 1; navpage <= num_pages;navpage++){
					tmp = Agent->page_number + 1 - pps/2;
					if (tmp < 1) tmp = 1;
					if (tmp > num_pages - pps + 1)
					tmp = num_pages - pps + 1;
					if (navpage >= tmp && navpage <(tmp+pps)){
						if(navpage>1)sprintf(fullhref,"%s&np=%d",href,navpage-1);
						else strcpy(fullhref,href);
						if (Agent->page_number == navpage-1)
						PrintTemplate(Agent,NULL,UDM_STREND(Target),TEMPL(T_NAVBAR0));
					else
						PrintTemplate(Agent,NULL,UDM_STREND(Target),TEMPL(T_NAVBAR1));
					}
				}
				break;
			case 'R':
				if (is_next) {
					sprintf(fullhref,"%s&np=%d",href,Agent->page_number+1);
					PrintTemplate(Agent,NULL,UDM_STREND(Target),TEMPL(T_NAVRIGHT));
				}
				else {
					PrintTemplate(Agent,NULL,UDM_STREND(Target),TEMPL(T_NAVRIGHT_NOP));
				}
				break;
			case 'H': 
				sprintf(UDM_STREND(Target),"%s",fullhref);
				break;
			case 'P': 
				sprintf(UDM_STREND(Target),"%d",navpage);
				break;
			}
			break;
		case 'i':
		case 'I':
			if(!strncasecmp(s,"if(",3)){
				char *fname=s+3;
				
				if((s=strchr(s,')'))){
					char template[UDMSTRSIZ];
					*s=0;
					if(strlen(fname)>sizeof(template))
						fname[sizeof(template)-1]=0;
					if(*fname=='/'){
						/* Absolute path */
						strcpy(template,fname);
					}else{
						/* Relative path */
						sprintf(template,"%s%c%s", UDM_CONF_DIR,UDMSLASH,fname);
					}
					if(LoadTemplate(Agent,template,NULL,lastt[T_INCLUDE])){
						sprintf(UDM_STREND(Target),"Unable to include '%s'",template);
					}else{
						PrintTemplate(Agent,NULL,UDM_STREND(Target),lastt[T_INCLUDE]);
						lastt[T_INCLUDE]++;
					}
				}
			}else if (!strncasecmp(s,"iurl(", 5)){
				char *ch, *url;
				if((ch=strchr(s,')'))){
					if (((len = ch-s-5)<1) || (TEMPL(T_RESULT) == where) || iurl_udm_recursion){
						s=ch;
						break;
					}
				    	url = UdmXmalloc((size_t)len+1);
					udm_snprintf(url, (size_t)len+1, "%s", s+5);
#ifdef HAVE_PTHREAD
					{
						int i;
						i=get_ind_by_url(url, where, ntempl);
						if (i >= 0){
							url_include[i].offset = buf_out.buf_len+strlen(Targ);
							url_include[i].visible = 1;
						}
					}
#else
			                if (cur_iurl++ < MAX_URL_INCLUDE){
                                		url_include[cur_iurl].status = 1;
                                                url_include[cur_iurl].offset = buf_out.buf_len+strlen(Targ);
						url_include[cur_iurl].visible = 1;
            					url_include[cur_iurl].where = where;
            					url_include[cur_iurl].ntempl = ntempl;
						url_include[cur_iurl].url = UdmXmalloc((size_t)len+1);
                                                udm_snprintf(url_include[cur_iurl].url, (size_t)len+1, "%s", url);
                                                get_remote_result(Agent);
			                }
#endif
					s=ch;
					UDM_FREE(url);
				}
			}else
				sprintf(UDM_STREND(Target),"%c",*s);
			break;
		case 'd': /* time limits vars */
			s++;
			switch(*s){
				case 't':
					sprintf(UDM_STREND(Target),"%s",dt_s?dt_s:DEFAULT_DT);
					break;
				case 'p':
					sprintf(UDM_STREND(Target),"%s",dp_s?dp_s:DEFAULT_DP);
					break;
				case 'x':
					sprintf(UDM_STREND(Target),"%s",dx_s?dx_s:DEFAULT_DX);
					break;
				case 'm':
					sprintf(UDM_STREND(Target),"%s",dm_s?dm_s:DEFAULT_DM);
					break;
				case 'd':
					sprintf(UDM_STREND(Target),"%s",dd_s?dd_s:DEFAULT_DD);
					break;
				case 'y':
					sprintf(UDM_STREND(Target),"%s",dy_s?dy_s:DEFAULT_DY);
					break;
				case 'b':
					sprintf(UDM_STREND(Target),"%s",db_s?db_s:DEFAULT_DB);
					break;
				case 'e':
					sprintf(UDM_STREND(Target),"%s",de_s?de_s:DEFAULT_DE);
					break;
			}
			break;	
		case 'p':
			s++;
			switch(*s){
				case 's':
					sprintf(UDM_STREND(Target),"%d",Agent->page_size?Agent->page_size:DEFAULT_PS);
					s++;
					break;
				case 'n':
					tmp = Agent->page_size*Agent->page_number;
					sprintf(UDM_STREND(Target),"%d",tmp);
					s++;
					break;
			}
			break;
		case 'L': /* Language limit */
		  sprintf(UDM_STREND(Target),"%s",Agent->glang?Agent->glang:"");
		  break;
		default: 
			if(!strncasecmp(s,"wm",2)){
				switch(Agent->word_match){
					case UDM_MATCH_SUBSTR:
						sprintf(UDM_STREND(Target),"%s","sub");
						break;
					case UDM_MATCH_BEGIN:
						sprintf(UDM_STREND(Target),"%s","beg");
						break;
					case UDM_MATCH_END:
						sprintf(UDM_STREND(Target),"%s","end");
						break;
					case UDM_MATCH_WORD:
					default:
						sprintf(UDM_STREND(Target),"%s","wrd");
						break;
				}
				s++;
			}else
			if(!strncasecmp(s,"SearchTime",10)){
				sprintf(UDM_STREND(Target),"%.3f",((double)work_time)/1000);
				s+=9;
			}else
			if(!strncasecmp(s,"ndocs",5)){
				sprintf(UDM_STREND(Target),"%d",UdmGetDocCount(Agent));
				s+=4;
			}else
			if(!strncmp(s,"ul",2)){
				sprintf(UDM_STREND(Target),"%s",ul_unescaped);
				s++;
			}else
			if(!strncmp(s,"wf",2)){
				sprintf(UDM_STREND(Target),"%s",wf?wf:"");
				s++;
			}else
			if(!strncmp(s,"cat",3)){
				if(s[3]=='('){
					char parent[100]="";
					char *ch;
					int level=0;
					int plen;
					
					if(!(ch=strchr(s,')')))
						continue;
					level=atoi(s+4);
					if(category){
						strncpy(parent,category,sizeof(parent)-1);
						parent[sizeof(parent)-1]=0;
					}
					plen=strlen(parent)-level*2;
					if(plen>0)parent[plen]='\0';
					else	parent[0]='\0';
					sprintf(UDM_STREND(Target),"%s",parent);

					s=ch;
				}else{
					sprintf(UDM_STREND(Target),"%s",category?category:"");
					s+=2;
				}
			}else{
			    sprintf(UDM_STREND(Target),"%c",*s);
			}
		}
		s++;
	}
	return(0);
}

int get_ind_by_url(char *url, int where, int ntempl){
int i;
	for (i=0; i<MAX_URL_INCLUDE; i++)
        	if (url_include[i].url)
			if (!strcmp(url_include[i].url, url) && 
			    (url_include[i].where == where) &&
			    (url_include[i].ntempl == ntempl))
				return i;
	return -1;
}

void *get_remote_result(void * Agent){
	UDM_URL url;
	UDM_CONN *connp;
	int i;
	int timeout = 60;
	size_t maxsize = 102400;

	char header[UDMSTRSIZ]="", *body;
	const char *charset;
	char exp_url[UDMSTRSIZ]="";

	i = cur_iurl;
#ifdef HAVE_PTHREAD
	UDM_MUTEX_UNLOCK(&iurl_mut);
#endif
	/* Expand $q, $pn parameters*/
	PrintOneTemplate((UDM_AGENT*)Agent,NULL,exp_url, url_include[i].url, 0, 0);
	UdmParseURL(&url, exp_url);

	/* Support only http for now */
	if (strncmp(url.schema, "http", 4)){
		url_include[i].buf = UdmXmalloc(strlen(exp_url)+50);
		sprintf(url_include[i].buf , "$iurl() error: Bad url %s given (only http is supported)", exp_url);
		url_include[i].status = 2;
		return  NULL;
	}
	
	connp = UdmXmalloc(sizeof(UDM_CONN));

	if (http_connect(((UDM_AGENT*)Agent)->Conf,connp, url.hostname, url.port?url.port:80, timeout) == -1){
		url_include[i].buf = UdmXmalloc(strlen(url.hostname)+50);
		sprintf(url_include[i].buf , "$iurl() error: Can't connect to %s", url.hostname);
		UDM_FREE(connp);
		url_include[i].status = 2;
		return  NULL;
	}

	/*Fix me: Make HTTP header */
	udm_snprintf(header, UDMSTRSIZ, "GET %s%s HTTP/1.0\r\nHost: %s\r\n",
		url.path, url.filename, url.hostname);
	if (((UDM_AGENT*)Agent)->charset!=UDM_CHARSET_USASCII )
		if ((charset = UdmCharsetStr(((UDM_AGENT*)Agent)->charset)))
    			sprintf(UDM_STREND(header),"Accept-charset: %s\r\n", charset);
        strcat(header,"\r\n");

	if (socket_write(connp, header) == -1){
		socket_close(connp);
		UDM_FREE(connp);
		url_include[i].status = 2;
		return  NULL;
	}
    
	if (socket_read(connp, maxsize) == -1 ){
		url_include[i].buf = UdmXmalloc(strlen(exp_url)+50);
		sprintf(url_include[i].buf , "Read error %s", exp_url);
		socket_close(connp);
		UDM_FREE(connp->buf);
		UDM_FREE(connp);
		url_include[i].status = 2;
		return  NULL;
	}

	/* Fixme  */
        if((body=strstr(connp->buf,"\r\n\r\n")))
                body +=4;
        else if ((body=strstr(connp->buf,"\n\n")))
                body +=2;
        
        if(body){
        	size_t len;
		len = strlen(body);
		url_include[i].buf = UdmXmalloc(len+1);
		sprintf(url_include[i].buf, "%s", body);
        }else{
		url_include[i].buf = UdmXmalloc(1);
	}

	socket_close(connp);
	UDM_FREE(connp->buf);
	UDM_FREE(connp);
	url_include[i].status = 2;
	return  NULL;
}

static void *get_result(UDM_AGENT * Indexer){
UDM_RESULT * Res=NULL;

	if (Indexer->Conf->ispell_mode & UDM_ISPELL_MODE_DB) {
	    if (UdmDBImportAffixes(Indexer,Indexer->charset) || UdmImportDictionaryFromDB(Indexer)) {
		PrintTemplate(Indexer,NULL,Targ, TEMPL(T_ERROR));
		buf_out.buf_len += strlen(Targ);
		buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
		sprintf(UDM_STREND(buf_out.buf), "%s", Targ);

		PrintTemplate(Indexer,NULL,Targ, TEMPL(T_BOT));

		buf_out.buf_len+= strlen(Targ);
		buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
		sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
		UDM_FREE(buf_out.buf);
		return(0);
	    } else if(Indexer->Conf->nspell) {
	      UdmSortDictionary(Indexer->Conf);
	      UdmSortAffixes(Indexer->Conf);
	    }
	}

	Indexer->page_size=Indexer->page_size?Indexer->page_size:DEFAULT_PS;
	Indexer->group_mask=group_mask?group_mask:0xffffffff;
	Indexer->weight_factor=wf?strdup(wf):wf;

	if((Res=UdmFind(Indexer,query_words))){
		work_time=Res->work_time;
		if(Res->num_rows){
			int i;
			first=Res->first;
			last=Res->last;
			num_pages = Indexer->total_found/(Indexer->page_size?Indexer->page_size:DEFAULT_PS);
			is_next=last<Indexer->total_found;
			if ((Indexer->page_size?Indexer->page_size:DEFAULT_PS)*num_pages<Indexer->total_found)
				num_pages++;
			sprintf(href,"%s?q=%s",self,query_url_escaped);
			strcpy(UDM_STREND(href),ul_str);

			if (mode)sprintf(UDM_STREND(href),"&m=%s",mode);
			if (sort)sprintf(UDM_STREND(href),"&s=%s",sort);
			/*if (wf)sprintf(UDM_STREND(href),"&s=%s",wf);*/
			if (wmode)sprintf(UDM_STREND(href),"&wm=%s",wmode);
			if (Indexer->page_size)sprintf(UDM_STREND(href),"&ps=%d",Indexer->page_size);
			if (format)sprintf(UDM_STREND(href),"&o=%d",format);
			if (dt_s)sprintf(UDM_STREND(href),"&dt=%s",dt_s);
			if (dp_s)sprintf(UDM_STREND(href),"&dp=%s",dp_s);
			if (dm_s)sprintf(UDM_STREND(href),"&dm=%s",dm_s);
			if (dy_s)sprintf(UDM_STREND(href),"&dy=%s",dy_s);
			if (dd_s)sprintf(UDM_STREND(href),"&dd=%s",dd_s);
			if (db_s)sprintf(UDM_STREND(href),"&db=%s",db_s);
			if (de_s)sprintf(UDM_STREND(href),"&de=%s",de_s);

			/* Print RESTOP then all RES's */
			PrintTemplate(Indexer,NULL,Targ, TEMPL(T_RESTOP));
			buf_out.buf_len+= strlen(Targ);
			buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
			sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
		
			for(i=0;i<Res->num_rows;i++){
				PrintTemplate(Indexer,&(Res->Doc[i]),Targ, TEMPL(T_RESULT));	
				buf_out.buf_len+= strlen(Targ);
				buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
				sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
			}
			/* Print RESBOT */
			PrintTemplate(Indexer,NULL,Targ, TEMPL(T_RESBOT));
			buf_out.buf_len+= strlen(Targ);
			buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
			sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
		}else{
			PrintTemplate(Indexer,NULL,Targ, TEMPL(T_NOTFOUND));
			buf_out.buf_len+= strlen(Targ);
			buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
			sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
		}
		UdmFreeResult(Res);
	}else{
		if(UdmDBErrorCode(Indexer->db)){
			/* Oops... error! We tried ...*/
			PrintTemplate(Indexer,NULL,Targ, TEMPL(T_ERROR));
    			buf_out.buf_len+= strlen(Targ);
			buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
			sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
		}

	}
	return NULL;
}

static int PrintOption(UDM_AGENT * Agent,char * Target,int where,char * option){
UDM_TAG tag;
char *s;
int len;
char tmp[UDMSTRSIZ]="";

	if(!(s=strchr(option,'>'))){
		sprintf(UDM_STREND(Target),"%s",option);
		return(0);
	}
	len=s-option;
	s=strdup(option);
	s[len+1]=0;
	UdmParseTag(&tag,s);
	if(tag.selected && tag.value){
		int i;
		const char *value;
		PrintOneTemplate(Agent,NULL,tmp,option,where,0);
		UdmFreeTag(&tag);
		UdmParseTag(&tag,tmp);
		value=tag.selected?tag.selected:"";
		if(*value=='$'){
			for(i=0;i<nVar;i++){
				if(!strcmp(Variables[i].name,"ul")&&!strcmp(Variables[i].value,tag.value)){
					value=Variables[i].value;
					break;
				}
			}
		}
		sprintf(UDM_STREND(Target),"<OPTION VALUE=\"%s\"%s>",tag.value,
			strcmp(tag.value,value)?"":" SELECTED");
		PrintOneTemplate(Agent,NULL,UDM_STREND(Target),option+len+1,where,0);
	}else{	
		sprintf(UDM_STREND(Target),"%s",option);
	}
	UdmFreeTag(&tag);
	return(0);
}


static int PrintInput(UDM_AGENT * Agent,char * Target,int where,char * option){
UDM_TAG tag;
char *s;
int len;
char tmp[UDMSTRSIZ]="";

	if(!(s=strchr(option,'>'))){
		sprintf(UDM_STREND(Target),"%s",option);
		return(0);
	}
	len=s-option;
	s=strdup(option);
	s[len+1]=0;
	UdmParseTag(&tag,s);

	if((tag.selected && tag.value)){
		const char * checked="";

		/* Original line from template */
		/*printf("HELLO INPUT!<BR>%s<BR>\n",option);*/
		
		/* This is to avoid recursion */
		strcpy(tmp,"<INPUT");
		PrintOneTemplate(Agent,NULL,UDM_STREND(tmp),option+6,where,0);

		/* Line with variables replaced by their values*/
		/* printf("HELLO INPUT!<BR>%s<BR>\n",tmp); */

		/* Parse tag again */
		UdmFreeTag(&tag);
		UdmParseTag(&tag,tmp);
		
		/*printf("<BR>HELLO '%s' '%s' '%s'<BR>\n",tag.selected,tag.value,tag.name);*/

		if(!strcmp(tag.selected?tag.selected:"",
				tag.value?tag.value:""))
			checked=" CHECKED";

		sprintf(UDM_STREND(Target),
			"<INPUT TYPE=\"%s\" NAME=\"%s\" VALUE=\"%s\"%s>",
			tag.type,tag.name,tag.value,checked);

		PrintOneTemplate(Agent,NULL,UDM_STREND(Target),option+len+1,where,0);
	}else{	
		/* To avoid recursion again */
		sprintf(UDM_STREND(Target),"%s","<INPUT");
		PrintOneTemplate(Agent,NULL,UDM_STREND(Target),option+6,where,0);
	}
	UdmFreeTag(&tag);
	return(0);
}



int PrintTemplate(UDM_AGENT * Agent,UDM_DOCUMENT * Doc,char * Target,int where){
int i;
	*Target=0;
#ifdef TRIAL
	if(where==TEMPL(T_BOT))strcat(UDM_STREND(Target), POWERED_LOGO);
#endif
	for(i=0;i<ntemplates;i++){
		char *s;
		if(Template[i].where!=where)continue;
		s=Template[i].str;
		while((*s==' '||*s=='\t'))s++;

		if(!UDM_STRNCASECMP(s,"<OPTION")){
			PrintOption(Agent,UDM_STREND(Target),where,s);
		}else
		if(!UDM_STRNCASECMP(s,"<INPUT")){
			PrintInput(Agent,UDM_STREND(Target),where,s);
		}else{
			PrintOneTemplate(Agent,Doc,UDM_STREND(Target),Template[i].str,where,i);
		}
	}
#ifdef TRIAL
	if(where==TEMPL(T_TOP))strcat(UDM_STREND(Target), POWERED_LOGO);
#endif
	return(0);
}

static void InitRand(void){
int i;
time_t tclock;
	tclock=time(0);
	srand((unsigned)tclock);
	for(i=0;i<MAXRANDOM;i++)
		Randoms[i]=0;
}

#if (WIN32|WINNT)
static void GetTemplatePath(int ntmpl, char *template){
	char template_name[33];
	DWORD type=REG_SZ;
	DWORD size=UDMSTRSIZ;
	HKEY key;

	_itoa(ntmpl,template_name,10);
	if(ERROR_SUCCESS==RegOpenKeyEx(HKEY_LOCAL_MACHINE,"Software\\Mnogo\\Mnogosearch\\Templates",0,KEY_READ,&key)){
		if(ERROR_SUCCESS!=RegQueryValueEx(key,template_name,NULL,&type,template,&size)) goto Err1;
		RegCloseKey(key);
		return;
	}
Err1:
	printf("Can't open registry key 'Software\\Mnogo\\Mnogosearch\\Templates\\%s'<BR>",template_name);
	return;
}
#endif

int main(int argc, char **argv) {
char template[UDMSTRSIZ]="";
char query_string[UDMSTRSIZ]="";
char *lasttok,*token;
const char * env;
/* search with time limits local vars */
int dx=0, dm=0, dd=0, dy=0, dt=0;
#if (WIN32||WINNT)
int ntmpl=0;
#endif
int i, ind_prev, imin=0, min, have_httpd=0;
char *buf_tmp=NULL;
time_t dp=0;
struct udm_stl_info_t stl_info = { 0, 0, 0 };
size_t len;
UDM_AGENT * Indexer;
UDM_ENV   * Conf;

	UdmInit(); /* Initialize library */

	Conf=UdmAllocEnv();
	Indexer=UdmAllocAgent(Conf, 0, UDM_OPEN_MODE_READ);

#ifdef HAVE_PTHREAD
	InitMutex(&iurl_mut);
#endif
	bzero(url_include, sizeof(url_include));

	/* Output Content-type if under HTTPD	*/
	/* Some servers do not pass QUERY_STRING*/
	/* if the query was empty, so check	*/
	/* REQUEST_METHOD as well to be safe    */

	if(getenv("QUERY_STRING")||getenv("REQUEST_METHOD")){
		have_httpd=1;
		printf("Content-type: text/html\r\n\r\n");
	}

	/* Determine self and template name */
	if((env=getenv("UDMSEARCH_TEMPLATE"))) {
		safe_strncpy(template, env, sizeof(template));
	}


	if(have_httpd){
		/* Store query_string */
		env=getenv("QUERY_STRING");
		safe_strncpy(query_string, env?env:"", sizeof(query_string));
		
		if((env=getenv("REDIRECT_STATUS"))){

			/* Check Apache internal redirect  */
			/* via   "AddHandler" and "Action" */

			safe_strncpy(self, (env=getenv("REDIRECT_URL"))?env:"search.cgi", sizeof(self));
			if(!template[0]){
				safe_strncpy(template, (env=getenv("PATH_TRANSLATED"))?env:"", sizeof(template));
			}
		}else{
			/* CGI executed directly */

			/* Detect $Self variable with OS independant SLASHES */
			safe_strncpy(self, (env=getenv("SCRIPT_NAME"))?env:"search.cgi", sizeof(self));

			if(!template[0]){
				char *s,*e;

				/*This is with OS specific SLASHES */
				env=getenv("SCRIPT_FILENAME");

				/* This is with / slashes under SamBar HTTPD */
				if(!env)env=getenv("EXECUTABLE_PATH");

				if(!env)env="search.cgi";

				if(strcmp(UDM_CONF_DIR,".")){
					/* Take from the config directory */
					udm_snprintf(template, sizeof(template), "%s/%s", UDM_CONF_DIR, (s=strrchr(env,UDMSLASH))?(s+1):(self));
				}else{
					/* Take from the current directory */
					safe_strncpy(template, env, sizeof(template));
				}

				/* Find right slash if it presents     */
				/* Strange Win HTTP servers may have   */
				/* either internet style slash or      */
				/* Win style slash. Check both of them */

				s=strrchr(template,'/');
				if(!s)s=strrchr(template,'\\');
				if(!s)s=template;

				/* Find .cgi or .exe substring */
				if((e=strstr(s,".cgi"))){
					/* Replace ".cgi" with ".htm" */
					e[1]='h';e[2]='t';e[3]='m';
				}else
				if((e=strstr(s,".exe"))){
					/* Replace ".exe" with ".htm" */
					e[1]='h';e[2]='t';e[3]='m';
				}else{
					safe_strncpy(template, "search.htm", sizeof(template));
				}
			}
		}
	}else{
		/* Executed from command line     */
		/* or under server which do not   */
		/* pass an empty QUERY_STRING var */

		if(argv[1]){
			strcpy(query_string,"q=");
			safe_strncpy(query_string+2, argv[1], sizeof(query_string)-2);
		}
		if(!template[0])
			udm_snprintf(template, sizeof(template), "%s/%s", UDM_CONF_DIR, "search.htm");
	}

	InitRand();

	/* Parse Query String */
	token=UdmGetToken(query_string,"&",&lasttok);
	while(token){
		/*
		char *value;
		if(value=strchr(token,'=')){
			*value='\0';
			AddVariable(token,value+1);
			*value='=';
		}
		*/
		if(!UDM_STRNCMP(token,"q=")){
			char str[UDMSTRSIZ]="";
			query_words=strdup(UdmUnescapeCGIQuery(str,token+2));
			query_url_escaped=strdup(UdmEscapeURL(str,query_words));
			query_form_escaped=UdmHtmlSpecialChars(query_words);
		}else
		if(!UDM_STRNCMP(token,"tmplt=")){
			char * s;
			
			for(s=token+6;*s;s++){
				/* To avoid files from other directories    */
				/* This should close some possible security */
				/* holes without a major lack of features   */

				if((*s=='/')||(*s=='\\'))
					*s='_';
			}
			/* Do not allow too long tamplate names */
			/* This also fixes possible exploit     */
			if(strlen(token)>64){
				token[64]='\0';
			}
			udm_snprintf(template, sizeof(template), "%s%s%s", UDM_CONF_DIR, UDMSLASHSTR, token+6);
			udm_snprintf(UDM_STREND(ul_str), sizeof(ul_str) - strlen(ul_str), "&tmplt=%s", token+6);
		}else
		if(!UDM_STRNCMP(token,"np=")){
			Indexer->page_number=atoi(token+3);
		}else
		if(!UDM_STRNCMP(token,"o=")){
			format=atoi(token+2);
			if((format>99)||(format<0))
				format=0;
		}else
		if(!UDM_STRNCMP(token,"ps=")){
			Indexer->page_size=atoi(token+3);
			/* Extra safety: do not allow to pass very big page sizes */
#ifndef UNLIMITED_PS
			Indexer->page_size=(Indexer->page_size>MAX_PS)?(MAX_PS):(Indexer->page_size);
#endif
		}else	/* time limiting options */
		if(!UDM_STRNCMP(token,"dt=") && strlen(token) > 3){
			/* search type */
			dt_s=strdup(token+3);
			dt=getSTLType(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dp=") && strlen(token) > 3){
			dp_s=strdup(token+3);
			dp=Udm_dp2time_t(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dx=") && strlen(token) > 3){
			/* Before/After flag */
			dx_s=strdup(token+3);
			dx=atoi(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dm=") && strlen(token) > 3){
			/* Month */
			dm_s=strdup(token+3);
			dm=atoi(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dd=") && strlen(token) > 3){
			dd_s=strdup(token+3);
			/* Day */
			dd=atoi(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dy=") && strlen(token) > 3){
			/* Year */
			dy_s=strdup(token+3);
			dy=atoi(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"db=") && strlen(token) > 3){
			/* (range) begin date */
			db_s=UdmXmalloc(strlen(token+3)+1);
			if (db_s)
			    UdmUnescapeCGIQuery(db_s, token+3);
		}
		else
		if(!UDM_STRNCMP(token,"de=") && strlen(token) > 3){
			/* (range) end date */
			de_s=UdmXmalloc(strlen(token+3)+1);
			if (de_s)
			    UdmUnescapeCGIQuery(de_s, token+3);
		}
		/* end of time limiting options */
		else
		if(!UDM_STRNCMP(token,"ul=") && strlen(token) > 3){
			char str1[UDMSTRSIZ]="";
			int use_autowild=1;
#ifdef HAVE_FILES
			use_autowild=0;
#endif
			UdmUnescapeCGIQuery(ul_unescaped,token+3);
			if(use_autowild){
				UDM_URL Url;
				UdmParseURL(&Url,ul_unescaped);
				if(Url.schema[0]==0){
					/* part of URL: /support/   */
					/* Add '%' before and after */
					udm_snprintf(str1, sizeof(str1), "%%%s%%", ul_unescaped);
				}else{
					/* full URL with beginning http://... */
					/* add '%' only after URL              */
					udm_snprintf(str1, sizeof(str1), "%s%%", ul_unescaped);
				}
			}else{
				udm_snprintf(str1, sizeof(str1), "%s", ul_unescaped);
			}
			AddVariable("ul",ul_unescaped);
			UdmAddURLLimit(Indexer->Conf,str1);
			udm_snprintf(UDM_STREND(ul_str), sizeof(ul_str) - strlen(ul_str), "&ul=%s", token+3);
		}else
		if((!UDM_STRNCMP(token,"t="))&&(*(token+2))){
			char str[UDMSTRSIZ]="";
			UdmUnescapeCGIQuery(str,token+2);
			UdmAddTagLimit(Indexer->Conf,str);
			udm_snprintf(UDM_STREND(ul_str), sizeof(ul_str) - strlen(ul_str), "&t=%s", token+2);
			UDM_FREE(ttag);
			ttag=strdup(token+2);
		}else
		if((!UDM_STRNCMP(token,"g="))&&(*(token+2))){
			UdmAddLangLimit(Indexer->Conf,token+2);
			udm_snprintf(UDM_STREND(ul_str), sizeof(ul_str) - strlen(ul_str), "&g=%s",token+2);
			UDM_FREE(Indexer->glang);
			Indexer->glang = strdup(token+2);
		}else
		if(!UDM_STRNCMP(token,"m=")){
			mode=token+2;
			if(!strcmp(mode,"all"))Indexer->search_mode=UDM_MODE_ALL;
			if(!strcmp(mode,"any"))Indexer->search_mode=UDM_MODE_ANY;
			if(!strcmp(mode,"bool"))Indexer->search_mode=UDM_MODE_BOOL;
			if(!strcmp(mode,"phrase"))Indexer->search_mode=UDM_MODE_PHRASE;
		}else
		if(!UDM_STRNCMP(token,"wm=")){
			wmode=token+3;
			if(!strcmp(wmode,"wrd"))Indexer->word_match=UDM_MATCH_WORD;
			if(!strcmp(wmode,"beg"))Indexer->word_match=UDM_MATCH_BEGIN;
			if(!strcmp(wmode,"end"))Indexer->word_match=UDM_MATCH_END;
			if(!strcmp(wmode,"sub"))Indexer->word_match=UDM_MATCH_SUBSTR;
		}else
		if(!UDM_STRNCMP(token,"s=")){
			sort=token+2;
			if(!strcmp(sort,"date"))Indexer->sort_order=UDM_ORD_DATE;
			if(!strcmp(sort,"rate"))Indexer->sort_order=UDM_ORD_RATE;
		}else
		if(!UDM_STRNCMP(token,"cat=")){
			category=token+4;
			UdmAddCatLimit(Indexer->Conf,token+4);
			udm_snprintf(UDM_STREND(ul_str), sizeof(ul_str) - strlen(ul_str), "&%s", token);
		}else
		if(!UDM_STRNCMP(token,"wf=")){
			UDM_FREE(wf);
			wf=strdup(token+3);
			udm_snprintf(UDM_STREND(ul_str), sizeof(ul_str) - strlen(ul_str), "&%s", token);
		}else
		if(!UDM_STRNCMP(token,"zo=")){
			int group_id;
			if((group_id=atoi(token+3))>0)
		    		group_mask |= 1<<(group_id);
		}else
#if (WIN32||WINNT)
		if(!UDM_STRNCMP(token,"ntmpl=")){
			ntmpl=atoi(token+6);
		}else
#endif
                if(!UDM_STRNCMP(token,"udm_recursion")){
	                iurl_udm_recursion=1;
                }

		token=UdmGetToken(NULL,"&",&lasttok);
	}
#if (WIN32||WINNT)
	template[0]=0;
	GetTemplatePath(ntmpl,template);
#endif
	if(LoadTemplate(Indexer,template,query_words,0)){
		printf("<html><body>Can't open template file '%s'!</body></html>\n",template);
		return(0);
	}


	/* commonize various "search with date limit" options */
	if (dt){
		switch(dt){
			case 1: /* dp seconds behind now */
				/* construct 'last_mod_time>=d1' */
				if (dp>0){ /* valid time and not 'anytime' */
					stl_info.t1=time(NULL)-dp;
					stl_info.type=1; /* after */
	                               }
	                               break;
			case 2: /* newer/older than dd/dm/dy */
				if ((stl_info.t1=d_m_y2time_t(dd, dm, dy))>0)
	                    		stl_info.type=dx;
	            		break;
			case 3: /* interval between db_s and de_s */
	            		/* db_s and de_s are in the form of dd/mm/yyyy */
	            		if ((stl_info.t1=dmy2time_t(db_s))>0)
	                        if ((stl_info.t2=dmy2time_t(de_s))>0)
	                    		stl_info.type=2; /* that means 'between' */
	                	break;
		}
		UdmAddTimeLimit(Indexer->Conf,&stl_info);
	} /* if (dt) */

	/* Make TOP and if no query BOTTOM */
	PrintTemplate(Indexer,NULL,Targ, TEMPL(T_TOP));
	buf_out.buf_len += strlen(Targ);
	buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
	sprintf(UDM_STREND(buf_out.buf), "%s", Targ);

	/* First print TOP */
	if (url_include[0].offset){
		len = url_include[0].offset;
		buf_tmp = UdmXrealloc(buf_tmp, len+1);
		udm_snprintf(buf_tmp, len+1, "%s", buf_out.buf);
		ind_prev = url_include[0].offset;
		printf("%s", buf_tmp);
		fflush(stdout);
	}else{
		ind_prev = strlen(Targ);
		printf("%s", Targ);
		fflush(stdout);
	}
	/* Make RES*/
	if ((query_words) && (query_words[0]!='\0')){
		get_result(Indexer);
	}
	else{
		PrintTemplate(Indexer,NULL,Targ, TEMPL(T_NOQUERY));
		buf_out.buf_len += strlen(Targ);
		buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
		sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
	}


	/* Make the BOT */
        PrintTemplate(Indexer,NULL,Targ, TEMPL(T_BOT));
	buf_out.buf_len += strlen(Targ);
	buf_out.buf = UdmXrealloc(buf_out.buf, (size_t)buf_out.buf_len+1);
	sprintf(UDM_STREND(buf_out.buf), "%s", Targ);

	/* Print it all */
	while(1){
		min = 1000000;
		imin =-1;
		for ( i=0; i<MAX_URL_INCLUDE; i++){
			if ((url_include[i].offset < min) &&
			    (url_include[i].status != 0)){
				imin = i;
				min = url_include[i].offset;
			}
		}
		if (imin == -1)
			break;
		/* fix me: Wait for phtread */
		if (url_include[imin].status == 1){
			UDMSLEEP(1);
			continue;
		}

    		if (url_include[imin].buf){
			if (url_include[imin].visible == 1){
				len = url_include[imin].offset - ind_prev;
				buf_tmp = UdmXrealloc(buf_tmp, len+1);
				udm_snprintf(buf_tmp, len+1, "%s", buf_out.buf+ind_prev);

				printf("%s", buf_tmp);
    				printf("%s", url_include[imin].buf);
				fflush(stdout);
			}
			UDM_FREE(url_include[imin].buf);
			url_include[imin].status = 0;
			ind_prev = url_include[imin].offset;
		}
	}
	len = buf_out.buf_len - ind_prev;
	buf_tmp = UdmXrealloc(buf_tmp, len+1);
	udm_snprintf(buf_tmp, len+1, "%s", buf_out.buf+ind_prev);
	printf("%s", buf_tmp);

	/* Keep your country tidy! */
	UDM_FREE(db_s);
	UDM_FREE(de_s);
	UDM_FREE(dt_s);
	UDM_FREE(dp_s);
	UDM_FREE(dx_s);
	UDM_FREE(dm_s);
	UDM_FREE(dd_s);
	UDM_FREE(dy_s);
	UDM_FREE(buf_out.buf);
	UDM_FREE(buf_tmp);
	
	UdmFreeEnv(Conf);
	UdmFreeAgent(Indexer);
	
	return(0);
}
