#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <ctype.h>


#include "udm_config.h"
#include "udm_common.h"
#include "udm_db.h"
#include "udm_charset.h"
#include "udm_xmalloc.h"
#include "udm_utils.h"
#include "udm_agent.h"
#include "udm_word.h"
#include "udm_crossword.h"


__INDLIB__ UDM_AGENT * UdmAllocAgent(UDM_ENV * Env, int handle, int db_open_mode){
	UDM_AGENT * result;

	result=(UDM_AGENT*)UdmXmalloc(sizeof(UDM_AGENT));
	memset(result, 0, sizeof(UDM_AGENT));
	result->Conf=Env;
	result->mwords=0;
	result->nwords=0;
	result->swords=0;
	result->ncrosswords=0;
	result->mcrosswords=0;
	result->CrossWord=NULL;
	result->handle=handle; /* Handle is used in multi-threaded version */
	result->action=0;
	result->state[0]=0;
	result->Word=NULL;
	result->buf=NULL;
	result->total_found=0;
	result->charset=UDM_CHARSET_USASCII;
	result->db=UdmAllocDB(result, db_open_mode);
        /* Reserve connection structure */
        result->connp = (UDM_CONN*)UdmXmalloc(sizeof(UDM_CONN));
        result->connp->indexer = result;
        result->connp->connp = (UDM_CONN*)UdmXmalloc(sizeof(UDM_CONN));
        result->connp->connp->indexer = result;
	result->wordinfo[0]=0;
	result->search_mode=0;
	result->word_match=UDM_MATCH_WORD;
	result->sort_order=UDM_ORD_RATE;
	result->page_number=0;
	result->page_size=20;
	result->group_mask=0xffffffff;
	result->track_mode=0;
	bzero(&result->t_Spell,sizeof(UDM_SPELL));
	result->read_timeout=UDM_READ_TIMEOUT;
	result->doc_timeout=UDM_DOC_TIMEOUT;
/*	result->maxsize=1024*1024;*/
	result->cache_mode=UDM_CACHE_DISABLED;
	result->weight_factor=NULL;
	result->spellang = -1;
	result->wordpos=0;
	result->glang = NULL;

	return(result);
}
__INDLIB__ void UdmFreeAgent(UDM_AGENT *Indexer){

	if(Indexer){
		UdmFreeWords(Indexer);
		UdmFreeCrossWords(Indexer);
		UdmFreeDB(Indexer);
		UDM_FREE(Indexer->Word);
		UDM_FREE(Indexer->CrossWord);
		UDM_FREE(Indexer->buf);
		UDM_FREE(Indexer->connp->hostname);
		UDM_FREE(Indexer->connp->connp);
		UDM_FREE(Indexer->connp);
		UDM_FREE(Indexer->weight_factor);
		UDM_FREE(Indexer->glang);
		UDM_FREE(Indexer);
	}
}


__INDLIB__ char * UdmAgentErrorMsg(UDM_AGENT *Indexer){
	return(UdmDBErrorMsg(Indexer->db));
}

__INDLIB__ void UdmAgentSetAction(UDM_AGENT *Indexer,int action){
	Indexer->action=action;
}

