#ifndef _UDM_PROTO_H
#define _UDM_PROTO_H

/* some of NNTP status codes */
#define NNTP_GROUP_OK                 211
#define NNTP_XOVER_OK                 224

/* HTTP status codes */
#define UDM_HTTP_STATUS_UNKNOWN		0
#define UDM_HTTP_STATUS_OK		200
#define UDM_HTTP_STATUS_PARTIAL_OK	206
#define UDM_HTTP_STATUS_REDIRECT	301
#define UDM_HTTP_STATUS_NOT_MODIFIED	304
#define UDM_HTTP_STATUS_DELETE		400
#define UDM_HTTP_STATUS_RETRY		503
#define UDM_HTTP_STATUS_BAD_REQUEST	400
#define UDM_HTTP_STATUS_UNSUPPORTED_MEDIA_TYPE 415
#define UDM_HTTP_STATUS_UNAVAIL		503
#define UDM_HTTP_STATUS_TIMEOUT		504
#define UDM_HTTP_STATUS_NOT_SUPPORTED	505

/* UdmSearch network error codes */
#define UDM_NET_ERROR			-1
#define UDM_NET_TIMEOUT			-2
#define UDM_NET_CANT_CONNECT		-3
#define UDM_NET_CANT_RESOLVE		-4
#define UDM_NET_UNKNOWN			-5
#define UDM_NET_FILE_TL                 -6

/* Mirror parameters and error codes */
#define UDM_MIRROR_NO			-1
#define UDM_MIRROR_YES			0
#define UDM_MIRROR_NOT_FOUND		-1
#define UDM_MIRROR_EXPIRED		-2
#define UDM_MIRROR_CANT_BUILD		-3
#define UDM_MIRROR_CANT_OPEN		-4

/* HTTP codes */
extern int   UdmHTTPResponseType(int status);
extern const char * UdmHTTPErrMsg(int code);

/* Different protocols */
#if (WIN32|WINNT)
extern int	UdmFILEGet(UDM_AGENT *Indexer,char *header,char* user,char* passwd);
#else
extern int	UdmFILEGet(UDM_AGENT *Indexer,char *header);
#endif
extern int	UdmHTTPGet(UDM_AGENT *Indexer,char *header,char *host,int port);
extern int	UdmHTTPSGet(UDM_AGENT *Indexer,char *header,char *host,int port);
extern int	UdmNEWSGet(UDM_AGENT *Indexer,char *header,char *host,int port);
extern int	UdmNNTPGet(UDM_AGENT *Indexer,char *header,char *host,int port);
extern int	UdmURLGetFTP(UDM_AGENT *Indexer,char *host,int port,char *path,char *filename,char *user, char *passwd,int last_mod_time, int checkonly);

/* Mirroring features */
extern int   UdmMirrorPUT(UDM_AGENT * Indexer,char * MirrorRoot, char *MirrorHeaders,char *schema, char *hostname, char *path,char *filename, char *header, char *content, int size, char *errmsg);
extern int   UdmMirrorGET(UDM_AGENT * Indexer,char * MirrorRoot, char *MirrorHeaders,char *schema, char *hostname, char *path,char *filename, char *buf, int days, char *errmsg);

#endif
