#ifndef _UDM_CHARSET_H
#define _UDM_CHARSET_H

#define UDM_CHARSET_DEFAULT		-1
#define UDM_CHARSET_USASCII		0
/* Cyr */
#define UDM_CHARSET_KOI8R		1
#define UDM_CHARSET_CP1251		2
#define	UDM_CHARSET_CP866		3
#define UDM_CHARSET_MACCYR		4
#define	UDM_CHARSET_ISO88595		5
/* Western */
#define UDM_CHARSET_ISO88591		6
/* Central */
#define UDM_CHARSET_CP1250		7
#define UDM_CHARSET_ISO88592		8
/* Arabic */
#define UDM_CHARSET_CP1256		9
/* Greek */
#define UDM_CHARSET_ISO88597		10
#define UDM_CHARSET_CP1253		11
/* Baltic (cp1257 and iso-8859-13 */
/* are letters compatible         */
#define UDM_CHARSET_CP1257		12
#define UDM_CHARSET_ISO885913		13
#define UDM_CHARSET_ISO88594		14
/* Hebrew are letters compatible */
#define UDM_CHARSET_ISO88598		15
#define UDM_CHARSET_CP1255		16
/* Turkisg are letters compatible */
#define UDM_CHARSET_ISO88599		17
#define UDM_CHARSET_CP1254		18


extern char * UdmRecode(unsigned char *str,int from,int to);
extern char * UdmTolower(unsigned char *str,int charset);
extern char * UdmToupper(unsigned char *str,int charset);
extern char * UdmGetWord( char *s, char **last, int charset);
extern int UdmGetLex(char **word, char **last, int charset);
extern const char * UdmCharsetStr(int id);

extern __INDLIB__ int UdmGetCharset(unsigned char *alias);
extern char   UdmSgmlToChar(char *sgml);
extern char * UdmUnescapeSgmlStr(char * str);
extern int    UdmWordChar(int s, int charset);
#ifdef USE_CHARSET_GUESSER
extern int    UdmGuessCharset(unsigned char *str, int charset);
#endif

extern __INDLIB__ int UdmInitCharset(void);


#endif
