#!/usr/bin/perl -T

# Web Auction Release Version 1.1                                   
# Copyright 1999, 2000 David Turley
# <dturley@pobox.com>           
# This program is free software. You may modify and distribute
# it under the same terms as perl itself. 

##$Id: auction_reg.cgi,v 1.5 1999/12/14 12:24:55 david Exp david $##

require 5.005;

use CGI qw/:all/;
use CGI::Carp(fatalsToBrowser);

use strict;

#need this line when tainting turned on to be sure and include library files
#this is the directory that contains the script usually
use lib qw(/web/cgi-bin);

##this file is probably in same directory as scripts, if not, edit 
require 'auction-lib.pl';

##You can change the basic color scheme here
my $BG = '#fffbec';	#background color
my $TX = '#000000';	#text color
my $LL = '#00008b';	#visited link color
my $VL = '#00008b';	#link color
my $BGIMG = '';		#background image url

$ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin';

##get the global set up variables
#auction.cfg should exist in same directory as this script
get_config();

use vars qw($INFO_PATH $LOCALMAIL $TEMP_FILE $PASS_FILE $USER_FILE 
	$MAIL_FROM $MAIL_SERVER $AUCTION_URL $AUCTION_TITLE $WAP $WAM $VERSION); 
        
my $TIME = time;

#required application form fields
my %required_reg = ('name'=>'Name',
				'email'=>'Email Adresss',
				'initials'=>'2 - 6 ID Characters',
				'address'=>'Address',
				'city'=>'City',
				'state'=>'State',
				'zip'=>'Zip/Postal Code',
				'country'=>'Country',
#uncomment next lines to include credit card info in form
				#'cc_type'=>'Credit Card Type',
				#'cc_name'=>'Name on Credit Card',
				#'cc_number'=>'Credit Card Number',
				#'cc_exp'=>'Credit Card Expiration Date',
                );

my $SCRIPT_URL = url();

#find out which form we want
my $form = path_info();
$form =~ s!^/!!;

if (!$form) {
	register_form();	
}

elsif ($form eq 'register') {
	my ($temp_pass,$body);
	empty_reg_fields();
	my $email = param('email');
	my $name = param('name');
	my $initials = param('initials');
	$email = validate_email($email); #check that it looks like a reasonable address
	check_initials($initials);
	$temp_pass = generate_pass();
	temp_reg($temp_pass);
	#generate the body of the email:
	$body = mail_body($temp_pass,$name);  
	send_email($email,$body,'Temporary Registration');
	return_html();
	exit(0);
	
}

elsif ($form eq 'confirm') {
	confirm_form();
		
}

elsif ($form eq 'confirm2'){ 
	my $password1 = param('password1');
	my $password2 = param('password2');
	
	#make sure new password entered the same twice
	check_password_entry($password1,$password2);
	
	my @reg_info = check_temp_reg();
	
	if (@reg_info) {
		add_user_record(@reg_info);
		return_confirmed_html($reg_info[2]);
		exit(0);	
	}
	else {
		return_not_confirmed_html();
		exit(0);
	}
		
}
else {register_form();} #in case the user altered path_info

############### SUBROUTINES ###############################

sub empty_reg_fields {
        my ($field,@missing_fields);
        foreach $field (keys %required_reg) {
        
                if (!param($field)) {
                        push(@missing_fields,$required_reg{$field});
                }
        }
        if (@missing_fields) { 
                print header,
                start_html(-bgcolor =>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Form Error'),
                h2('Incomplete Form'),
                "The form was not filled out completely. ",
                "You must fill out all required fields.",p,
                b('Empty Form Fields:'),br;
        
        @missing_fields = sort(@missing_fields);   
                for (0..$#missing_fields) {
                        print "$missing_fields[$_]<BR>";
                }
            
                print p,"Please complete the form before submitting.",p,
                a({href=>'javascript:history.go(-1);'},'Please try again.'),
                end_html;
                exit(0);
    }
   
}

sub register_form {
	print header,
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Registration Form'),
	center(
		h2("$AUCTION_TITLE Registration Form"),
		"Use this form to register for $AUCTION_TITLE.",p,
		'Already registered?',
		'&nbsp;&nbsp;&nbsp;',
		a({href=>"$SCRIPT_URL/confirm"},'Confirm Temporary Registration'),p,
	),
		b('Instructions:'),
		(ul
			li('Fill out the registration form completely.'),
			li('A temporary password will be mailed to the email address you enter.'),
			li('After receiving your temporary password, go to the confirmation page.'),
			li('On the confirmation page, enter your email address, temporary password, 
			and select a permanent password.'),
			li('Once this process is completed, you may participate in the auctions.'),
		),
	center(
		start_form(-action=>"$SCRIPT_URL/register"),
		table({-border=>1,-bgcolor=>'#dddddd'},
		Tr(td(	
			table(
			Tr({-align=>'LEFT'},
				th({-align=>'right'},'Your Name: '),
				td({-align=>'left'},textfield(-name=>'name',-size=>30))
			),
			Tr(
				th({-align=>'right'},'Email Address: '),
				td({-align=>'left'},textfield(-name=>'email',-size=>30))
			),
			Tr(
				th({-align=>'right'},'2 - 8 Characters for ID: '),
				td({-align=>'left'},textfield(-name=>'initials',-size=>30))
			),
			Tr(
				th({-align=>'right'},'Street Address: '),
				td({-align=>'left'},textfield(-name=>'address',-size=>30))
			),
			Tr(
				th({-align=>'right'},'City: '),
				td({-align=>'left'},textfield(-name=>'city',-size=>30))
			),
			Tr(
				th({-align=>'right'},'State: '),
				td({-align=>'left'},textfield(-name=>'state',-size=>30))
			),
			Tr(
				th({-align=>'right'},'Zip or Postal Code: '),
				td({-align=>'left'},textfield(-name=>'zip',-size=>30))
			),
			Tr(
				th({-align=>'right'},'Country: '),
				td({-align=>'left'},textfield(-name=>'country',-size=>30))
			),
#uncomment next lines to include credit card info in form
			#Tr(td(b('Credit Card Information:'))),
			#Tr(
			#	th({-align=>'right'},'Card Type: '),
			#	td({-align=>'left'},popup_menu(-name=>'cc_type',-values=>['MasterCard','Visa']))
			#),
			#Tr(
			#	th({-align=>'right'},'Name on Card: '),
			#	td({-align=>'left'},textfield(-name=>'cc_name',-size=>30))
			#),
			#Tr(
			#	th({-align=>'right'},'Card Number: '),
			#	td({-align=>'left'},textfield(-name=>'cc_number',-size=>30))
			#),
			#Tr(
			#	th({-align=>'right'},'Expiration Date: '),
			#	td({-align=>'left'},textfield(-name=>'cc_exp',-size=>15))
			#),
		
			##end of credit card info
			Tr({-align=>'center'},
				td({-colspan=>2},submit(-name=>'ENTER'))
			),
			),
		)),
		),
	),
    end_form,hr,
    font({-size=>'-1'},a({-href=>$WAP,-target=>'_blank'},
    'Web Auction'),br,'Version ',$VERSION,br,'&copy; 1999 by ', a({-href=>$WAM},
    'David Turley')),
    end_html;
		
		
}

sub validate_email {
	my $email = shift;
	
	##for local debugging, address is local user name
	if ($LOCALMAIL) {
	    $email =~ /([a-z]+)/;
	    $email = $1;
	    return $email;
	}

	#so far this check is pretty good
	#if ($email !~ /^[\w\-\.\!\%\+\/]+\@[a-zA-z0-9\-]+(\.[a-zA-Z0-9\-]+)*\.[a-zA-Z0-9\-]+$/){
	if ($email =~ /^([\w\-\.\!\%\+\/]+\@[a-zA-z0-9\-]+(\.[a-zA-Z0-9\-]+)*\.[a-zA-Z0-9\-]+)$/){
	    $email = $1;
	    return $email;
	}
	else {
		print header,
		start_html(-bgcolor =>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Form Error'),
		h2('Invalid Email Address'),
		"It appears that you did not enter a valid email address.",p,
		"Please correct the form before submitting.",p,
		a({href=>'javascript:history.go(-1);'},'Please try again.'),
		end_html;
		exit(0);
	}
}

sub check_initials {
	my $initials = shift;
	
	if ($initials !~ /^[A-Za-z]{2,8}$/){
		print header,
		start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Form Error'),
		h2('Invalid Identifier'),
		'Your initials or identifier must consist of 2 - 8 letters.',p,
		a({href=>'javascript:history.go(-1);'},'Please try again.'),
		end_html;
		exit(0);
	}
}

sub generate_pass {
	#the characters to use for temporary password
	#we don't use o, 0, 1, or l to avoid confusion
	my @chars=("a".."k","m".."n","p".."z",2..9);

	##srand( time() ^ ($$ + ($$ << 15)) );
	my $temp_pass="";
        
	for (my $i=1;$i<=6;$i++){  #generate a 6 character temporary password
		$temp_pass .= $chars[rand(@chars)];
	}
	return $temp_pass;
}

sub add_user_record {
	my $user_file = $INFO_PATH . $USER_FILE;
	
	#since we entered the paths, they should be okay.
	$user_file =~ /^(.*)$/;
	$user_file = $1;
	my @reg_info = @_;
	my $new_pass = param('password1');
	
	my @salt_chars = ('A' .. 'Z', 0 .. 9, 'a' .. 'z', '.', '/');
	my $salt = join '', @salt_chars[rand 64, rand 64];
	my $encrypted = crypt($new_pass, $salt);
	$reg_info[1] = $encrypted;
	open (USERS, ">>$user_file") || error($user_file,'10');
	flock(USERS,2);
	my $new_info = join '|', @reg_info;
	print USERS $new_info;
	close (USERS);
	  
}

sub temp_reg {
	my $temp_password = shift;
	my $time = $TIME;
	my $init = param('initials');
	my $id_string = $init . " from " . param('city') . ', ' . param('state');
	my $user_id = $time . uc($init);
	my $temp_file = $INFO_PATH . $TEMP_FILE;
	
	#since we entered the paths, they should be okay.
	$temp_file =~ /^(.*)$/;
	$temp_file = $1;
	
	my @salt_chars = ('A' .. 'Z', 0 .. 9, 'a' .. 'z', '.', '/');
	my $salt = join '', @salt_chars[rand 64, rand 64];
	my $encrypted = crypt($temp_password, $salt);
	my @reg_param = param();
	my ($item,@reg_info);
	
	#delete submit param from end of list
	pop @reg_param;
	foreach $item (@reg_param) {
		push @reg_info, param($item);
	}
	$reg_info[2] = $id_string;
	unshift @reg_info, $encrypted;
	unshift @reg_info, $user_id;
	@reg_info = notag(@reg_info);
	my $info = join '|', @reg_info;
	
	open (TEMP_FILE, ">>$temp_file") || error($temp_file,'10');
	flock(TEMP_FILE,2);
	print TEMP_FILE "$info\n";
	close (TEMP_FILE);
	    
}

sub mail_body {
	my $temp_password = shift;
	my $name = shift;
	
	my $time = $TIME;
	my $init = param('initials');
	my $ref = $time . uc($init);
	my $body = '';
	
	$body .= "$name, thank you for registering for $AUCTION_TITLE\n";
	$body .= "Your temporary password is:\n\n";
	$body .= "\t$temp_password\n\n";
	$body .= "Please return to the auction registration area to confirm and complete your registration.\n\n";
	$body .= "$SCRIPT_URL/confirm";
	$body .= "\n\nRef\#: $ref\n";
	
	return $body;
}

sub return_html {
	print header,
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Password Sent'),
	center(
		h2('Temporary Password Mailed'),
		'Your temporary password has been sent to the email address you specified.',p,
		'When you have received this temporary password you must go to the confirmation 
		page to complete the auction registration process.',p,
		'The confirmation page is at:',br,
		a({href=>"$SCRIPT_URL/confirm"},"$SCRIPT_URL/confirm"),
	),
	end_html;
}

sub confirm_form {
	print header,
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Confirm Registration Form'),
	center(
		h2('Confirm Auction Registration'),
		"Use this form to confirm your registration for $AUCTION_TITLE.",p,
		'Need to register?',
		'&nbsp;&nbsp;&nbsp;',
		a({href=>"$SCRIPT_URL"},'Register'),p,
		start_form(-action=>"$SCRIPT_URL/confirm2"),
		table({-border=>1,-bgcolor=>'#dddddd'},
		TR(td(	
			table(
			TR(
				th({-align=>'right'},'Enter Your Email Address: '),
				td({-align=>'left'},textfield(-name=>'email',-size=>30))
			),
			TR(
				th({-align=>'right'},'Enter Your Temporary Password: '),
				td({-align=>'left'},password_field(-name=>'temp_password',-size=>30))
			),
			TR(
				th({-align=>'right'},'Enter A New Password: '),
				td({-align=>'left'},password_field(-name=>'password1',-size=>30))
			),
			TR(
				th({-align=>'right'},'Enter New Password Again:'),
				td({-align=>'left'},password_field(-name=>'password2',-size=>30))
			),
			TR({-align=>'center'},
				td({-colspan=>2},submit(-name=>'ENTER'))
			),
			),
		)),
		),
	),
    end_form,hr,
    font({-size=>'-1'},a({-href=>$WAP,-target=>'_blank'},
    'Web Auction'),br,'Version ',$VERSION,br,'&copy; 1999 by ', a({-href=>$WAM},
    'David Turley')),
    end_html;		
}

sub check_password_entry {
	my $pass1 = shift;
	my $pass2 = shift;
	
	if ($pass1 ne $pass2) {
		print header,
			start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Form Error'),
			h2('New Password Not Entered Correctly'),
			"You did not enter your new password the same way both times.",p,
			"Please correct the form before submitting.",p,
			a({href=>'javascript:history.go(-1);'},'Please try again.'),
			end_html;
			exit(0);
    }
}

sub check_temp_reg {
	my ($count,$line,@data,@info,$encrypted,$file_email,$confirmed);
	my $temp_pass = param('temp_password');
	my $email = param('email');
	my $temp_file = $INFO_PATH . $TEMP_FILE;
	
	#since we entered the paths, they should be okay.
	$temp_file =~ /^(.*)$/;
	$temp_file = $1;
	
	if(!-e $temp_file){ #no temp registrations yet
		return;
	}
	
	open (TEMP_FILE, "+>>$temp_file") || error($temp_file,'10');
	flock(TEMP_FILE,2);
    seek TEMP_FILE, 0, 0;
	@data = <TEMP_FILE>;
 
	$count = 0;
	$confirmed = 0;
	foreach $line (@data) {
		@info = split(/\|/,$line);
		$encrypted = $info[1];
		$file_email = $info[3];
		if (($email eq $file_email) && (crypt($temp_pass, $encrypted) eq $encrypted)) {
				$confirmed = 1;
				last;
		}
		else {
			$count++;
		}
        
	}  
	
	if (!$confirmed) {  #can't confirm
		return;
	}
        
	splice (@data, $count, 1);      #remove the listing from temporary file
	seek TEMP_FILE, 0, 0;
	truncate $temp_file, 0;
	foreach $line (@data) {
		print TEMP_FILE $line;
	}
	close(TEMP_FILE);
	
	return @info;
}


sub return_confirmed_html {
	my $name = shift;
	
	print header,
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Registration Completed'),
	center(
		h2('Auction Registration Completed'),
		"$name, your registration has been completed.",p,
		'Go to:',p,
		a({href=>"$AUCTION_URL"},"$AUCTION_URL"),p,
		"to enter $AUCTION_TITLE.",
	),
	end_html;
}

sub return_not_confirmed_html {	
	print header,
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Registration Not Confirmed'),
	center(
		h2('Registration Not Confirmed'),
		"Your temporary registration could not be confirmed.",p,
		"Please be sure you entered your email address and temporary password correctly.",p,
		a({href=>'javascript:history.go(-1);'},'Try again.'),br,
		'If you have not completed the registration form, you may do so here:',p,
		a({href=>"$SCRIPT_URL"},$SCRIPT_URL),	
	),
	end_html;
}

#some people make a hobby of sending image tags, block this
sub notag {
	my @str = @_;
	my $value;
	foreach $value (@str) {
		$value =~ s/<//g;
		$value =~ s/>//g;
	}
	return @str;
}





