# Web Auction Release Version 1.1                                   
# Copyright 1999 David Turley
# <dturley@pobox.com>           
# This program is free software. You may modify and distribute
# it under the same terms as perl itself. 

##$Id: auction-lib.pl,v 1.4 1999/12/13 12:42:20 david Exp david $##

#get global configuration variables
sub get_config {
    open (CONFIG, "auction.cfg") || &error("auction.cfg",10);
    while (<CONFIG>) {
        chomp;
        s/#.*//;
        s/^s+//;
        s/\s+$//;
        next unless length;
        my ($var, $value) = split(/\s*=\s*/,$_,2);
        no strict 'refs';
        $$var = $value;
    }
    close CONFIG;
}
         
##error message
sub error {
    my ($err_str, $err_num) = @_;
    print header(),
    start_html;
    if ($err_num eq '10'){
        print "There is an error accessing the file listed below.<P>$err_str";
        print "<P>Please be sure the path is correct and the proper permissions are set.";
    }
    elsif ($err_num eq '20'){
        print "Sorry, but there does not appear to be any crypt functionality installed on this system.<BR>";
        print "<P>Please see the auction install docs for help.";
    }
    elsif ($err_num eq '30') {
        print "Sorry, I could not get a lock on the file listed below.<P>$err_str";
        print "<P>Please see the auction install docs for help.";
    }
    print end_html;
    exit(0);
}

#get the auction categories
sub get_categories {
    my @cats;
    my %categories;
    my $category_path = $INFO_PATH . $CATEGORY_FILE;
    
    if (!-e $category_path) {
    	#there are no categories set yet, (or they path is wrong which we'll find out when add is attempted
	return %categories;
    }
    
    open(CATEGORY, "$category_path") || &error("$category_path",10);
    while (<CATEGORY>) {
        @cats = split(/=/,$_);
        $categories{$cats[0]} = $cats[1];
    }
    close(CATEGORY);
    return %categories;
}


#format all money amount properly
sub format_amt {
    my $amt = $_[0];
   $amt =~ s/\$//; #get rid of any dollar signs added 4/22/99
   $amt = sprintf "%.2f", $amt;
    return $amt;
}
        

#encrypt a string
sub encrypt {
    my $str = shift;
    my @salt_chars = ('A'..'Z', 0..9, 'a'..'z','.','/');
    my $salt = join '',@salt_chars[rand 64, rand 64];
    my $encrypted = crypt($str,$salt);
    return $encrypted;
}


#get time string pieces for date/time menus
sub get_time_pieces {
    my ($time_str) = $_[0];
    my($sec,$minute,$hour,$day,$mon,$year,$wday,$yday) = localtime($time_str);
    my $ampm;
    
	#get month name
	my $month = ('January','February','March','April','May','June','July',
    'August','September','October','November','December')[$mon];

	#add 0 where needed to minutes and seconds
	if ($minute < 10) {$minute = "0$minute";}
	
	$year += 1900;
	    
	return ($month,$day,$year,$hour,$minute);
}

#convert date/time string into epoch seconds
sub get_time_digits {
    
    my ($str) = $_[0];
    #$str =~ s/,//g;
    my ($month_name,$day,$year,$time_str) = split ' ',$str;

	my %MONTHS = ('January' => '0',
	            'February' => '1',
	            'March' =>  '2',
	            'April' => '3',
	            'May' => '4',
	            'June' => '5',
	            'July' => '6',
	            'August' => '7',
	            'September' => '8',
	            'October' => '9',
	            'November' => '10',
	            'December' => '11'
	            );
	           
	        
	my $month = $MONTHS{$month_name};
	my ($hour,$minute,$sec) = split /:/,$time_str;
    
	if ($year > 1900) {$year -= 1900;}
	
	my ($time) = timelocal($sec,$minute,$hour,$day,$month,$year);
	return $time;

}

#make time into pretty string
sub format_time {

    my ($time_str) = $_[0];
    my($month_name,$day_name,$date,$ampm);
    my($sec,$min,$hour,$mday,$mon,$year,$wday,$yday) = localtime($time_str);
    
    #time zone stuff
   	my($isdst) = (localtime)[8];
    my ($offset,$tz);
    if (($isdt != 0) && ($isdt != 1)) {
    	$tz eq ''; #can't determine daylight savings, so skip time zone
    }
    else {
    	$offset = tz_offset();
		$tz = TZoffset_to_TZname($offset,$isdst);
	}
	
	#get day name
	$day_name = ('Sunday','Monday','Tuesday','Wednesday',
	'Thursday','Friday','Saturday')[$wday];

	#get month name
	$month_name = ('January','February','March','April','May','June','July',
    'August','September','October','November','December')[$mon];
    
    if($TIME_TYPE == 1){
	    #determine AM or PM so we can use 12 hour clock
	    if ($hour > 11) {$ampm='PM';}
	    else {$ampm='AM';}

	    #convert to 12 hour clock
	    if ($hour > 12) {$hour -= 12;}
	    if ($hour == 0) {$hour = 12;}
    }

	#add 0 where needed to minutes and seconds
	if ($min < 10) {$min = "0$min";}
	if ($sec < 10) {$sec = "0$sec";}
	
	$year += 1900;
	if($TIME_TYPE == 1){    
		$date = "$day_name, $month_name $mday, $year $hour\:$min\:$sec $ampm $tz";
	}
	else {
		$date = "$day_name, $month_name $mday, $year $hour\:$min\:$sec $tz";
	}
	
	return $date;
}

#generic sort function by Joseph Hall, joseph@5sigma.com 
sub fieldsort {
	my ($sep, $cols);
	if (ref $_[0]) {
		$sep = '\\s+'
	} 
	else {
		$sep = shift;
	}
	unless (ref($cols = shift) eq 'ARRAY') {
		die "fieldsort columns must be in anon array";
	}
	my (@sortcode, @col);
	my $col = 1;
	for (@$cols) {
		my ($a, $b) = /^-/ ? qw(b a) : qw(a b);
		my $op = /n$/ ? '<=>' : 'cmp';
		push @col, (/(\d+)/)[0] - 1;
		push @sortcode, "\$${a}->[$col] $op \$${b}->[$col]";
	$col++;
	 }
	my $sortfunc = eval "sub { " . join (" or ", @sortcode) . " } ";
	my $splitfunc = eval 'sub { (split /$sep/o, $_)[@col] } ';
	return
	map $_->[0],
	sort { $sortfunc->() }
	map [$_, $splitfunc->($_)],
	@_;
}



#######timezone routines by Larry Rosler
# TZname_to_TZoffset: Convert timezone abbreviation to offset from UTC.
# TZoffset_to_TZname: Convert offset from UTC to timezone abbreviation.
# Larry Rosler, 25 February 1999
#
# TZname_to_TZoffset returns the offset from UTC (in hours) of the
#     first apparent timezone abbreviation in its argument, or undef
#     if the argument is invalid or the timezone abbreviation is
#     not defined.  Upper- and lower-case distinctions are ignored.
#
# TZoffset_to_TZname returns the timezone abbreviation corresponding
#     to the first apparent offset from UTC (in hours) in its argument,
#     or undef if the argument is invalid or a timezone with that
#     offset is not defined.  If the optional second argument has a
#     TRUE value, the offset is interpreted as if Daylight Savings Time
#     (Summer Time) is in effect.


# This list follows the conventions of the Unix TZ environment variable
# (see /usr/lib/tztab).  It has two uses:
# 1.  To derive a UTC offset from a specified timezone abbreviation.
# The order of the list favors the North American entries (CST, CDT and
# EST) over the Chinese and Australian.
# 2.  To derive a timezone abbreviation from a specified UTC offset.
# The order of the list favors the most populous name.
# These orderings may be changed locally.
#
# The primary source is ftp://elsie.nci.nih.gov/pub/tzdata1998c.tar.gz .
# The detailed names are descriptive comments only, and are not used.


my @data = qw{
LINT-14          Line Islands (Kiribati)
PHOT-13          Phoenix Islands (Kiribati)
TOT-13           Tonga
CHAST-12:45CHADT Chatham Island (New Zealand)
WFT-12           Wallis & Futuna
WAKT-12          Wake
TVT-12           Tuvalu
NRT-12           Nauru
MHT-12           Marshall Islands
KOST-12          Kosrae (Micronesia)
GILT-12          Gilbert Islands (Kiribati)
FJT-12           Fiji
NZST-12NZDT      New Zealand
NFT-11:30        Norfolk (Australia)
SBT-11           Solomon Islands
PONT-11          Ponape (Micronesia)
NCT-11NCST       New Caledonia
VUT-11VUST       Vanuatu
LHST-10:30LHST   Lord Howe Island (Australia)
YAPT-10          Yap (Micronesia)
TRUT-10          Truk (Micronesia)
PGT-10           Papua New Guinea
MPT-10           Mariana Islands
EST-10           Eastern Australia
CST-9:30         Central Australia
PWT-9            Palau
KST-9            Korea
JAYT-9           Jayapura (Indonesia)
JST-9            Japan
WST-8            Western Australia
ULAT-8ULAST      Ulan Bator (Mongolia)
SGT-8            Singapore
PHT-8PHST        Philippines
MYT-8            Malaysia
BNT-8            Brunei
BORT-8           Borneo (Indonesia)
CST-8CDT         China
CXT-7            Christmas Island (Australia)
JAVT-7           Java (Indonesia)
ICT-7            Indochina
CCT-6:30         Cocos (Australia)
MMT-6:30         Myanmar (formerly Burma)
LKT-6            Sri Lanka
BTT-6            Bhutan
ALMT-6ALMST      Alma-Ata (Kazakhstan)
BDT-6            Bangladesh
NPT-5:45         Nepal
IST-5:30         India
UZT-5            Uzbekistan
TMT-5            Turkmenistan
TJT-5            Tajikistan
MVT-5            Maldives
KGT-5KGST        Kyrghyzstan
IOT-5            British Indian Ocean Territory
GET-5            Georgia
AQTT-5AQTST      Aqtobe (Kazakhstan)
PKT-5            Pakistan
AFT-4:30         Afghanistan
SCT-4            Seychelles
RET-4            Reunion
AZT-4AZST        Azerbaijan
AMT-4AMST        Armenia
GST-4            Gulf
IRT-3:30IRST     Iran
EAT-3            Eastern Africa
AST-3ADT         Arabia
MSK-3MSD         Moscow
SAST-2           South Africa
EET-2EEST        Eastern Europe
CAT-2            Central Africa
IST-2IDT         Israel
WAT-1WAST        Western Africa
MEZ-1MESZ        Germany
CET-1CEST        Central Europe
UTC0             Universal Coordinated
WET0WEST         Western Europe
GMT0BST          Greenwich Mean/British Summer
EGT1EGST         Eastern Greenland
AZOT1AZODT       Azores (Portugal)
FST2FDT          Fernando de Noronha (Brazil)
WGT3WGST         Western Greenland
ART3ARST         Argentina
NST3:30NDT       Newfoundland
AST4ADT          Atlantic
HNE5HAE          Quebec
EST5EDT          Eastern
CST6CDT          Central
MST7MDT          Mountain
PST8PDT          Pacific
PNT8:30          Pitcairn
GAMT9            Gambier Islands (French Polynesia)
AKST9AKDT        Alaska
MART9:30         Marquesas Islands (French Polynesia)
CKT10CKHST       Cook Islands (New Zealand)
TKT10            Tokelau
TAHT10           Tahiti (French Polynesia)
GST10            Guam
HAST10HADT       Hawaii-Aleutians
HST10            Hawaii
WST11            Western Samoa
NUT11            Niue
SST11            American Samoa
};

# Preprocess the data to convert minutes to fractions of hours and to
# eliminate the comments.  The result is three hashes.
my (%tz_name, %tz_std, %tz_dst);
for (@data) {
    next unless /^([A-Z]+)(-?\d+):?(\d*)([A-Z]*)/;
    my $off = 0 - ($2 . ($3 && '.' . $3 * 100 / 60));
    $tz_name{$1} = $off;
    $tz_std{$off} = $1;
    next unless $4;
    $tz_name{$4} = ++$off;
    $tz_dst{$off} = $4;
}

sub TZname_to_TZoffset {
    defined $_[0] && $_[0] =~ /([A-Za-z]{3,})/ ?
        $tz_name{uc $1} : undef
}

sub TZoffset_to_TZname {
    defined $_[0] && $_[0] =~ /([+-]?(?:\d+\.?\d*|\.\d+))/ ?
        $_[1] ? $tz_dst{$1} : $tz_std{$1} : undef
}



# tz_offset: Compute the offset of the local timezone from UTC.
# Larry Rosler, February 19, 1999

# tz_offset returns the offset of the local timezone from UTC,
# at the epoch time specified by the argument (if any) or at the
# current time if no argument is specified.

# The value of the offset is returned in hours (and fractions).
# For example, (North American) Eastern Standard Time is -5,
# India Time is +5.5.  This convention conforms to international
# usage, but has the opposite sign of that used by the Unix TZ
# environment variable.
sub tz_offset {
    my $now = defined $_[0] ? $_[0] : time;
    my ($l_min, $l_hour, $l_year, $l_yday) =
                            (localtime $now)[1, 2, 5, 7];
    my ($g_min, $g_hour, $g_year, $g_yday) =
                               (gmtime $now)[1, 2, 5, 7];
    ($l_min - $g_min)/60 + $l_hour - $g_hour +
        24 * ($l_year - $g_year || $l_yday - $g_yday)
}

###########

sub nospace {
	my $str = shift;
	$str =~ s/^\s+//;  #remove any leading spaces
	$str =~ s/\s+$//;  #remove any trailing spaces
	return $str;
}

sub send_email {
	
    my $to = shift;
    my $body = shift;
    my $action = shift;
    $subject = $AUCTION_TITLE . ' ' . $action;
    my $from = $MAIL_FROM;
    my $sendmail = $MAIL_SERVER;
    $sendmail =~ /^(.*)$/;
    $sendmail = $1;
	
    open (SENDMAIL, "| $sendmail -t") || error($sendmail,10);
    print SENDMAIL "Subject: $subject\n";
    print SENDMAIL "From: $from\n";
    print SENDMAIL "To: $to\n\n";
    print SENDMAIL "$body\n";
    close (SENDMAIL);

}

###DO NOT EDIT NEXT LINE###
1;
