#!/usr/bin/perl

# Web Auction Release Version 1.1                                   
# Copyright 1999 David Turley
# <dturley@pobox.com>           
# This program is free software. You may modify and distribute
# it under the same terms as perl itself. 

##$Id: auction_admin.cgi,v 1.6 1999/12/14 12:24:40 david Exp david $##

require 5.005;

use CGI qw/:all/;
use CGI::Carp(fatalsToBrowser);
use Time::Local;
use strict;

#need this line when tainting turned on to be sure and include library files
#this is the directory that contains the script usually
use lib qw(/web/cgi-bin);

##thisfile is probably in same directory as scripts, if not, edit 
require 'auction-lib.pl';

##get the global set up variables
#auction.cfg should exist in same directory as this script
get_config();

use vars qw($INFO_PATH $TIME_TYPE $CATEGORY_FILE 
		$ADMIN_PASS_FILE $USER_FILE $DATE_VALIDATE_JS $WAP $WAM $VERSION); 
       
my $TIME = time;

##variables for date/time menus
my @years = qw(1999 2000 2001 2002);
my @months = qw(January February March April May June July
    August September October November December);
my @days = (1..31);
my @hours = (0..23);
my @minutes = qw(00 15 30 45);

my $job=param('job');

# If no path information is provided, then we send the login screen
if (!$job){
    print_frameset();
    exit(0);
}

#Main frameset done, what job do we do now?
print_login() if $job eq 'login';
check_login() if $job eq 'check_pass';
print_main_menu() if $job eq 'main_menu';
print_add_form() if $job eq 'Add Item';
add_item() if $job eq 'add_item2';
modify_list() if $job eq 'Modify Item';
modify_item() if $job eq 'modify_item2';
commit_modify() if $job eq 'modify_commit';
delete_list() if $job eq 'Delete Item';
delete_all() if $job eq 'Delete All Items';
delete_checked() if $job eq 'Delete Checked Items';
category_menu() if $job eq 'Edit Categories';
add_category() if $job eq 'Add This Category';
remove_category() if $job eq 'Remove This Category';
confirm_cat() if $job eq 'confirm_cat';
dup_cat() if $job eq 'dup_cat';
password_menu() if $job eq 'Change Password';
change_password() if $job eq 'change_password';
bid_history() if $job eq 'Closed Items';
log_off() if $job eq 'Log Off';
user_info() if $job eq 'user_info';
export_file() if $job eq 'Export User File';
import_data1() if $job eq 'Import Data File';
show_users() if $job eq 'Delete User';
delete_users() if $job eq 'Delete Checked Users';
show_history_for_move() if $job eq 'Add From History';
add_from_history() if $job eq 'Add Checked Items';
delete_from_history() if $job eq 'delete_from_history';
show_log() if $job eq 'Show Log';
delete_from_log() if $job eq 'Delete Log Entry';

sub remove_category {
    check_cookie();
    my $script = url();
    my $key = param('delete_key');
    my $category_path = $INFO_PATH . $CATEGORY_FILE;
    open(CATEGORY, "$category_path") || error($category_path,'10');
    my @categories = <CATEGORY>;
    my $line;
    my $found = 0;
    close (CATEGORY);
    
    open(CATEGORY, ">$category_path") || error($category_path,'10');
    flock(CATEGORY,2);
    foreach $line (@categories) {
    	if ($line =~ /^$key/o) {
    		$found = 1;
    	}
    	else {
    		print CATEGORY $line;
    	}
    }

    close CATEGORY;
    
    if ($found) {refresh_menu('success');}
    else {refresh_menu('fail');}

}

sub change_password {
	check_cookie();
	my $pass1 = param('password1');
	my $pass2 = param('password2');
	check_password_entry($pass1,$pass2);
	my $adminPass_path = $INFO_PATH . $ADMIN_PASS_FILE;
	my $new_password = param('password1');
	my $encrypted = encrypt($new_password);
	open(PASS, ">$adminPass_path") || error($adminPass_path,'10');
    flock(PASS,2);
    print PASS $encrypted;
    close PASS;
    
    print header(-expires=>'-1d'),
    start_html(-title=>'Password Changed',-bgcolor=>'white'),
    'Your administrator password has been successfully changed.',p,
    'You may select another option from the menu.',
    end_html;
    
}

sub check_password_entry {
	my ($pass1,$pass2) = @_;

	if ($pass1 ne $pass2) {
		print header(-expires=>'-1d'),
			start_html(-bgcolor => '#ffffff',-title=>'Form Error'),
			h2('New Password Not Entered Correctly'),
			"You did not enter your new password the same way both times.",p,
			"Please correct the form before submitting.",p,
			a({href=>'javascript:history.go(-1);'},'Please try again.'),
			end_html;
			exit(0);
    }
}
sub password_menu {
	check_cookie();
    my $script = url();
    print header(-expires=>'-1d'),
    start_html(-title=>'Change Administrator Password',
                    -bgcolor=>'white'),

    h1({-align=>'center'},'Change Administrator Password'),
    'Use this form to change your administrator password.',p,
    start_form(-action=>"$script"),
		table(
			TR(
				th({-align=>'right'},'Enter A New Password: '),
				td({-align=>'left'},password_field(-name=>'password1',-size=>30))
			),
			TR(
				th({-align=>'right'},'Enter New Password Again:'),
				td({-align=>'left'},password_field(-name=>'password2',-size=>30))
			),
			TR({-align=>'center'},
				td({-colspan=>2},submit(-name=>'CHANGE'))
			),
		),
	hidden(-name=>'job',-value=>'change_password',-override=>1),
    end_form,
    end_html;  
    exit(0);         
}
   
sub delete_checked {
	check_cookie();
    my $script = url();
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    my $data_file = $INFO_PATH . $category_key . ".dat";
    my @items = param('item');
    my ($line,$expr,$match_any,@data);

	open(DATA, "+>>$data_file") || error($data_file,'10');
    flock(DATA,2);
    seek DATA, 0, 0;
    @data = <DATA>;
    
	$expr = join(' || ',map { "m/$items[$_]/o" } 0..$#items);
	$match_any = eval "sub { $expr }";
	seek DATA, 0, 0;
	truncate $data_file, 0;
	for (@data) {
		next if &$match_any;
		print DATA $_;
	} 

	close(DATA);
	delete_list();
}
	
#category already exists
sub dup_cat {
	my $script = url();
    print header(-expires=>'-1d'),
    start_html(-title=>'Categories Not Modified',
                    -bgcolor=>'white'),
    'The category list was not changed.',p,
    'You either tried to add a category that already exists, or tried to delete a
    category that does not exist.',p,
    'Please select another key.',p,
    start_form(-action=>$script,
                    -target=>'main'),
    hidden(-name=>'job',-value=>'Edit Categories',-override=>1),
    submit(-label=>'Try Again'),
    end_form(),
    end_html;

    exit(0);    
} 

#confirm a category edit
sub confirm_cat {
	my $script = url();
    print header(-expires=>'-1d'),
    start_html(-title=>'Categories Modified',
                    -bgcolor=>'white'),
    "The category menu has been refreshed with your changes.",p,
    "You may select another option from the menu or add or delete another category.",
    p,
    start_form(-action=>$script,
                    -target=>'main'),
    hidden(-name=>'job',-value=>'Edit Categories',-override=>1),
    submit(-label=>'Edit Categories'),
    end_form(),
    end_html;
    exit(0);  
} 

#add a category
sub add_category {
    check_cookie();
    my $script = url();
    my $category = param('category_name');
    my $new_key = param('category_key');
    my $category_path = $INFO_PATH . $CATEGORY_FILE;
    my %categories = get_categories();
    my $key;
    foreach $key (sort keys %categories){
        if ($key eq $new_key){
            refresh_menu('fail');
            last;
        }
    }
    open(CATEGORY, ">>$category_path") || &error($category_path,'10');
    flock(CATEGORY,2);
    print CATEGORY "$new_key=$category\n";
    close CATEGORY;
    
    refresh_menu('success');

}

#redraw frameset after a category edit
sub refresh_menu {
    my $result = $_[0];
    my $script = url();
    print header(-expires=>'-1d');

    print <<HTML;
    <HTML><HEAD>
    <TITLE>Web Auction Administration</TITLE></HEAD>
    <frameset  cols="25%,*"  border="1">
    <frame name="menu" src="$script?job=main_menu" marginwidth="5" marginheight="0" scrolling="no" noresize>
HTML
    if ($result eq 'success'){
        print <<HTML;
    <frame name="main" src="$script?job=confirm_cat" marginwidth="5" marginheight="0" scrolling="auto" noresize>
HTML
    }
    else{
        print <<HTML;
        <frame name="main" src="$script?job=dup_cat" marginwidth="5" marginheight="0" scrolling="auto" noresize>
HTML
    }
        
    print "</frameset></HTML>";
    exit(0);        
}

#print the form to add/delete categories
sub category_menu {
    check_cookie();
    my $script = url();
    my %categories = get_categories();
    my $key;
    
    print header(-expires=>'-1d'),
    start_html(-title=>'Edit Auction Categories',
                    -bgcolor=>'white'),

    h1({-align=>'center'},'Edit Auction Categories'),
    p,
    "Use this form to edit the categories in your auction.",p,
    b('Labels'), " are the names of the categories that your visitors will see.",br,
    b('Keys'), " are used to create data files and must be single words.",p;
    
    print "<table border = \"1\" cellpadding = \"3\">";
    print "<tr><th colspan=\"2\" bgcolor=\"#FAFAD2\">";
    print "Current Categories</th></tr>";
    print "<th>Label</th><th>Key</th></tr>";
    
    foreach $key (sort keys %categories){
        print "<tr><td>$categories{$key}</td><td>$key</td></tr>";
    }
    print "</table>";
    
    print start_form(-action=>$script,
                    -target=>'_top'),
        b('New Category Name: '),
        textfield(-name=>'category_name',-size=>30),p,
        b('New Category Key: '),
        textfield(-name=>'category_key',-size=>15),p,
        submit(-name=>'job',-value=>'Add This Category'),p,
        end_form,
        hr,
        start_form(-action=>$script,
                    -target=>'_top'),
        "Enter a category key to remove that category.",p,
        b('Category To Remove: '),
        textfield(-name=>'delete_key',-size=>15),p,
        submit(-name=>'job',-value=>'Remove This Category',-override=>1),p,
        
        end_form(),
        
        end_html();
}        
    

#delete all items
sub delete_all {
    check_cookie();
    my $script = url();
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    my $data_file = $INFO_PATH . $category_key . ".dat";
    
    unlink $data_file;
    print header(-expires=>'-1d'),
    start_html(-title=>'All Items Deleted',-bgcolor=>'white'),
    "All items in category $category have been deleted.",p,
    end_html;
        
}
#get a list of items to delete
sub delete_list {    
    check_cookie();
    my $script = url();
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    my $data_file = $INFO_PATH . $category_key . ".dat";
    my $line;
    if ((!-e $data_file) || (-z $data_file)) {
        print header(-expires=>'-1d'),
        start_html,
        "There are no items in $category.",br,
        "Please use the &quot;Add Item&quot; button to add items to this category
        or choose another category.",
        end_html;
        exit(0);
    }
    open(DATA, "$data_file") || &error($data_file,'10');
    print header(-expires=>'-1d'),
    start_html(-title=>'Delete Auction Item',
                    -bgcolor=>'white'),

    h1({-align=>'center'},'Delete Auction Item'),
    b("Category: $category"),p,
    b("Note: "),"You probabaly don't need this function. Items are deleted from 
    the data files when they are no longer displayed. All deletions are permanent, please be sure you have recorded all 
    bidder information before deleting items.",p,
    start_form(-action=>$script,
                    -target=>'main'),
    #hidden(-name=>'job',-value=>'delete_item2',-override=>1),
    hidden(-name=>'category',-value=>$category_key),
    submit(-name=>'job',-value=>'Delete All Items'),p,
    hr,p,
    "Select items to delete from the list below",p,
    submit(-name=>'job',-value=>'Delete Checked Items');
    
    print "<TABLE BORDER=1><TR>";
    print "<TH>Check</TH><TH>Number</TH><TH>Name</TH><TH>Open</TH><TH>Close</TH></TR>";
    while (defined($line = <DATA>)) {
        chomp $line;
        my ($item_number,$open_digits,$close_digits,$item_name) = split(/\|/,$line);
        my $open_time = format_time($open_digits);
        my $end_time = format_time($close_digits);
        print "<TR>";
        print "<TD><INPUT TYPE=\"checkbox\" NAME = \"item\" VALUE=\"$item_number\"></TD>";
        print "<TD>$item_number</TD><TD>$item_name</TD><TD>$open_time</TD>";
        print "<TD>$end_time</TD></TR>";
    }
    print "</TABLE>";
    close DATA;
    print end_form,
    end_html;

    exit(0);
}           
    

#commit modification
sub commit_modify {
    
    check_cookie();
    my $script = url();
    
    my $item_number = param('item');
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    my $data_file = $INFO_PATH . $category_key . ".dat";
    my $item_name = param('item_name');
    my $opening_bid = param('opening_bid');
    $opening_bid = format_amt($opening_bid);
    my $min_increase = param('min_increase');
    $min_increase = format_amt($min_increase);
    my $open_day = param('open_month') . " " . param('open_day') . " " .param('open_year');
    my $open_time = param('open_hour') . ":" . param('open_minute') . ":00";
    my $open_str = $open_day . " " .$open_time;
    my $open_digits = get_time_digits($open_str);
    
    my $close_day = param('close_month') . " " . param('close_day') . " " .param('close_year');
    my $close_time = param('close_hour') . ":" . param('close_minute') . ":00";
    my $close_str = $close_day . " " .$close_time;
    my $close_digits = get_time_digits($close_str);
    
    my $item_url = param('item_url');
    my $item_desc = param('item_desc');
    #fix to get rid of any embedded line feeds in desc, Feb 11, 1999
    $item_desc =~ s/([\012\015]*)(\012\015?|\015\012?)//g;
    my ($line,@info);

    open(DATA, "+>>$data_file") || &error($data_file,'10');
    flock(DATA,2);
    seek DATA, 0, 0;
    my @list = <DATA>;
    
    seek DATA, 0, 0;
	truncate $data_file, 0;
    foreach $line (@list) {
    	chomp $line;
		if ($line =~ /^$item_number/o){ 
		    @info = split(/\|/,$line,9);
    
            $info[1] = $open_digits;
            $info[2] = $close_digits;
            $info[3] = $item_name;
            $info[4] = $opening_bid;
            $info[5] = $min_increase;
            $info[6] = $item_url;
            $info[7] = $item_desc;
            my $new_info = join '|', @info;
            print DATA "$new_info\n";
		}
		
		else {
			print DATA "$line\n";
		}
	}
    
    close(DATA);
    
    print header(-expires=>'-1d'),
    start_html(-title=>'Item Modified',
                    -bgcolor=>'white'),
    "The following item has been modified in category $category:",p,
    "Item number: $item_number",br,
    "Item name: $item_name",p,
    "Click below to modify another item or select another option from the menu.",
    p,
    start_form(-action=>$script,
                    -target=>'main'),
    hidden(-name=>'job',-value=>'Modify Item',-override=>1),
    hidden(-name=>'category',-value=>$category_key),

    submit(-label=>'Modify Another Item'),
        
    end_form(),
    end_html;

    exit(0);   

}

#present mod form for selected item
sub modify_item {

    check_cookie();
    
    my $script = url();
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    my $item_number = param('item');
    
    my $data_file = $INFO_PATH . $category_key . ".dat";
    my ($line,@info);
    my($item,$open_digits,$close_digits,$item_name,$opening_bid,$min_increase,$item_url,$item_desc);
    
    open(DATA, "$data_file") || &error($data_file,'10');
    my @list = <DATA>;
    close DATA;
    
    foreach $line (@list) {
		if ($line =~ /^$item_number/o){ 
		    @info = split(/\|/,$line,9);
    
            $item = $info[0];
            $open_digits = $info[1];
            $close_digits = $info[2];
            $item_name = $info[3];
            $opening_bid = $info[4];
            $min_increase = $info[5];
            $item_url = $info[6];
            $item_desc = $info[7];
            #$bidder_id = $info[8];
            #$bidder_initials = $info[9];
            #$current_bid = $info[10];
            #$bid_time = $info[11];
		    last;
		}
	}
    
    my ($open_month,$open_day,$open_year,$open_hour,$open_minute)=get_time_pieces($open_digits);
    my ($close_month,$close_day,$close_year,$close_hour,$close_minute)=get_time_pieces($close_digits);
    
    print header(-expires=>'-1d'),
    start_html(-title=>'Modify Item Menu',
                    -bgcolor=>'white',
                    -script=>$DATE_VALIDATE_JS),

    h1({-align=>'center'},'Modify Auction Item');

    print <<HTML;
    
    Use this form to modify the following item.<BR>
    The item is in the category shown below.<P>
    Click &quot;Save Changes&quot; to enter your changes.<BR>
    Click &quot;Reset Values&quot; to reset to the original values.<BR>
       
HTML

print center(
    start_form(-action=>$script,
               -target=>'main',
               -name=>'addForm',
               -onSubmit=>'return checkStartDate()'),
               
    table({-border=>1,-cellpadding=>3,-cellspacing=>3},
            Tr(
                th({-bgcolor=>'#FAFAD2',-colspan=>2},"Item: $item -- Category: $category"),
            ),
            Tr(
                td('Item Name: '),
                td(textfield(-name=>'item_name',-size=>30,-default=>$item_name)),
            ),
            Tr(
                td('Opening Bid: '),
                td(textfield(-name=>'opening_bid',-size=>15,-default=>$opening_bid)),
            ),
            Tr(
                td('Minimum Bid Increase: '),
                td(textfield(-name=>'min_increase',-size=>15,-default=>$min_increase)),
            ),
            Tr(
                td('Opening Date: '),
                td(popup_menu(-name=>'open_month',
                    -values=>\@months,
                    -default=>$open_month),
                
                   popup_menu(-name=>'open_day',
                    -values=>\@days,
                    -default=>$open_day),
        
                  popup_menu(-name=>'open_year',
                    -values=>\@years,
                    -default=>$open_year)
                ),
             ),
             Tr( 
                td('Opening Time: '),
                td(popup_menu(-name=>'open_hour',
                    -values=>\@hours,
                    -default=>$open_hour),b(':'),
        
                   popup_menu(-name=>'open_minute',
                    -values=>\@minutes,
                    -default=>$open_minute),
        
                ),
             ),
            Tr(
                td('Closing Date: '),
                td(popup_menu(-name=>'close_month',
                    -values=>\@months,
                    -default=>$close_month),
              
                   popup_menu(-name=>'close_day',
                    -values=>\@days,
                    -default=>$close_day),
        
                   popup_menu(-name=>'close_year',
                    -values=>\@years,
                    -default=>$close_year)
                ),
             ),
             Tr( 
                td('Closing Time: '),
                td(popup_menu(-name=>'close_hour',
                    -values=>\@hours,
                    -default=>$close_hour),b(':'),
        
                   popup_menu(-name=>'close_minute',
                    -values=>\@minutes,
                    -default=>$close_minute),
        
                ),
             ),
             Tr(
                td('Item URL: '),
                td(textfield(-name=>'item_url',-size=>30,-default=>$item_url)),
             ),
             Tr(
                td('Brief Description: '),
                td(textarea(-name=>'item_desc',-rows=>3,
                    -cols=>30,-wrap=>'virtual',-default=>$item_desc),
                ),
             ),
             Tr(
                td({-align=>'center',-colspan=>2},
                submit(-label=>'Save Changes'),
                reset(-label=>'Reset Values'),
                ),
             ),
         ),
         
         	hidden(-name=>'item',-value=>$item,-override=>1),
            hidden(-name=>'category',-value=>$category_key,-override=>1),
            hidden(-name=>'job',-value=>'modify_commit',-override=>1),
           	#hidden(-name=>'bidder_id',-value=>$bidder_id,-override=>1),
            #hidden(-name=>'bidder_initials',-value=>$bidder_initials,-override=>1),
            #hidden(-name=>'current_bid',-value=>$current_bid,-override=>1),
            #hidden(-name=>'bid_time',-value=>$bid_time,-override=>1),

        end_form(),
     ),
        end_html();
        
    exit(0);
}

#get a list of items with checkboxes
sub modify_list {    
    check_cookie();
    my $script = url();
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    my $data_file = $INFO_PATH . $category_key . ".dat";
    my $line;
    if ((!-e $data_file)  || (-z $data_file)) {
        print header(-expires=>'-1d'),
        start_html,
        "There are no items in $category to modify yet.",br,
        "Please use the &quot;Add Item&quot; button to add items to this category
        or choose another category.",
        end_html;
        exit(0);
    }
    open(DATA, "$data_file") || &error($data_file,'10');
    print header(-expires=>'-1d'),
    start_html(-title=>'Modify Auction Item',
                    -bgcolor=>'white'),

    h1({-align=>'center'},'Modify Auction Item'),
    b("Category: $category"),br,
    "Select an item to modify from the list below",p,
    start_form(-action=>$script,
                    -target=>'main'),
    hidden(-name=>'job',-value=>'modify_item2',-override=>1),
    hidden(-name=>'category',-value=>$category_key),

    submit(-label=>'Modify Checked Item');
    
    print "<TABLE BORDER=1><TR>";
    print "<TH>Check</TH><TH>Number</TH><TH>Name</TH><TH>Open</TH><TH>Close</TH></TR>";
    while (defined($line = <DATA>)) {
        chomp $line;
        my ($item_number,$open_digits,$close_digits,$item_name) = split(/\|/,$line);
        my $open_time = format_time($open_digits);
        my $end_time = format_time($close_digits);
        print "<TR>";
        print "<TD><INPUT TYPE=\"radio\" NAME = \"item\" VALUE=\"$item_number\"></TD>";
        print "<TD>$item_number</TD><TD>$item_name</TD><TD>$open_time</TD>";
        print "<TD>$end_time</TD></TR>";
    }
    print "</TABLE>";
    close DATA;
    print end_form,
    end_html;

    exit(0);
}        

#add the new item
sub add_item {

    check_cookie();
    my $script = url();
    
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    
    my $item_name = param('item_name');
    my $opening_bid = param('opening_bid');
    $opening_bid = format_amt($opening_bid);
    my $min_increase = param('min_increase');
    $min_increase = format_amt($min_increase);
    my $open_day = param('open_month') . " " . param('open_day') . " " .param('open_year');
    my $open_time = param('open_hour') . ":" . param('open_minute') . ":00";
    my $open_str = $open_day . " " .$open_time;
    my $open_digits = get_time_digits($open_str);
    
    my $close_day = param('close_month') . " " . param('close_day') . " " .param('close_year');
    my $close_time = param('close_hour') . ":" . param('close_minute') . ":00";
    my $close_str = $close_day . " " .$close_time;
    my $close_digits = get_time_digits($close_str);
    
    my $item_url = param('item_url');
    $item_url = nospace($item_url); #some admins are putting spaces in
    my $item_desc = param('item_desc');
    #fix to get rid of any embedded line feeds in desc, Feb 11, 1999
    #$item_desc =~ s/(\n+)//g;
    #$item_desc =~ s/([\012\015]+)//g;
    $item_desc =~ s/([\012\015]*)(\012\015?|\015\012?)//g;
    
    my $item_number = $TIME; #get a unique item number
    my $data_file = $INFO_PATH . $category_key . ".dat";
    
    open(DATA, ">>$data_file") || &error($data_file,'10');
    flock(DATA,2);
    print DATA "$item_number|$open_digits|$close_digits|$item_name|";
    print DATA "$opening_bid|$min_increase|$item_url|$item_desc|";
    #bidder id, bidder initials, bidder email, current bid, bid time, closed_flag
    print DATA "0|0|0|0|0|0\n";
    close DATA;
    
    
    print header(-expires=>'-1d'),
    start_html(-title=>'Item Added',
                    -bgcolor=>'white'),
    "The following item has been added to category $category:",p,
    "Item number: $item_number",br,
    "Item name: $item_name",p,
    "Click below to add more items or select another option from the menu.",
    p,
    start_form(-action=>$script,
                    -target=>'main'),
    hidden(-name=>'job',-value=>'Add Item',-override=>1),
    hidden(-name=>'category',-value=>$category_key),

    submit(-label=>'Add Item'),
        
    end_form(),
    end_html;

    exit(0);   

}
#print the admin login screen
sub print_login {
    my $script = url();
    print header(-expires=>'-1d'),
    start_html(-title=>'Administrator Login',
                    -bgcolor=>'white'),
        center(      
        h1('Auction Administrator Login'),
        
        start_form(-action=>$script,
                    -target=>'main'),
        
        'Please enter your Auction Administrator Password',p,
        password_field(-name=>'password',-size=>30),
        hidden(-name=>'job',-value=>'check_pass', -override=>1),p,
        submit(-label=>'Check Me In'),
        
        end_form(),
        ),
        end_html();
        
    exit(0);
}

#check admin password
sub check_login {
    my $adminPass_path = $INFO_PATH . $ADMIN_PASS_FILE;
    my $password = param('password');
    open(PASS, "$adminPass_path") || &error($adminPass_path,'10');
    my $encrypted_password = <PASS>;
    close PASS;
    if (crypt($password, $encrypted_password) eq $encrypted_password){
        print_intro();
    }
    else {
        invalid_login();        
    }
    
    exit(0);
}

# Create the frameset
sub print_frameset {
    my $script = url();
    print header(-expires=>'-1d');

    print <<HTML;
    <HTML><HEAD>
    <TITLE>Web Auction Administration</TITLE></HEAD>
    <frameset  cols="25%,*"  border="1">
    <frame name="menu" src="$script?job=main_menu" marginwidth="5" marginheight="0" scrolling="auto" noresize>
    <frame name="main" src="$script?job=login" marginwidth="5" marginheight="0" scrolling="auto" noresize>
    </frameset></HTML>
HTML
        
    exit(0);
        
}

#print the main menu
sub print_main_menu {
    my $script = url();
    my $line;
    my %categories = get_categories();
    
    print header(-expires=>'-1d'),
    start_html(-title=>'Main Menu',
                    -bgcolor=>'white'),
        center(
        b('Auction Admin Functions'),
        start_form(-action=>$script,
        	-name=>'menu',
            -target=>'main'),
    
    
            table({-border=>1,-cellpadding=>3,-cellspacing=>3,-bgcolor=>'#FAFAD2'},
            Tr({-align=>'CENTER',-valign=>'MIDDLE'},
                [td(b('Select a category:'),br,
   				popup_menu(-name=>'category',
                -values=>[ sort keys %categories ],
                -labels=>\%categories)),
    
                td(submit(-name=>'job',-value=>'Add Item')),
                td(submit(-name=>'job',-value=>'Modify Item')),
                td(submit(-name=>'job',-value=>'Delete Item')),
                td(submit(-name=>'job',-value=>'Closed Items')),
                td(submit(-name=>'job',-value=>'Edit Categories')),
                td(submit(-name=>'job',-value=>'Export User File')),
                td(submit(-name=>'job',-value=>'Import Data File')),
                td(submit(-name=>'job',-value=>'Delete User')),
                td(submit(-name=>'job',-value=>'Add From History')),
                td(submit(-name=>'job',-value=>'Show Log')),
                td(submit(-name=>'job',-value=>'Change Password')),
                td(submit(-name=>'job',-value=>'Log Off')),
                ]
            )
            ),
    
        end_form(),
        ),p,
    
    font({-size=>'-1'},a({-href=>$WAP,-target=>'_blank'},
    'Web Auction'),br,'Version ',$VERSION,br,'&copy; 1999 by ', a({-href=>$WAM},
    'David Turley')),
    
    end_html();

    exit(0);
}

#print the intro frame
sub print_intro {
    #my $checked_in = $_[0];
    #invalid_login() unless $checked_in = "okay";
    my $cookie = cookie(-name=>'login',
                -value=>'okay');
                
    print header(-cookie=>$cookie),
    
    start_html(-title=>'Auction Administration',
                    -bgcolor=>'white'),
         center(            
        h1('Web Auction Administration'),
       
    "Select a function from the menu on the left. 
    All administrative screens will appear in this window."),
    p,
    b('Auction Administration Functions'),br,
    'For most functions, the action will apply to the category that is selected
    in the pull down menu at the top.',p,
    b('Add Item'),' This is used to add items to the auction.',p,
    b('Modify Item'),' This is used to modify auction items. 
    You will be presented with a list of all items in the category. 
    You can select the item to modify.',p,
    b('Delete Item'),' This is used to delete auction items. 
    You will be presented with a list of all items in the category. 
    You can select items to delete or delete all items.',p,
    b('Closed Items'),' Use this to view bidding results on closed auction items. 
    From the history screen you may also retreive information about the winning bidder.',p,
    b('Edit Categories'),' Use this to create and remove categories from you auction.',p,
    b('Export User File'),' This will create a tab-delimited file of registered users 
    suitable for importing into a spreadsheet or database. Previously created files will 
    be overwritten',p,
    b('Import Data File'),' Use this to import a data file into the selected category. 
    See the auction readme for instructions on properly formatting the import file.',p,
    b('Delete User'),' Use this to delete registered users from the user data file.',p,
    b('Add From History'),' This is used to put finished items back inot the auction. 
    The item will be deleted from the closed items file.',p,
    b('Show Log'),' You may view the entire bid log for a category. 
    Log entries may also be deleted.',p,
    b('Change Password'),' Select this function to change your adminstrator password.',p,
    b('Log Off'),' You will automatically be logged off when you quit your browser. 
    Use this button if you want to log off without quitting your browser.',p,
    
	end_html;
    exit(0);
}

#print the form for adding items
sub print_add_form {

    check_cookie();
    
    my $script = url();
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    my ($this_month,$this_day,$this_year,$this_hour,$this_minute)=get_time_pieces($TIME);
    
    $this_minute = '00' if $this_minute < 15;
    $this_minute = '15' if $this_minute >= 15 and $this_minute < 30;
    $this_minute = '30' if $this_minute >= 30 and $this_minute < 45;
    $this_minute = '45' if $this_minute >= 45 and $this_minute < 60;
    
    #print header(-expires=>'-1d'),
    print header,
    
    start_html(-title=>'Add Menu',
                    -bgcolor=>'white',
                    -script=>$DATE_VALIDATE_JS),

    h1({-align=>'center'},'Add Item to Auction');
    
    print <<HTML;
    
    Use this form to add items to your auction. The items will be added to the catagory shown below.<P>

    <B>Item Name:</B> This is the name by which the item will be listed.<BR>
    <B>Opening Bid:</B> The amount at which bidding must start for this item.<BR>
    <B>Minimum Bid Increase:</B> This is the amount that a bid must be over the current bid to be accepted.<BR>
    <B>Opening Date:</B> This is the date on which the bidding for this item will open.<BR>
    <B>Opening Time:</B> The time on the closing date that bidding on this item will open.<BR>        
    <B>Closing Date:</B> This is the date on which the bidding for this item will end.<BR>
    <B>Closing Time:</B> The time on the closing date that bidding on this item will close.<BR>
    <B>Item URL:</B> (Optional) Enter the URL for this item's description page. The URL may be relative to your script directory, or a complete path.<BR>
    <B>Brief Description:</B> (Optional) Enter a one or two sentence description of the item.
    <P>
HTML

print center(
    start_form(-action=>$script,
               -target=>'main',
               -name=>'addForm',
               -onSubmit=>'return checkStartDate()'),
               
    table({-border=>1,-cellpadding=>3,-cellspacing=>3},
            Tr(
                th({-bgcolor=>'#FAFAD2',-colspan=>2},"Add Item to Category: $category"),
            ),
            Tr(
                td('Item Name: '),
                td(textfield(-name=>'item_name',-size=>30)),
            ),
            Tr(
                td('Opening Bid: '),
                td(textfield(-name=>'opening_bid',-size=>15)),
            ),
            Tr(
                td('Minimum Bid Increase: '),
                td(textfield(-name=>'min_increase',-size=>15)),
            ),
            Tr(
                td('Opening Date: '),
                td(popup_menu(-name=>'open_month',
                    -values=>\@months,
                    -default=>$this_month),
                
                   popup_menu(-name=>'open_day',
                    -values=>\@days,
                    -default=>$this_day),
        
                  popup_menu(-name=>'open_year',
                    -values=>\@years,
                    -default=>$this_year)
                ),
             ),
             Tr( 
                td('Opening Time: '),
                td(popup_menu(-name=>'open_hour',
                    -values=>\@hours,
                    -default=>$this_hour),b(':'),
        
                   popup_menu(-name=>'open_minute',
                    -values=>\@minutes,
                    -default=>$this_minute),
        
                ),
             ),
            Tr(
                td('Closing Date: '),
                td(popup_menu(-name=>'close_month',
                    -values=>\@months,
                    -default=>$this_month),
              
                   popup_menu(-name=>'close_day',
                    -values=>\@days,
                    -default=>$this_day),
        
                   popup_menu(-name=>'close_year',
                    -values=>\@years,
                    -default=>$this_year)
                ),
             ),
             Tr( 
                td('Closing Time: '),
                td(popup_menu(-name=>'close_hour',
                    -values=>\@hours,
                    -default=>$this_hour),b(':'),
        
                   popup_menu(-name=>'close_minute',
                    -values=>\@minutes,
                    -default=>$this_minute),
        
                ),
             ),
             Tr(
                td('Item URL: '),
                td(textfield(-name=>'item_url',-size=>30)),
             ),
             Tr(
                td('Brief Description: '),
                td(textarea(-name=>'item_desc',-rows=>3,
                    -cols=>30,-wrap=>'virtual'),
                ),
             ),
             Tr(
                td({-align=>'center',-colspan=>2},
                submit(-label=>'Add This Item'),
                reset(-label=>'Clear Form'),
                ),
             ),
         ),
         
            hidden(-name=>'category',-value=>"$category_key",-override=>1),
            hidden(-name=>'job',-value=>'add_item2',-override=>1),
        end_form(),
     ),
        end_html();
        
    exit(0);
}


sub invalid_login {
    print header(-expires=>'-1d'),
    start_html(-title=>'BZZZZ!',
                    -bgcolor=>'white');
    print "<CENTER><FONT COLOR=red><BLINK><H2>ACCESS DENIED</H2></BLINK></FONT><P>";
    print "Your login cannot be confirmed. You are denied access.</CENTER><P>\n";
    print end_html;
    exit(0);
}

sub check_cookie{
    my $login = cookie('login');
    invalid_login() unless $login eq "okay";  
    return;
} 

sub log_off {
	my $script = url();
	my $cookie = cookie(-name=>'login',
                -value=>'gone'); #
                
    print header(-cookie=>$cookie),
    start_html(-title=>'Administrator Login',
                    -bgcolor=>'white'),
        center(      
        h1('Auction Administrator Login'),
        
        start_form(-action=>$script,
                    -target=>'main'),
        
        'Please enter your Auction Administrator Password',p,
        textfield(-name=>'password',-size=>30),
        hidden(-name=>'job',-value=>'check_pass', -override=>1),p,
        submit(-label=>'Check Me In'),
        
        end_form(),
        ),
        end_html();
        
    exit(0);
}

sub bid_history {
	
	check_cookie();
    my $script = url();
    my @rows;
	
	my $js = <<JS;
function show_info(show) {
popupWin = window.open(show,'info_window','width=400,height=300,scrollbars=yes');
}
JS

    my $category_key = shift || param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    
    my $log_file = $INFO_PATH . $category_key . ".fin";
    
    if (!-e $log_file) {
        print header(-expires=>'-1d'),
        start_html,
        "There are no finished items in $category.",br,
        end_html;
        exit(0);
    }
    
    open(LOG, "$log_file") || error($log_file,'10');
    my @history = <LOG>;
    close(LOG);
    
    #colors for table rows
	my $odd = '#dddddd';
	my $even = '#ffffff';
	my $count = 0;
	
	#make the table rows
	push (@rows,Tr(th(['Delete','Item No.','Item','Open','Close','Winner ID','Bid'])));		
	#process the rows
	for (@history) {
		my(@info) = split /\|/, $_;
		my $item_num = $info[0];
		my $item = $info[3];
		my $open = format_time($info[1]);
		my $close = format_time($info[2]);
		my $user = $info[8];
		my $id = a({-href=>"javascript:show_info('$script?job=user_info&user=$user');"},$user),
		my $bid = $info[11];
		my $check = "<INPUT TYPE=\"checkbox\" NAME = \"id\" VALUE=\"$item_num\">";
		push (@rows, Tr({-bgcolor=>(($count = 1 - $count) ? $odd : $even)},td([$check,$item_num,$item,$open,$close,$id,$bid])));
	}
	
	print header(-expires=>'-1d'),
    start_html(-title=>'Bid Results',
                    -bgcolor=>'white',
                    -script=>$js),
                    
    start_form(-action=>$script,
                    -target=>'main'),
	hidden(-name=>'job',-value=>'delete_from_history',-override=>1),
	hidden(-name=>'category',-value=>"$category_key",-override=>1),             
 	center(
    h1('Closed Auction Items'),
    h2($category),
    'Clicking Winner ID will open a new window with user information.',p,
    '"Delete Item" button will remove item from closed item history file.',p,
    
    submit(-label=>'Delete Item'),
    reset(-label=>'Uncheck Items'),
   
	table({-width=>'100%',-border=>1,-cellspacing=>2,-cellpadding=>2},@rows),
	),
	end_form,
	end_html;
	exit(0);
}	

sub user_info {
    check_cookie();
	my $user = param('user');
	my $user_file = $INFO_PATH . $USER_FILE;
	my (@data,@info);
	open (DATA, "$user_file") || error($user_file,'10');
	@data = <DATA>;
	close (DATA);
	
	for (@data) {
		if (/^$user/) {
			@info = split(/\|/,$_,11);
			last;
		}
	}
	
	my $name = $info[2];
	my $email = $info[3];
	my $initials = $info[4];
	my $address = $info[5];
	my $city = $info[6];
	my $state = $info[7];
	my $zip = $info[8];
	my $country = $info[9];
	my $the_rest = $info[10]; #this is cc info and other added fields
	
	print header(-expires=>'-1d'),
	start_html(-bgcolor=>'#ffffff'),
	center(
	h2("Information for User $user"),
	),
	b('Name: '),$name,br,
	b('Email: '),a({-href=>"mailto:$email"},$email),br,
	b('ID: '),$initials,br,
	b('Address: '),$address,br,
	b('City: '),$city,br,
	b('State: '),$state,br,
	b('Country: '),$country,p,
	'Additional Information:',br; 
    my @additional_stuff = split(/\|/,$the_rest,);  
    for (@additional_stuff) {
    	print $_,br;
    }
	
	print center(
	a({-href=>'javascript:window.close();'},'Close Window'),
	),
	end_html;
	
	exit(0);
}

sub export_file {
	my $user_file = $INFO_PATH . $USER_FILE;
	my $export_file = $INFO_PATH . 'export.txt';
	my (@data,@info);
	open (DATA, "$user_file") || error($user_file,'10');
	@data = <DATA>;
	close (DATA);
	open (EXPORT, ">$export_file") || error($export_file,'10');
	flock(EXPORT,2);
	
	print EXPORT "ID Number\tName\tEmail\tID String\tAddress\tCity\tState\tZip\tCountry";
	
#uncomment next line to include credit card info in form
	#print EXPORT "\tCredit Card Type\tName on Card\tCard Number\tCard Exp";
	
	##any additional fields need to be added here
	
	print EXPORT "\n";
	for (@data) {
		chomp;
		@info = split(/\|/);
		for (@info[0,2..$#info]) {
			print EXPORT "$_\t";
		}
		print EXPORT "\n";
	}
	close(EXPORT);
	
	print header(-expires=>'-1d'),
	start_html(-bgcolor=>'#ffffff'),
	center('A tab-delimited file has been created.',br,
	"The file is $export_file.",br,
	'You may download it via FTP.'),
	end_html;
	exit(0);
}		

sub import_data1 {
	check_cookie();
    
    my $script = url();
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    
    my $import_data = $INFO_PATH . $category_key . "_import.txt";
    my $data_file = $INFO_PATH . $category_key . ".dat";
    my $number = $TIME - 100000000;  #get a number long ago to avoid duplicates
    
    if (!-e $import_data) {
    	print header(-expires=>'-1d'),
   		start_html(-title=>'Import Data File Not Found',
                    -bgcolor=>'white'),

    	h1({-align=>'center'},'Import Data File Not Found'),
    	'I could not find the file:',br,
    	$import_data,br,
    	'Please be sure you have uploaded a date file in the proper format.',p,
    	'See the auction readme file for the proper import data format.',
    	end_html;
    	exit(0);
    }
    
    open(IN, "$import_data") || error($import_data,'10');
    my @input = <IN>;
    close(IN);
    open(DATA, ">>$data_file") || error($data_file,'10');
    flock(DATA,2);
    
    for(@input) {
    	chomp;
    	my ($name,$open,$close,$open_bid,$min_incr,$url,$desc) = split '\t', $_;
		
		$open = get_time_digits($open);	
    	$close = get_time_digits($close);
    	$open_bid = format_amt($open_bid);
    	$min_incr = format_amt($min_incr);
    	$number++;
    	print DATA "$number|$open|$close|$name|";
    	print DATA "$open_bid|$min_incr|$url|$desc|";
    	#bidder id, bidder initials, bidder email, current bid, bid time, closed_flag
    	print DATA "0|0|0|0|0|0\n";
    	
    }
    close DATA;	
    
    	
    print header(-expires=>'-1d'),
   	start_html(-title=>'Data Imported',
               -bgcolor=>'white'),

    h1({-align=>'center'},'Data Imported'),
    "The data has been added to the $category category.",
    end_html;
    exit(0);
    
    	
}	
	
sub show_users {       
    check_cookie();
    my $script = url();
    my $user_file = $INFO_PATH . $USER_FILE;
    my $line;
    if ((!-e $user_file) || (-z $user_file)) {
        print header(-expires=>'-1d'),
        start_html,
        "There are no users registered.",br,
        exit(0);
    }
    open(DATA, "$user_file") || error($user_file,'10');
    print header(-expires=>'-1d'),
    start_html(-title=>'Delete Users Menu',
                    -bgcolor=>'white'),

    h1({-align=>'center'},'Delete Users Menu'),
    start_form(-action=>$script,
                    -target=>'main'),
    hr,p,
    "Select users to delete from the list below",p,
    submit(-name=>'job',-value=>'Delete Checked Users');
    
    print "<TABLE BORDER=1><TR>";
    print "<TH>Check</TH><TH>ID Number</TH><TH>Name</TH><TH>Email</TH></TR>";
    while (defined($line = <DATA>)) {
        chomp $line;
        my @info = split(/\|/,$line);
        my $id = $info[0];
		my $name = $info[2];
		my $email = $info[3];
        print "<TR>";
        print "<TD><INPUT TYPE=\"checkbox\" NAME = \"id\" VALUE=\"$id\"></TD>";
        print "<TD>$id</TD><TD>$name</TD><TD>$email</TD></TR>";
    }
    print "</TABLE>";
    close DATA;
    print end_form,
    end_html;

    exit(0);
}           

sub delete_users {
	check_cookie();
    my $script = url();
    my $user_file = $INFO_PATH . $USER_FILE;
    my @ids = param('id');
    my ($line,$expr,$match_any,@data);

	open(DATA, "+>>$user_file") || error($user_file,'10');
    flock(DATA,2);
    seek DATA, 0, 0;
    @data = <DATA>;
    
	$expr = join(' || ',map { "m/$ids[$_]/o" } 0..$#ids);
	$match_any = eval "sub { $expr }";
	seek DATA, 0, 0;
	truncate $user_file, 0;
	for (@data) {
		next if &$match_any;
		print DATA $_;
	} 

	close(DATA);
	
	show_users();
}

sub show_history_for_move {
	check_cookie();
    my $script = url();
    my (@rows,$days_added);
    my @days = (1..28);

    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    
    my $log_file = $INFO_PATH . $category_key . ".fin";
    
    if (!-e $log_file) {
        print header(-expires=>'-1d'),
        start_html,
        "There are no finished items in $category.",br,
        end_html;
        exit(0);
    }
    
    open(LOG, "$log_file") || error($log_file,'10');
    my @history = <LOG>;
    close(LOG);
    
    #colors for table rows
	my $odd = '#dddddd';
	my $even = '#ffffff';
	my $count = 0;
	
	#make the table rows
	push (@rows,Tr(th(['Check','Item No.','Item','Open','Close'])));		
	#process the rows
	for (@history) {
		my(@info) = split /\|/, $_;
		my $item_num = $info[0];
		my $item = $info[3];
		my $open = format_time($info[1]);
		my $close = format_time($info[2]);
		my $user = $info[8];
		#my $id = a({-href=>"javascript:show_info('$script?job=user_info&user=$user');"},$user),
		#my $bid = $info[11];
		my $chk_box = "<INPUT TYPE=\"checkbox\" NAME = \"item\" VALUE=\"$item_num\">";
		push (@rows, Tr({-bgcolor=>(($count = 1 - $count) ? $odd : $even)},td([$chk_box,$item_num,$item,$open,$close])));
	}
	
	print header(-expires=>'-1d'),
    start_html(-title=>'Closed Items',
                    -bgcolor=>'white'),
 	center(
    h1('Closed Auction Items'),
    h2($category),
     start_form(-action=>$script,
                    -target=>'main'),
    
    'Check the items to be rentered into auction.',p,
    'Items will retain original start time. ',
    'Ending time will have ',
    popup_menu(-name=>'days_added',
                    -values=>\@days,
                    -default=>'7'),
    ' days added to original ending time.',p,
    '<font color="red">
    The item will be removed from history file, 
    be sure to record any bidder info first.</font>',p,
   
    
    hidden(-name=>'category',-value=>$category_key),
    ##hidden(-name=>'time_added',-value=>$time_added),
    submit(-name=>'job',-value=>'Add Checked Items'),
	table({-width=>'100%',-border=>1,-cellspacing=>2,-cellpadding=>2},@rows),
	),p,
	end_form,
	
	end_html;
	exit(0);
}

sub add_from_history {
	check_cookie();
    my $script = url();
    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    
    my $log_file = $INFO_PATH . $category_key . ".fin";
    my $data_file = $INFO_PATH . $category_key . ".dat";
    
    my $days_added = param('days_added');
    my $sec_in_day = 60 * 60 *24;
    my $sec_added = $days_added * $sec_in_day;
    
    my @items = param('item');
    my ($line,$expr,$match_any,@data,@added);
	my($item_number,$open_digits,$close_digits,$item_name,$opening_bid,$min_increase,$item_url,$item_desc);
	my ($close_date,$open_date);

    open(HISTORY, "+>>$log_file") || error($log_file,'10');
    flock(HISTORY,2);
    seek HISTORY, 0, 0;
    my @history = <HISTORY>;
	seek HISTORY, 0, 0;
	truncate $log_file, 0;
    
    open(DATA, ">>$data_file") || error($log_file,'10');
    flock(DATA,2);
  
	$expr = join(' || ',map { "m/^$items[$_]/o" } 0..$#items);
	$match_any = eval "sub { $expr }";
	for (@history) {
		##next if !&$match_any;
		if (!&$match_any) { ##it's not one we want to move, put it back
		    print HISTORY $_;
		    next;
		}
		##it's one we want to move 
		##get the data, and add to data file
		($item_number,$open_digits,$close_digits,$item_name,$opening_bid,$min_increase,$item_url,$item_desc) = split(/\|/,$_,9);
		$close_digits += $sec_added;
		$open_date = format_time($open_digits);
		$close_date = format_time($close_digits);
		##$new_item_number++; #change the item number or we will get duplicates added
		print DATA "$item_number|$open_digits|$close_digits|$item_name|";
    	print DATA "$opening_bid|$min_increase|$item_url|$item_desc|";
    	print DATA "0|0|0|0|0|0\n";
    	$line = "Item: $item_number<br>Open Time: $open_date<br>
    	Close Time: $close_date<br>Item Name: $item_name<br>
    	Opening Bid: $opening_bid<br>Minimum Increase: $min_increase<br>
    	Item Url: $item_url<br>Item Description: $item_desc<p>";
    	push (@added,$line);
		
	} 

	close(DATA);
	
	close(HISTORY);
	
	print header(-expires=>'-1d'),
    start_html(-title=>'Items Added',
                    -bgcolor=>'white'),
    "The following items were removed from history and added to $category:",p;
    for (@added) {
    	print $_,hr,"\n";
    }
    print 'You may modify the items by choosing the Modify Item option.',br,
    b('Note: If the close date is past, the item will be moved back to history 
    the next time the auction is accessed.'),
    end_html;
    exit(0);
 
}

sub delete_from_history {
	check_cookie();
    my $script = url();

    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    
    my $log_file = $INFO_PATH . $category_key . ".fin";
    
    my @items = param('id');
    my ($line,$expr,$match_any,@data);

	open(DATA, "+>>$log_file") || error($log_file,'10');
    flock(DATA,2);
    seek DATA, 0, 0;
    @data = <DATA>;
    
	$expr = join(' || ',map { "m/$items[$_]/o" } 0..$#items);
	$match_any = eval "sub { $expr }";
	seek DATA, 0, 0;
	truncate $log_file, 0;
	for (@data) {
		next if &$match_any;
		print DATA $_;
	} 

	close(DATA);
	
	bid_history($category_key);
}
    
sub show_log {
	
	my $js = <<JS;
function show_info(show) {
popupWin = window.open(show,'info_window','width=400,height=300,scrollbars=yes');
}
JS
	check_cookie();
    my $script = url();
    my $category_key = shift || param('category');
    #my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    
    #colors for table rows
	my $odd = '#dddddd';
	my $even = '#ffffff';
	#my $count = 0;
	my @rows;
    
    my $log_file = $INFO_PATH . $category_key . '.blog';
    
    if (!-e $log_file) {
        print header(-expires=>'-1d'),
        start_html,
        "There are no logged bids in $category.",br,
        end_html;
        exit(0);
    }
    
    #$/ = '';  #set input mode to blank line for paragraphs

	open(IN, "$log_file") || error($log_file,'10');
	
	my @log = <IN>;
	close(IN);
		
	#make the table rows
	push (@rows,Tr(th(['Delete','Date','Item Number','Item Name','Bidder ID','Bidder Name','Bid'])));	
	
	my @sort_log = fieldsort(':', ['2n','1n'], @log);
	
	##6/7/99
	my $currentcolor = $odd;
	my $prevcolor;
	my $previtem;
	my $currentitem; 
	
    for (@sort_log) {
    	
    	my($time,$item_num,$item_name,$id_num,$name,$bid) = split(/:/,$_);
    	my $date = format_time($time);
    	my $id_link = a({-href=>"javascript:show_info('$script?job=user_info&user=$id_num');"},$id_num),
		#my $item_link = a({-href=>"javascript:show_info('$script?job=item_info&item=$item_num');"},$item_num),
		my $item_key = "$time:$item_num";
		my $check = "<INPUT TYPE=\"checkbox\" NAME = \"id\" VALUE=\"$item_key\">";
		
		$currentitem = $item_num;
		if ($currentitem eq $previtem) {
			$previtem = $currentitem;
		}
		else {
			if ($currentcolor eq $odd) {$currentcolor = $even;}
			else {$currentcolor = $odd;}
			$previtem = $currentitem;
		}
		
		#push (@rows, Tr({-bgcolor=>(($count = 1 - $count) ? $odd : $even)},td([$check,$date,$item_num,$item_name,$id_link,$name,$bid])));
		push (@rows, Tr({-bgcolor=>$currentcolor},td([$check,$date,$item_num,$item_name,$id_link,$name,$bid])));
           
	}
	
	print header(-expires=>'-1d'),
    start_html(-title=>'Bidding Log',
                    -bgcolor=>'white',
                    -script=>$js),
                    
    start_form(-action=>$script,
                    -target=>'main'),
	hidden(-name=>'category',-value=>"$category_key",-override=>1),             
 	center(
    h1('Bidding Log'),
    h2($category),
    ##'Clicking Item Number will open a new window with item information.',p,
    'Clicking Bidder ID will open a new window with user information.',p,
    '"Delete Log Entry" button will remove checked items from closed log file.',p,
    'Log entries are sorted by item, then by time.',p,
    
    #submit(-label=>'Delete Log Entry',-name=>'job'),
    submit(-name=>'job',-value=>'Delete Log Entry'),
    reset(-label=>'Uncheck Items'),p,
   
	table({-width=>'100%',-border=>1,-cellspacing=>2,-cellpadding=>2},@rows),
	),
	end_form,
	end_html;
	exit(0);
}	

sub delete_from_log {
	check_cookie();
    my $script = url();

    my $category_key = param('category');
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    
    my $log_file = $INFO_PATH . $category_key . '.blog';
    
    my @items = param('id');
    my ($line,$expr,$match_any,@data);

	open(DATA, "+>>$log_file") || error($log_file,'10');
    flock(DATA,2);
    seek DATA, 0, 0;
    @data = <DATA>;
    
	$expr = join(' || ',map { "m/$items[$_]/o" } 0..$#items);
	$match_any = eval "sub { $expr }";
	seek DATA, 0, 0;
	truncate $log_file, 0;
	for (@data) {
		next if &$match_any;
		print DATA $_;
	} 

	close(DATA);
	
	show_log($category_key);
}
	
#############################
BEGIN{
$DATE_VALIDATE_JS = <<JS;
// adapted from date validation script by
// Arash Ramin (http://www.ugrad.cs.ubc.ca/spider/v3p1/)
function checkStartDate() {
  var errorMsg= "You have not selected options for the following menus ";
  var errorFlag = false;

  //check to make sure that input has been made
  if (document.addForm.open_year.selectedIndex == -1) {
    errorMsg = errorMsg + " - open year";
    errorFlag = true;
  }
  if (document.addForm.close_year.selectedIndex == -1) {
    errorMsg = errorMsg + " - close year";
    errorFlag = true;
  }
  if (document.addForm.open_month.selectedIndex == -1) {
    errorMsg = errorMsg + " - open month";
    errorFlag = true;
  }
  if (document.addForm.close_month.selectedIndex == -1) {
    errorMsg = errorMsg + " - close month";
    errorFlag = true;
  }
  if (document.addForm.open_day.selectedIndex == -1) {
    errorMsg = errorMsg + " - open day";
    errorFlag = true;
  }
  if (document.addForm.close_day.selectedIndex == -1) {
    errorMsg = errorMsg + " - close day";
    errorFlag = true;
  }
  if (errorFlag) {
    errorMsg = errorMsg + ".";
    alert(errorMsg);
    return false;
  }

  // check to make sure that selected date is valid
  var SY = document.addForm.open_year.selectedIndex;
  var SM = document.addForm.open_month.selectedIndex;
  var SD = document.addForm.open_day.selectedIndex;
  var cSY = document.addForm.close_year.selectedIndex;
  var cSM = document.addForm.close_month.selectedIndex;
  var cSD = document.addForm.close_day.selectedIndex;

  // check months with only 30 days
  if (((SM == 3) || (SM == 5) || (SM == 8) || (SM == 10)) && (SD == 30)) {
    errorMsg = "Incorrect date entered. ";
    errorMsg = errorMsg + document.addForm.open_month.options[SM].value;
    errorMsg = errorMsg + " only has 30 days."
    alert(errorMsg);
    return false;
  }
  if (((cSM == 3) || (cSM == 5) || (cSM == 8) || (cSM == 10)) && (cSD == 30)) {
    errorMsg = "Incorrect date entered. ";
    errorMsg = errorMsg + document.addForm.close_month.options[cSM].value;
    errorMsg = errorMsg + " only has 30 days."
    alert(errorMsg);
    return false;
  }

  // check February on leap years (only 29 days)
  var leapyear = false;
  var c_leapyear = false;
  var i = parseInt(document.addForm.open_year.options[SY].value);
  var c = parseInt(document.addForm.close_year.options[cSY].value);
  
  // check for leapyear 
  if ( Math.floor(i/4) == (i/4) ) {
    leapyear = true;
  }
  if ( Math.floor(c/4) == (c/4) ) {
    c_leapyear = true;
  }
  // if year is divisible by 100 (but not 400) it is not a leapyear
  if ( (Math.floor(i/100) == (i/100)) && (Math.floor(i/400) != (i/400)) ) {
    leapyear = false;
  }
  if ( (Math.floor(c/100) == (c/100)) && (Math.floor(c/400) != (c/400)) ) {
    c_leapyear = false;
  }
  
  if ( leapyear && (SM == 1) && (SD > 28) ){
      errorMsg = "Incorrect date entered.  February only has 29 days in ";
      errorMsg = errorMsg + document.addForm.open_year.options[SY].value;
      alert(errorMsg);
      return false;
    }
  if ( c_leapyear && (cSM == 1) && (cSD > 28) ){
      errorMsg = "Incorrect date entered.  February only has 29 days in ";
      errorMsg = errorMsg + document.addForm.close_year.options[SY].value;
      alert(errorMsg);
      return false;
    }

  // check February for all other years (only 28 days)
  if ( (SM == 1) && (SD > 27) && (leapyear == false) ) {
    errorMsg = "Incorrect date entered.  February only has 28 days in ";
    errorMsg = errorMsg + document.addForm.open_year.options[SY].value;
    alert(errorMsg);
    return false;
  }
  if ( (cSM == 1) && (cSD > 27) && (c_leapyear == false) ) {
    errorMsg = "Incorrect date entered.  February only has 28 days in ";
    errorMsg = errorMsg + document.addForm.close_year.options[SY].value;
    alert(errorMsg);
    return false;
  }   
    return true;
}

JS
}
	
