#!/usr/bin/perl -T

# Web Auction Release Version 1.1                                   
# Copyright 1999, 2000 David Turley
# <dturley@pobox.com>           
# This program is free software. You may modify and distribute
# it under the same terms as perl itself. 

##$Id: auction.cgi,v 1.5 1999/12/14 12:24:25 david Exp david $##

use CGI qw/:all/;
use CGI::Carp(fatalsToBrowser);
use Time::Local;
#use Fcntl;
use strict;

#need this line when tainting turned on to be sure and include library files
#this is the directory that contains the script usually
use lib qw(/web/cgi-bin);


##this file is probably in same directory as scripts, if not, edit 
require 'auction-lib.pl';

##You can change the basic color scheme here
my $BG = '#fffbec';	#background color
my $TX = '#000000';	#text color
my $LL = '#00008b';	#visited link color
my $VL = '#00008b';	#link color
my $BGIMG = '';		#background image url

$ENV{'PATH'} = '/bin:/usr/bin:/usr/local/bin';

##get the global set up variables
#auction.cfg should exist in same directory as this script
get_config();

use vars qw($INFO_PATH $AUCTION_URL $TIME_TYPE $MAIL_FROM $MAIL_SERVER $AUCTION_TITLE
	$LOCALMAIL $REGISTER_URL $SHOW_HOURS $USER_FILE $EXTENDED $NOTIFY 
	$UPDATE $WAP $WAM $VERSION);
	
my %ITEMS; #use this for saving names of items bid on to write to log file
my $TIME = time;

#these are the characters we will allow to show up int he category key
my $OK_CHARS = 'a-zA-Z0-9_-'; 

#find out what we need to do
my $request = path_info();
$request =~ s!^/!!;

#make sure nothing extra has been added, and untaint
$request =~ /^([$OK_CHARS]+)$/;
$request = $1;

my $job = param('job');

# If no path information is provided, then we send the login screen
if (!$request){
    main_auction();
    exit (0);
}

else {
	show_time() if $request eq 'current_time';
	show_category($request) if !$job;
	if ($job eq 'bid') {
		my $email = param('email');
		my $password = param('password');
		my ($id,$name,$initials) = check_password($email,$password);
		process_bid($request,$id,$name,$email,$initials);
	}
	else {main_auction();}
	exit(0);
}
#############################################################
sub main_auction {
	my $script = url();
	my %categories = get_categories();
	my ($key,@rows,$label,$row);
	my $count = 0;
	my $odd_open = "<tr align='center'><td width='25%'>";
	my $odd_close = '</td>';
	my $even_open = "<td width='25%'>";
	my $even_close = '</td></tr>';
	
	if ($script ne $AUCTION_URL) { #send the custom page
		print "Location: $AUCTION_URL\n\n";
		exit(0);
	}
	
	print header(-expires=>'-1d'),
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>$AUCTION_TITLE),
	center(
	h1($AUCTION_TITLE),
	'Select an auction category from the list below.',br,
	'Need to register? ',a ({href=>$REGISTER_URL},'Do so here.'),p,
	
	); #end center
	
	foreach $key (sort { $categories{$a} cmp $categories{$b} } keys %categories) {
		$label = $categories{$key};
		$row = (($count = 1- $count) ? $odd_open : $even_open) . a({href=>"$script/$key"},$label) . ($count ? $odd_close : $even_close);
		push(@rows,$row);	
	}

	print center(table{-width=>'50%',-cellspacing=>3},(@rows));
 	
	print hr,
	font({-size=>'-1'},a({-href=>$WAP,-target=>'_blank'},
    'Web Auction'),br,'Version ',$VERSION,br,'&copy; 1999 by ', a({-href=>$WAM},
    'David Turley')),
    end_html();
        
    exit(0);
	
}

sub show_category {
	my $script = url();
	my $js = <<JS;
function current_time() {
popupWin = window.open('$script/current_time','auction_time','width=300,height=150')
}

function show_info(show) {
popupWin = window.open(show,'info_window','width=600,height=450,scrollbars=yes');
}
JS

    my $category_key = shift;
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    if (!$category) { #the path_info was invalid
        main_auction();
    }
	my $time = $TIME;
    my $show_seconds = $SHOW_HOURS * 60 * 60;
    my $no_show_time = $show_seconds + $time;
    
    my $extend_seconds = $EXTENDED * 60;
    
    my $data_file = $INFO_PATH . $category_key . ".dat";
    #since we entered the paths, they should be okay.
	$data_file =~ /^(.*)$/;
	$data_file = $1;
    my (@drop,$line,$item_name,$current_bid,$bidder,$bid_time,$next_bid,
    @done,@notify,$new_line,$list,$last_chance,%extend_flag);
    
    my $changed = 0;
    #get the data
    open(DATA, "+>>$data_file") || error($data_file,'10');
    flock(DATA,2);
    seek DATA, 0, 0;
    my @unsorted_list = <DATA>;
    
    if (@unsorted_list) {

		my $count = 0;
		#my $dropped = 0;
   		foreach $line (@unsorted_list) {
			chomp $line;
			my @data = split(/\|/,$line);
		
			if ($data[1] > $time){ #this item has not opened yet
				$count++;
				next;
			}
			
			#figure out if bidding is to be extended
			if ($data[12]) {
				$last_chance = $data[12] + $extend_seconds;
				#print header,format_time($last_chance);exit;
			}
			else {$last_chance = 0;}
			
			if (($last_chance > $time) && ($last_chance != 0) && ($data[2] < $time)) {
				$extend_flag{"$data[0]"} = 1;
				$changed = 1;
				
			}
			
			#first we'll add finished item to done list
			#if we haven't already
			if (($data[2] < $time) && ($last_chance < $time) && ($data[13] != 1)) {
				$data[13] = 1;
				$changed = 1;
				$line = join '|', @data;
				push (@done,$line); 
				push (@notify,$line);
			
			}
		
			#if display time is up, delete it from data file
			my $done_for_seconds = $time - $data[2];
			
			if (($data[2] < $time) && ($done_for_seconds > $show_seconds)) {
				push(@drop,$count);
				$count++;#
				next;
			}
			$count++;#
		}  #end of foreach $line (@unsorted_list) 
		
		if (@drop) {
			$changed = 1;
			foreach $line(reverse @drop){ #splice from 'end' so we don't mess up indexes
				splice (@unsorted_list, $line, 1);

				
			}
		}
		
		if ($changed) {
			#now reload the data file
			seek DATA, 0, 0;
			truncate $data_file, 0;
			foreach $line(@unsorted_list) {
				chomp $line;
				print DATA "$line\n";##
			} 
		}
		close(DATA);
		
		#add items to done history file
		
		if (@done) {
			my $done_file = $INFO_PATH . $category_key . ".fin";
			#since we entered the paths, and have checked category key,
			#they should be okay.
	        $done_file =~ /^(.*)$/;
	        $done_file = $1;
			open(DONE, ">>$done_file") || error($data_file,'10');
			flock(DONE,2);
			foreach $line(@done) {
				print DONE "$line\n";
			}
			close(DONE);

			my $notify_line;
			foreach $notify_line (@notify) {
			    notify_winner($notify_line);
			}
	
		}
	

	} #end of if @unsorted_list

	#now do the bidding page
	
	#sort by close time
	#sort by end time, opening time, item name
	my @list = fieldsort ('\|', ['3n','2n',4], @unsorted_list);
	print header(-expires=>'-1d'),
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>$AUCTION_TITLE,-script=>$js),
	center(
	h1($AUCTION_TITLE),
	h2($category),
	), #end center
	hr,
	center(
		a({-href=>'javascript:current_time();'},'Current Auction Time'),
		'&nbsp;&nbsp;&nbsp',
		a({-href=>"$script/$category_key"},'Refresh This Page'),
	);
		
	if (!@list) {
		print center('There are no items in this category.'),
		end_html;
		exit(0);
	}
	
	print start_form(-action=>"$script/$category_key");
	
	foreach $line (@list) {
		chomp $line;
		my @data = split(/\|/,$line);
		
		next if $data[1] > $time; #this item has not opened yet
	
        my $open_time = format_time($data[1]);
        my $end_time = format_time($data[2]);
        if ($data[11]) {
        	$current_bid = $data[11];
        	$bidder = $data[9];
        	$bid_time = format_time($data[12]);
        	$next_bid = format_amt($data[11] + $data[5]);
        }
        
        else {
        	($current_bid,$bidder,$bid_time) = '';
        	$next_bid = $data[4];
        }

        if ($data[6]) {
        	#$item_name = a ({href=>$data[6]},$data[3])
        	$item_name = a({-href=>"javascript:show_info('$data[6]');"},$data[3]),
        }
        
        else {
        	$item_name = $data[3];
        }

		my @rows = '';
		push(@rows,Tr(td({-width=>'50%',-colspan=>'2',-valign=>'top'},$item_name)));
		push(@rows,Tr(td({-width=>'50%',-colspan=>'2',-valign=>'top'},$data[7])));
		push(@rows,Tr(td({-width=>'50%',-colspan=>'2'},hr())));
		push(@rows,Tr(td({-width=>'50%',-valign=>'top'},b("Bidding Started: "). $open_time),
			td({-width=>'50%',-valign=>'top'},b("Bidding Ends: ") . $end_time)));
		
		
		if ($data[13]) {
			push(@rows,Tr(td({-width=>'50%',-valign=>'top'},b("Winning Bid: \$") . $current_bid),
			td({-width=>'50%',-valign=>'top'},b("Placed By: ") . $bidder)));
			push(@rows,Tr(td({-width=>'50%',-valign=>'top'},b("Placed At: ") . $bid_time),
			td({-width=>'50%'},'&nbsp;')));
			push(@rows,Tr(td({-width=>'50%',-colspan=>2,-align=>'center',-valign=>'top'},b('Item Closed'))));
				
		}
		else {
			push(@rows,Tr(td({-width=>'50%',-valign=>'top'},b("Current Bid: \$") . $current_bid),
			td({-width=>'50%',-valign=>'top'},b("Placed By: ") . $bidder)));
			push(@rows,Tr(td({-width=>'50%',-valign=>'top'},b("Placed At: ") . $bid_time),
			td({-width=>'50%',-valign=>'top'},b("Minimum Bid: \$") . $next_bid)));
			push(@rows,Tr(td({-width=>'50%',-align=>'right'},b('Enter Your Bid: ')),
				td({-width=>'50%'},textfield(-size=>'25',-name=>"item$data[0]"))));
				
			if ($extend_flag{"$data[0]"}) {
				push(@rows,Tr(td({-colspan=>'2',-align=>'center'},
					font({-color=>'red'},'Bidding Extended'))));
			}

		} 
		
		##show ref number, added 3/14/99
		push(@rows,Tr(td({-colspan=>'2'},font({-size=>'-1'},"Ref \#: $data[0]"))));

		print center(
		table({-border=>2,-bgcolor=>'#dddddd',-width=>'90%'},
		TR(td(	
			table({-width=>'100%'},@rows)
		  	)),
		)),p;
		
		
	}	#end foreach $line (@list) 
	
	
	print hidden(-name=>'job',-value=>'bid',-override=>1),
	hr,
	center(
	table({-border=>0},
		TR(td(  
			table(
			Tr(th({-colspan=>2},b('You must enter your email address and password to bid.'))),
			Tr(
				th({-align=>'right'},'Enter Your Email Address: '),
				td({-align=>'left'},textfield(-name=>'email',-size=>30))
			),
			Tr(
				th({-align=>'right'},'Enter Your Password: '),
				td({-align=>'left'},password_field(-name=>'password',-size=>30))
			),
			Tr({-align=>'center'},
				td({-colspan=>2},submit(-name=>'SUBMIT BIDS'))
			),
			),
		)),
	),
	), #end center
	end_form,
	center(a({-href=>"$AUCTION_URL"},'Main Auction Page')),
	hr,
	font({-size=>'-1'},a({-href=>$WAP,-target=>'_blank'},
    'Web Auction'),br,'Version ',$VERSION,br,'&copy; 1999 by ', a({-href=>$WAM},
    'David Turley')),

	end_html;
	
exit(0);

}

sub notify_winner {
    
	    return unless $NOTIFY;	

	    my $line = shift;
	    
		my @data = split(/\|/,$line);
		next if !$data[10]; #no winning bid on this item
		my $item_name = $data[3];
		my $to = $data[10];
		my $bid = $data[11];
		my $bid_time = format_time($data[12]);
		my $body = '';
		$body .= "Congratulations!\n";
		$body .= "At $bid_time, you placed a bid of \$$bid on the $item_name at $AUCTION_TITLE.\n";
		$body .= "The auction has closed and your bid is the winning bid.\n";
		$body .= "Please follow the auction instructions at $AUCTION_URL for claiming your item.\n";
		$body .= "\nRef\#: $data[0]\n";
		$body .= "Bidder\#: $data[8]\n";
		
		send_email($to,$body,'Winning Bid');
		
}


sub show_time {
	my $time = format_time($TIME);
	print header(-expires=>'-1d'),
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>$AUCTION_TITLE),
	center(
	b("$AUCTION_TITLE Current Time"),p,
	$time,
	
	p,
	a({-href=>'javascript:window.close();'},'Close Window'),
	),
	end_html;
	exit(0);
}

sub check_password {
	my $email = shift;
	my $password = shift;
	my $user_file = $INFO_PATH . $USER_FILE;
	#since we entered the paths, they should be okay.
	$user_file =~ /^(.*)$/;
	$user_file = $1;
	my ($line,@data,@info,$id,$name,$initials,$encrypted,$file_email);
        
	if(!-e $user_file){ #no registrations yet
		invalid_user();
	}
        
	open (DATA, "$user_file") || error($user_file,'10');
	@data = <DATA>;
	close (DATA);
    
	foreach $line (@data) {
		chomp $line;
		@info = split(/\|/,$line);
		$encrypted = $info[1];
		$file_email = $info[3];
		
		if (($email eq $file_email) && (crypt($password, $encrypted) eq $encrypted)) {
			$id = $info[0];
			$name = $info[2];
			$email = $info[3];
			$initials = $info[4];
			last;
		}

	}  
  
	if (!$id) {  #can't confirm
		invalid_user();
	}
	else {
		return ($id,$name,$initials);
	}       
}

sub invalid_user {
	print header(-expires=>'-1d'),
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Unknown User'),
	center(
		h2('Registration Not Confirmed'),
		"Your registration could not be confirmed.",p,
		"Please be sure you entered your email address and password correctly.",p,
		a({href=>'javascript:history.go(-1);'},'Try again.'),br,
		'If you have not registered as an auction user, you may do so here:',p,
		a({href=>"$REGISTER_URL"},$REGISTER_URL),	
	),
	end_html;
	exit(0);
}

sub process_bid {
	my ($request,$id,$name,$email,$initials) = @_;
	my $category_key = $request;
    my %categories = get_categories();
    my $category = $categories{"$category_key"};
    my $script = url();
    my $now = $TIME;
    my $time = format_time($now);

    my $data_file = $INFO_PATH . $category_key . ".dat"; 
    #since we entered the paths, and have checked category key,
    #they should be okay.
	$data_file =~ /^(.*)$/;
	$data_file = $1;
    my @items = param(); 
    my (@bids,@bad_bid,@info,$this_bid,@low_bid,$min_bid,@good_bids,$report_line,@update);

    #get a list of the item numbers that were bid on
    for (@items) {
  		if ((/^item/) && (param($_))){
  			s/^item(\d+)/$1/;
  			my $n;
  			$n =~ /^(\d+)$/;
  			$n = $1;
  			push(@bids, $n);
  		}
  	}

  	#get the data
    open(DATA, "+>>$data_file") || error($data_file,'10');
    flock(DATA,2);
    seek DATA, 0, 0;
    my @list = <DATA>;

    my $expr = join(' || ',map { "m/^$bids[$_]/o" } 0..$#bids);
	my $match_any = eval "sub { $expr }";
	for (@list) {
		if (&$match_any) {
			#chomp $_;
			@info = split(/\|/,$_);
			$this_bid = param("item$info[0]");
			#check for proper bid format
			$this_bid =~ s/\$//;   #remove dollar sign if there
			$ITEMS{$info[0]} = $info[3]; #saves item name for log file
			unless ($this_bid =~ /^(\d+\.?(\d\d)?|\.\d\d)$/) {
 				push(@bad_bid,$info[3]);
 				#$ITEMS{$info[0]} = $info[3]; #saves item name for log file
 				next;	#move on to next bid since this one is invalid
			}
			#check if bidding closed since page was drawn
			next if param("item$info[2]") >= $now;
			
			#does bid meet minimum?
			if ($info[11]) {
        		$min_bid = $info[11] + $info[5];
        	}
        	else {
        		$min_bid = $info[4];
        	}
        	if ($this_bid < $min_bid) {
        		push(@low_bid,$info[3]);
        		next;
        	}
        	
        	
			#made it this far, so update bid info with new bid
			#gather info for update email
			
			$ITEMS{$info[0]} = $info[3]; #saves item name for log file
			my $update_item_num = $info[0];
			my $update_bidder_id = $info[8];
			my $update_item = $info[3];
			my $update_email = $info[10];
			my $update_old_bid = $info[11];
			my $update_old_bid_time = $info[12];
			my $update_new_bid = $this_bid;
			my $update_close_time = $info[2];
			my $update_info = join '|', ($update_item,$update_email,$update_old_bid,
										$update_old_bid_time,$update_new_bid,$update_close_time,
										$update_item_num,$update_bidder_id);
			push(@update,$update_info);

        	$info[8] = $id;
        	$info[9] = $initials;
        	$info[10] = $email;
        	$info[11] = format_amt($this_bid);
        	$info[12] = $now;
        	
        	$_ = join '|', @info;

        	$report_line = "$info[3]|$info[11]";
        	push(@good_bids,$report_line);
 
 
		}	## end if (&$match_any)
			

	} 	##end for (@list)

	#now reload the data file
	seek DATA, 0, 0;
	truncate $data_file, 0;
	foreach my $line(@list) {
		chomp $line;
		print DATA "$line\n";
	}
	close(DATA);
	
	#send update email to bidders who were outbid
	if(@update) {
		send_updates(@update);
	}
	
	log_bids($request,$id,$name);

	#send feedback
	
	#make the table rows for accepted bids
	my (@report_rows);
	push(@report_rows,Tr({-bgcolor=>'#dddddd'},td("Bid Results for $name"),td("Bid Time: $time")));
	push(@report_rows,Tr(td(b('Item')),td(b('Bid'))));
	if (!@good_bids) {
		push (@report_rows,Tr(td({-colspan=>'2',-align=>'center'},'No Bids Accepted')));
	}
	else {
		for (@good_bids) {
			chomp;
			my @bids_data = split(/\|/);
			push(@report_rows,Tr(td($bids_data[0]),td($bids_data[1])));
		}
	}
		
	print header(-expires=>'-1d'),
	start_html(-bgcolor=>$BG,-text=>$TX,-link=>$LL,
				-vlink=>$VL,-background=>$BGIMG,-title=>'Bid Results'),
	center(
		h1($AUCTION_TITLE),
		h2($category),
	
	hr,
	table({-boder=>'0',-cellspacing=>'0',-cellpadding=>'2'},@report_rows),
	hr,
	center(a({-href=>"$script/$category_key"},'Return to Bid Page')),
	hr,
	); #end center

	if ((@low_bid) || (@bad_bid)) {
		print b('Errors:'),br;
	}
	
	if (@bad_bid) {
		print 'The following item(s) had invalid bids entered:',
		ul(
             li({-type=>'disc'},[@bad_bid]),
        );
    }
    
    if (@low_bid) {
    	print 'The following item(s) had bids that did not meet the minimum:',
		ul(
             li({-type=>'disc'},[@low_bid]),
        );
    }
    
    if ((@low_bid) || (@bad_bid)) {
    	print a({href=>'javascript:history.go(-1);'},'Go Back and Fix');
	}
	print end_html;
	exit(0);
} ##end process_bid

sub log_bids {
	my $category_key = shift;
	my $id = shift;
	my $name = shift;
	my @bids;
	#my $log_file = $INFO_PATH . $category_key . ".log";
	my $log_file = $INFO_PATH . $category_key . ".blog";
	#since we entered the paths, and have checked category key,
	#they should be okay.
	$log_file =~ /^(.*)$/;
	$log_file = $1;
	my $time = $TIME;
	my @items = param(); 
    for (@items) {
  		if ((/^item/) && (param($_))){
  			s/^item(\d+)/$1/;
  			push(@bids, $_);
  		}
  	}
    open(LOG, ">>$log_file") || error($log_file,'10');
    flock(LOG,2);
    
    for (@bids) {
    	my $t = param("item$_");
    	my $log_line = join(':',$time,$_,$ITEMS{$_},$id,$name,$t);
    	print LOG "$log_line\n";
    }

    close(LOG);

}

sub send_updates {
	return unless $UPDATE;
	my @updates = @_;
	my $line;
	foreach $line (@updates) {
		chomp $line;
		my @data = split(/\|/,$line);
		next if !$data[1]; #no bid yet so skip it
		my $item_name = $data[0];
		my $to = $data[1];
		my $old_bid = $data[2];
		my $bid_time = format_time($data[3]);
		my $new_bid = format_amt($data[4]);
		my $close = format_time($data[5]);
		my $body = '';
		$body .= "This notice is from $AUCTION_TITLE.\n";
		$body .= "At $bid_time you placed a bid of \$$old_bid on the $item_name.\n";
		$body .= "A new bid of \$$new_bid has been placed and ";
		$body .= "you are no longer the high bidder.\n";
		$body .= "You may return to the auction at $AUCTION_URL to update your bid.\n";
		$body .= "The bidding on this item closes $close.\n";
		$body .= "\nRef\#: $data[6]\n";
		$body .= "Bidder\#: $data[7]\n";
		
		send_email($to,$body,'Bid Update');
		
	}
}
