#!/usr/bin/perl
############################################
##                                        ##
##            OpenSearch                  ##
##             by OpenScripts.com         ##
##      (e-mail admin@openscripts.com)    ##
##                                        ##
##             version:  1.01             ##
##         last modified: 08/22/00        ##
##           copyright (c) 2000           ##
##                                        ##
##    latest version is available from    ##
##         http://openscripts.com/        ##
##                                        ##
############################################

# COPYRIGHT NOTICE:
#
# Copyright 2000 OpenScripts.com.  All Rights Reserved.
#
# This program is being distributed as freeware to registered users of OpenScripts.com
# for educational uses. No claims are made for any current or future commercial value.
# It may be used and modified, as long as this copyright notice and the header
# above remain intact Selling the code for this program without prior
# written consent is expressly forbidden.
#
# This program is distributed "as is" and without warranty of any
# kind, either express or implied.  (Some states do not allow the
# limitation or exclusion of liability for incidental or consequential
# damages, so this notice may not apply to you.)  In no event shall
# the author of this script, Steve Clark, be liable for any damages or
# losses. You use this script on your own risk.


use LWP::Simple;
use HTML::TokeParser;
require Time::Local;
require "Template.pm";

my @cellcolor=("FFFFFF","EEEEEE");
my $color = 0;
my $templatepath = "/home/auctionlistings/templates/";
my $hotpath = "<img src=\"../images/hot.gif\">";
my $picpath = "<img src=\"../images/pic.gif\">";
print "Content-type: text/html\n\n";
%form = &get_form_data;
$form{'terms'} =~ s/ /+/g;

if ($form{'offset'}) {
	$offset = "\&offset=$form{'offset'}";
	$upset = $form{'offset'} + 50;
	$backset = $form{'offset'} - 50;
	$linkforward = "\&offset=$upset";
	$linkback =  "\&offset=$backset";
}
else {
	$offset = "";
	$linkforward = "\&offset=50";
	$linkback = "\&offset=0";
}
if ($form{'use_desc'}) {
	$use_desc = "\&use_desc=$form{'use_desc'}";
}
else {
	$use_desc = "";
}
if ($form{'sort'}) {
	$sort = "\&sort=$form{'sort'}";
}
else {
	$sort = "";
}

my $nav =<<"EOF";
<br><br><center><a href=$ENV{'SCRIPT_NAME'}?terms=$form{'terms'}$sort$linkback$use_desc>BACK</a> &nbsp  <a href=$ENV{'SCRIPT_NAME'}?terms=$form{'terms'}$sort$linkforward$use_desc>FORWARD</a></center>
EOF
my $footer =<<"EOF";
<br><CENTER><FONT SIZE=-1><I>Powered By <A HREF=http://www.openscripts.com/>OpenScripts.com</A></I></FONT></CENTER><br>
<center><a href="http://www2.valinux.com/adbouncer.phtml?f_s=468x60&f_p=592">
<img src="http://www2.valinux.com/adserver.phtml?f_s=468x60&f_p=592" width="468" height="60" border="0"
alt="Member of the VA Affiliate Underground" ></a></center>
EOF

$awpage = "http://auctionwatch.com/usearch/results.html?terms=$form{'terms'}$sort$use_desc$offset";
if ($form{'terms'}){
	$webPage=get($awpage);
	&parse_AW_page;
	&output;
}
else {
	$itemcount = "Enter Search Terms";
	&output;
}


sub parse_AW_page{
	$parser=HTML::TokeParser->new(\$webPage);
	 while (my $token = $parser->get_tag("span")) {
		$itemcount = $parser->get_trimmed_text("/span");
		if ($itemcount =~ /Results/i){
			last;
		}
	 }

	 while (my $token = $parser->get_tag("b")) {
		$linkText = $parser->get_trimmed_text("/b");
		if ($linkText eq "Auction Results") {
			my $token = $parser->get_tag("td");
			my $token = $parser->get_tag("b");
			$linkText = $parser->get_trimmed_text("/b");
			$resultsout .= " Displaying $linkText ";
			my $token = $parser->get_tag("b");
			$linkText = $parser->get_trimmed_text("/b");
			$resultsout .= " of $linkText  Total Results";
			&parse;
			return;
			
		}
	 }
}
sub parse {
 while (my $token = $parser->get_tag("tr")) {
		my $token = $parser->get_tag("input");
		$sitestuff = $token->[1]{value} || "-";
		if ($sitestuff eq "title"){return;}
		if ($sitestuff eq "c"){return;}
		if ($sitestuff eq "-"){return;}
		if ($sitestuff eq "search"){next;}
		($sitenum, $itemnum) = split (/:/, $sitestuff);
		my $itempic = "";
		my $token = $parser->get_tag("td"); 
		$itempic = $parser->get_trimmed_text("/td");
		if ($itempic eq "[IMG]"){
			$pic = $picpath;
		}
		else {
			$pic = "";
		}
		my $token = $parser->get_tag("a");
		$title = $parser->get_trimmed_text("/a");
		if ($sitenum eq "1"){
			$sitename = "eBay";
			$titlelink = "http://cgi.ebay.com/aw-cgi/eBayISAPI.dll?MfcISAPICommand=ViewItem&item=$itemnum";
		}
		elsif ($sitenum eq "2"){
			$sitename = "Amazon";
			$titlelink = "http://s1.amazon.com/exec/varzea/ts/exchange-glance/$itemnum";
		}
		elsif ($sitenum eq "3"){
			$sitename = "Yahoo!";
			$titlelink = "http://page.auctions.yahoo.com/auction/$itemnum";
		}
		else {
			$sitename = "Other";
			$titlelink = "";
		}
		if ($titlelink){
			$linkedtitle = "<a href=$titlelink>$title</a>";
		}
		else {
			$linkedtitle = $title;
		}
		my $token = $parser->get_tag("td");
		my $token = $parser->get_tag("td"); 
		$price = $parser->get_trimmed_text("/td");
		($junk, $itemprice) = split (/\$/, $price);
		my $token = $parser->get_tag("td");
		my $itembids = 0;
		$itembids = $parser->get_trimmed_text("/td");
		if ($itembids eq "--"){$itembids = 0; $testbids = 0;}
		else {$testbids = $itembids;}
		if ($itembids > 9){
			$hotpic = $hotpath;
		}
		else {
			$hotpic = "";
		}
	
		my $token = $parser->get_tag("td"); 
		$itemends = $parser->get_trimmed_text("/td");
		if ($itemends =~ /closed/i){next;}
		$endingtimedate = $itemends;
$rowcolor = $cellcolor[$color];
$searchout .= "<tr><td BGCOLOR=\"$rowcolor\">$linkedtitle $pic $hotpic</td><td BGCOLOR=\"$rowcolor\"><center>$sitename</center></td><td BGCOLOR=\"$rowcolor\"><center>$endingtimedate</center></td><td BGCOLOR=\"$rowcolor\"><center>$itembids</center></td><td BGCOLOR=\"$rowcolor\"><center>$price</center></td></tr>";
$color = int(!($color));
 }
}
################################################################
sub load_template {
# --------------------------------------------------------
# Loads and parses a template. Expects to find as input a
# template file name, and a hash ref and optionally template text.
#

    my ($tpl, $vars, $string) = @_;

    my $template = new Template ( { ROOT => $templatepath, CHECK => 0 } );

    $template->clear_vars;
    $template->load_template ($tpl, $string);
    $template->load_vars     ($vars);
    return $template->parse  ($tpl);
}
#-######################################################################
#-
# Sub: Get Form Data
# This gets data from a post.

sub get_form_data {
        my $temp;
        my $buffer;
        my @data;
        read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
        foreach $temp (split(/&|=/,$buffer)) {
                $temp =~ tr/+/ /;
                $temp =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
		$temp =~ s/[\r\n]/ /g;
                push @data, $temp;
        }
        foreach $temp (split(/&|=/,$ENV{'QUERY_STRING'})) {
                $temp =~ tr/+/ /;
                $temp =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
		$temp =~ s/[\r\n]/ /g;
                push @data, $temp;
        }
        return @data;
}
#-#############################################
# Sub: Output
# This prints the results.

sub output {
    print	&load_template ('searchauction.html', {
				SEARCHSTRING => "$form{'terms'} $resultsout",
				SEARCHOUT => $searchout,
				FOOTER => $footer,
				NAV => $nav,
				SCRIPT_NAME => $ENV{'SCRIPT_NAME'}
	});
}
