use strict;
require Time::Local;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
#-#############################################
# Process New Item
# This processes new item to be put up for
# sale from a posted form

	my ($password, @userbids);
	if ($config{'regdir'} ne "") {
		$form{'ALIAS'} = ucfirst(lc($form{'ALIAS'}));
		&oops('Your alias could not be found!') unless ($password, $form{'EMAIL'}, $form{'ADDRESS1'}, $form{'ADDRESS2'}, $form{'ADDRESS3'}, @userbids) = &read_reg_file($form{'ALIAS'});
		&oops('Your password is incorrect.') unless ((lc $password) eq (lc $form{'PASSWORD'}));
	}
	&oops('You must have an item title that is up to 50 characters.') unless ($form{'TITLE'} && (length($form{'TITLE'}) < 51));
	$form{'TITLE'} =~ s/\</\&lt\;/g;
	$form{'TITLE'} =~ s/\>/\&gt\;/g;
 #&oops('You must select a valid category.') unless (-d "$config{'basepath'}$form{'CATEGORY'}" and $category{$form{'CATEGORY'}});
	$form{'IMAGE'} = "" if ($form{'IMAGE'} eq "http://");
	&oops('You must enter an item description.') unless ($form{'DESC'});
	&oops('You must enter an alias to track your item.') unless ($form{'ALIAS'});
	&oops('You must enter a valid e-mail address.') unless ($form{'EMAIL'} =~ /^.+\@.+\..+$/);
	&oops('You must enter a valid starting bid.') unless ($form{'BID'} =~ /^(\d+\.?\d*|\.\d+)$/);
	&oops('You must enter a valid bid increment.') unless (($form{'INC'} =~ /^(\d+\.?\d*|\.\d+)$/) and ($form{'INC'} >= .01));
	$form{'INC'} = &parsebid($form{'INC'});
	$form{'RESERVE'} = &parsebid($form{'RESERVE'});
	&oops('You must enter your full name.') unless ($form{'ADDRESS1'});
	&oops('You must enter your street address.') unless ($form{'ADDRESS2'});
	&oops('You must enter your city, state, and zip code.') unless ($form{'ADDRESS3'});
    my $item_number = &Time::Local::timelocal(0,$form{'minute'},$form{'hour'}, $form{'day'}, $form{'month'}, 00);
	#$item_number = ($form{'DAYS'} * 86400 + time) until (!(-f "$config{'basepath'}$form{'CATEGORY'}/$item_number.dat"));
	if ($form{'FROMPREVIEW'}) {
		my $key;
		foreach $key (keys %form) {
			$form{$key} =~ s/\[greaterthansign\]/\>/gs;
			$form{$key} =~ s/\[lessthansign\]/\</gs;
			$form{$key} =~ s/\[quotes\]/\"/gs;
		}
		&postitem($item_number);
	}
	else {
		my $nowtime = localtime(time);
		my $closetime = localtime($item_number);
		print "<H2>$form{'TITLE'} PREVIEW</H2><HR><FONT SIZE=+1><B>Information</B></FONT><HR>\n";
		print "<TABLE WIDTH=100\%><TR>";
		print "<TD BGCOLOR=$config{'colortablebody'}><IMG SRC=$form{'IMAGE'}></TD>" if ($form{'IMAGE'});
		print "<TD><TABLE BORDER=1><TR><TD BGCOLOR=$config{'colortablehead'}><B>$form{'TITLE'}</B></TD></TR><TR><TD BGCOLOR=$config{'colortablebody'}><B>Category:</B> <A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'CATEGORY'}>$category{$form{'CATEGORY'}}</A></TD></TR><TR><TD BGCOLOR=$config{'colortablebody'}><B>Offered By:</B> <A HREF=mailto:$form{'EMAIL'}>$form{'ALIAS'}</A></TR></TD><TR><TD BGCOLOR=$config{'colortablebody'}><B>Current Time:</B> $nowtime</TD></TR><TR><TD BGCOLOR=$config{'colortablebody'}><B>Closes:</B> $closetime<BR><FONT SIZE=-2>Or $config{'aftermin'} minutes after last bid...</FONT></TD></TR><TR><TD BGCOLOR=$config{'colortablebody'}><B>Number of Bids:</B> 0</TD></TR><TR><TD BGCOLOR=$config{'colortablebody'}><B>Last Bid:</B> \$$form{'BID'}</TD></TR></TABLE></TD></TR></TABLE>\n";
		print "<HR><FONT SIZE=+1><B>Description</B></FONT><HR>$form{'DESC'}</FONT></FONT></B></I></U></H1></H2></H3></H4></H5>";
		print "<HR><B><FORM ACTION=$ENV{'SCRIPT_NAME'} METHOD=POST>If this looks good, hit <INPUT TYPE=SUBMIT VALUE=\"Post Item\">, else hit the back button on your browser to edit the item.<INPUT TYPE=HIDDEN NAME=FROMPREVIEW VALUE=1></B>\n";
		my $key;
		foreach $key (keys %form) {
			$form{$key} =~ s/\>/\[greaterthansign\]/gs;
			$form{$key} =~ s/\</\[lessthansign\]/gs;
			$form{$key} =~ s/\"/\[quotes\]/gs;
			print "<INPUT TYPE=hidden NAME=\"$key\" VALUE=\"$form{$key}\">\n";
		}
		print "</FORM>\n";
	}

