use strict;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
#-#############################################
# Process Registration
# This adds new accounts to the database

	if ($config{'regdir'}) {
		umask(000);  # UNIX file permission junk
		mkdir("$config{'basepath'}$config{'regdir'}", 0777) unless (-d "$config{'basepath'}$config{'regdir'}");		
		&oops('You must enter an alias that consists of alphanumeric characters.') if $form{'ALIAS'} =~ /\W/ or !($form{'ALIAS'});
		&oops('You must enter a valid e-mail address.') unless ($form{'EMAIL'} =~ /^.+\@.+\..+$/);
		&oops('You must enter your full name so buyers or sellers may contact you.') unless ($form{'ADDRESS1'});
		&oops('You must enter a valid street address so buyers or sellers can contact you.') unless ($form{'ADDRESS2'});
		&oops('You must enter a valid city, state, and zip code so buyers or sellers can contact you.') unless ($form{'ADDRESS3'});
		$form{'ALIAS'} = ucfirst(lc($form{'ALIAS'}));
		&procreg;
	}
	else {
		print "User Registration is Not Implemented on This Server!  The System Administrator Did Not Specify a Registration Directory...\n";
	}
	


#-#############################################
# Sub: Random Password
# This generates psudo-random 8-letter
# passwords

sub randompass {
	srand(time ^ $$);
	my @passset = ('a'..'k', 'm'..'n', 'p'..'z', '2'..'9');
	my $randpass = "";
	for (my $i=0; $i<8; $i++) {
		$randpass .= $passset[int(rand($#passset + 1))];
	}
	return $randpass;
}
