use strict;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
#-#############################################
# Process Bid
# This processes new bids from a posted form

	require "sendemail.pl";
	my ($password, @userbids);
	if ($config{'regdir'} ne "") {
		&oops('Your alias could not be found!') unless ($password, $form{'EMAIL'}, $form{'ADDRESS1'}, $form{'ADDRESS2'}, $form{'ADDRESS3'}, @userbids) = &read_reg_file($form{'ALIAS'});
		$form{'ALIAS'} = ucfirst(lc($form{'ALIAS'}));
		&oops('Your password is incorrect.') unless ((lc $password) eq (lc $form{'PASSWORD'}));
	}
	&oops('You must enter an alias to track your item.') unless ($form{'ALIAS'});
	&oops('You must enter a valid e-mail address.') unless ($form{'EMAIL'} =~ /^.+\@.+\..+$/);
	&oops('You must enter a valid bid amount.') unless ($form{'BID'} =~ /^(\d+\.?\d*|\.\d+)$/);
	$form{'BID'} = &parsebid($form{'BID'});
	&oops('You must enter your full name.') unless ($form{'ADDRESS1'});
	&oops('You must enter your street address.') unless ($form{'ADDRESS2'});
	&oops('You must enter you city, state, and zip.') unless ($form{'ADDRESS3'});
	&oops('The item number you entered cannot be found.  Maybe it has closed or it was moved since you last loaded the page.') unless my ($title, $reserve, $inc, $desc, $image, @bids) = &read_item_file($form{'CATEGORY'},$form{'ITEM'});
	my ($selleralias, $selleremail, $sellerbid, $sellertime, $selleradd1, $selleradd2, $selleradd3) = &read_bid($bids[0]);
	&oops('You cannot bid on your own item!') if ($selleralias eq $form{'ALIAS'});
	my ($alias, $email, $bid, $time, $add1, $add2, $add3) = &read_bid($bids[$#bids]);
	if ((time <= $form{'ITEM'}) or (time <= (60 * $config{'aftermin'} + $time))) {
		&oops('Your bid is too low.  Sorry.') if ($form{'BID'} < ($bid+$inc) and ($#bids)) or ($form{'BID'} < $bid);
		&oops('We are unable to append your bid to the auction item.  It appears to be a file write problem.') unless (open NEW, ">>$config{'basepath'}$form{'CATEGORY'}/$form{'ITEM'}.dat");
		if ($config{'flock'}) {
			flock(NEW, 2);
			seek(NEW, 0, 2);
		}
		print NEW "\n$form{'ALIAS'}\[\]$form{'EMAIL'}\[\]$form{'BID'}\[\]".time."\[\]$form{'ADDRESS1'}\[\]$form{'ADDRESS2'}\[\]$form{'ADDRESS3'}";
		close NEW;
		print "<B>$form{'ALIAS'}, your bid has been placed on item number $form{'ITEM'} for \$$form{'BID'} on ".scalar(localtime(time)).".</B><BR>You may want to print this notice as confirmation of your bid.<P>Go <A HREF=\"$ENV{'SCRIPT_NAME'}\?category=$form{'CATEGORY'}\&item=$form{'ITEM'}\">back to the item</A>\n";
		my $flag=0;
		my $userbid;
		foreach $userbid (@userbids) {
			$flag=1 if ("$form{'CATEGORY'}$form{'ITEM'}" eq $userbid);
		}
		if ($flag==0 && $config{'regdir'} ne "") {
			&oops('ALIAS') unless (open(REGFILE, ">>$config{'basepath'}$config{'regdir'}/$form{'ALIAS'}.dat"));
			print REGFILE "\n$form{'CATEGORY'}$form{'ITEM'}";
			close REGFILE;
		}
		&sendemail($email, $config{'admin_address'}, 'You\'ve been outbid!', "You have been outbid on $title\!  If you want to place a higher bid, please visit\:\n\n\thttp://$config{'scripturl'}$ENV{'SCRIPT_NAME'}\?category=$form{'CATEGORY'}\&item=$form{'ITEM'}\n\nThe current high bid is \$$form{'BID'}.") if ($config{'scripturl'} and $#bids);
	}
	else {
		print "Item number $form{'ITEM'} in category $form{'CATEGORY'} is now closed!<BR>Sorry...\n";
	}
1;
