use strict;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
#-#############################################
# Display List Of Categories
# This creates a "nice" list of categories.
	my ($key, $maincat, $categorytable, %maincats);
	&autoclose;
	&maincats;
	foreach $maincat (sort keys %maincats) {
			$categorytable .= "<TR><TD BGCOLOR=$config{'colortablebody'}><A HREF=$ENV{'SCRIPT_NAME'}\?category=$maincat&listtype=current&level=0>$category{$maincat}</A> <small>($maincats{$maincat})</small></TD></TR>";
	}
    print	&load_template ('dispcat.html', { 
				CATEGORYTABLE => $categorytable,
				%globals
	});      
##############################################
# Sub: Get Main Categories 

sub maincats {
	my @data;
	foreach $key (sort keys %category) {
		my @catarray = split (/\//,$key);
			umask(000);  # UNIX file permission junk
			mkdir("$config{'basepath'}$key", 0777) unless (-d "$config{'basepath'}$key");
			opendir DIR, "$config{'basepath'}$key" or &oops("Category directory $key could not be opened.");
			$maincats{$catarray[0]} = $maincats{$catarray[0]} + scalar(grep -T, map "$config{'basepath'}$key/$_", readdir DIR);
			closedir DIR;
	}
}
##############################################
# Sub: Automate Close Auctions 
# This allows the script to close all items that
# have passed their closing time, w/o having
# to go to each item seperately

sub autoclose {
require "sendemail.pl";
mkdir("$config{basepath}$config{closedir}", 0777) unless (-d "$config{basepath}$config{closedir}/$key");             
my ($title, $reserve, $inc, $desc, $image, @lastbid, @firstbid, $key, @allfiles, $file, $bid, @bids, @thebid, $bidtime, $reservemsg, $nowtime, $closetime, $numauct);
 foreach $key (sort keys %category) {
   mkdir("$config{basepath}$config{closedir}$key", 0777) unless (-d "$config{basepath}$config{closedir}/$key");             
   opendir THEDIR, "$config{basepath}$key" || die "Unable to open directory: $!";
        @allfiles = readdir THEDIR;
        closedir THEDIR;
          foreach $file (sort { int($a) <=> int($b) } @allfiles) {
            if (time > $file) {
              if (-T "$config{basepath}$key/$file") {
                open THEFILE, "$config{basepath}$key/$file";
                ($title, $reserve, $inc, $desc, $image, @bids) = <THEFILE>;
                close THEFILE;
                chomp($title, $reserve, $inc, $desc, $image, @bids);
                @firstbid = split(/\[\]/,$bids[0]);
                @lastbid = split(/\[\]/,$bids[$#bids]);
                $nowtime = localtime(time);
                $closetime = localtime($file);
                foreach $bid (@bids) {
                        @thebid = split(/\[\]/,$bid);
                        $bidtime = localtime($thebid[3]);
                }
                        if ($key ne $config{closedir}) {
                                if ($config{closedir}) {
                                        umask(000);  # UNIX file permission junk
                                        print "Please notify the site admin that this item cannot be copied to the closed directory even though it is closed.\n" unless &movefile("$config{basepath}$key/$file", "$config{basepath}$config{closedir}$key/$file");
                                #       print "<H3>$category{$key}\: $title closed</H3><BR>";
                                        $numauct = $file;
                                        $numauct =~ s/\.dat//;  #makes it just the number, rather than number.dat 
                                }
                                else {
                                print "Please notify the site admin that this item cannot be removed even though it is closed.\n" unless unlink("$config{basepath}$key/$file");
                                }
                                if ($lastbid[2] >= $reserve) {
                                        &sendemail($lastbid[1], $config{'admin_address'}, "Auction Winner: $title", "Congratulations!  You are the winner of auction number $numauct.\nYour winning bid was \$$lastbid[2].\n\nPlease contact the seller to make arrangements for payment and shipping:\n\n$firstbid[4]\n$firstbid[5]\n$firstbid[6]\n$firstbid[1]\n\nThanks for using OpenAuction!");
                                        $reservemsg = " ";
                                }
                                else {
                                        if ($firstbid[2] ne $lastbid[2]) {
                                                &sendemail($lastbid[1], $config{'admin_address'}, "Auction Close: $title", "Congratulations!  You were the high bidder on auction number $numauct.\nYour bid was \$$lastbid[2].\n\nUnfortunately, your bid did not meet the seller\'s reserve price...\n\nYou may still wish to contact the seller to negotiate a fair price:\n\n$firstbid[4]\n$firstbid[5]\n$firstbid[6]\n$firstbid[1]\n\nThanks for using OpenAuction!");
                                        $reservemsg = "YOUR RESERVE PRICE WAS NOT MET! Feel free to repost your auction by following this link: http://$config{'scripturl'}$ENV{'SCRIPT_NAME'}\?1\&1\&v";
                                        }
                                        else {
                                                $reservemsg = "Sorry, no bids were placed on your auction. Feel free to repost your auction by following this link: http://$config{'scripturl'}$ENV{'SCRIPT_NAME'}\?action=repost";
                                        }
                                }
                                        &sendemail($firstbid[1], $config{'admin_address'}, "Auction Close: $title", "Auction Number $numauct Is Now Closed.\nThe high bid was \$$lastbid[2] (Your reserve was: \$$reserve).\n\n$reservemsg\n\nPlease contact the high bidder to make any necessary arrangements:\n\n$lastbid[4]\n$lastbid[5]\n$lastbid[6]\n$lastbid[1]\n\nThanks for using OpenAuction!");
                        }
                }
         }
           }
     }
} 
#-#############################################
# Sub: Movefile(file1, file2)
# This moves a file.  Quick and dirty!

sub movefile {
	my ($firstfile, $secondfile) = @_;
	print "Failed to open first file" unless open(FIRSTFILE,$firstfile);
	my @lines=<FIRSTFILE>;
	close FIRSTFILE;
	print "Failed to open second file" unless open(SECONDFILE,">$secondfile");
	my $line;
	foreach $line (@lines) {
		print SECONDFILE $line;
	}
	close SECONDFILE;
	print "Failed to unlink first file" unless unlink($firstfile);
	return 1;
}

1;