#!/usr/bin/perl
use vars qw(%config %category %form %globals);
use strict;
use lib "/home/auction/pl2";
require "config.pl";
#-###########################################################################
# 
# OpenAuction Release Version   1.02b3
# Copyright (C) 2000 OpenScripts.com
# http://www.openscripts.com
#
#
# Original Copyright (C) 2000 EverySoft
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#-###########################################################################
#
# Modification Log:
#
# * Steve Clark (admin@openscripts.com) - 8/01/00 Fixed more bugs.
#
# * Steve Clark (admin@openscripts.com) - 6/26/00 Added seller sets exact closing time, 
# * feedback system, viewsellers other auctions, spam proof blind email, debugging
# * feature, integrated help thanks to Ralph Roberts.
#
#
# * Steve Clark (admin@openscripts.com) - 3/27/00 Restored copyright notice to INSTALL file to appease Matt.
#
#
# * Steve Clark (admin@openscripts.com) - 3/23/00 Complete rewrite adding modularity and templates.
# * Mail to friend, lost password, unlimited subcats, new, hot, going, improved closed viewer,
# * closing today, ask seller a question. Extensive reformatting of output.
# 
# 
# * Matt Hahnfeld (matth@everysoft.com) - Original Concept and Design
#
#-###########################################################################
($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");    # Get the script location: UNIX /
($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");    # Get the script location: Windows \
eval    { &main; };                      # Trap any fatal errors so the program hopefully 
if ($@) { &cgierr("fatal error: $@"); }  # never produces those nasty blank pages.
exit;    
#-#############################################
# Main Program
#
#
#-#############################################
sub main {
print "Content-type: text/html\n\n";
%form = &get_form_data;
if ($form{'action'} eq 'new') { 
	require "newitem.pl"; 
}
elsif ($form{'action'} eq 'repost') { 
	require "newitem.pl"; 
}
elsif ($form{'action'} eq 'procnew') { 
   	require "procnew.pl"; 
}
elsif ($form{'action'} eq 'procbid') { 
	require "procbid.pl"; 
}
elsif ($form{'action'} eq 'help') { 
	require "help.pl"; 
}
elsif ($form{'action'} eq 'reg') { 
	require "newreg.pl"; 
}
elsif ($form{'action'} eq 'procreg') { 
	require "procreg.pl"; 
}
elsif ($form{'action'} eq 'creg') { 
	require "chreg.pl"; 
}
elsif ($form{'action'} eq 'proccreg') { 
	require "proccreg.pl"; 
}
elsif ($form{'action'} eq 'admin') { 
	require "admin.pl"; 
}
elsif ($form{'action'} eq 'feed') { 
	require "feed.pl"; 
}
elsif ($form{'action'} eq 'viewseller') { 
	require "viewsellers.pl"; 
}
elsif ($form{'action'} eq 'feed') { 
	require "feed.pl"; 
}
elsif ($form{'action'} eq 'askseller') { 
	require "askseller.pl"; 
}
elsif ($form{'action'} eq 'sellersend') { 
	require "sellersend.pl"; 
}
elsif ($form{'action'} eq 'lostpass') { 
	require "lostpass.pl"; 
}
elsif ($form{'action'} eq 'mailto') { 
	require "mailto.pl"; 
}
elsif ($form{'action'} eq 'mailtosend') { 
	require "mailtosend.pl"; 
}
elsif ($form{'action'} eq 'procadmin') { 
	require "procadmin.pl"; 
}
elsif ($form{'action'} eq 'search') { 
	require "procsearch.pl"; 
}
elsif ($form{'action'} eq 'dispcloseditem') { 
	require "dispitemclosed.pl"; 
}
elsif ($form{'item'} eq int($form{'item'}) and $category{$form{'category'}}) { 
	require "dispitem.pl"; 
}
elsif ($form{'category'} and ($form{'listtype'} eq 'new')) { 
	require "displistnew.pl"; 
}
elsif ($form{'category'} and ($form{'listtype'} eq 'closingtoday')) { 
	require "displistclosingtoday.pl"; 
}
elsif ($form{'category'} and ($form{'listtype'} eq 'hot')) { 
	require "displisthot.pl"; 
}
elsif ($form{'category'} and ($form{'listtype'} eq 'going')) { 
	require "displistgoing.pl"; 
}
elsif ($form{'category'} and ($form{'listtype'} eq 'closed')) { 
	require "displistclosed.pl"; 
}
elsif ($form{'category'} and ($form{'listtype'} eq 'current')) { 
	require "displist.pl"; 
}
else { 
	require "dispcat.pl"; 
}
}
#-######################################################################
#- We always have to do this so we leave it here, as a general call
# Sub: Get Form Data
# This gets data from a post.

sub get_form_data {
        my $temp;
        my $buffer;
        my @data;
        read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
        foreach $temp (split(/&|=/,$buffer)) {
                $temp =~ tr/+/ /;
                $temp =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
		$temp =~ s/[\r\n]/ /g;
                push @data, $temp;
        }
        foreach $temp (split(/&|=/,$ENV{'QUERY_STRING'})) {
                $temp =~ tr/+/ /;
                $temp =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
		$temp =~ s/[\r\n]/ /g;
                push @data, $temp;
        }
        return @data;
}
################################################################
sub load_template {
# --------------------------------------------------------
# Loads and parses a template. Expects to find as input a 
# template file name, and a hash ref and optionally template text.
#
require "Template.pm";

    my ($tpl, $vars, $string) = @_;
    
    my $template = new Template ( { ROOT => $config{'templatepath'}, CHECK => 0 } );
 
    $template->clear_vars;
    $template->load_template ($tpl, $string);
    $template->load_vars     ($vars);   
    return $template->parse  ($tpl); 
}


#-#############################################
# Sub: parse bid
# This formats a bid amount to look good...
# ie. $###.##

sub parsebid {
	$_[0] =~ s/\,//g; 
	my @bidamt = split(/\./, $_[0]);
	$bidamt[0] = "0" if (!($bidamt[0]));
	$bidamt[0] = int($bidamt[0]);
	$bidamt[1] = substr($bidamt[1], 0, 2);
	$bidamt[1] = "00" if (length($bidamt[1]) == 0);
	$bidamt[1] = "$bidamt[1]0" if (length($bidamt[1]) == 1);
	return "$bidamt[0].$bidamt[1]";
}

#-#############################################
# Sub: Oops!
# This generates an error message and dies.

sub oops {
    print	&load_template ('oops.html', { 
				OOPS => $_[0],
				%globals
	});      
	die "Error: $_[0]\n";
}

#-#############################################
# Sub: Read Reg File (alias)
# Reads a registration file

sub read_reg_file {
	my $alias = shift;
	return '' unless $alias;
	# verify the user exists
	&oops('Your alias may not contain any non-word characters.') if $alias =~ /\W/;
	$alias = ucfirst(lc($alias));
	return '' unless -r "$config{'basepath'}$config{'regdir'}/$alias.dat" and -T "$config{'basepath'}$config{'regdir'}/$alias.dat";
	print "Could not open user file $alias" unless (open FILE, "$config{'basepath'}$config{'regdir'}/$alias.dat");
	my ($password,$email,$add1,$add2,$add3,@past_bids) = <FILE>;
	close FILE;
	chomp ($password,$email,$add1,$add2,$add3,@past_bids);
	return ($password,$email,$add1,$add2,$add3,@past_bids);
}

#-#############################################
# Sub: Read Item File (cat, item)
# Reads an item file

sub read_item_file {
	my ($cat, $item) = @_;
#print "$cat      $item";
	# verify the category exists
	return '' unless $cat and $item;
	#&oops('The category may not contain any non-word characters.') if $cat =~ /\W/;
	#return '' unless $category{$cat};
	# verify the item exists
	&oops('The item number may not contain any non-numeric characters.') if $item =~ /\N/;
	return '' unless -T "$config{'basepath'}$cat/$item.dat" and -R "$config{'basepath'}$cat/$item.dat";
	open FILE, "$config{'basepath'}$cat/$item.dat";
	my ($title, $reserve, $inc, $desc, $image, @bids) = <FILE>;
	close FILE;
	chomp ($title, $reserve, $inc, $desc, $image, @bids);
	return ($title, $reserve, $inc, $desc, $image, @bids);
}

#-#############################################
# Sub: Read Bid Information (bid_string)
# Reads an item file

sub read_bid {
	my $bid_string = shift;
	my ($alias, $email, $bid, $time, $add1, $add2, $add3) = split(/\[\]/,$bid_string);
	return ($alias, $email, $bid, $time, $add1, $add2, $add3);
}
# --------------------------------------------------------
# Displays any errors and prints out FORM and ENVIRONMENT 
# information. Useful for debugging.
#
sub cgierr {
    my ($key, $env, $space); 
    print "<PRE>\n\nCGI ERROR\n==========================================\n";
    $_[0]      and print "Error Message       : $_[0]\n";   
    $0         and print "Script Location     : $0\n";
    $]         and print "Perl Version        : $]\n";  
    
    print "\nForm Variables\n-------------------------------------------\n";
    foreach $key (sort keys %form) {
        my $space = " " x (20 - length($key));
        print "$key$space: $form{$key}\n";
    }
    print "\nEnvironment Variables\n-------------------------------------------\n";
    foreach $env (sort keys %ENV) {
        my $space = " " x (20 - length($env));
        print "$env$space: $ENV{$env}\n";
    }
    print "\n</PRE>";
    exit -1;
}
