use strict;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
#-#############################################
# Display Item
# This displays a particular item, its
# description, and its associated bids.
	&oops("Item $form{'item'} could not be opened.") unless (my ($title, $reserve, $inc, $desc, $image, @bids) = &read_item_file("$config{'closedir'}$form{'category'}",$form{'item'}));
	my ($bidsout, $reserveout, $template, $seller, $highbidder, $lowest_new_bid, $buyerrating);
	my $nowtime = localtime(time);
	my $closetime = localtime($form{'item'});
	my $timeleft = &timeleft($form{'item'});
	my $imageout = "<IMG SRC=$image>" if ($image);
	my ($selleralias, $selleremail, $sellerbid, $sellertime, $selleradd1, $selleradd2, $selleradd3) = &read_bid($bids[0]); # read first bid
	my $bidstart = localtime($sellertime);
	my $numbids = $#bids;
	if (!(-e "$config{'basepath'}$config{'feeddir'}/$selleralias.dat")){ &initialize($selleralias);}
	my ($positive, $neutral, $negative) = &returnrate($selleralias);
	my $rating = $positive - $negative;
	$seller = "<a href=$ENV{'SCRIPT_NAME'}?action=askseller&category=$form{'category'}&item=$form{'item'}&ALIAS=$selleralias>$selleralias </a> <a href=\"$ENV{'SCRIPT_NAME'}?action=feed&feedaction=viewrate&ALIAS=$selleralias\">($rating)</a>";
	my ($alias, $email, $lastbid, $time, $add1, $add2, $add3) = &read_bid($bids[$numbids]); # read last bid
	if ($alias eq $selleralias){
		$highbidder = "No bids";
		$lastbid =$sellerbid;
	}
	else {
		if (!(-e "$config{'basepath'}$config{'feeddir'}/$alias.dat")){ &initialize($alias);}
		my ($buypositive, $buyneutral, $buynegative) = &returnrate($alias);
		$buyerrating = $buypositive - $buynegative;
	 	$highbidder = "<a href=$ENV{'SCRIPT_NAME'}?action=askseller&category=$form{'category'}&item=$form{'item'}&ALIAS=$alias>$alias </a> <a href=\"$ENV{'SCRIPT_NAME'}?action=feed&feedaction=viewrate&ALIAS=$alias\">($buyerrating)</a>";
	}
	if ($#bids) {
		shift @bids; # remove the first bid (start bid)
		for (my $i=0; $i<scalar(@bids); $i++) {
			my ($alias, $email, $bid, $time, $add1, $add2, $add3) = &read_bid($bids[$i]);
			my $bidtime = localtime($time);
			$bidsout .= "<FONT SIZE=-1>$alias \($bidtime\) - \$$bid</FONT><BR>";
		}
	}
	else {
		$bidsout .= "<FONT SIZE=-1>No bids yet...</FONT><BR>";
	}
	if ($lastbid < $reserve){
		$reserveout = "<FONT SIZE=-1>(reserve price not yet met)</FONT>"
	} 
	if (($lastbid >= $reserve) and ($reserve > 0)){
		$reserveout ="<FONT SIZE=-1>(reserve price met)</FONT>" 
	}
	if ($reserve = 0){
		$reserveout = "<FONT SIZE=-1>(no reserve)</FONT>"
	} 
	my ($alias, $email, $bid, $time, $add1, $add2, $add3) = &read_bid($bids[0]); # read the last bid
		$template = 'dispitemclosed.html';
		&dispcloseditem;



#-#############################################
# Sub Display Closed Item
#
sub dispcloseditem {
    print	&load_template ($template, { 
	   RATING		=>	  $rating,
	   BUYRATING	=>	  $buyerrating,
       DESC  		=>    $desc,        
	   BIDS			=>	  $bidsout,
	   INC			=>	  $inc,
       BID  		=>    $lastbid,        
       IMAGE  		=>    $imageout,        
       NOWTIME  	=>    $nowtime,        
       CLOSETIME  	=>    $closetime,        
       TIMELEFT  	=>    $timeleft,        
       STARTTIME  	=>    $bidstart,        
       STARTBID  	=>    $sellerbid,        
	   LOCATION		=>	  $selleradd3,
       NUMBIDS  	=>    $numbids,        
       RESERVE  	=>    $reserveout,        
       ITEMTITLE  	=>    $title,        
       CATEGORY  	=>    $category{$form{'category'}},        
	   CATTREE		=>	  $form{'category'},
       ITEMNUM  	=>    $form{'item'},        
       EMAIL  		=>    $selleremail,        
       ALIAS  		=>    $selleralias,
	   SELLER		=>	  $seller,
	   HIGHBIDDER	=>	  $highbidder,
	   LOWESTNEWBID =>	  $lowest_new_bid,        
				%globals
	});      
}

#-#############################################
# Sub: time left
# revised w/ proper english - smarter output
# Note: This sub does not handle the year change properly, yet.
# Also may not handle leap years. Fixes are welcome.

sub timeleft {

 my ($rsecond, $rminute, $rhour, $rday, $timeremain);
 my ($second, $minute, $hour, $dayofmonth, $month, $year, $weekday, $dayofyear, $iddst) = localtime($_[0]); 
 my ($csecond, $cminute, $chour, $cdayofmonth, $cmonth, $cyear, $cweekday, $cdayofyear, $ciddst) = localtime(time); 

  if ($second >= $csecond) { $rsecond = ($second - $csecond); }
  else { $rsecond = (($second + 60) - $csecond);
         $minute = ($minute - 1); }

  if ($minute >= $cminute) { $rminute = ($minute - $cminute); }
  else { $rminute = (($minute + 60) - $cminute);
         $hour = ($hour - 1); }

  if ($hour >= $chour) { $rhour = ($hour - $chour); }
  else { $rhour = (($hour + 24) - $chour);
         $dayofyear = ($dayofyear - 1); }

    if ($dayofyear == $cdayofyear) {
     if($rhour < 1) {
      if($rminute < 1) {
       if ($rminute = 0) { $timeremain = "<font color=red> auction has ended</font>"; }
       else { 
         $timeremain = sprintf('%02d seconds', $rsecond);
         my @s = split / /, $timeremain;
         if ($s[0] eq "01") {$s[1] = "second";}
         $timeremain = "<font color=red> " . "$s[0] $s[1]"; }}

      else {
       $timeremain = sprintf('%02d minutes %02d seconds', $rminute, $rsecond);
       my @s = split / /, $timeremain;
       if ($s[0] eq "01") {$s[1] = "minute";}
       if ($s[2] eq "01") {$s[3] = "second";}
       $timeremain = "<font color=red> " . "$s[0] $s[1] $s[2] $s[3]"; }}

     else {
       $timeremain = sprintf('%02d hours %02d minutes', $rhour, $rminute); 
       my @s = split / /, $timeremain;
       if ($s[0] eq "01") {$s[1] = "hour";}
       if ($s[2] eq "01") {$s[3] = "minute";}
       $timeremain = "<font color=red> " . "$s[0] $s[1] $s[2] $s[3]"; }}

    else {
     $rday = ($dayofyear - $cdayofyear);
 
     if ($rday <= -1) { $timeremain = "<font color=red> auction has ended</font>"; }
     else {
       $timeremain = sprintf('%02d days %02d hours +', $rday, $rhour);
       my @s = split / /, $timeremain;
       if ($s[0] eq "01") {$s[1] = "day";}
       if ($s[2] eq "01") {$s[3] = "hour";}
       if ($s[2] eq "00") {($s[3], $s[2], $s[4]) = (" 1 hour","\<","");}
       $timeremain = "$s[0] $s[1] $s[2] $s[3] $s[4]"; }
     }
  return "$timeremain";
}   
##############################################
# Lookup a users feedback
#
sub returnrate{
		my $user = shift;
	    &oops('could not open the file') unless (open(FEEDFILE, "$config{'basepath'}$config{'feeddir'}/$user.dat"));
		my ($positive, $neutral, $negative, @userfeeds) = <FEEDFILE>;
		close FEEDFILE;
		chomp($positive, $neutral, $negative, @userfeeds);
		return ($positive, $neutral, $negative);
}
##############################################
# Initialize a users feedback file
#
sub initialize{
		my $user = shift;
	    &oops("could not open the file  $config{'basepath'}$config{'feeddir'}/$user.dat") unless (open(FEEDFILE, ">$config{'basepath'}$config{'feeddir'}/$user.dat"));
		print FEEDFILE "0\n0\n0\n";
 		close FEEDFILE;
	  	
}

1;
