use strict;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
#-#############################################
# Display List Of Items a Particular User Has Placed
# 
# 
my ($key, @allfiles, $listtable);
foreach $key (sort keys %category) {
	opendir THEDIR, "$config{'basepath'}$key" or &oops("Category directory $key could not be opened.");
	@allfiles = grep -T, map "$config{'basepath'}$key/$_", sort { int($a) <=> int($b) } (readdir THEDIR);
	closedir THEDIR;
	my ($file,);
	my @cellcolor=($config{'colortablerowodd'},$config{'colortableroweven'});
	my $color = 0;
	foreach $file (@allfiles) {
		$file =~ s/^$config{'basepath'}$key\///;
		$file =~ s/\.dat$//;
		if (my ($title, $reserve, $inc, $desc, $image, @bids) = &read_item_file($key,$file)) {
			my ($selleralias, $selleremail, $sellerbid, $sellertime, $selleradd1, $selleradd2, $selleradd3) = &read_bid($bids[0]);
			if ($form{'seller'} eq $selleralias){
				my ($alias, $email, $bid, $time, $add1, $add2, $add3) = &read_bid($bids[$#bids]);
				my @closetime = localtime($file);
				$closetime[4]++;
				my $rowcolor = $cellcolor[$color];
				my $timeleft = &timeleft($file);
				$listtable .= "<TR><TD BGCOLOR=$rowcolor ALIGN=LEFT><A HREF=$ENV{'SCRIPT_NAME'}\?category=$key\&item=$file>$title</A>";
				$listtable .= "$config{'pic'}" if ($image);
				$listtable .= "$config{'new'}" if (($sellertime + (86400 * $config{'newdays'})) > time);
				$listtable .= "$config{'hot'}" if ($#bids >= $config{'hotnum'});
				$listtable .= "</TD><TD BGCOLOR=$rowcolor ALIGN=CENTER>\$$bid</TD><TD BGCOLOR=$rowcolor ALIGN=CENTER>$#bids</TD><TD BGCOLOR=$rowcolor ALIGN=CENTER>$timeleft</TD></TR>\n";
				$color = int(!($color));
			}
		}
	}
}
	if (!$listtable){
		$listtable = "<TR><TD>No Listings For $form{'seller'}</TD><TD></TD><TD></TD><TD></TD></TR>";
	}

    print	&load_template ('viewsellers.html', { 
				SELLER		=>	$form{'seller'},
				LISTTABLE 	=> 	$listtable,
				%globals
	}); 
#-#############################################
# Sub: time left
# revised w/ proper english - smarter output
# Note: This sub does not handle the year change properly, yet.
# Also may not handle leap years. Fixes are welcome.

sub timeleft {

 my ($rsecond, $rminute, $rhour, $rday, $timeremain);
 my ($second, $minute, $hour, $dayofmonth, $month, $year, $weekday, $dayofyear, $iddst) = localtime($_[0]); 
 my ($csecond, $cminute, $chour, $cdayofmonth, $cmonth, $cyear, $cweekday, $cdayofyear, $ciddst) = localtime(time); 

  if ($second >= $csecond) { $rsecond = ($second - $csecond); }
  else { $rsecond = (($second + 60) - $csecond);
         $minute = ($minute - 1); }

  if ($minute >= $cminute) { $rminute = ($minute - $cminute); }
  else { $rminute = (($minute + 60) - $cminute);
         $hour = ($hour - 1); }

  if ($hour >= $chour) { $rhour = ($hour - $chour); }
  else { $rhour = (($hour + 24) - $chour);
         $dayofyear = ($dayofyear - 1); }

    if ($dayofyear == $cdayofyear) {
     if($rhour < 1) {
      if($rminute < 1) {
       if ($rminute = 0) { $timeremain = "<font color=red> auction has ended</font>"; }
       else { 
         $timeremain = sprintf('%02d seconds', $rsecond);
         my @s = split / /, $timeremain;
         if ($s[0] eq "01") {$s[1] = "second";}
         $timeremain = "<font color=red> " . "$s[0] $s[1]"; }}

      else {
       $timeremain = sprintf('%02d minutes %02d seconds', $rminute, $rsecond);
       my @s = split / /, $timeremain;
       if ($s[0] eq "01") {$s[1] = "minute";}
       if ($s[2] eq "01") {$s[3] = "second";}
       $timeremain = "<font color=red> " . "$s[0] $s[1] $s[2] $s[3]"; }}

     else {
       $timeremain = sprintf('%02d hours %02d minutes', $rhour, $rminute); 
       my @s = split / /, $timeremain;
       if ($s[0] eq "01") {$s[1] = "hour";}
       if ($s[2] eq "01") {$s[3] = "minute";}
       $timeremain = "<font color=red> " . "$s[0] $s[1] $s[2] $s[3]"; }}

    else {
     $rday = ($dayofyear - $cdayofyear);
 
     if ($rday <= -1) { $timeremain = "<font color=red> auction has ended</font>"; }
     else {
       $timeremain = sprintf('%02d days %02d hours +', $rday, $rhour);
       my @s = split / /, $timeremain;
       if ($s[0] eq "01") {$s[1] = "day";}
       if ($s[2] eq "01") {$s[3] = "hour";}
       if ($s[2] eq "00") {($s[3], $s[2], $s[4]) = (" 1 hour","\<","");}
       $timeremain = "$s[0] $s[1] $s[2] $s[3] $s[4]"; }
     }
  return "$timeremain";
}    
1;
