use strict;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
#-#############################################
# Process Registration
# This adds new accounts to the database

	if ($config{'regdir'}) {
		umask(000);  # UNIX file permission junk
		mkdir("$config{'basepath'}$config{'regdir'}", 0777) unless (-d "$config{'basepath'}$config{'regdir'}");		
		&oops('You must enter an alias that consists of alphanumeric characters.') if $form{'ALIAS'} =~ /\W/ or !($form{'ALIAS'});
		&oops('You must enter a valid e-mail address.') unless ($form{'EMAIL'} =~ /^.+\@.+\..+$/);
		&oops('You must enter your full name so buyers or sellers may contact you.') unless ($form{'ADDRESS1'});
		&oops('You must enter a valid street address so buyers or sellers can contact you.') unless ($form{'ADDRESS2'});
		&oops('You must enter a valid city, state, and zip code so buyers or sellers can contact you.') unless ($form{'ADDRESS3'});
		$form{'ALIAS'} = ucfirst(lc($form{'ALIAS'}));
		if (!(-f "$config{'basepath'}$config{'regdir'}/$form{'ALIAS'}.dat")) {
			&oops('We were unable to write to the user directory.') unless (open NEWREG, ">$config{'basepath'}$config{'regdir'}/$form{'ALIAS'}.dat");
			my $newpass = &randompass; 
			print NEWREG "$newpass\n$form{'EMAIL'}\n$form{'ADDRESS1'}\n$form{'ADDRESS2'}\n$form{'ADDRESS3'}";
			close NEWREG;
			require "sendemail.pl";
			print "$form{'ALIAS'}, you should receive an e-mail to $form{'EMAIL'} in a few minutes.  It will contain your password needed to post or bid.  You may change your password once you receive it.  If you do not get an e-mail, please re-register.\n";
			&sendemail($form{'EMAIL'}, $config{'admin_address'}, 'Auction Password', "PLEASE DO NOT REPLY TO THIS E-MAIL.\n\nThank you for registering to use the online auctions at $config{'sitename'}!\n\nYour new password is: $newpass\nYour alias (as you entered it) is: $form{'ALIAS'}\n\nThank you for visiting!");
		}
		else {
			print "Sorry...  that alias is taken.  Hit back to try again!\n";
		}
	}
	else {
		print "User Registration is Not Implemented on This Server!  The System Administrator Did Not Specify a Registration Directory...\n";
	}
	


#-#############################################
# Sub: Random Password
# This generates psudo-random 8-letter
# passwords

sub randompass {
	srand(time ^ $$);
	my @passset = ('a'..'k', 'm'..'n', 'p'..'z', '2'..'9');
	my $randpass = "";
	for (my $i=0; $i<8; $i++) {
		$randpass .= $passset[int(rand($#passset + 1))];
	}
	return $randpass;
}
