#use strict;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
if ($form{'feedaction'} eq 'rate') {
	&rate; 
} 
elsif ($form{'feedaction'} eq 'procrate') { 
	&procrate; 
}
elsif ($form{'feedaction'} eq 'viewrate') { 
	&viewrate; 
}
elsif ($form{'feedaction'} eq 'getrate') { 
	&returnrate; 
}
else  {
	&feedform; 
} 

##############################################

##############################################
# Sub: Display The Feedback Form
# 

sub feedform {

    	print	&load_template ('feedform.html', {
				ALIAS	=>	$form{'ALIAS'}, 
				%globals
		});      
	
}
############################################
# Sub: Rate 
# Begins the rating process

sub rate {
           &oops('You must enter the users ALIAS') unless ($form{'ALIAS'});
           &oops('You must enter your ALIAS') unless ($form{'ALIAS2'}); 
           &oops('You must enter your PASSWORD') unless ($form{'PASSWORD'}); 
           &oops('You must enter an ITEM NUMBER') unless ($form{'ITEM'});  
           &oops('You cannot leave feedback for yourself') if ($form{'ALIAS'} eq $form{'ALIAS2'}); 
        
        if ($feeddir ne "") {
			$form{'ALIAS'} =~ s/\W//g;
			$form{'ALIAS'} = lc($form{'ALIAS'});
			$form{'ALIAS'} = ucfirst($form{'ALIAS'});
			&oops("The username you entered, $form{'ALIAS'}, is not a registered user") unless (open(FEEDFILE, "$basepath2$feeddir/$form{'ALIAS'}.dat"));
			($password, $form{'EMAIL'}, $form{'ADDRESS1'}, $form{'ADDRESS2'}, $form{'ADDRESS3'}, @userbids) = <FEEDFILE>;
			close FEEDFILE;
			chomp($password, $form{'EMAIL'}, $form{'ADDRESS1'}, $form{'ADDRESS2'}, $form{'ADDRESS3'}, @userbids);
			$form{'ALIAS2'} =~ s/\W//g;
			$form{'ALIAS2'} = lc($form{'ALIAS2'});
			$form{'ALIAS2'} = ucfirst($form{'ALIAS2'});
			&oops("The username you entered, $form{'ALIAS2'}, is not a registered user") unless (open(FEEDFILE, "$basepath2$feeddir/$form{'ALIAS2'}.dat"));
			($password, $form{'EMAIL'}, $form{'ADDRESS1'}, $form{'ADDRESS2'}, $form{'ADDRESS3'}, @userbids) = <FEEDFILE>;
			close FEEDFILE;
			chomp($password, $form{'EMAIL'}, $form{'ADDRESS1'}, $form{'ADDRESS2'}, $form{'ADDRESS3'}, @userbids);
			&oops('The password you have entered is not correct') unless ((lc $password) eq (lc $form{'PASSWORD'}));
	   }
                  
        
    	print	&load_template ('feedform2.html', {
				ITEM	=> $form{'ITEM'},
				ALIAS	=> $form{'ALIAS'},
				ALIAS2	=> $form{'ALIAS2'}, 
				%globals
		});      

}

############################################
# Sub: Rate processing
# Begins the rating process

sub procrate {
	  		$form{'ALIAS'} =~ s/\W//g;
	  		$form{'ALIAS'} = lc($form{'ALIAS'});
	  		$form{'ALIAS'} = ucfirst($form{'ALIAS'});
			&oops('This user could not be found!') unless ($password, $form{'EMAIL'}, $form{'ADDRESS1'}, $form{'ADDRESS2'}, $form{'ADDRESS3'}, @userbids) = &read_reg_file($form{'ALIAS'});
	  			open(FEEDFILE, "$config{'basepath'}$config{'feeddir'}/$form{'ALIAS'}.dat");
	  			($positive,$neutral,$negative,@junk) = <FEEDFILE>;
	  			close FEEDFILE;
	  			chomp($positive,$neutral,$negative,@junk);
				if ($form{'RATE'} eq "p"){
				$positive = $positive + 1;
				}
				if ($form{'RATE'} eq "n"){
				$neutral = $neutral + 1;
				}
				if ($form{'RATE'} eq "nn"){
				$negative = $negative + 1;
				}
				open FEEDFILE, ">$config{'basepath'}$config{'feeddir'}/$form{'ALIAS'}.dat" or die "can't update the file: $!";
				print FEEDFILE "$positive\n$neutral\n$negative\n";
				print FEEDFILE "$form{'ALIAS2'}\[\]$form{'ITEM'}\[\]$form{'RATE'}\[\]$form{'RATES'}\n"; # I had to add \n to the back.
				foreach $bid (@junk) {
					print FEEDFILE "$bid\n";
				}
				close FEEDFILE;

	  			
				my $message = "$form{'ALIAS2'}, your Rating of $form{'ALIAS'} has been saved.\n";
    	print	&load_template ('feedform3.html', {
				MESSAGE	=>	$message,
				%globals
		});      

}
##############################################
# View a users feedback
#
sub viewrate{
		my ($feedout);
		mkdir("$config{'basepath'}$config{'feeddir'}", 0777) unless (-d "$config{'basepath'}$config{'feeddir'}");
		if (!(-e "$config{'basepath'}$config{'feeddir'}/$form{'ALIAS'}.dat")){ &initialize;}
	    &oops("could not open the file  $config{'basepath'}$config{'feeddir'}/$form{'ALIAS'}.dat") unless (open(FEEDFILE, "$config{'basepath'}$config{'feeddir'}/$form{'ALIAS'}.dat"));
		my ($positive, $neutral, $negative, @userfeeds) = <FEEDFILE>;
		close FEEDFILE;
		chomp($positive, $neutral, $negative, @userfeeds);
		my $rating = $positive - $negative;
		foreach $feed (@userfeeds) {
				@thefeed = split(/\[\]/,$feed);
				my $bidtime = localtime($thefeed[3]);
				$feedout .= "<table border=\"config{'tableborder0'}\"  cellspacing=\"$config{'tablecellspace0'}\" cellpadding=\"$config{'tablecellpad0'}\" width=\"500\" >";
		
				$feedout .= "<tr><td width=75>Feedback by:</td><td>Item</td><td>Rating</td></tr>";
				$feedout .= "<tr><td>$thefeed[0]</td><td>$thefeed[1]</td>";
				$feedout .= "<td width=75><font color=\"#009933\"><b>Positive </b></font></td>" if ($thefeed[2] eq "p");
				$feedout .= "<td width=75>Neutral</td>" if ($thefeed[2] eq "n");
				$feedout .= "<td width=75><font color=\"#ff0000\">Negative </font></td>" if ($thefeed[2] eq "nn");
				$feedout .= "</tr><tr><td colspan=3 align=center>Comment</td></tr><tr><td colspan=3>$thefeed[3]</td></tr></table><br>";
				
	}
	
    	print	&load_template ('feedform4.html', { 
				ALIAS		=>	$form{'ALIAS'},
				RATING		=>	$rating,
				POS			=>	$positive,
				NEG			=>	$negative,
				NEU			=>	$neutral,
				FEEDOUT		=>	$feedout,
				%globals
		});      
	
}
##############################################
# Lookup a users feedback
#
sub returnrate{
	    &oops('ALIAS') unless (open(FEEDFILE, "$config{'basepath'}$config{'feeddir'}/$form{'ALIAS'}.dat"));
		my ($positive, $neutral, $negative, @userfeeds) = <FEEDFILE>;
		close FEEDFILE;
		chomp($positive, $neutral, $negative, @userfeeds);
		return ($positive, $neutral, $negative);
}
##############################################
# Initialize a users feedback file
#
sub initialize{

	    &oops("could not open the file  $config{'basepath'}$config{'feeddir'}/$form{'ALIAS'}.dat") unless (open(FEEDFILE, ">$config{'basepath'}$config{'feeddir'}/$form{'ALIAS'}.dat"));
		print FEEDFILE "0\n0\n0\n";
 		close FEEDFILE;
	  	
}
