use strict;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
#-#############################################
# Display List Of Items
# This creates a "nice" list of items in a
# category.
	my $subcatarray = &subcats;
	opendir THEDIR, "$config{'basepath'}$form{'category'}" or &oops("Category directory $form{'category'} could not be opened.");
	my @allfiles = grep -T, map "$config{'basepath'}$form{'category'}/$_", sort { int($a) <=> int($b) } (readdir THEDIR);
	closedir THEDIR;
	my ($file, $listtable);
	my @cellcolor=($config{'colortablerowodd'},$config{'colortableroweven'});
	my $color = 0;
	foreach $file (@allfiles) {
		$file =~ s/^$config{'basepath'}$form{'category'}\///;
		$file =~ s/\.dat$//;
		if (my ($title, $reserve, $inc, $desc, $image, @bids) = &read_item_file($form{'category'},$file)) {
			if ($#bids >= $config{'hotnum'}){
				my ($alias, $email, $bid, $time, $add1, $add2, $add3) = &read_bid($bids[$#bids]);
				my ($selleralias, $selleremail, $sellerbid, $sellertime, $selleradd1, $selleradd2, $selleradd3) = &read_bid($bids[0]);
				my @closetime = localtime($file);
				$closetime[4]++;
				my $rowcolor = $cellcolor[$color];
				my $timeleft = &timeleft($file);
				$listtable .= "<TR><TD BGCOLOR=$rowcolor ALIGN=LEFT><A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}\&item=$file>$title</A>";
				$listtable .= "$config{'pic'}" if ($image);
				$listtable .= "$config{'new'}" if (($sellertime + (86400 * $config{'newdays'})) > time);
				$listtable .= "$config{'hot'}" if ($#bids >= $config{'hotnum'});
				$listtable .= "</TD><TD BGCOLOR=$rowcolor ALIGN=CENTER>\$$bid</TD><TD BGCOLOR=$rowcolor ALIGN=CENTER>$#bids</TD><TD BGCOLOR=$rowcolor ALIGN=CENTER>$timeleft</TD></TR>\n";
				$color = int(!($color));
			}
		}
	}
	if (!@allfiles){
		$listtable = "<TR><TD>No Listings in this Category</TD><TD></TD><TD></TD><TD></TD></TR>";
	}
	my $listbar .= "<P><P ALIGN=CENTER><FONT SIZE=-1><A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=current&level=$form{'level'}>Current</A> |";
	$listbar .= "| <A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=new&level=$form{'level'}>New Today</A> |";
	$listbar .= "| Hot |";
	$listbar .= "| <A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=closingtoday&level=$form{'level'}>Closing Today</A> |";
	$listbar .= "| <A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=closed&level=$form{'level'}>Completed</A> |";
	$listbar .= "| <A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=going&level=$form{'level'}>Going, Going, Gone</A>";
	$listbar .= "</FONT></P>\n";

    print	&load_template ('displist.html', { 
				LISTBAR		=>	$listbar,
				SUBCATARRAY	=>	$subcatarray,
				THISCAT 	=> 	"Top:$category{$form{'category'}}",
				LISTTABLE 	=> 	$listtable,
				%globals
	}); 
#-#############################################
# Sub: SubCats
# Makes a table of subcategories with stats
#
sub subcats {
	my ($file, @files, @subcats, @catarray, $nextlevel, $output, %stats, %cattree, $key);
	$nextlevel = $form{'level'} + 1;
	foreach $key (sort keys %category) {
		umask(000);  # UNIX file permission junk
		mkdir("$config{'basepath'}$key", 0777) unless (-d "$config{'basepath'}$key");
		@catarray = split (/\//,$key);
		if ($catarray[$nextlevel] && ($catarray[$form{'level'}] eq $form{'category'})){
			push (@subcats, $catarray[$nextlevel]);
			$cattree{$catarray[$nextlevel]} = $key; 
			opendir DIR, "$config{'basepath'}$key" or &oops("Category directory $key could not be opened.");
			@files = grep -T, map "$config{'basepath'}$key/$_", sort { int($a) <=> int($b) } (readdir DIR);
				foreach $file (@files) {
					$file =~ s/^$config{'basepath'}$key\///;
					$file =~ s/\.dat$//;
					if (my ($title, $reserve, $inc, $desc, $image, @bids) = &read_item_file($key,$file)) {
						if ($#bids >= $config{'hotnum'}){
							$stats{$catarray[$nextlevel]}++;
						}
					}
				}
			$stats{$catarray[$nextlevel]} = 0 unless ($stats{$catarray[$nextlevel]});
			closedir DIR;
		}
	}
	if (@subcats){
		$output = qq|<div><table width="80%" border="$config{'tableborder0'}" cellspacing="$config{'tablecellspace0'}" cellpadding="$config{'tablecellpad0'}"><tr><td valign="top">\n|;
		my $i = 0;
		my $cat;
		my $catclean;
		my $half = int (($#subcats+2) / 2);
    	foreach $cat (sort @subcats) { 
			$catclean = $cat;
			$catclean =~ s/_/ /g;
        	if ($i == $half) {
            	$output .= qq|</td><td valign="top">\n|;
        	}
        	$i++;
        	$output .= qq|<dl><dt><strong><a href="$ENV{'SCRIPT_NAME'}\?category=$cattree{$cat}&level=$nextlevel&listtype=hot">$catclean</a></strong> <small>($stats{$cat})</small></dt></dl> |;
		}
    	$output .= "</td></tr></table></div>\n";
	}
    return $output;
}

#-#############################################
# Sub: Movefile(file1, file2)
# This moves a file.  Quick and dirty!

sub movefile {
	my ($firstfile, $secondfile) = @_;
	return 0 unless open(FIRSTFILE,$firstfile);
	my @lines=<FIRSTFILE>;
	close FIRSTFILE;
	return 0 unless open(SECONDFILE,">$secondfile");
	my $line;
	foreach $line (@lines) {
		print SECONDFILE $line;
	}
	close SECONDFILE;
	return 0 unless unlink($firstfile);
	return 1;
}
#-#############################################
# Sub: time left
# revised w/ proper english - smarter output
# Note: This sub does not handle the year change properly, yet.
# Also may not handle leap years. Fixes are welcome.

sub timeleft {

 my ($rsecond, $rminute, $rhour, $rday, $timeremain);
 my ($second, $minute, $hour, $dayofmonth, $month, $year, $weekday, $dayofyear, $iddst) = localtime($_[0]); 
 my ($csecond, $cminute, $chour, $cdayofmonth, $cmonth, $cyear, $cweekday, $cdayofyear, $ciddst) = localtime(time); 

  if ($second >= $csecond) { $rsecond = ($second - $csecond); }
  else { $rsecond = (($second + 60) - $csecond);
         $minute = ($minute - 1); }

  if ($minute >= $cminute) { $rminute = ($minute - $cminute); }
  else { $rminute = (($minute + 60) - $cminute);
         $hour = ($hour - 1); }

  if ($hour >= $chour) { $rhour = ($hour - $chour); }
  else { $rhour = (($hour + 24) - $chour);
         $dayofyear = ($dayofyear - 1); }

    if ($dayofyear == $cdayofyear) {
     if($rhour < 1) {
      if($rminute < 1) {
       if ($rminute = 0) { $timeremain = "<font color=red> auction has ended</font>"; }
       else { 
         $timeremain = sprintf('%02d seconds', $rsecond);
         my @s = split / /, $timeremain;
         if ($s[0] eq "01") {$s[1] = "second";}
         $timeremain = "<font color=red> " . "$s[0] $s[1]"; }}

      else {
       $timeremain = sprintf('%02d minutes %02d seconds', $rminute, $rsecond);
       my @s = split / /, $timeremain;
       if ($s[0] eq "01") {$s[1] = "minute";}
       if ($s[2] eq "01") {$s[3] = "second";}
       $timeremain = "<font color=red> " . "$s[0] $s[1] $s[2] $s[3]"; }}

     else {
       $timeremain = sprintf('%02d hours %02d minutes', $rhour, $rminute); 
       my @s = split / /, $timeremain;
       if ($s[0] eq "01") {$s[1] = "hour";}
       if ($s[2] eq "01") {$s[3] = "minute";}
       $timeremain = "<font color=red> " . "$s[0] $s[1] $s[2] $s[3]"; }}

    else {
     $rday = ($dayofyear - $cdayofyear);
 
     if ($rday <= -1) { $timeremain = "<font color=red> auction has ended</font>"; }
     else {
       $timeremain = sprintf('%02d days %02d hours +', $rday, $rhour);
       my @s = split / /, $timeremain;
       if ($s[0] eq "01") {$s[1] = "day";}
       if ($s[2] eq "01") {$s[3] = "hour";}
       if ($s[2] eq "00") {($s[3], $s[2], $s[4]) = (" 1 hour","\<","");}
       $timeremain = "$s[0] $s[1] $s[2] $s[3] $s[4]"; }
     }
  return "$timeremain";
}    
1;
