use strict;
#
#
# License: This code is released under the terms of the GNU GPL
# version 2 or later. Please refer to www.gnu.org for a copy
# of this license.
#
#-#############################################
# Display List Of Items
# This creates a "nice" list of items in a
# category.
	my $subcatarray = &subcats;
	opendir THEDIR, "$config{'basepath'}$config{'closedir'}$form{'category'}" or &oops("Category directory $form{'category'} could not be opened.");
	my @allfiles = grep -T, map "$config{'basepath'}$config{'closedir'}$form{'category'}/$_", sort { int($a) <=> int($b) } (readdir THEDIR);
	closedir THEDIR;
	my ($file, $listtable);
	my @cellcolor=($config{'colortablerowodd'},$config{'colortableroweven'});
	my $color = 0;
	foreach $file (@allfiles) {
		$file =~ s/^$config{'basepath'}$config{'closedir'}$form{'category'}\///;
		$file =~ s/\.dat$//;
		if (my ($title, $reserve, $inc, $desc, $image, @bids) = &read_item_file("$config{'closedir'}$form{'category'}",$file)) {
			my ($alias, $email, $bid, $time, $add1, $add2, $add3) = &read_bid($bids[$#bids]);
			my ($selleralias, $selleremail, $sellerbid, $sellertime, $selleradd1, $selleradd2, $selleradd3) = &read_bid($bids[0]);
			my @closetime = localtime($file);
			$closetime[4]++;
			$closetime[5] =~ s/1//;
			my $rowcolor = $cellcolor[$color];
			$listtable .= "<TR><TD BGCOLOR=$rowcolor ALIGN=LEFT><A HREF=$ENV{'SCRIPT_NAME'}\?action=dispcloseditem&category=$form{'category'}\&item=$file>$title</A>";
			$listtable .= "$config{'pic'}" if ($image);
			$listtable .= "$config{'hot'}" if ($#bids >= $config{'hotnum'});
			$listtable .= "</TD><TD BGCOLOR=$rowcolor ALIGN=CENTER>\$$bid</TD><TD BGCOLOR=$rowcolor ALIGN=CENTER>$#bids</TD><TD BGCOLOR=$rowcolor ALIGN=CENTER>$closetime[4]/$closetime[3]/$closetime[5] $closetime[2]:$closetime[1]:$closetime[0]</TD></TR>\n";
			$color = int(!($color));
		}
	}
	if (!@allfiles){
		$listtable = "<TR><TD>No Listings in this Category</TD><TD></TD><TD></TD><TD></TD></TR>";
	}
	my $listbar .= "<P><P ALIGN=CENTER><FONT SIZE=-1><A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=current&level=$form{'level'}>Current</A> |";
	$listbar .= "| <A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=new&level=$form{'level'}>New Today</A> |";
	$listbar .= "| <A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=hot&level=$form{'level'}>Hot</A> |";
	$listbar .= "| <A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=closingtoday&level=$form{'level'}>Closing Today</A> |";
	$listbar .= "| Completed |";
	$listbar .= "| <A HREF=$ENV{'SCRIPT_NAME'}\?category=$form{'category'}&listtype=going&level=$form{'level'}>Going, Going, Gone</A>";
	$listbar .= "</FONT></P>\n";

    print	&load_template ('displistclosed.html', { 
				LISTBAR		=>	$listbar,
				SUBCATARRAY	=>	$subcatarray,
				THISCAT 	=> 	"Top:$category{$form{'category'}}",
				LISTTABLE 	=> 	$listtable,
				%globals
	}); 
#-#############################################
# Sub: SubCats
# Makes a table of subcategories with stats
#
sub subcats {
	my (@subcats, @catarray, $nextlevel, $output, %stats, %cattree, $key);
	$nextlevel = $form{'level'} + 1;
	foreach $key (sort keys %category) {
		umask(000);  # UNIX file permission junk
		mkdir("$config{'basepath'}$config{'closedir'}$key", 0777) unless (-d "$config{'basepath'}$config{'closedir'}$key");
		@catarray = split (/\//,$key);
		if ($catarray[$nextlevel] && ($catarray[$form{'level'}] eq $form{'category'})){
			push (@subcats, $catarray[$nextlevel]);
			opendir DIR, "$config{'basepath'}$config{'closedir'}$key" or &oops("Category directory $key could not be opened.");
			$stats{$catarray[$nextlevel]} = scalar(grep -T, map "$config{'basepath'}$config{'closedir'}$key/$_", readdir DIR);
			$cattree{$catarray[$nextlevel]} = $key; 
			closedir DIR;
		}
	}
	if (@subcats){
		$output = qq|<div><table width="80%" border="$config{'tableborder0'}" cellspacing="$config{'tablecellspace0'}" cellpadding="$config{'tablecellpad0'}"><tr><td valign="top">\n|;
		my $i = 0;
		my $cat;
		my $catclean;
		my $half = int (($#subcats+2) / 2);
    	foreach $cat (sort @subcats) { 
			$catclean = $cat;
			$catclean =~ s/_/ /g;
        	if ($i == $half) {
            	$output .= qq|</td><td valign="top">\n|;
        	}
        	$i++;
        	$output .= qq|<dl><dt><strong><a href="$ENV{'SCRIPT_NAME'}\?category=$cattree{$cat}&level=$nextlevel&listtype=closed">$catclean</a></strong> <small>($stats{$cat})</small></dt></dl> |;
		}
    	$output .= "</td></tr></table></div>\n";
	}
    return $output;
}

#-#############################################
# Sub: Movefile(file1, file2)
# This moves a file.  Quick and dirty!

sub movefile {
	my ($firstfile, $secondfile) = @_;
	return 0 unless open(FIRSTFILE,$firstfile);
	my @lines=<FIRSTFILE>;
	close FIRSTFILE;
	return 0 unless open(SECONDFILE,">$secondfile");
	my $line;
	foreach $line (@lines) {
		print SECONDFILE $line;
	}
	close SECONDFILE;
	return 0 unless unlink($firstfile);
	return 1;
}
   
1;
