<?
/*
 * Name: HyperBook Guestbook
 * Developer: Thomas R. Pasawicz
 * Creation Date: April 15, 2001
 * Version: 1.12 (released May 16, 2001)
 * Function: Allows guests to add and veiw guestbook entries.
 * (c) 2001-2002 Thomas R. Pasawicz (webmaster@diamond-back.com)
 *
 */


/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/


include("database_functions.php"); # Load Core Database Functions


/*
 * 
 * Function: Cook Raw Data
 *
 */

function cook ($textin) {
	$textin = str_replace("\\", "", $textin);
	$text1 = htmlspecialchars($textin);
	$textout = addslashes($text1);
	return $textout;
} # End of function - Cook Raw Data





/*
 * 
 * Function: Reverse HTML Special Characters 
 *
 */

function reversehtmlspecialchars($data) {

$data = str_replace("&amp;", "&", $data); # Convert ampersand
$data = str_replace("&quot;", "\"", $data); # Convert double quote
$data = str_replace("&#039;", "\'", $data); # Convert single quote
$data = str_replace("&lt;", "<", $data); # Convert less than
$data = str_replace("&gt;", ">", $data); # Convert greater than

return $data;

} # End of function - Reverse HTML Special Characters





/*
 * 
 * Function: Word Break
 *
 */

function wordbreak($text, $wordsize) {

if (strlen($text) <= $wordsize) { return $text; } # No breaking necessary, return original text.

$text = str_replace("\n", "", $text); # Strip linefeeds
$done = "false";
$newtext = "";
$start = 0; # Initialize starting position
$segment = substr($text, $start, $wordsize + 1); # Initialize first segment

while ($done == "false") { # Parse text

	$lastspace = strrpos($segment, " ");
	$lastbreak = strrpos($segment, "\r");

	if ( $lastspace == "" AND $lastbreak == "" ) { # Break segment
		$newtext .= substr($text, $start, $wordsize) . " ";
		$start = $start + $wordsize; }
	else { # Move start to last space or break
		$last = max($lastspace, $lastbreak);
		$newtext .= substr($segment, 0, $last + 1);
		$start = $start + $last + 1;
	} # End If - Break segment

	$segment = substr($text, $start, $wordsize + 1);

	if ( strlen($segment) <= $wordsize ) { # Final segment is smaller than word size.
		$newtext .= $segment;
		$done = "true";
	} # End If - Final segment is smaller than word size.

} # End While - Parse text

$newtext = str_replace("\r", "\r\n", $newtext); # Replace linefeeds

return $newtext;

} # End of function - Word Break





/*
 * 
 * Function: Load Guestbook Configuration File
 *
 */

function load_gbconfiguration() {

global $perpage, $ipcheck, $addquestion1, $displayadd1, $addquestion2, $displayadd2, $addquestion3, $displayadd3, $displayuin, $displayemail, 
$foundoptions, $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, $alinkcolor, $hovercolor, 
$homepage_title, $homepage_url, $guestbookname, $guestbookbannerurl, $signguestbookurl1, $signguestbookurl2, $backgroundimageurl, 
$webmaster_email, $notifications, $notification_email, $welcome_msg, $thankyou_msg, $adminurl, $adminpass, $cookieexpiration, $datapath, 
$bannedwords, $headertag;

$filename = "data/gbconfiguration.dat";

if ($fp = fopen($filename, 'r')) { # File opened for reading
	$lock = flock($fp, LOCK_SH); 
	if ($lock) { # Lock achived

		$perpage = chop(fgets($fp, 5000));
		$ipcheck = chop(fgets($fp, 5000));
		$addquestion1 = chop(fgets($fp, 5000));
		$displayadd1 = chop(fgets($fp, 5000));
		$addquestion2 = chop(fgets($fp, 5000));
		$displayadd2 = chop(fgets($fp, 5000));
		$addquestion3 = chop(fgets($fp, 5000));
		$displayadd3 = chop(fgets($fp, 5000));
 		$displayuin = chop(fgets($fp, 5000));
		$displayemail = chop(fgets($fp, 5000));
		$bodycolor = chop(fgets($fp, 5000));
		$bordercolor = chop(fgets($fp, 5000));
		$tablecolor = chop(fgets($fp, 5000));
		$barcolor = chop(fgets($fp, 5000));
		$textcolor = chop(fgets($fp, 5000));
		$bartextcolor = chop(fgets($fp, 5000));
		$linkcolor = chop(fgets($fp, 5000));
		$vlinkcolor = chop(fgets($fp, 5000));
		$alinkcolor = chop(fgets($fp, 5000));
		$hovercolor = chop(fgets($fp, 5000));
		$homepage_title = chop(fgets($fp, 5000));
		$homepage_url = chop(fgets($fp, 5000));
		$guestbookname = chop(fgets($fp, 5000));
		$guestbookbannerurl = chop(fgets($fp, 5000));
		$signguestbookurl1 = chop(fgets($fp, 5000));
		$signguestbookurl2 = chop(fgets($fp, 5000));
		$backgroundimageurl = chop(fgets($fp, 5000));
		$webmaster_email = chop(fgets($fp, 5000));
		$notifications = chop(fgets($fp, 5000));
		$notification_email = chop(fgets($fp, 5000));
		$welcome_msg = chop(fgets($fp, 5000));
		$thankyou_msg = chop(fgets($fp, 5000));
		$adminurl = chop(fgets($fp, 5000));
		$adminpass = chop(fgets($fp, 5000));
		$cookieexpiration = chop(fgets($fp, 5000));
		$howfound = chop(fgets($fp, 5000));
		$bannedwords = chop(fgets($fp, 5000));
		$headertag = chop(fgets($fp, 5000));

		$lock = flock($fp, LOCK_UN);
	} # End If - Lock achived
	fclose($fp);

	$foundoptions = explode("|", $howfound);

	$linebreak = chr(13) . "\n";  # Linebreak & line feed characters.
	$headertag = str_replace("|", $linebreak, $headertag); # Convert pipes to linebreaks.
	$headertag = str_replace("&#124;", "|", $headertag); # Convert HTML elements to pipes.

} # End If - File opened for reading

} # End of function - Load Guestbook Configuration File





/*
 * 
 * Function: Load Language Configuration File
 *
 */

function load_language($filename) {

if ($fp = fopen($filename, 'r')) { # File opened for reading
	$lock = flock($fp, LOCK_SH); 
	if ($lock) { # Lock achived
		$lang = file($filename);
		$lock = flock($fp, LOCK_UN);
	} # End If - Lock achived
	fclose($fp);
} # End If - File opened for reading

$number_lines = sizeof($lang);
for ($i = 0;$i < $number_lines;$i++) { # Initialize text
	$lang[$i] = trim($lang[$i]);  # Trim string (removes CR from end of line).
} # End For Loop - Initialize text

return $lang;

} # End of function - Load Language Configuration File




/*
 * 
 * Function: Display Header
 *
 */

function displayheader($title) {

global $bodycolor, $backgroundimageurl, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, $alinkcolor, $hovercolor,
$homepage_title, $homepage_url, $webmaster_email, $displaythankyou, $signguestbookurl1, $signguestbookurl2, $headertag;

?>
<html>
<head>
<title><? echo $title ?></title>

<meta http-equiv="Content-Type" content="text/html">
<meta name="Description" content="HyperBook Guestbook">
<meta name="Keywords" content="guestbook PHP">
<meta name="Author" content="Thomas R. Pasawicz - webmaster@diamond-back.com">

<style type="text/css">
<!--
a:link        {text-decoration: none;}
a:active    {text-decoration: none;}
a:visited   {text-decoration: none;}
a:hover     {color:<? echo $hovercolor ?>; text-decoration: none;}
-->
</style>

<? if ($signguestbookurl1 != "" AND $signguestbookurl2 != "") { # Display mouseover javascript ?>
<SCRIPT LANGUAGE="JavaScript">  <!-- Hide from old browsers
var iName=""; var nav=navigator.appName.indexOf("Netscape"); var vers=parseInt(navigator.appVersion);
  if ( (nav != -1 && vers >= 3) || (vers == 4) ) {
default1 = new Image(); default1.src = "<? echo $signguestbookurl1 ?>"
changed1 = new Image(); changed1.src = "<? echo $signguestbookurl2 ?>"
  }
  function Ichange(p) {
    if ( (nav != -1 && vers >= 3) || (vers == 4) ) {
    var pSrc=eval(p+ ".src");
    document[iName].src = pSrc;
    }
  }
// end hiding --></SCRIPT>
<? } # End If - Display mouseover javascript ?>

</head>

<body bgcolor="<? echo $bodycolor ?>" background="<? echo $backgroundimageurl ?>" text="<? echo $textcolor ?>" link="<? echo $linkcolor ?>" 
vlink="<? echo $vlinkcolor ?>" alink="<? echo $alinkcolor ?>">

<table width="600" cellspacing="0" cellpadding="0" align="center"><tr><td>

<?

if ($headertag != "") { print "$headertag\n<br>\n"; }

if ($displaythankyou == "true") { displaythankyou(); }

} # End of function - Display Header




/*
 * 
 * Function: Display Footer
 *
 */

function displayfooter() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $version, $lang;

?>
<table cellpadding="1" cellspacing="0" border="1" bgcolor="<? echo $tablecolor ?>" align="center" width="600"><tr><td align="center">
<font size="1" face="Arial" color="<? echo $textcolor ?>">
<i>HyperBook Guestbook <? echo $version ?></i> Copyright &copy; 2001 by 
<a href="mailto:webmaster@diamond-back.com">Thomas R. Pasawicz</a>. All rights reserved. &#149; 
<a href="http://diamond-back.com/software/guestbook/"><i><? echo $lang[41] ?></i></a>
</font></td></tr></table>
</td></tr></table>
<?

} # End of function - Display Footer




/*
 * 
 * Function: Display Thank You
 *
 */

function displaythankyou() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $homepage_title, $homepage_url, $thankyou_msg, $lang;

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b><? echo $lang[20] ?></b></font>
</td></tr><tr>
<td><font size="2" face="Arial" color="<? echo $textcolor ?>"><i><? echo $thankyou_msg ?></i></font></td>
</tr></table>
</td></tr></table><br>
<?

} # End of function - Display Thank You




/*
 * 
 * Function: Validate e-mail address
 *
 */

function checkmail ($email) {

if (ereg('^[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+'.'@'.'[-!#$%&\'*+\\/0-9=?A-Z^_`a-z{|}~]+\.'.
'[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+$', $email)) {
	return true;
} else {
	return false;
}} # End of function - Validate e-mail address




/*
 * 
 * Function: Display Error Message
 *
 */

function errormsg($errortitle,$message) {

global $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor;

displayheader($errortitle);

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>" colspan="2">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b><? echo $errortitle ?></b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i><? echo $message ?></i><br></font>
</td></tr></table>
</td></tr></table><br>
<?

displayfooter();

exit;

} # End of function - Display Error Message




/*
 * 
 * Function: Check IP Log
 *
 */

function checkiplog($ipaddress) {

global $ipcheck, $datapath;

$filename = $datapath . 'ip_log.dat';

if ($fp = fopen($filename, 'r')) { # File opened for reading
	$lock = flock($fp, LOCK_SH); 
	if ($lock) { # Lock achived
		for ($i = 0; $i <= 24; $i++) { $iplist[$i] = fgets($fp, 16); } # Read in IPs
		$lock = flock($fp, LOCK_UN);
	} # End If - Lock achived
	fclose($fp);
} # End If - File opened for reading

$targetip = $ipaddress . "\n";
$ipcount = 0;

for ($i = 0; $i <= 24; $i++) { if ( $targetip == $iplist[$i] ) { $ipcount++; } }

if ( $ipcount < $ipcheck ) { # Update IP log
	if ($fp = fopen($filename, 'w')) { # File opened for writing
		$lock = flock($fp, LOCK_EX);
		if ($lock) { # Lock achived
			fwrite( $fp, $targetip ); # Write new IP
			for ($i = 0; $i <= 23; $i++) { fwrite( $fp, $iplist[$i] ); } # Write remaining IPs
			flock($fp, LOCK_UN);
		} # End If - Lock achived
		fclose($fp);
	} # End If - File opened for writing
	return "pass";
} else { return "fail"; }

} # End of function - IP Check





/*
 * 
 * Function: E-mail Notification
 *
 */

function notification($recordnumber,$record_data) {

global $notifications, $notification_email, $webmaster_email, $guestbookname, $displayadd1, $displayadd2, $displayadd3, 
$displayuin, $adminurl;

if ($notifications == "true" AND $notification_email != "") { # Send notification e-mail(s)

$linebreak = chr(13) . "\n";  # Linebreak & line feed characters.

$breakchar = chr(13);

$data = explode("|", $record_data);

$record_name = stripslashes(reversehtmlspecialchars($data[0]));
$record_date = stripslashes(reversehtmlspecialchars($data[1]));
$record_email = stripslashes(reversehtmlspecialchars($data[2]));
$record_url = stripslashes(reversehtmlspecialchars($data[3]));
$record_website = stripslashes(reversehtmlspecialchars($data[4]));
$record_icq = stripslashes(reversehtmlspecialchars($data[5]));
$record_found = stripslashes(reversehtmlspecialchars($data[6]));
$record_location = stripslashes(reversehtmlspecialchars($data[7]));
$record_comments = stripslashes(reversehtmlspecialchars($data[8]));
$record_ipaddress = stripslashes(reversehtmlspecialchars($data[9]));
$record_remotehost = stripslashes(reversehtmlspecialchars($data[10]));
$record_question1 = stripslashes(reversehtmlspecialchars($data[11]));
$record_question2 = stripslashes(reversehtmlspecialchars($data[12]));
$record_question3 = stripslashes(reversehtmlspecialchars($data[13]));
$record_answer1 = stripslashes(reversehtmlspecialchars($data[14]));
$record_answer2 = stripslashes(reversehtmlspecialchars($data[15]));
$record_answer3 = stripslashes(reversehtmlspecialchars($data[16]));

$guestbooknamestripped = stripslashes(reversehtmlspecialchars($guestbookname));

$record_uid = stripslashes($data[18]);

$record_comments = str_replace($breakchar, "",$record_comments);  # Strip linebreaks.
$record_comments = str_replace("\n", "",$record_comments);  # Strip linefeeds.
$record_comments = str_replace("<br>",$linebreak, $record_comments);  # Convert <br> to linebreaks.

$from = $webmaster_email; if ($record_email != "") { $from = "$record_name <$record_email>"; } # Use guest's e-mail of available


$message = "New Addition to $guestbooknamestripped $linebreak $linebreak";
$message .= "Name: $record_name  $linebreak";
if ($record_email != "") { $message .= "E-mail: $record_email  $linebreak"; }
if ($record_website != "") { $message .= "Website: $record_website  $linebreak"; }
if ($record_url != "") { $message .= "URL: $record_url  $linebreak"; }
if ($record_icq != "") { $message .= "UIN: $record_icq  $linebreak"; }
if ($record_found != "") { $message .= "Found: $record_found  $linebreak"; }
if ($record_location != "") { $message .= "Location: $record_location  $linebreak"; }
$message .= "$linebreak";
if ($record_answer1 != "") { $message .= "$record_question1
$record_answer1  $linebreak $linebreak"; }
if ($record_answer2 != "") { $message .= "$record_question2
$record_answer2  $linebreak  $linebreak"; }
if ($record_answer3 != "") { $message .= "$record_question3
$record_answer3  $linebreak $linebreak"; }
if ($record_comments != "") { $message .= "Comment:
$record_comments  $linebreak $linebreak"; }

$message .= "
Record #: $recordnumber
Date: $record_date
IP Address: $record_ipaddress
Remote Host: $record_remotehost

To edit, delete or add a comment to this post, click on the following URL:
$adminurl?action=uidsearch&uid=$record_uid&page=0
";

# Send e-mail
mail ("$notification_email", "New Addition to $guestbooknamestripped",$message,"From: $from");

} # End If - Send notification e-mail(s)

} # End of function - E-mail Notification




/*
 * 
 * Function: Sign Guestbook
 *
 */

function signguestbook() {

global $addquestion1, $displayadd1, $addquestion2, $displayadd2, $addquestion3, $displayadd3, $displayuin, $displayemail, 
$foundoptions, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $homepage_title, $homepage_url, $webmaster_email, 
$welcome_msg, $browser, $lang;

$halflength = "33"; if ($browser == "MSIE") { $halflength = "37"; } # Adjust input box length for IE
$fulllength = "70"; if ($browser == "MSIE") { $fulllength = "79"; } # Adjust input box length for IE

$new_name = ""; $record_name = "";
$new_date = ""; $record_date = "";
$new_email = ""; $record_email = "";
$new_url = ""; $record_url = "";
$new_website = ""; $record_website = "";
$new_icq = ""; $record_icq = "";
$new_found = ""; $record_found = "";
$new_location = ""; $record_location = "";
$new_comments = ""; $record_comments = "";
$new_ipaddress = ""; $record_ipaddress = "";
$new_remotehost = ""; $record_remotehost = "";
$new_question1 = $addquestion1;
$new_question2 = $addquestion2;
$new_question3 = $addquestion3;
$new_answer1 = ""; $record_answer1 = "";
$new_answer2 = ""; $record_answer2 = "";
$new_answer3 = ""; $record_answer3 = "";
$new_adminmsg = ""; $record_adminmsg = "";

displayheader($lang[21]);

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">

<form action="index.php" method="post">
<input type="hidden" name="action" value="preview">
<input type="hidden" name="new_question1" value="<? echo $new_question1 ?>">
<input type="hidden" name="new_question2" value="<? echo $new_question2 ?>">
<input type="hidden" name="new_question3" value="<? echo $new_question3 ?>">
<input type="hidden" name="new_answer1" value="">
<input type="hidden" name="new_answer2" value="">
<input type="hidden" name="new_answer3" value="">
<input type="hidden" name="new_icq" value="">

<tr><td bgcolor="<? echo $barcolor ?>" colspan="2">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b><? echo $lang[21] ?></b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i><? echo $welcome_msg ?><br>
<? if ($displayemail == "true") { # Display Webmaster's e-mail ?>
<br><? echo $lang[22] ?>: 
<a href="mailto:<? echo $webmaster_email ?>"><font color="<? echo $bartextcolor ?>"><? echo $webmaster_email ?></font></a>.
<? } # End If - Display Webmaster's e-mail ?>
</i></font>
</td></tr><tr><td>


<? include("input_template.php"); # Load Input form ?>


</td></tr><tr><td colspan="2" align="center">

<input type="submit" value="<? echo $lang[21] ?>">
</form>

</td></tr></table>
</td></tr></table><br>

<?

displayfooter();

exit;

} # End of function - Sign Guestbook






/*
 * 
 * Function: Preview
 *
 */

function preview ($record_data) {

global $displayadd1, $displayadd2, $displayadd3, $displayuin, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, 
$homepage_title, $homepage_url, $webmaster_email, $notifications, $totalrecords, $lang;

$record_number = "TBA";

$data = explode("|", $record_data);

$record_name = stripslashes($data[0]);
$record_date = stripslashes($data[1]);
$record_email = stripslashes($data[2]);
$record_url = stripslashes($data[3]);
$record_website = stripslashes($data[4]);
$record_icq = stripslashes($data[5]);
$record_found = stripslashes($data[6]);
$record_location = stripslashes($data[7]);
$record_comments = stripslashes($data[8]);
$record_ipaddress = stripslashes($data[9]);
$record_remotehost = stripslashes($data[10]);
$record_question1 = stripslashes($data[11]);
$record_question2 = stripslashes($data[12]);
$record_question3 = stripslashes($data[13]);
$record_answer1 = stripslashes($data[14]);
$record_answer2 = stripslashes($data[15]);
$record_answer3 = stripslashes($data[16]);
$record_adminmsg = stripslashes($data[17]);

$breakchar = chr(13);
$linebreak = chr(13) . "\n";  # Linebreak & line feed characters.

$record_comments = str_replace($breakchar, "",$record_comments);  # Strip linebreaks.
$record_comments = str_replace("\n", "",$record_comments);  # Strip linefeeds.

$record_adminmsg = str_replace($breakchar, "",$record_adminmsg);  # Strip linebreaks.
$record_adminmsg = str_replace("\n", "",$record_adminmsg);  # Strip linefeeds.


/* Check for missing or incorrect data. */

if ( $record_name == "" ) { errormsg($lang[23],$lang[24]); }

if ( $record_email != "" ) { # Check for e-mail
	if (checkmail($record_email) != 1) { 
		errormsg($lang[23],$lang[25]); }
} # End If - Check for e-mail

if ( $record_comments == "" ) { errormsg($lang[23],$lang[26]); }

if ( $record_url != "" ) { # Check for URL
	if ( strtolower(substr($record_url, 0, 7)) != "http://" ) { $record_url = "http://" . $record_url; } # Add http tag to URL if it's missing.
	if ( strtolower(substr($record_url, 0, 14)) == "http://http://" ) { $record_url =  substr($record_url, 7); } # Remove "double" http://
} # End If - Check for URL


/* Check for double post */

if ($totalrecords > 0) { # - Check for double post
	$last_record = loadrecord($totalrecords);
	$last_data = explode("|", $last_record);

	if ( $data[0] == $last_data[0] AND $data[8] == $last_data[8] )
		{ errormsg($lang[23],"$lang[27] <a href=\"index.php\"><font color=\"$bartextcolor\"><b>$lang[28]</b></font></a>"); }
} # End If - Check for double post


displayheader($lang[29]);

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>" colspan="2">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b><? echo $lang[29] ?></b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i><? echo $lang[30] ?></i><br></font>
</td></tr></table>
</td></tr></table><br>

<?
include("display_template.php"); # Use template to display guestbook entry
$record_comments = str_replace("<br>",$linebreak, $record_comments);  # Convert <br> to linebreaks.
$record_adminmsg = str_replace("<br>",$linebreak, $record_adminmsg);  # Convert <br> to linebreaks.
?>

<br>
<form action="index.php" method="post">
<input type="hidden" name="action" value="addpost">
<input type="hidden" name="new_name" value="<? echo $record_name ?>">
<input type="hidden" name="new_email" value="<? echo $record_email ?>">
<input type="hidden" name="new_website" value="<? echo $record_website ?>">
<input type="hidden" name="new_url" value="<? echo $record_url ?>">
<input type="hidden" name="new_icq" value="<? echo $record_icq ?>">
<input type="hidden" name="new_found" value="<? echo $record_found ?>">
<input type="hidden" name="new_location" value="<? echo $record_location ?>">
<input type="hidden" name="new_question1" value="<? echo $record_question1 ?>">
<input type="hidden" name="new_question2" value="<? echo $record_question2 ?>">
<input type="hidden" name="new_question3" value="<? echo $record_question3 ?>">
<input type="hidden" name="new_answer1" value="<? echo $record_answer1 ?>">
<input type="hidden" name="new_answer2" value="<? echo $record_answer2 ?>">
<input type="hidden" name="new_answer3" value="<? echo $record_answer3 ?>">
<input type="hidden" name="new_comments" value="<? echo $record_comments ?>">
<input type="hidden" name="new_adminmsg" value="<? echo $record_adminmsg ?>">

<center><input type="submit" value="<? echo $lang[31] ?>"></center>
</form>

<?

displayfooter();

exit;

} # End of function - Preview




/*
 * 
 * Function: Display Record
 *
 */

function displayrecord ($record_number, $record_data, $page) {

global $displayadd1, $displayadd2, $displayadd3, $displayuin, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $lang;

$data = explode("|", $record_data);

$record_name = stripslashes($data[0]);
$record_date = stripslashes($data[1]);
$record_email = stripslashes($data[2]);
$record_url = stripslashes($data[3]);
$record_website = stripslashes($data[4]);
$record_icq = stripslashes($data[5]);
$record_found = stripslashes($data[6]);
$record_location = stripslashes($data[7]);
$record_comments = stripslashes($data[8]);
$record_ipaddress = stripslashes($data[9]);
$record_remotehost = stripslashes($data[10]);
$record_question1 = stripslashes($data[11]);
$record_question2 = stripslashes($data[12]);
$record_question3 = stripslashes($data[13]);
$record_answer1 = stripslashes($data[14]);
$record_answer2 = stripslashes($data[15]);
$record_answer3 = stripslashes($data[16]);
$record_adminmsg = stripslashes($data[17]);

$breakchar = chr(13);
$record_adminmsg = str_replace($breakchar, "",$record_adminmsg);  # Strip linebreaks.
$record_adminmsg = str_replace("\n", "",$record_adminmsg);  # Strip linefeeds.

include("display_template.php"); # Use template to display guestbook entry

print "<br>\n";

} # End of function - Display Record





/*
 * 
 * Function: Display Page
 *
 */

function displaypage ($page) {

global $perpage, $totalrecords;

/* Calculate range of records on this page. */

if ($totalrecords == 0) { $totalpages = 0; }
else { $totalpages = intval(($totalrecords - 1) / $perpage) + 1; } # Calculate how many pages there are.

$end = $totalrecords - (($totalpages - $page) * $perpage);
$start = $end - ($perpage - 1); if ($start < 1) { $start = 1; }

$records = loadrange($start,$end);
$recordindex = sizeof($records);
for ($i = $end;$i >= $start;$i--) { displayrecord($i,$records[$recordindex],$page); $recordindex--; }

} # End of function - Display Page





/*
 * 
 * Function: Opening Screen
 *
 */

function openingscreen($page) {

global $perpage, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $guestbookname, $homepage_title, $guestbookbannerurl, 
$signguestbookurl1, $signguestbookurl2, $homepage_url, $webmaster_email, $totalrecords, $confirm, $lang;


if ($totalrecords == 0) { $totalpages = 0; }
else { $totalpages = intval(($totalrecords - 1) / $perpage) + 1; } # Calculate how many pages there are.

if ($page == "" OR $page > $totalpages) { $page =  $totalpages; }

$currentpage = $page;

displayheader("$guestbookname");

if ($guestbookbannerurl != "") { print "<image src=\"$guestbookbannerurl\"><br><br>\n"; } # Display banner or text
else {	print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\" bgcolor=\"$bordercolor\" width=\"600\" align=\"center\"><tr><td>\n";
		print "<table cellpadding=\"5\" cellspacing=\"0\" border=\"0\" bgcolor=\"$barcolor\" width=\"100%\"><tr>\n";
		print "<td bgcolor=\"$barcolor\" align=\"center\"><font size=\"6\" face=\"Arial\" color=\"$bartextcolor\"><b>$guestbookname</b></font>\n";
		print "</td></tr></table></td></tr></table><br>\n";
} # End If - Display banner or text

?>

<table cellpadding="3" cellspacing="0" border="2" bgcolor="<? echo $bordercolor ?>" width="600"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%"><tr><td>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><? echo $totalrecords ?> <? echo $lang[32] ?>.</font>

</td><td>

<font size="2" face="Arial" color="<? echo $textcolor ?>">
<? echo $lang[33] ?> <? echo $currentpage ?> <? echo $lang[34] ?> <? echo $totalpages ?>.</font>

</td><td>
<? if ($currentpage < $totalpages) { ?>
<table cellpadding="1" cellspacing="0" border="1"><tr><td>
<a href="index.php?page=<? echo $currentpage + 1 ?>">
<font size="2" face="Arial" color="<? echo $textcolor ?>"><font face="Wingdings">
&ccedil;</font> <? echo $lang[35] ?></font></a></td></tr></table>
</td><td>
<? }
	if ($currentpage > 1) { ?>
<table cellpadding="1" cellspacing="0" border="1"><tr><td>
<a href="index.php?page=<? echo $currentpage - 1 ?>">
<font size="2" face="Arial" color="<? echo $textcolor ?>">
<? echo $lang[36] ?> <font face="Wingdings">&egrave;</font></font></a></td></tr></table>
</td><td>
<? } ?>

<form action="index.php" method="post">
<font size="2" face="Arial" color="<? echo $textcolor ?>"><? echo $lang[37] ?>: </font>
<font size="2"><input type="text" name="page" size="6" maxlength="6">
<input type="submit" value="<? echo $lang[38] ?>"></font>

</td></tr></table>
</td></tr></table>

</form>

<? if ($signguestbookurl1 != "" AND $signguestbookurl2 != "") { # Use mouseover ?>
<center><a href="index.php?action=sign" onMouseOver="iName='image1' ; Ichange('changed1') ; window.status='<? echo $lang[21] ?>';return true" onMouseOut="Ichange('default1') ; window.status='';return true">
<image src="<? echo $signguestbookurl1 ?>" name="image1" border="0"></a></center>

<? } elseif ($signguestbookurl1 != "") { # Use single graphic ?>
<center><a href="index.php?action=sign"><image src="<? echo $signguestbookurl1 ?>" border="0"></a></center>

<? } else { # Use text link ?>
<table cellpadding="2" cellspacing="0" border="1" bgcolor="<? echo $tablecolor ?>" align="center"><tr><td align="center">
<font size="3" face="Arial" color="<? echo $textcolor ?>"><a href="index.php?action=sign">&nbsp;- <? echo $lang[21] ?> -&nbsp;</a>
</font></td></tr></table>
<? } ?>
<br>

<? if ($totalpages == 0) { # No records have been entered. ?>
<table cellpadding="2" cellspacing="0" border="1" bgcolor="<? echo $tablecolor ?>" align="center"><tr><td align="center">
<font size="3" face="Arial" color="<? echo $textcolor ?>"><b><i> <? echo $lang[39] ?> </i></b></font></td></tr></table><br>
<? } else { displaypage($page); } ?>


<table cellpadding="3" cellspacing="0" border="2" bgcolor="<? echo $bordercolor ?>" width="600"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%"><tr><td>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><? echo $totalrecords ?> <? echo $lang[32] ?>.</font>

</td><td>

<font size="2" face="Arial" color="<? echo $textcolor ?>">
<? echo $lang[33] ?> <? echo $currentpage ?> <? echo $lang[34] ?> <? echo $totalpages ?>.</font>

</td><td>
<? if ($currentpage < $totalpages) { ?>
<table cellpadding="1" cellspacing="0" border="1"><tr><td>
<a href="index.php?page=<? echo $currentpage + 1 ?>">
<font size="2" face="Arial" color="<? echo $textcolor ?>"><font face="Wingdings">
&ccedil;</font> <? echo $lang[35] ?></font></a></td></tr></table>
</td><td>
<? }
	if ($currentpage > 1) { ?>
<table cellpadding="1" cellspacing="0" border="1"><tr><td>
<a href="index.php?page=<? echo $currentpage - 1 ?>">
<font size="2" face="Arial" color="<? echo $textcolor ?>">
<? echo $lang[36] ?> <font face="Wingdings">&egrave;</font></font></a></td></tr></table>
</td><td>
<? } ?>

<form action="index.php" method="post">
<font size="2" face="Arial" color="<? echo $textcolor ?>"><? echo $lang[37] ?>: </font>
<font size="2"><input type="text" name="page" size="6" maxlength="6">
<input type="submit" value="<? echo $lang[38] ?>"></font>

</td></tr></table>
</td></tr></table>

</form>

<?

displayfooter("true");

exit;

} # End of function - Opening Screen




/*
 * 
 * Function: Page Shift
 *
 */

function pageshift ($page) {

global $perpage, $totalrecords;

$pageshift = "false";

if ($totalrecords != 0) {
	$totalpagesnow = intval(($totalrecords - 1) / $perpage) + 1; # Calculate how many pages there are now.
	$totalpagesbefore = intval(($totalrecords) / $perpage) + 1; # Calculate how many pages there were before record was deleted.
	if ($totalpagesnow < $totalpagesbefore AND $page != 1) { $pageshift = "true"; }
}

if ($pageshift == "true") { return $page - 1; } else { return $page; }

} # End of function - Page Shift




/******************************************************************************
 * MAIN PROGRAM
 *****************************************************************************/

/* Turn on verbose error reporting (15) to see all warnings and errors - ONLY USED FOR TESTING, normally commented out. */
# error_reporting(15);

$version = "v1.12";

while(list($key, $value) = each($HTTP_GET_VARS)) { $$key = $value; } # Read in GET vars in case register_globals is turned off.
while(list($key, $value) = each($HTTP_POST_VARS)) { $$key = $value; } # Read in POST vars in case register_globals is turned off.
while(list($key, $value) = each($HTTP_COOKIE_VARS)) { $$key = $value; } # Read in GET vars in case register_globals is turned off.

load_dbconfiguration(); # Load database parameters
load_gbconfiguration(); # Load guestbook parameters
$lang = load_language("language.conf"); # Load language configuration file

$addquestion1 = stripslashes($addquestion1);
$addquestion2 = stripslashes($addquestion2);
$addquestion3 = stripslashes($addquestion3);
$homepage_title = stripslashes($homepage_title);
$guestbookname = stripslashes($guestbookname);
$welcome_msg = stripslashes($welcome_msg);
$thankyou_msg = stripslashes($thankyou_msg);


/* Check HTTP Server Vars */

$supported_keys = array_keys($HTTP_SERVER_VARS);
$useragent = ""; if (in_array("HTTP_USER_AGENT", $supported_keys)) { $useragent = $HTTP_SERVER_VARS["HTTP_USER_AGENT"]; }
$browser = "Netscape"; if ( strpos($useragent, "MSIE") ) { $browser = "MSIE"; } # Determine browser type


/* Cook raw data */

if (!isset($action)) { $action = ""; }
$action = cook($action);

if (!isset($page)) { $page = ""; }
$page = cook($page);

if (!isset($record)) { $record = ""; }
$record = cook($record);

if (!isset($uid)) { $uid = ""; }
$uid = cook($uid);


/* Actions */

if ($action == "preview") {
	if (!isset($new_answer1)) { $new_answer1 = ""; }
	if (!isset($new_answer2)) { $new_answer2 = ""; }
	if (!isset($new_answer3)) { $new_answer3 = ""; }
	if (!isset($new_icq)) { $new_icq = ""; }
	if (!isset($new_ipaddress)) { $new_ipaddress = ""; }
	if (!isset($new_remotehost)) { $new_remotehost = ""; }
	if (!isset($new_adminmsg)) { $new_adminmsg = ""; }
	$new_date = date("F j, Y, g:i a");
	$data[0] = wordbreak(strip_tags($new_name), 25);
	$data[1] = strip_tags($new_date);
	$data[2] = strip_tags($new_email);
	$data[3] = strip_tags($new_url);
	$data[4] = wordbreak(strip_tags($new_website), 25);
	$data[5] = strip_tags($new_icq);
	$data[6] = wordbreak(strip_tags($new_found1), 25);
	if ($new_found2 != "") { $data[6] = wordbreak(strip_tags($new_found2), 25); }
	$data[7] = wordbreak(strip_tags($new_location), 25);
	$data[8] = wordbreak(strip_tags($new_comments), 44);
	$data[9] = $new_ipaddress;
	$data[10] = $new_remotehost;
	$data[11] = wordbreak($new_question1, 44);
	$data[12] = wordbreak($new_question2, 44);
	$data[13] = wordbreak($new_question3, 44);
	$data[14] = wordbreak(strip_tags($new_answer1), 44);
	$data[15] = wordbreak(strip_tags($new_answer2), 44);
	$data[16] = wordbreak(strip_tags($new_answer3), 44);
	$data[17] = wordbreak(strip_tags($new_adminmsg), 44);
	$thisrecord = recordformat($data);
       if(getenv("HTTP_X_FORWARDED_FOR")){ 
		$ipaddress = getenv("HTTP_X_FORWARDED_FOR"); } 
  	else{ $ipaddress = getenv("REMOTE_ADDR"); } 
	preview($thisrecord, $ipaddress);
	}


if ($action == "addpost") {
	if (!isset($new_answer1)) { $new_answer1 = ""; }
	if (!isset($new_answer2)) { $new_answer2 = ""; }
	if (!isset($new_answer3)) { $new_answer3 = ""; }
	if (!isset($new_icq)) { $new_icq = ""; }
	$new_date = date("F j, Y, g:i a");
	if(getenv("HTTP_X_FORWARDED_FOR")) { 
		$new_ipaddress = getenv("HTTP_X_FORWARDED_FOR"); }
  	else{ $new_ipaddress = getenv("REMOTE_ADDR"); }
	$new_remotehost = gethostbyaddr($new_ipaddress);

	if ($ipcheck > 0) { # Do IP check
		if (checkiplog($new_ipaddress) == "fail") {
			errormsg($lang[23],"$ipcheck $lang[40]<br><a href=\"index.php\"><font color=\"$bartextcolor\"><b>$lang[28]</b></font></a>"); }
	} # End If - Do IP check

	$uidcounter++;
	$new_uid = $uidcounter;
	$data[0] = $new_name;
	$data[1] = $new_date;
	$data[2] = $new_email;
	$data[3] = $new_url;
	$data[4] = $new_website;
	$data[5] = $new_icq;
	$data[6] = $new_found;
	$data[7] = $new_location;
	$data[8] = $new_comments;
	$data[9] = $new_ipaddress;
	$data[10] = $new_remotehost;
	$data[11] = $new_question1;
	$data[12] = $new_question2;
	$data[13] = $new_question3;
	$data[14] = $new_answer1;
	$data[15] = $new_answer2;
	$data[16] = $new_answer3;
	$data[17] = $new_adminmsg;
	$data[18] = $new_uid;
	$data[19] = ""; # Scrach field for future expansion
	$data[20] = ""; # Scrach field for future expansion
	$data[21] = ""; # Scrach field for future expansion
	$data[22] = ""; # Scrach field for future expansion
	$thisrecord = recordformat($data);
	$recordnumber = addrecord($thisrecord);
	notification($recordnumber,$thisrecord);
	$displaythankyou = "true";
	$action = "";
	$page = "";
	}


if ($action == "sign") { signguestbook(); }


openingscreen($page); # No action, display Opening Screen by default.

?>

