<?
/*
 * Name: HyperBook Guestbook Administration
 * Author: Thomas R. Pasawicz
 * Creation Date: April 15, 2001
 * Version: 1.12 (released May 16, 2001)
 * Function: Allows administrator to configure guestbook and edit/delete entries.
 * (c) 2001-2002 Thomas R. Pasawicz (webmaster@diamond-back.com)
 *
 */


/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/


include("database_functions.php"); # Load Core Database Functions


/*
 * 
 * Function: Cook Raw Data
 *
 */

function cook ($textin) {
	$textin = str_replace("\\", "", $textin);
	$text1 = htmlspecialchars($textin);
	$textout = addslashes($text1);
	return $textout;
} # End of function - Cook Raw Data





/*
 * 
 * Function: Display Script Execution Time
 *
 */

function displayexectime($displaycolor) {

global $scriptstarttime, $availabletime;

$timeparts = explode(" ", $scriptstarttime);
$starttime = $timeparts[1] . substr($timeparts[0],1);
$timeparts = explode(" ", microtime());
$endtime = $timeparts[1] . substr($timeparts[0],1);

if ($starttime !="" AND $endtime !="") { # If times are available, display the elapsed time.
	if (is_numeric($starttime) AND is_numeric($endtime)) { # Now make certain they are numeric.

		$elapsedtime = $endtime - $starttime;
		$elapsedtime = round($elapsedtime, 6);

		print "<br><center><font size=\"1\" face=\"Arial\" color=\"$displaycolor\"><i>Script execution time: $elapsedtime seconds\n";

		If ( $availabletime != "" AND $availabletime != "0" ) { # If known, display available time.
			$timeremaining = $availabletime - $elapsedtime; print "&nbsp;&#149;&nbsp;Time remaining: $timeremaining seconds"; }

		print "</i></font></center>\n";

	} # End If - Now make certain they are numeric.
} # End If - If times are available, display the elapsed time.

} # End of function - Display Script Execution Time




/*
 * 
 * Function: Validate e-mail address
 *
 */

function checkmail ($email) {

if (ereg('^[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+'.'@'.'[-!#$%&\'*+\\/0-9=?A-Z^_`a-z{|}~]+\.'.
'[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+$', $email)) {
	return true;
} else {
	return false;
} # End If
} # End of function - Validate e-mail address





/*
 * 
 * Function: Word Break
 *
 */

function wordbreak($text, $wordsize) {

if (strlen($text) <= $wordsize) { return $text; } # No breaking necessary, return original text.

$text = str_replace("\n", "", $text); # Strip linefeeds
$done = "false";
$newtext = "";
$start = 0; # Initialize starting position
$segment = substr($text, $start, $wordsize + 1); # Initialize first segment

while ($done == "false") { # Parse text

	$lastspace = strrpos($segment, " ");
	$lastbreak = strrpos($segment, "\r");

	if ( $lastspace == "" AND $lastbreak == "" ) { # Break segment
		$newtext .= substr($text, $start, $wordsize) . " ";
		$start = $start + $wordsize; }
	else { # Move start to last space or break
		$last = max($lastspace, $lastbreak);
		$newtext .= substr($segment, 0, $last + 1);
		$start = $start + $last + 1;
	} # End If - Break segment

	$segment = substr($text, $start, $wordsize + 1);

	if ( strlen($segment) <= $wordsize ) { # Final segment is smaller than word size.
		$newtext .= $segment;
		$done = "true";
	} # End If - Final segment is smaller than word size.

} # End While - Parse text

$newtext = str_replace("\r", "\r\n", $newtext); # Replace linefeeds

return $newtext;

} # End of function - Word Break





/*
 * 
 * Function: Display Confirmation Message
 *
 */

function confirmmsg($confirm) {

global $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor;

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Confirmation</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i><? echo $confirm ?></i><br></font>
<? displayexectime($bartextcolor); ?>
</td></tr></table>
</td></tr></table><br>
<?

} # End of function - Display Confirmation Message




/*
 * 
 * Function: Display Header
 *
 */

function displayheader($title) {

global $bodycolor, $backgroundimageurl, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, 
$alinkcolor, $hovercolor, $homepage_title, $homepage_url, $webmaster_email, $signguestbookurl1, $signguestbookurl2, $headertag;

/* Try to prevent caching of dynamic pages. */

header ("Expires: Mon, 26 Jul 1997 05:00:00 GMT");			// Date in the past
header ("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");	// always modified
header ("Cache-Control: no-cache, must-revalidate");			// HTTP/1.1
header ("Pragma: no-cache");										// HTTP/1.0

?>
<html>
<head>
<title><? echo $title ?></title>

<meta http-equiv="Content-Type" content="text/html">
<meta http-equiv="Expires" content="0">
<meta name="Description" content="HyperBook Guestbook">
<meta name="Keywords" content="guestbook PHP">
<meta name="Author" content="Thomas R. Pasawicz - webmaster@diamond-back.com">

<style type="text/css">
<!--
a:link        {text-decoration: none;}
a:active    {text-decoration: none;}
a:visited   {text-decoration: none;}
a:hover     {color:<? echo $hovercolor ?>; text-decoration: none;}
-->
</style>

<? if ($signguestbookurl1 != "" AND $signguestbookurl2 != "") { # Display mouseover javascript ?>
<SCRIPT LANGUAGE="JavaScript">  <!-- Hide from old browsers
var iName=""; var nav=navigator.appName.indexOf("Netscape"); var vers=parseInt(navigator.appVersion);
  if ( (nav != -1 && vers >= 3) || (vers == 4) ) {
default1 = new Image(); default1.src = "<? echo $signguestbookurl1 ?>"
changed1 = new Image(); changed1.src = "<? echo $signguestbookurl2 ?>"
  }
  function Ichange(p) {
    if ( (nav != -1 && vers >= 3) || (vers == 4) ) {
    var pSrc=eval(p+ ".src");
    document[iName].src = pSrc;
    }
  }
// end hiding --></SCRIPT>
<? } # End If - Display mouseover javascript ?>

</head>

<body bgcolor="<? echo $bodycolor ?>" background="<? echo $backgroundimageurl ?>" text="<? echo $textcolor ?>" 
link="<? echo $linkcolor ?>" vlink="<? echo $vlinkcolor ?>" alink="<? echo $alinkcolor ?>">

<table width="600" cellspacing="0" cellpadding="0" align="center"><tr><td>

<?

if ($headertag != "") { print "$headertag\n<br>\n"; }

} # End of function - Display Header






/*
 * 
 * Function: Display Footer Menu
 *
 */

function displayfootermenu() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor;

?>

<table cellpadding="2" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td align="center">

<font size="1" face="Arial" color="<? echo $textcolor ?>">

<a href="admin.php">Main Menu</a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=logout">Admin Log Out</a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=display">Display/Edit/Delete Posts</a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=configure">Guestbook Configuration</a><br>

<a href="admin.php?action=dbconfigure">Database Manager</a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=colorconfigure">Color/Graphics Selection</a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=changepassword">Change Password</a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=resetip">Reset IP Log</a>

</font>

<? displayexectime($textcolor); ?>

</td></tr></table>
</td></tr></table><br>
<?

} # End of function - Display Footer Menu




/*
 * 
 * Function: Display Footer
 *
 */

function displayfooter($displaymenu) {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $version;

if ($displaymenu == "true") { displayfootermenu(); }

?>
<table cellpadding="1" cellspacing="0" border="1" bgcolor="<? echo $tablecolor ?>" align="center" width="600"><tr><td align="center">
<font size="1" face="Arial" color="<? echo $textcolor ?>">
<i>HyperBook Guestbook <? echo $version ?></i> Copyright &copy; 2001 by 
<a href="mailto:webmaster@diamond-back.com">Thomas R. Pasawicz</a>. All rights reserved. &#149; 
<a href="http://diamond-back.com/software/guestbook/"><i>Click here for more info.</i></a>

</font></td></tr></table>
</td></tr></table>

</body>
</html>
<?

} # End of function - Display Footer




/*
 * 
 * Function: Display Error Message
 *
 */

function errormsg($errortitle,$message) {

global $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor;

displayheader($errortitle);

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b><? echo $errortitle ?></b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i><? echo $message ?></i><br></font>
</td></tr></table>
</td></tr></table><br>
<?

displayfooter("false");

exit;

} # End of function - Display Error Message





/*
 * 
 * Function: Administrator Log-in
 *
 */

function login() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $homepage_title, $homepage_url, $thankyou_msg, $action, $record, $uid;

displayheader("Guestbook Administrator Log-in");

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Guestbook Administrator Log-in</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>Please enter your password. For proper function, 
you must have cookies enabled in your browser.</i><br></font>
</td></tr><tr>
<td align="center">

<form action="admin.php" method="post">
<input type="hidden" name="action" value="<? echo $action ?>">
<input type="hidden" name="record" value="<? echo $record ?>">
<input type="hidden" name="uid" value="<? echo $uid ?>">
<input type="hidden" name="newlogin" value="true">
<font size="2" face="Arial" color="<? echo $textcolor ?>">Password: </font>
<font size="3"><input type="password" name="loginpassword" size="20" maxlength="20">
<input type="submit" value="Submit"></font>

</td></tr></table>
</td></tr></table><br>
<?

displayfooter("false");

exit;

} # End of function - Administrator Log-in




/*
 * 
 * Function: Administrator Log-out
 *
 */

function logout() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $homepage_title, $homepage_url, $thankyou_msg, $action, $record;

setcookie("hyperbookpassword", "null", time() - 3600);

displayheader("Guestbook Administrator Log-out");

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>" colspan="3">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Guestbook Administrator Log-out</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>You have been successfully logged-out.</i><br></font>
</td></tr><tr>
<td align="center"><font size="2" face="Arial"><a href="index.php"><b>View Guestbook</b></a></font></td>
<td align="center"><font size="2" face="Arial"><a href="<? echo $homepage_url ?>"><b>Homepage</b></a></font></td>
<td align="center"><font size="2" face="Arial"><a href="admin.php"><b>Log-in Again</b></a></font></td>
</tr></table>
</td></tr></table><br>
<?

displayfooter("false");

exit;

} # End of function - Administrator Log-out




/*
 * 
 * Function: Update Guestbook Configuration File
 *
 */

function update_gbconfiguration() {

global $perpage, $ipcheck, $addquestion1, $displayadd1, $addquestion2, $displayadd2, $addquestion3, $displayadd3, $displayuin, 
$displayemail, $foundoptions, $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, $alinkcolor, 
$hovercolor, $homepage_title, $homepage_url, $guestbookname, $guestbookbannerurl, $signguestbookurl1, $signguestbookurl2, 
$backgroundimageurl, $webmaster_email, $notifications, $notification_email, $welcome_msg, $thankyou_msg, $adminurl, $adminpass, 
$cookieexpiration, $datapath, $bannedwords, $headertag;

if (!isset($addquestion1)) { $addquestion1 = ""; }
$addquestion1 = cook($addquestion1);

if (!isset($addquestion2)) { $addquestion2 = ""; }
$addquestion2 = cook($addquestion2);

if (!isset($addquestion3)) { $addquestion3 = ""; }
$addquestion3 = cook($addquestion3);

if (!isset($homepage_title)) { $homepage_title = ""; }
$homepage_title = cook($homepage_title);

if (!isset($guestbookname)) { $guestbookname = ""; }
$guestbookname = cook($guestbookname);

if (!isset($welcome_msg)) { $welcome_msg = ""; }
$welcome_msg = cook($welcome_msg);

if (!isset($thankyou_msg)) { $thankyou_msg = ""; }
$thankyou_msg = cook($thankyou_msg);

$howfound = chop(recordformat($foundoptions));

$linebreak = chr(13) . "\n";  # Linebreak & line feed characters.
$headertag_converted = str_replace("|", "&#124;", $headertag); # Convert pipes to HTML elements.
$headertag_converted = str_replace($linebreak, "|", $headertag_converted); # Convert linebreaks to pipes.


$filename = $datapath . 'gbconfiguration.dat';

$contents = "$perpage
$ipcheck
$addquestion1
$displayadd1
$addquestion2
$displayadd2
$addquestion3
$displayadd3
$displayuin
$displayemail
$bodycolor
$bordercolor
$tablecolor
$barcolor
$textcolor
$bartextcolor
$linkcolor
$vlinkcolor
$alinkcolor
$hovercolor
$homepage_title
$homepage_url
$guestbookname
$guestbookbannerurl
$signguestbookurl1
$signguestbookurl2
$backgroundimageurl
$webmaster_email
$notifications
$notification_email
$welcome_msg
$thankyou_msg
$adminurl
$adminpass
$cookieexpiration
$howfound
$bannedwords
$headertag_converted
";

if ($fp = fopen($filename, 'w')) { # File opened for writing
      $lock = flock($fp, LOCK_EX);
	if ($lock) { # Lock achived
		fwrite($fp, $contents);
		flock($fp, LOCK_UN);
	} # End If - Lock achived
	fclose($fp);
} else { print "ERROR: Guestbook Configuration file couldn't be opened for writing.<br><br>\n\nFilename: $filename<br><br>\n\n";
} # End If - File opened for writing

} # End of function - Update Guestbook Configuration File







/*
 * 
 * Function: Load Guestbook Configuration File
 *
 */

function load_gbconfiguration() {

global $perpage, $ipcheck, $addquestion1, $displayadd1, $addquestion2, $displayadd2, $addquestion3, $displayadd3, $displayuin, 
$displayemail, $foundoptions, $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, 
$alinkcolor, $hovercolor, $homepage_title, $homepage_url, $guestbookname, $guestbookbannerurl, $signguestbookurl1, 
$signguestbookurl2, $backgroundimageurl, $webmaster_email, $notifications, $notification_email, $welcome_msg, $thankyou_msg, 
$adminurl, $adminpass, $cookieexpiration, $datapath, $bannedwords, $headertag;

$filename = "data/gbconfiguration.dat";

if ($fp = fopen($filename, 'r')) { # File opened for reading
	$lock = flock($fp, LOCK_SH); 
	if ($lock) { # Lock achived

		$perpage = chop(fgets($fp, 5000));
		$ipcheck = chop(fgets($fp, 5000));
		$addquestion1 = chop(fgets($fp, 5000));
		$displayadd1 = chop(fgets($fp, 5000));
		$addquestion2 = chop(fgets($fp, 5000));
		$displayadd2 = chop(fgets($fp, 5000));
		$addquestion3 = chop(fgets($fp, 5000));
		$displayadd3 = chop(fgets($fp, 5000));
 		$displayuin = chop(fgets($fp, 5000));
		$displayemail = chop(fgets($fp, 5000));
		$bodycolor = chop(fgets($fp, 5000));
		$bordercolor = chop(fgets($fp, 5000));
		$tablecolor = chop(fgets($fp, 5000));
		$barcolor = chop(fgets($fp, 5000));
		$textcolor = chop(fgets($fp, 5000));
		$bartextcolor = chop(fgets($fp, 5000));
		$linkcolor = chop(fgets($fp, 5000));
		$vlinkcolor = chop(fgets($fp, 5000));
		$alinkcolor = chop(fgets($fp, 5000));
		$hovercolor = chop(fgets($fp, 5000));
		$homepage_title = chop(fgets($fp, 5000));
		$homepage_url = chop(fgets($fp, 5000));
		$guestbookname = chop(fgets($fp, 5000));
		$guestbookbannerurl = chop(fgets($fp, 5000));
		$signguestbookurl1 = chop(fgets($fp, 5000));
		$signguestbookurl2 = chop(fgets($fp, 5000));
		$backgroundimageurl = chop(fgets($fp, 5000));
		$webmaster_email = chop(fgets($fp, 5000));
		$notifications = chop(fgets($fp, 5000));
		$notification_email = chop(fgets($fp, 5000));
		$welcome_msg = chop(fgets($fp, 5000));
		$thankyou_msg = chop(fgets($fp, 5000));
		$adminurl = chop(fgets($fp, 5000));
		$adminpass = chop(fgets($fp, 5000));
		$cookieexpiration = chop(fgets($fp, 5000));
		$howfound = chop(fgets($fp, 5000));
		$bannedwords = chop(fgets($fp, 5000));
		$headertag = chop(fgets($fp, 5000));

		$lock = flock($fp, LOCK_UN);
	} # End If - Lock achived
	fclose($fp);

	$foundoptions = explode("|", $howfound);

	$linebreak = chr(13) . "\n";  # Linebreak & line feed characters.
	$headertag = str_replace("|", $linebreak, $headertag); # Convert pipes to linebreaks.
	$headertag = str_replace("&#124;", "|", $headertag); # Convert HTML elements to pipes.

} # End If - File opened for reading

} # End of function - Load Guestbook Configuration File





/*
 * 
 * Function: Load Language Configuration File
 *
 */

function load_language($filename) {

if ($fp = fopen($filename, 'r')) { # File opened for reading
	$lock = flock($fp, LOCK_SH); 
	if ($lock) { # Lock achived
		$lang = file($filename);
		$lock = flock($fp, LOCK_UN);
	} # End If - Lock achived
	fclose($fp);
} # End If - File opened for reading

$number_lines = sizeof($lang);
for ($i = 0;$i < $number_lines;$i++) { # Initialize text
	$lang[$i] = trim($lang[$i]); # Trim string (removes CR from end of line).
} # End For Loop - Initialize text

return $lang;

} # End of function - Load Language Configuration File




/*
 * 
 * Function: Change Administrative Password
 *
 */

function changepassword() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor;

displayheader("Change Administrative Password");

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>" colspan="2">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Change Administrative Password</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>This is the password used to access the Guestbook Administration section. 
It must be at least 6 characters long and may consist of upper and lower case letters and numbers (punctuation characters should not be used).
</i><br></font>
</td></tr><tr><td colspan="2"><font size="1">&nbsp; </font>
</td></tr><tr><td>
<form action="admin.php" method="post">
<input type="hidden" name="action" value="updatepassword">
<font size="2" face="Arial" color="#000000">Password: </font>
<font size="3"><input type="password" name="new_adminpass" size="20" maxlength="20"></font>
</td><td>
<font size="2" face="Arial" color="#000000">Enter Again: </font>
<font size="3"><input type="password" name="new2_adminpass" size="20" maxlength="20"></font>
</td></tr><tr><td align="center" colspan="2">
<input type="submit" value="Update Password">
</form>
</td></tr></table>
</td></tr></table><br>
<?

displayfooter("true");

exit;

} # End of function - Change Administrative Password





/*
 * 
 * Function: Update Administrative Password
 *
 */

function updatepassword($new_adminpass,$new2_adminpass) {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $adminpass, $cookieexpiration;

if ( $new_adminpass != $new2_adminpass ) { errormsg("Password Error","The passwords you entered don't match, please try again."); }
elseif ( strlen($new_adminpass) < 6 ) { errormsg("Password Error","The password you entered is less than six characters long, please try again."); }
else { # New password verified

$adminpass = $new_adminpass;
setcookie ("hyperbookpassword", "$adminpass", time() + $cookieexpiration);
$adminpass = md5 ($adminpass); # Encrypt password
update_gbconfiguration();

} # End If - New password verified


} # End of function - Update Administrative Password





/*
 * 
 * Function: Check Database
 *
 */

function dbintegritycheck() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $totalrecords, $perfile, $datapath;

displayheader("Database Integrity Check");

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Database Integrity Check</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>These are the results of the database diagnostic test.
</i><br></font>
</td></tr><tr><td>

<font size="2" face="Arial" color="<? echo $textcolor ?>">

<? dbcheck(); ?>

</font>

</td></tr></table>
</td></tr></table><br>
<?

displayfooter("true");

exit;

} # End of function - Check Database






/*
 * 
 * Function: Guestbook Configuration Update Check
 *
 */

function configurationcheck() {

global $perpage, $ipcheck, $addquestion1, $displayadd1, $addquestion2, $displayadd2, $addquestion3, $displayadd3, $displayuin, 
$displayemail, $foundoptions, $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, 
$alinkcolor, $hovercolor, $homepage_title, $homepage_url, $guestbookname, $webmaster_email, $notifications, $notification_email, 
$welcome_msg, $thankyou_msg, $adminurl, $cookieexpiration, $bannedwords, $headertag;


/* Check for missing or incorrect data. */

if ( $guestbookname == "" )
	{ errormsg("Guestbook Configuration Error","Missing Guestbook Name, please click the back button and fill-in this field."); }

if ( $homepage_title == "" )
	{ errormsg("Guestbook Configuration Error","Missing Homepage Title, please click the back button and fill-in this field."); }

if ( $webmaster_email == "" )
	{ errormsg("Guestbook Configuration Error","Missing Webmaster E-mail, please click the back button and fill-in this field."); }

if (checkmail($webmaster_email) != 1)
	{ errormsg("Guestbook Configuration Error","The Webmaster e-mail address you entered does not appear to be valid. Please click the back 
	button and check the e-mail address for errors. Note: Spaces cannot be used in an e-mail address."); }

if ( strtolower(substr($homepage_url, 0, 7)) != "http://" ) { $homepage_url = "http://" . $homepage_url; } # Add http tag to Homepage URL if it's missing.

} # End of function - Guestbook Configuration Update Check




/*
 * 
 * Function: Guestbook Configuration
 *
 */

function configuration($possibleadminurl) {

global $perpage, $ipcheck, $addquestion1, $displayadd1, $addquestion2, $displayadd2, $addquestion3, $displayadd3, $displayuin, 
$displayemail, $foundoptions, $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, 
$alinkcolor, $homepage_title, $homepage_url, $guestbookname, $webmaster_email, $notifications, $notification_email, 
$welcome_msg, $thankyou_msg, $adminurl, $cookieexpiration, $bannedwords, $headertag;

$checked['true'] = "checked";
$checked['false'] = "";

$break = chr(13) . "\n";  # Linebreak & line feed characters.

$cookiecheck1=""; if ($cookieexpiration == "3600") { $cookiecheck1="checked"; } # hour
$cookiecheck2=""; if ($cookieexpiration == "86400") { $cookiecheck2="checked"; } # day
$cookiecheck3=""; if ($cookieexpiration == "2592000") { $cookiecheck3="checked"; } # month
$cookiecheck4=""; if ($cookieexpiration == "31536000") { $cookiecheck4="checked"; } # year

displayheader("Guestbook Configuration");

?>

<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Guestbook Configuration</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>The following functions will allow you to control the way your guestbook will 
be displayed.</i><br></font>
</td></tr><tr>
<td align="left">

<form action="admin.php" method="post">
<input type="hidden" name="action" value="updateconfig">
<input type="hidden" name="new_notifications" value="false">
<input type="hidden" name="new_bannedwords" value="false">
<input type="hidden" name="new_displayadd1" value="false">
<input type="hidden" name="new_displayadd2" value="false">
<input type="hidden" name="new_displayadd3" value="false">
<input type="hidden" name="new_displayuin" value="false">
<input type="hidden" name="new_displayemail" value="false">


<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Guestbook Name</b><br>
<i>Your guestbook name will be displayed in the page title and in place of a banner graphic if you decide not to use one. </i></font><br>
<font size="3"><input type="text" name="new_guestbookname" value="<? echo $guestbookname ?>" size="66" maxlength="60"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Website Title</b><br>
<i>Your Website/Homepage title will be displayed on links back to your homepage URL.<br>
If you don't have a name for your website, you may simply use "Homepage". </i></font><br>
<font size="3"><input type="text" name="new_homepage_title" value="<? echo $homepage_title ?>" size="66" maxlength="60"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Homepage URL</b><br>
<i>This is the full URL back to your homepage beginning with "http://".<br>
Examples: "http://mydomain.com" or "http://www.myhost.com/~mywebsite/index.html"</i></font><br>
<font size="3"><input type="text" name="new_homepage_url" value="<? echo $homepage_url ?>" size="66"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Webmaster E-mail</b><br>
<i>Please enter your e-mail address.</i></font><br>
<font size="3"><input type="text" name="new_webmaster_email" value="<? echo $webmaster_email ?>" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Admin Program URL</b><br>
<i>This is the complete URL to the admin program. The admin program will attempt to determine this URL for you. 
If a URL is shown below, use it unless you know for certain that a different URL is required. </i><br>
<? if ($possibleadminurl == "") { $possibleadminurl = "Could Not Be Determined"; } ?>
Possible URL: <? echo $possibleadminurl ?> <br></font>
<font size="3"><input type="text" name="new_adminurl" value="<? echo $adminurl ?>" size="66"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>E-mail Notifications</b><br>
<i>E-mail notifications will allow you to receive each post to your guestbook via e-mail, this way you will not have to continuously visit your 
guestbook to check for new posts. In addition, a link will be provided in each notification to take you directly to the editor page for that post. 
From the editor page you may change, delete or add a personal comment to the guestbook post. Notifications can be sent to more than one 
person by entering multiple e-mail addresses, separated by commas, in the notification list box.</i></font><br>
<input type="checkbox" name="new_notifications" value="true" <? echo $checked[$notifications] ?>>
<font size="2" face="Arial" color="<? echo $textcolor ?>"> Send E-mail Notifications</font><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">E-mail Notification List:<br></font>
<font size="3">
<textarea cols="68" rows="2" maxlenght="3000" name="new_notification_email" wrap="virtual"><? echo $notification_email ?></textarea>
</font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>IP Check</b><br>
<i>The IP Check is used to prevent guestbook "flooding," where a malicious visitor attempts to post a large number of nonsense posts to 
your guestbook. It works by recording a log of each poster's IP address and will only allow additional posts up to the number specified in the 
IP Check box. For example, if you enter "2" in the box, then a visitor will only be allowed to post twice before being blocked. A "1" would allow 
only a single post, a "3" would allow up to three posts. If you enter a zero (0), then IP Checking will be disabled and visitors may post as often 
as they wish. Note that only the most recent 25 IP addresses are logged, after 25 posts a return visitor will be allowed to post again since 
their IP address will no longer be in the log. Recommended values are 2 or 3, since some visitors may wish to make a follow-up post 
or two.</i></font><br>
<font size="2" face="Arial" color="<? echo $textcolor ?>">IP Check: </font>
<font size="3"><input type="text" name="new_ipcheck" value="<? echo $ipcheck ?>" size="8" maxlength="8"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Posts Per Page</b><br>
<i>This setting will control how many posts are displayed on each page of your guestbook and may be changed at any time. By default, 
your guestbook will always display the most recent posts first, with each following page displaying eariler posts. A good value for this 
setting is 10.</i></font><br>
<font size="2" face="Arial" color="<? echo $textcolor ?>">Posts Per Page: </font>
<font size="3"><input type="text" name="new_perpage" value="<? echo $perpage ?>" size="8" maxlength="8"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Banned Words</b><br>
<i>You may screen out banned words from your guestbook post by checking the box below. The list of banned words may be changed by 
editing the "bannedwords.txt" file in your guestbook directory.</i></font><br>
<input type="checkbox" name="new_bannedwords" value="true" <? echo $checked[$bannedwords] ?>>
<font size="2" face="Arial" color="<? echo $textcolor ?>"> Screen Banned Words</font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Password Cookie Expiration</b><br>
<i>The Administrator's password is saved in a cookie after successfully logging into the admin program. You may use this setting to determine 
how long a cookie will be stored before it expires and the Admin is required to enter the password again. If you share your computer with other 
people, it is recommended that you set the expiration low, such as one hour. If you are the only one to have access to your computer, you 
may wish to set the expiration to a month or even a year (just be sure you don't forget your password after such a long period of time). 
Note: you can clear the password from your cookie at any time by clicking on the "Admin Log Out" link.</i></font><br>
<font size="2" face="Arial" color="<? echo $textcolor ?>">Password Cookie Expiration: </font>
<font size="2" face="Arial" color="<? echo $textcolor ?>">
<input type="radio" value="3600" name="new_cookieexpiration" <? echo $cookiecheck1 ?> > Hour &nbsp; 
<input type="radio" value="86400" name="new_cookieexpiration" <? echo $cookiecheck2 ?> > Day &nbsp; 
<input type="radio" value="2592000" name="new_cookieexpiration" <? echo $cookiecheck3 ?> > Month &nbsp; 
<input type="radio" value="31536000" name="new_cookieexpiration" <? echo $cookiecheck4 ?> > Year</font><br><br>


<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Additional Questions</b><br>
<i>Along with the usual Name/Location/Comments fields in the guestbook, you may include up to three additional questions of your choice. 
It is recommended that you keep your questions short and simple since visitors will only have one line (100 characters) to enter each answer 
(they could use the "comments" section for more detailed answers). Your questions may pertain to your website's theme, for example a music 
site could ask visitors what their favorite band, CD or concert are. Or you may ask if a visitor wishes to be contacted regarding a product or 
service. Be sure to click the "Displayed" box for each question you enter. </i></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Additional Question 1: &nbsp; </font>
<input type="checkbox" name="new_displayadd1" value="true" <? echo $checked[$displayadd1] ?>>
<font size="2" face="Arial" color="<? echo $textcolor ?>"> Displayed</font><br>
<font size="3"><input type="text" name="new_addquestion1" value="<? echo $addquestion1 ?>" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Additional Question 2: &nbsp; </font>
<input type="checkbox" name="new_displayadd2" value="true" <? echo $checked[$displayadd2] ?>>
<font size="2" face="Arial" color="<? echo $textcolor ?>"> Displayed</font><br>
<font size="3"><input type="text" name="new_addquestion2" value="<? echo $addquestion2 ?>" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Additional Question 3: &nbsp; </font>
<input type="checkbox" name="new_displayadd3" value="true" <? echo $checked[$displayadd3] ?>>
<font size="2" face="Arial" color="<? echo $textcolor ?>"> Displayed</font><br>
<font size="3"><input type="text" name="new_addquestion3" value="<? echo $addquestion3 ?>" size="66" maxlength="100"></font><br><br>


<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Found Options</b><br>
<i>Vistors can be presented with a list of ways they found your website. You may enter additional options to this list, one per line. It is 
recommended that each line be no more than 35 characters in lenght to ensure proper display.</i></font><br>
<font size="3">
<textarea cols="68" rows="5" maxlenght="3000" name="new_foundoptions" wrap="virtual"><? echo implode($break, $foundoptions) ?></textarea>
</font><br><br>


<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Display UIN (ICQ Number) Field</b><br>
<i>The UIN (ICQ Number) is an optional field. If your guests use ICQ you may wish to include it as a way of contacting them.</i></font><br>
<input type="checkbox" name="new_displayuin" value="true" <? echo $checked[$displayuin] ?>>
<font size="2" face="Arial" color="<? echo $textcolor ?>"> Display UIN (ICQ Number) Field</font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Display Admin's E-mail Address</b><br>
<i>You may display the Administrator's e-mail address along with a note to send "private messages" via e-mail (since guestbooks are 
intended for public viewing, it doesn't make sense to post private messages when an e-mail will accomplish the same thing).</i></font><br>
<input type="checkbox" name="new_displayemail" value="true" <? echo $checked[$displayemail] ?>>
<font size="2" face="Arial" color="<? echo $textcolor ?>"> Display Admin's E-mail Address</font><br><br>


<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Welcome Message</b><br>
<i>This is the message displayed to visitors who are about to sign your guestbook. It may contain additional information about the guestbook 
form or simply invite them to share their thoughts.</i></font><br>
<font size="3">
<textarea cols="68" rows="5" maxlenght="3000" name="new_welcome_msg" wrap="virtual"><? echo $welcome_msg ?></textarea></font><br><br>


<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Thank You Message</b><br>
<i>The thank you message is displayed to visitors who have just signed your guestbook. It never hurts to be polite and let your visitors know 
you appreciate the time they took to leave you a message.</i></font><br>
<font size="3">
<textarea cols="68" rows="5" maxlenght="3000" name="new_thankyou_msg" wrap="virtual"><? echo $thankyou_msg ?></textarea></font><br><br>


<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Header Tag HTML</b><br>
<i>The HTML entered in this box will be included at the top of each page of your guestbook. It is typically used for displaying an ad banner, 
particularly if you are using a "free" hosting service which requires you to include their banner code in exchange for hosting your site. 
You should exercise caution when entering code in this box, any errors such as an unclosed tag could adversely affect the display of your 
guestbook. Note that the actual "HEAD" and "BODY" tags are generated by HyperBook and should not be included here. If you wish to change 
your Guestbook's colors, please use the Color/Graphics Selection area.</i></font><br>
<font size="3">
<textarea cols="68" rows="5" maxlenght="3000" name="new_headertag" wrap="virtual"><? echo $headertag ?></textarea></font><br><br>

<center><input type="submit" value="Update Configuration"></center>
</form>

</td></tr></table>
</td></tr></table><br>

<?

displayfooter("true");

exit;

} # End of function - Guestbook Configuration




/*
 * 
 * Function: Database Manager
 *
 */

function dbconfiguration($possiblepath) {

global $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, $alinkcolor, $perfile, 
$totalrecords, $uidcounter, $datapath;

$possiblepath = str_replace("admin.php", "data/", $possiblepath);  # Corrected data path

displayheader("Database Manager");

?>

<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Database Manager</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>The following functions will allow you to control the way your database 
operates. It is advisable to read the HyperBook Documentation before using any of the functions in this section.</i><br></font>
</td></tr><tr>
<td align="left">

<form action="admin.php" method="post">
<input type="hidden" name="action" value="updatedbconfig">

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Data Directory Pathway</b><br>
<i>This is the pathway on your server to the data directory. Note: this is NOT a URL. The admin program will attempt to determine this path for 
you. If a path is shown below, use it unless you know for certain that a different path is required. </i><br>
<? if ($possiblepath == "") { $possiblepath = "Could Not Be Determined"; } ?>
Possible path: <? echo $possiblepath ?> <br></font>
<font size="3"><input type="text" name="new_datapath" value="<? echo $datapath ?>" size="66"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Number of Records Per File</b><br>
<i>This controls how many files will be stored in each of the flat text database files. It is NOT the number of records displayed on each page, 
that may be modified from the Guestbook Configuration menu. You should NOT change this setting unless you know what you are doing! 
Once a multi-file database has been created, the number of records stored in each file cannot be changed without severely corrupting the database. 
If for some reason this value must be changed, you should first export your current database, then delete all the data files, change this setting and 
then import the database so that all the files will have the correct number of records.</i><br></font>

<font size="3"><input type="text" name="new_perfile" value="<? echo $perfile ?>" size="5" maxlength="5"></font> 
<font size="2" face="Arial" color="<? echo $textcolor ?>">
<b><u>WARNING:</u></b><i> Should not be arbitrarily altered! Normally set to 25.</i><br><br></font>

<center><input type="submit" value="Update Configuration"></center>
</form>

<hr>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Clear Database</b><br>
<b><u>WARNING:</u></b> <i>This function will remove all posts from your guestbook and reset it to zero entries. "Data" files in the data 
directory will then be deleted. Once cleared, you will not be able to recover these files unless you have made a back-up or used the 
Export function (below).</i><br></font>
<form action="admin.php" method="post">
<input type="hidden" name="action" value="cleardatabase">
<center><input type="submit" value="Clear Database"></center>
</form>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Export Database</b><br>
<i>This function is used to dump all records in the multi-file database to a single file called "records.dat" located in the data directory. 
It may be used for archiving your data or in conjunction with the Import Database function for importing records from other guestbooks 
or changing the number of records stored in each file.</i><br></font>
<form action="admin.php" method="post">
<input type="hidden" name="action" value="exportdatabase">
<center><input type="submit" value="Export Database"></center>
</form>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Import Database</b><br>
<i>This function is used to load records from a single file called "records.dat" located in the data directory into the multi-file database. 
It may be used for importing records from other guestbooks or changing the number of records stored in each file. Imported records will 
be added to the current records in the order they found. Therefore, the last record in the imported file will appear as the most recent post. 
Note: the imported records must be in the proper format or the guestbook database could become corrupted. It is advisable to back-up 
any existing records before attempting to import new records.</i><br></font>
<form action="admin.php" method="post">
<input type="hidden" name="action" value="importdatabase">
<center><input type="submit" value="Import Database"></center>
</form>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Database Integrity Check</b><br>
<i>This function is used to confirm that all files in the database exist, contain the expected number of records and that each record contains 
the expected number of fields. It can be used to test an imported database or to diagnose error messages generated by PHP.</i><br></font>
<form action="admin.php" method="post">
<input type="hidden" name="action" value="checkdb">
<center><input type="submit" value="Check Database"></center>
</form>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Record Format</b><br>
<i>Shown below is the format used for each record in the flat text database files. Each record is a single line terminated by a line break 
(character 13 and a linefeed). Records are divided into fields using "pipes": | chr(124). If a pipe is to appear as part of a field, it should 
first be converted into an HTML entity (&amp;#124;) so it will not be mistaken for a field delimiter. Likewise, all line breaks should be 
converted to "&lt;br&gt;" tags so that a record will not be prematurely terminated. URLs are stored with the "http://" prefix and will not 
work properly without it. The only expected fields are name, date and comments, the rest may be left blank (the pipes will still be required 
to hold their place, eg. a missing e-mail would be || ). UID is a "unique identifier" used when searching for a particular record, it is only 
used for identifying posts in e-mail notifications and should be left blank in imported records. Note that there are 23 fields in total 
(counting starts at "0").</i></font><br><br>

<table cellpadding="3" cellspacing="0" border="0" bgcolor="#ffffff" align="center"><tr><td>
<table cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff"><tr>
<td><font size="3" face="Arial" color="#000000">00<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">01<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">02<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">03<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">04<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">05<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">06<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">07<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">08<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">09<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">10<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">11<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">12<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">13<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">14<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">15<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">16<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">17<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">18<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">19<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">20<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">21<font color="#ff0000">|</font></font></td>
<td><font size="3" face="Arial" color="#000000">22</font></td>
</tr></table>
</td></tr></table><br>

<table cellpadding="5" cellspacing="0" border="0" bgcolor="#ffffff" align="center"><tr><td>
<table cellpadding="0" cellspacing="0" border="0" bgcolor="#ffffff" align="center"><tr>
<td><font size="2" face="Arial" color="#000000"><b>&nbsp; Field &nbsp;</b></font></td>
<td><td><font size="2" face="Arial" color="#000000"><b>Description</b></font></td>
<td><font size="2" face="Arial" color="#000000"><b>&nbsp; Field &nbsp;</b></font></td>
<td><td><font size="2" face="Arial" color="#000000"><b>Description</b></font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">00</font></td>
<td><font size="2" face="Arial" color="#000000">Name or Handle</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">12</font></td>
<td><font size="2" face="Arial" color="#000000">Question 2</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">01</font></td>
<td><font size="2" face="Arial" color="#000000">Date of Post</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">13</font></td>
<td><font size="2" face="Arial" color="#000000">Question 3</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">02</font></td>
<td><font size="2" face="Arial" color="#000000">E-mail Address</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">14</font></td>
<td><font size="2" face="Arial" color="#000000">Answer 1</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">03</font></td>
<td><font size="2" face="Arial" color="#000000">Homepage Address</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">15</font></td>
<td><font size="2" face="Arial" color="#000000">Answer 2</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">04</font></td>
<td><font size="2" face="Arial" color="#000000">Homepage Title</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">16</font></td>
<td><font size="2" face="Arial" color="#000000">Answer 3</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">05</font></td>
<td><font size="2" face="Arial" color="#000000">ICQ Number/UIN</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">17</font></td>
<td><font size="2" face="Arial" color="#000000">Admin Comments</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">06</font></td>
<td><font size="2" face="Arial" color="#000000">How Found</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">18</font></td>
<td><font size="2" face="Arial" color="#000000">UID</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">07</font></td>
<td><font size="2" face="Arial" color="#000000">Location</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">19</font></td>
<td><font size="2" face="Arial" color="#000000">Future Expansion</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">08</font></td>
<td><font size="2" face="Arial" color="#000000">Comments</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">20</font></td>
<td><font size="2" face="Arial" color="#000000">Future Expansion</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">09</font></td>
<td><font size="2" face="Arial" color="#000000">IP Address</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">21</font></td>
<td><font size="2" face="Arial" color="#000000">Future Expansion</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">10</font></td>
<td><font size="2" face="Arial" color="#000000">Remote Host</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">22</font></td>
<td><font size="2" face="Arial" color="#000000">Future Expansion</font></td>
</tr><tr>

<td align="center"><font size="2" face="Arial" color="#000000">11</font></td>
<td><font size="2" face="Arial" color="#000000">Question 1</font></td>
<td align="center"><font size="2" face="Arial" color="#000000">&nbsp;</font></td>
<td><font size="2" face="Arial" color="#000000">&nbsp;</font></td>

</tr></table>
</td></tr></table>

</td></tr></table>
</td></tr></table><br>

<?

displayfooter("true");

exit;

} # End of function - Database Manager





/*
 * 
 * Function: Color Configuration
 *
 */

function colorconfiguration() {

global $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, $alinkcolor, $hovercolor, 
$backgroundimageurl, $guestbookbannerurl, $signguestbookurl1, $signguestbookurl2, $version, $confirm, $headertag;


?>
<html>
<head>
<title>Color/Graphics Selection</title>

<meta http-equiv="Content-Type" content="text/html">
<meta name="Description" content="HyperBook Guestbook">
<meta name="Keywords" content="guestbook PHP">
<meta name="Author" content="Thomas R. Pasawicz - webmaster@diamond-back.com">

<style type="text/css">
<!--
a:link        {text-decoration: none;}
a:active    {text-decoration: none;}
a:visited   {text-decoration: none;}
a:hover     {color:<? echo $hovercolor ?>; text-decoration: none;}
-->
</style>

<script language="JavaScript">
<!-- hide this script from non-javascript-enabled browsers
function popup(url){
  popupWindow = window.open(url, "littleWindow", "location=no,width=565,height=340,top=10,left=10"); 
                          window.open(url, "littleWindow", "location=no,width=565,height=340,top=10,left=10");
}
// stop hiding -->
</script>

</head>

<body bgcolor="#ffffff" background="<? echo $backgroundimageurl ?>" text="#000000" link="#3333ff" vlink="#3333ff"
alink="#ff0000">

<table width="600" cellspacing="0" cellpadding="0" align="center"><tr><td>

<? if ($headertag != "") { print "$headertag\n<br>\n"; } ?>

<? if ($confirm != "") { confirmmsg($confirm); } ?>

<table cellpadding="3" cellspacing="0" border="0" bgcolor="#757575" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="#e0e0e0" width="100%">
<tr><td bgcolor="#0066ff">
<font size="4" face="Arial" color="#ffffff"><b>Color/Graphics Selection</b><br></font>
<font size="2" face="Arial" color="#ffffff"><i>Select the colors and graphics you would like your guestbook displayed with.</i><br></font>
</td></tr><tr>
<td align="left">

<form action="admin.php" method="post">
<input type="hidden" name="action" value="updatecolorconfig">

<font size="2" face="Arial" color="#000000"><b>Guestbook Banner URL</b><br>
<i>This is an optional field to display a title banner graphic above the posts in your guestbook. If you leave this field blank, the name of your 
guestbook will be displayed in a bar in place of the graphic. You may specify a graphic anywhere on the Web by supplying a fully qualified URL 
such as "http://www.somedomain.com/graphicsfolder/bannergraphic.gif". You may also upload a graphic to the directory you created for your 
guestbook, in which case only the file name of the graphic is required (eg. "guestbookbanner.gif"). For best appearance, your banner graphic 
should be no wider than 600 pixels and in GIF or JPG format.</i><br></font>
<font size="3"><input type="text" name="new_guestbookbannerurl" value="<? echo $guestbookbannerurl ?>" size="66">
</font><br><br>

<font size="2" face="Arial" color="#000000"><b>Sign Guestbook Button URL</b><br>
<i>This is an optional field to display a "Sign the Guestbook" graphic button. If you leave this field blank, a text link inside a table will be 
displayed in it's place. You may specify a graphic anywhere on the Web by supplying a fully qualified URL such as 
"http://www.somedomain.com/graphicsfolder/buttongraphic.gif". You may also upload a graphic to the directory you created for your 
guestbook, in which case only the file name of the graphic is required (eg. "signguestbook.gif"). For best appearance, your button graphic 
should be about 200 pixels wide and in GIF or JPG format.</i><br></font>
<font size="3"><input type="text" name="new_signguestbookurl1" value="<? echo $signguestbookurl1 ?>" size="66">
</font><br><br>

<font size="2" face="Arial" color="#000000"><b>Sign Guestbook Button URL 2 (Mouseover)</b><br>
<i>If a second "Sign the Guestbook" graphic button is assigned, it will be used for the mouseover effect with the first button, ie. the first 
button will be displayed until the mouse pointer passes over it, at which time the second button will be displayed.</i><br></font>
<font size="3"><input type="text" name="new_signguestbookurl2" value="<? echo $signguestbookurl2 ?>" size="66">
</font><br><br>

<font size="2" face="Arial" color="#000000"><b>Guestbook Background Image URL</b><br>
<i>Similar to the Banner URL, this is a link to an optional background image. If no link is specified, the background color chosen below will be 
displayed.</i><br></font>
<font size="3"><input type="text" name="new_backgroundimageurl" value="<? echo $backgroundimageurl ?>" size="66">
</font><br><br>

<font size="2" face="Arial" color="#000000"><b>Color Selection</b><br>
<i>This section will allow you to select the colors your guestbook will be displayed with. Below the submit button is a preview of how a 
typical display box will appear. The body color is the background color, unless a background image was specified (see above). All text 
boxes have a thin border with a "title bar" at the top. The "table color" is the color of the text box beneath the bar. Table text color is used 
to specify the color of the text appearing inside the table, which includes all the text posted in the guestbook entries. The "bar text color" 
is displayed in the bar at the top of the text box. The remaining selections are for the four link states (unvisited, visited, active and hover). 
Note that the hover color is only used by MS Internet Explorer, it will have no effect with Netscape. Try to choose background and text 
colors that contrast, this will improve the look of your guestbook and make it easier to read. A color chart is provided in a pop-up window 
to aid in your color selection, see the link below the preview box. Note: only the colors of the preview box and background image will 
change on this page. This was done so  an accidental color change would not render this page unreadable.</i><br><br></font>
<table cellpadding="0" cellspacing="0" border="0" width="540" align="center">

<tr><td width="30">
<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $bodycolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Body Color</font><br>
<font size="3"><input type="text" name="new_bodycolor" value="<? echo $bodycolor ?>" size="8" maxlength="8"></font>

</td><td width="30">
<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $barcolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Bar Color</font><br>
<font size="3"><input type="text" name="new_barcolor" value="<? echo $barcolor ?>" size="8" maxlength="8"></font>

</td><td width="30">
<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $tablecolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Table Color</font><br>
<font size="3"><input type="text" name="new_tablecolor" value="<? echo $tablecolor ?>" size="8" maxlength="8"></font>

</td></tr><tr><td width="30">
<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $bordercolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Border Color</font><br>
<font size="3"><input type="text" name="new_bordercolor" value="<? echo $bordercolor ?>" size="8" maxlength="8"></font>

</td><td width="30">
<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $bartextcolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Bar Text Color</font><br>
<font size="3"><input type="text" name="new_bartextcolor" value="<? echo $bartextcolor ?>" size="8" maxlength="8"></font>

</td><td width="30">
<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $textcolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Table Text Color</font><br>
<font size="3"><input type="text" name="new_textcolor" value="<? echo $textcolor ?>" size="8" maxlength="8"></font>

</td></tr><tr><td width="30">
<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $linkcolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Link Color</font><br>
<font size="3"><input type="text" name="new_linkcolor" value="<? echo $linkcolor ?>" size="8" maxlength="8"></font>

</td><td width="30">
<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $vlinkcolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Visited Link Color</font><br>
<font size="3"><input type="text" name="new_vlinkcolor" value="<? echo $vlinkcolor ?>" size="8" maxlength="8"></font>

</td><td width="30">
<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $alinkcolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Active Link Color</font><br>
<font size="3"><input type="text" name="new_alinkcolor" value="<? echo $alinkcolor ?>" size="8" maxlength="8"></font>

</td></tr><tr><td width="30">
&nbsp;
</td><td width="150">
&nbsp;

</td></td><td width="30">

<table cellpadding="0" cellspacing="0" border="1" align="left" width="20" height="15"
bgcolor="<? echo $hovercolor ?>"><tr><td>&nbsp;</td></tr></table>
</td><td width="150">
<font size="2" face="Arial" color="#000000">Hover Color</font><br>
<font size="3"><input type="text" name="new_hovercolor" value="<? echo $hovercolor ?>" size="8" maxlength="8"></font>

</td><td width="30">
&nbsp;
</td><td width="150">
&nbsp;

</td></tr></table><br>

<center><input type="submit" value="Update Graphics and Colors"></center>
</form>

<font size="2" face="Arial" color="#000000"><b>&nbsp; &nbsp; &nbsp; Preview Box</b><br></font>
<table cellpadding="20" cellspacing="0" border="1" bgcolor="<? echo $bodycolor ?>" width="550" align="center">
<tr><td align="center">
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="500" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>" colspan="3">
<font size="3" face="Arial" color="<? echo $bartextcolor ?>"><b>Bar Text</b><br></font>
</td></tr>
<tr><td><font size="2" face="Arial" color="<? echo $textcolor ?>">Table Text <b>Bold Text</b></font></td>
<td><font size="2" face="Arial" color="<? echo $linkcolor ?>">Unvisted Link Color</font></td>
<td><font size="2" face="Arial" color="<? echo $vlinkcolor ?>">Visited Link Color</font></td></tr>
<tr><td><font size="2" face="Arial" color="<? echo $alinkcolor ?>">Active Link Color</font></td>
<td colspan="2"><font size="2" face="Arial"><a href="mailto:webmaster@diamond-back.com">Mouse over for Hover Color (MSIE only)</a></font>
</td></tr></table>
</td></tr></table>
</td></tr></table>


<center><br><b><a href="javascript:popup('colorchart.html')"><font size="3" face="Arial" color="#3333ff">Pop-up Color Chart</font>
</a></b></font></center>

</td></tr></table>
</td></tr></table><br>

<table cellpadding="2" cellspacing="0" border="0" bgcolor="#999999" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="#eaeaea" width="100%">
<tr><td align="center">

<font size="1" face="Arial">

<a href="admin.php"><font color="#3333ff">Main Menu</font></a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=logout"><font color="#3333ff">Admin Log Out</font></a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=display"><font color="#3333ff">Display/Edit/Delete Posts</font></a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=configure"><font color="#3333ff">Guestbook Configuration</font></a><br>

<a href="admin.php?action=dbconfigure"><font color="#3333ff">Database Manager</font></a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=colorconfigure"><font color="#3333ff">Color/Graphics Selection</font></a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=changepassword"><font color="#3333ff">Change Password</font></a>&nbsp;&#149;&nbsp;

<a href="admin.php?action=resetip"><font color="#3333ff">Reset IP Log</font></a>

</font>

<? displayexectime("#3333ff"); ?>

</td></tr></table>
</td></tr></table><br>

<table cellpadding="1" cellspacing="0" border="1" bgcolor="#eaeaea" align="center" width="600"><tr><td align="center">
<font size="1" face="Arial" color="#003399">
<i>HyperBook Guestbook <? echo $version ?></i> Copyright &copy; 2001 by 
<a href="mailto:webmaster@diamond-back.com">Thomas R. Pasawicz</a>. All rights reserved. &#149; 
<a href="http://diamond-back.com/software/guestbook/"><i>Click here for more info.</i></a>
</font></td></tr></table>

</td></tr></table>
<?

exit;

} # End of function - Color Configuration






/*
 * 
 * Function: Reset IP Log
 *
 */

function resetip() {

global $datapath;

$blank_ip = "0.0.0.0\n";
$filename = $datapath . 'ip_log.dat';

if ($fp = fopen($filename, 'w')) { # File opened for writing
	$lock = flock($fp, LOCK_EX);
	if ($lock) { # Lock achived
		for ($i = 0; $i <= 24; $i++) { fwrite( $fp, $blank_ip ); }
		flock($fp, LOCK_UN);
	} # End If - Lock achived
	fclose($fp);
} # End If - File opened for writing

} # End of function - Reset IP Log






/*
 * 
 * Function: Initial Set-up
 *
 */

function initialsetup($possibleadminurl, $possiblepath) {

global $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, $alinkcolor;

$possiblepath = str_replace("admin.php", "data/", $possiblepath);  # Corrected data path

$datapath = $possiblepath;
$adminurl = $possibleadminurl;

$bodycolor = "#cccccc";
$bordercolor = "#999999";
$tablecolor = "#eaeaea";
$barcolor = "#0066ff";
$textcolor = "#003399";
$bartextcolor = "#ffffff";
$linkcolor = "#3333ff";
$vlinkcolor = "#3333ff";
$alinkcolor = "#cc0000";
$hovercolor = "ff0000";

displayheader("Hyperbook Initial Set-up");

?>

<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Hyperbook Initial Set-up</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>Welcome to HyperBook. In a few minutes your guestbook will be set-up 
and ready to use.<br>The following information is required for proper function, please fill in all fields.</i><br></font>
</td></tr><tr>

<form action="admin.php" method="post">
<input type="hidden" name="action" value="setupdatadirectory">

<td align="left">

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Data Directory Pathway</b><br>
<i>This is the pathway on your server to the data directory. Note: this is NOT a URL. The admin program will attempt to determine this path for 
you. If a path is shown below, use it unless you know for certain that a different path is required. </i><br>
<? if ($possiblepath == "") { $possiblepath = "Could Not Be Determined"; } ?>
Possible path: <? echo $possiblepath ?> <br></font>
<font size="3"><input type="text" name="datapath" value="<? echo $datapath ?>" size="66"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Admin Program URL</b><br>
<i>This is the complete URL to the admin program. The admin program will attempt to determine this URL for you. 
If a URL is shown below, use it unless you know for certain that a different URL is required. </i><br>
<? if ($possibleadminurl == "") { $possibleadminurl = "Could Not Be Determined"; } ?>
Possible URL: <? echo $possibleadminurl ?> <br></font>
<font size="3"><input type="text" name="adminurl" value="<? echo $adminurl ?>" size="66"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Admin Password</b><br>
<i>This is the password you will use to access your guestbook administration program, be sure to choose a password you can remember 
but won't be easy for anyone else to guess.<br>
Note: To function properly, you must have your browser configured to accept cookies. </i></font><br>
<table cellpadding="0" cellspacing="0" border="0" width="580"><tr><td width="290">
<font size="2" face="Arial" color="<? echo $textcolor ?>">Admin password (min. 6 characters)<br></font>
<font size="3"><input type="password" name="adminpass" size="25" maxlength="14"></font>
</td><td width="290">
<font size="2" face="Arial" color="<? echo $textcolor ?>">Enter again for confirmation<br></font>
<font size="3"><input type="password" name="adminpass2" size="25" maxlength="14"></font>
</td></tr></table><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Guestbook Name</b><br>
<i>Your guestbook name will be displayed in the page title and in place of a banner graphic if you decide not to use one. </i></font><br>
<font size="3"><input type="text" name="guestbookname" size="66" maxlength="60"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Homepage Title</b><br>
<i>Your Homepage title will be displayed on links back to your main page.<br>
If you don't have a name for your website, you may simply use "Homepage". </i></font><br>
<font size="3"><input type="text" name="homepage_title" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Homepage URL</b><br>
<i>This is the full URL back to your homepage beginning with "http://".<br>
Examples: "http://mydomain.com" or "http://www.myhost.com/~mywebsite/index.html"</i></font><br>
<font size="3"><input type="text" name="homepage_url" value="http://" size="66"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><b>Webmaster E-mail</b><br>
<i>Please enter your e-mail address.</i></font><br>
<font size="3"><input type="text" name="webmaster_email" size="66" maxlength="100"></font><br><br>

<table cellpadding="8" cellspacing="0" border="2" bgcolor="#ffffff" align="center"><tr><td>
<font size="2" face="Arial" color="#ff0000">By clicking on the "Set-up Guestbook" button, I hereby agree to all terms<br>
and conditions of the HyperBook Guestbook 
<a href="http://diamond-back.com/software/guestbook/license.html" target="_blank">License Agreement</a>.
</td></tr></table><br>

<center><input type="submit" value="Set-up Guestbook"></center>
</form>

</td></tr></table>
</td></tr></table><br>

<?

displayfooter("false");

exit;

} # End of function - Initial Set-up




/*
 * 
 * Function: Set-up Data Directory
 *
 */

function setupdatadirectory() {

global $perpage, $totalrecords, $uidcounter, $perfile, $ipcheck, $addquestion1, $displayadd1, $addquestion2, $displayadd2, $addquestion3, 
$displayadd3, $displayuin, $displayemail, $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $linkcolor, $vlinkcolor, 
$alinkcolor, $hovercolor, $homepage_title, $homepage_url, $guestbookname, $guestbookbannerurl, $signguestbookurl1, $signguestbookurl2, 
$backgroundimageurl, $webmaster_email, $notifications, $notification_email, $welcome_msg, $thankyou_msg, $adminurl, $adminpass, 
$adminpass2, $cookieexpiration, $datapath, $newlogin, $loginpassword, $bannedwords, $foundoptions, $headertag;

$bodycolor = "#cccccc";
$bordercolor = "#999999";
$tablecolor = "#eaeaea";
$barcolor = "#0066ff";
$textcolor = "#003399";
$bartextcolor = "#ffffff";
$linkcolor = "#3333ff";
$vlinkcolor = "#3333ff";
$alinkcolor = "#cc0000";
$hovercolor = "ff0000";

/* Confirm data */

if ( $datapath == "" )
	{ errormsg("Initialization Error","Missing Data Directory Pathway, please click the back button and fill-in this field."); }

if ( $adminurl == "" )
	{ errormsg("Initialization Error","Missing Admin Program URL, please click the back button and fill-in this field."); }

if ( $adminpass != $adminpass2 )
	{ errormsg("Initialization Error","Admin Password doesn't match the Confirmation Password, please click the back button and try again."); }

if ( strlen($adminpass) < 6 )
	{ errormsg("Initialization Error","Admin Password must be at least 6 characters long, please click the back button and enter a longer password."); }

if ( $guestbookname == "" )
	{ errormsg("Initialization Error","Missing Guestbook Name, please click the back button and fill-in this field."); }

if ( $homepage_title == "" )
	{ errormsg("Initialization Error","Missing Homepage Title, please click the back button and fill-in this field."); }

if ( strtolower(substr($homepage_url, 0, 7)) != "http://" ) { $homepage_url = "http://" . $record_url; } # Add http tag to Homepage URL if it's missing.

if ( $homepage_url == "http://" )
	{ errormsg("Initialization Error","Missing Homepage URL, please click the back button and fill-in this field."); }

if ( $webmaster_email == "" )
	{ errormsg("Initialization Error","Missing Webmaster E-mail, please click the back button and fill-in this field."); }

if (checkmail($webmaster_email) != 1)
	{ errormsg("Initialization Error","The Webmaster e-mail address you entered does not appear to be valid. Please click the back button and 
	check the e-mail address for errors. Note: Spaces cannot be used in an e-mail address."); }


/* Initialize Data */

$totalrecords = "0";
$uidcounter = "0";
$perfile = "25";

$perpage = "10";
$ipcheck = "3";
$addquestion1 = "";
$displayadd1 = "false";
$addquestion2 = "";
$displayadd2 = "false";
$addquestion3 = "";
$displayadd3 = "false";
$displayuin = "true";
$displayemail = "true";
$bodycolor = "#cccccc";
$bordercolor = "#999999";
$tablecolor = "#eaeaea";
$barcolor = "#0066ff";
$textcolor = "#003399";
$bartextcolor = "#ffffff";
$linkcolor = "#3333ff";
$vlinkcolor = "#3333ff";
$alinkcolor = "#cc0000";
$hovercolor = "ff0000";
$guestbookbannerurl = "guestbook.jpg";
$signguestbookurl1 = "signup.jpg";
$signguestbookurl2 = "signdown.jpg";
$backgroundimageurl = "background.jpg";
$notifications = "false";
$notification_email = "";
$welcome_msg = "Please take a moment to sign our guestbook and tell us what you think of this website.";
$thankyou_msg = "Thank you for signing our guestbook, your opinions and encouragment are important to us.";
$cookieexpiration = "86400";
$bannedwords = "false";
$headertag = "";

$foundoptions[0] = "Linked from another site.";
$foundoptions[1] = "From a friend.";
$foundoptions[2] = "From a chatroom.";
$foundoptions[3] = "From a newsgroup.";
$foundoptions[4] = "Found using a search engine.";

$newlogin = "true";
$loginpassword = $adminpass;
$adminpass = md5 ($adminpass); # Encrypt password

update_dbconfiguration();
update_gbconfiguration();
resetip();

} # End of function - Set-up Data Directory






/*
 * 
 * Function: Program Registration
 *
 */

function registerprogram() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $webmaster_email, $homepage_title, $homepage_url;

displayheader("HyperBook Registration");

?>

<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>HyperBook Registration</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>
There is no requirement to register this program, but there are some advantages. By registering, you will be eligible to receive timely update 
notifications via e-mail and have your website linked from the HyperBook website. Your information will be kept confidential and you will only 
receive e-mails concerning this program. In the event of a serious bug or security breach being discovered, a critical update notification will be 
sent to all registered users advising them of the problem. While every effort has been made to test this software, changes to PHP, Apache or 
UNIX could introduce bugs that did not exist during development and testing. So please take a moment to register for this free service.<br><br>
Along with your form data, the registration e-mail will also send your HyperBook version number and server software version numbers (from the Apache "SERVER_SOFTWARE" Environment Variable, if present). This information is used so we can determine which version your are using and track the servers under which HyperBook has been successfully installed.<br><br>
Note: If your e-mail or URL change, please resubmit this form and include the former e-mail/URL in the comments section so 
our records can be updated.
</i><br></font>
</td></tr><tr>
<td align="left">

<form action="admin.php" method="post">
<input type="hidden" name="action" value="sendregistration">
<input type="hidden" name="reg_link" value="false">

<font size="2" face="Arial" color="<? echo $textcolor ?>">Webmaster's E-mail (required - this is where notifications will be sent): </font><br>
<font size="3"><input type="text" name="reg_email" value="<? echo $webmaster_email ?>" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Webmaster's Name (optional): </font><br>
<font size="3"><input type="text" name="reg_name" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Homepage Title (optional): </font><br>
<font size="3"><input type="text" name="reg_title" value="<? echo $homepage_title ?>" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Homepage URL (optional): </font><br>
<font size="3"><input type="text" name="reg_url" value="<? echo $homepage_url ?>" size="66"></font><br><br>

<input type="checkbox" name="reg_link" value="true" checked>
<font size="2" face="Arial" color="<? echo $textcolor ?>"> 
I would like to be linked from the Hyperbook website (requires a homepage URL).</font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Comments (optional):<br></font>
<font size="3"><textarea cols="68" rows="5" maxlenght="3000" name="reg_comments" wrap="virtual"></textarea></font><br><br>

<center><input type="submit" value="Send Registration"></center>
</form>

</td></tr></table>
</td></tr></table><br>

<?

displayfooter("true");

exit;

} # End of function - Program Registration





/*
 * 
 * Function: Send Registration E-mail
 *
 */

function sendregistration($email, $name, $title, $url, $link, $comments, $serverinfo) {

global $version;

if ( $email == "" ) { # Check for e-mail
	errormsg("Registration Submission Error","Missing Webmater's E-mail address.<br>
		Please click the back button and enter an e-mail address to complete your registration."); }
else {
	if (checkmail($email) != 1) { 
		errormsg("Registration Submission Error","The e-mail address you entered does not appear to be valid.<br>
		Please click the back button and check your e-mail address for errors. Note: Spaces cannot be used in an e-mail address."); }
} # End If - Check for e-mail

if ( $link == "true" AND $url == "") { # Check for link
		errormsg("Registration Submission Error","You have indicated that you would like to be linked from the HyperBook website but did not enter 
		a URL. Please click the back button and enter a link URL.");
} # End If - Check for link

$name = stripslashes($name);
$title = stripslashes($title);
$comments = stripslashes($comments);

$message = "HyperBook Registration

E-mail: $email
Name: $name
Title: $title
URL: $url
Link: $link
Version: $version
Server Info: $serverinfo
Comments: $comments
";

# Send e-mail
mail ("hyperbookregistration@diamond-back.com", "HyperBook Registration",$message,"From: $email");

} # End of function - Send Registration E-mail







/*
 * 
 * Function: Feedback Form
 *
 */

function feedbackform() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $webmaster_email, $homepage_title, $homepage_url;

displayheader("HyperBook Feedback Form");

?>

<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>HyperBook Feedback Form</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>
You are welcome to use this form to submit bug reports, offer suggestions or make general comments about the HyperBook software. Your 
opinions and reports are important to us... all feedback will be read and filed. We regret that personal tech support cannot be guaranteed, 
please read the included documentation before contacting us with your support questions. All questions will be answered as time permits. 
We hope you enjoy using this software and we will continue to develop it as long as there are webmasters interested in using it.<br><br>
Note: Along with your form data, the feedback e-mail will also send your HyperBook version number and server software version numbers (from the Apache "SERVER_SOFTWARE" Environment Variable, if present). This information is helpful when responding to tech support requests. It is also helpful if you have uploaded the "phpinfo.php" file to your guestbook directory so we can determine if there may be a configuration setting on your server which could cause problems with HyperBook.<br><br>
If for any reason you cannot contact us using this form, you may write directly to 
<a href="mailto:hyperbookfeedback@diamond-back.com" subject="HyperBook Feedback">
<font color="<? echo $bartextcolor ?>">hyperbookfeedback@diamond-back.com</font></a>.
</i><br></font>
</td></tr><tr>
<td align="left">

<form action="admin.php" method="post">
<input type="hidden" name="action" value="sendfeedback">

<font size="2" face="Arial" color="<? echo $textcolor ?>">Webmaster's E-mail (required for replies): </font><br>
<font size="3"><input type="text" name="fb_email" value="<? echo $webmaster_email ?>" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Webmaster's Name (optional): </font><br>
<font size="3"><input type="text" name="fb_name" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Homepage Title (optional): </font><br>
<font size="3"><input type="text" name="fb_title" value="<? echo $homepage_title ?>" size="66" maxlength="100"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Homepage URL (optional): </font><br>
<font size="3"><input type="text" name="fb_url" value="<? echo $homepage_url ?>" size="66"></font><br><br>

<font size="2" face="Arial" color="<? echo $textcolor ?>">Questions, reports or comments:<br></font>
<font size="3"><textarea cols="68" rows="5" maxlenght="3000" name="fb_comments" wrap="virtual"></textarea></font><br><br>

<center><input type="submit" value="Send Feedback"></center>
</form>

</td></tr></table>
</td></tr></table><br>

<?

displayfooter("true");

exit;

} # End of function - Feedback Form





/*
 * 
 * Function: Send Feedback
 *
 */

function sendfeedback($email, $name, $title, $url, $comments, $serverinfo) {

global $version;

if ( $email == "" ) { # Check for e-mail
	errormsg("Feedback Submission Error","Missing Webmater's E-mail address.<br>
		Please click the back button and enter an e-mail address to complete your feedback."); }
else {
	if (checkmail($email) != 1) { 
		errormsg("Feedback Submission Error","The e-mail address you entered does not appear to be valid.<br>
		Please click the back button and check your e-mail address for errors. Note: Spaces cannot be used in an e-mail address."); }
} # End If - Check for e-mail

if ( $comments == "") { # Check for comments
		errormsg("Feedback Submission Error","You haven't included any comments... not much point in sending feedback without saying anything.
		<br>Please click the back button and enter your comments.");
} # End If - Check for link

$name = stripslashes($name);
$title = stripslashes($title);
$comments = stripslashes($comments);

$message = "HyperBook Feedback

E-mail: $email
Name: $name
Title: $title
URL: $url
Version: $version
Server Info: $serverinfo
Comments: $comments
";

# Send e-mail
mail ("hyperbookfeedback@diamond-back.com", "HyperBook Feedback",$message,"From: $email");

} # End of function - Send Feedback





/*
 * 
 * Function: Sign Guestbook
 *
 */

function signguestbook() {

global $addquestion1, $displayadd1, $addquestion2, $displayadd2, $addquestion3, $displayadd3, $displayuin, $displayemail, 
$foundoptions, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $homepage_title, $homepage_url, $webmaster_email, 
$welcome_msg, $browser, $lang;

$halflength = "33"; if ($browser == "MSIE") { $halflength = "37"; } # Adjust input box length for IE
$fulllength = "70"; if ($browser == "MSIE") { $fulllength = "79"; } # Adjust input box length for IE

$new_name = ""; $record_name = ""; 
$new_date = ""; $record_date = ""; 
$new_email = ""; $record_email = ""; 
$new_url = ""; $record_url = ""; 
$new_website = ""; $record_website = ""; 
$new_icq = ""; $record_icq = ""; 
$new_found = ""; $record_found = ""; 
$new_location = ""; $record_location = ""; 
$new_comments = ""; $record_comments = ""; 
$new_ipaddress = ""; $record_ipaddress = ""; 
$new_remotehost = ""; $record_remotehost = ""; 
$new_question1 = $addquestion1; $record_question1 = ""; 
$new_question2 = $addquestion2; $record_question2 = ""; 
$new_question3 = $addquestion3; $record_question3 = ""; 
$new_answer1 = ""; $record_answer1 = ""; 
$new_answer2 = ""; $record_answer2 = ""; 
$new_answer3 = ""; $record_answer3 = ""; 
$new_adminmsg = ""; $record_adminmsg = ""; 

displayheader($lang[21]);

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">

<form action="admin.php" method="post">
<input type="hidden" name="action" value="preview">
<input type="hidden" name="new_question1" value="<? echo $new_question1 ?>">
<input type="hidden" name="new_question2" value="<? echo $new_question2 ?>">
<input type="hidden" name="new_question3" value="<? echo $new_question3 ?>">
<input type="hidden" name="new_answer1" value="">
<input type="hidden" name="new_answer2" value="">
<input type="hidden" name="new_answer3" value="">
<input type="hidden" name="new_icq" value="">

<tr><td bgcolor="<? echo $barcolor ?>" colspan="2">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b><? echo $lang[21] ?></b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i><? echo $welcome_msg ?><br>
<? if ($displayemail == "true") { # Display Webmaster's e-mail ?>
<br><? echo $lang[22] ?>: 
<a href="mailto:<? echo $webmaster_email ?>"><font color="<? echo $bartextcolor ?>"><? echo $webmaster_email ?></font></a>.
<? } # End If - Display Webmaster's e-mail ?>
</i></font>
</td></tr><tr><td>


<? include("input_template.php"); # Load Input form ?>


</td></tr><tr><td colspan="2" align="center">

<input type="submit" value="<? echo $lang[21] ?>">
</form>

</td></tr></table>
</td></tr></table><br>

<?

displayfooter("true");

exit;

} # End of function - Sign Guestbook






/*
 * 
 * Function: Preview
 *
 */

function preview ($record_data) {

global $ipcheck, $displayadd1, $displayadd2, $displayadd3, $displayuin,  $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, 
$homepage_title, $homepage_url, $webmaster_email, $notifications, $totalrecords, $lang;

$record_number = "TBA";

$data = explode("|", $record_data);

$record_name = stripslashes($data[0]);
$record_date = stripslashes($data[1]);
$record_email = stripslashes($data[2]);
$record_url = stripslashes($data[3]);
$record_website = stripslashes($data[4]);
$record_icq = stripslashes($data[5]);
$record_found = stripslashes($data[6]);
$record_location = stripslashes($data[7]);
$record_comments = stripslashes($data[8]);
$record_ipaddress = stripslashes($data[9]);
$record_remotehost = stripslashes($data[10]);
$record_question1 = stripslashes($data[11]);
$record_question2 = stripslashes($data[12]);
$record_question3 = stripslashes($data[13]);
$record_answer1 = stripslashes($data[14]);
$record_answer2 = stripslashes($data[15]);
$record_answer3 = stripslashes($data[16]);
$record_adminmsg = stripslashes($data[17]);

$breakchar = chr(13);
$linebreak = chr(13) . "\n";  # Linebreak & line feed characters.

$record_comments = str_replace($breakchar, "",$record_comments);  # Strip linebreaks.
$record_comments = str_replace("\n", "",$record_comments);  # Strip linefeeds.

$record_adminmsg = str_replace($breakchar, "",$record_adminmsg);  # Strip linebreaks.
$record_adminmsg = str_replace("\n", "",$record_adminmsg);  # Strip linefeeds.


/* Check for missing or incorrect data. */

if ( $record_name == "" ) { errormsg($lang[23],$lang[24]); }

if ( $record_email != "" ) { # Check for e-mail
	if (checkmail($record_email) != 1) { 
		errormsg($lang[23],$lang[25]); }
} # End If - Check for e-mail

if ( $record_comments == "" ) { errormsg($lang[23],$lang[26]); }

if ( $record_url != "" ) { # Check for URL
	if ( strtolower(substr($record_url, 0, 7)) != "http://" ) { $record_url = "http://" . $record_url; } # Add http tag to URL if it's missing.
	if ( strtolower(substr($record_url, 0, 14)) == "http://http://" ) { $record_url =  substr($record_url, 7); } # Remove "double" http://
} # End If - Check for URL


/* Check for double post */

if ($totalrecords > 0) { # - Check for double post
	$last_record = loadrecord($totalrecords);
	$last_data = explode("|", $last_record);

	if ( $data[0] == $last_data[0] AND $data[8] == $last_data[8] )
		{ errormsg($lang[23],"$lang[27] <a href=\"index.php\"><font color=\"$bartextcolor\"><b>$lang[28]</b></font></a>"); }
} # End If - Check for double post


displayheader($lang[29]);

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>" colspan="2">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b><? echo $lang[29] ?></b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i><? echo $lang[30] ?></i><br></font>
</td></tr></table>
</td></tr></table><br>

<?
include("display_template.php"); # Use template to display guestbook entry
$record_comments = str_replace("<br>",$linebreak, $record_comments);  # Convert <br> to linebreaks.
$record_adminmsg = str_replace("<br>",$linebreak, $record_adminmsg);  # Convert <br> to linebreaks.
?>

<br>
<form action="admin.php" method="post">
<input type="hidden" name="action" value="addpost">
<input type="hidden" name="new_name" value="<? echo $record_name ?>">
<input type="hidden" name="new_email" value="<? echo $record_email ?>">
<input type="hidden" name="new_website" value="<? echo $record_website ?>">
<input type="hidden" name="new_url" value="<? echo $record_url ?>">
<input type="hidden" name="new_icq" value="<? echo $record_icq ?>">
<input type="hidden" name="new_found" value="<? echo $record_found ?>">
<input type="hidden" name="new_location" value="<? echo $record_location ?>">
<input type="hidden" name="new_question1" value="<? echo $record_question1 ?>">
<input type="hidden" name="new_question2" value="<? echo $record_question2 ?>">
<input type="hidden" name="new_question3" value="<? echo $record_question3 ?>">
<input type="hidden" name="new_answer1" value="<? echo $record_answer1 ?>">
<input type="hidden" name="new_answer2" value="<? echo $record_answer2 ?>">
<input type="hidden" name="new_answer3" value="<? echo $record_answer3 ?>">
<input type="hidden" name="new_comments" value="<? echo $record_comments ?>">
<input type="hidden" name="new_adminmsg" value="<? echo $record_adminmsg ?>">

<center><input type="submit" value="<? echo $lang[31] ?>"></center>
</form>

<?

displayfooter("true");

exit;

} # End of function - Preview




/*
 * 
 * Function: Confirm Delete
 *
 */

function deleteconfirm($record,$page) {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor;

displayheader("Delete Confirmation");

$data = loadrecord($record);

$data = explode("|", $data);

$record_name = $data[0];

?>

<br>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Delete Confirmation</b><br></font>
</td></tr><tr><td align="center" valign="middle">

<font size="2"><br></font>
<font size="3" face="Arial" color="<? echo $textcolor ?>">
<b>Please confirm you wish to DELETE:</b><br><br>
<font size="4">Record #<? echo $record ?>: <? echo $record_name ?></font><br><br>
<b>from your guestbook.</b></font><br><br>

<table cellpadding="5" cellspacing="0" border="1"><tr>
<td bgcolor="#00bb00" width="100" align="center">
<a href="admin.php?action=deleteconfirmed&record=<? echo $record ?>&page=<? echo $page ?>">
<font size="2" face="Arial" color="#ffffff"><b>&nbsp; CONFIRM &nbsp;</b></font></a></td>

<td bgcolor="#ea0000" width="100" align="center">
<a href="admin.php?page=<? echo $page ?>&action=display">
<font size="2" face="Arial" color="#ffffff"><b>&nbsp; CANCEL &nbsp;</b></font></a></td>
</tr></table><br>

</td></tr></table>
</td></tr></table><br>
<?

displayfooter("false");

exit;

} # End of function - Confirm Delete




/*
 * 
 * Function: Clear Database Confirmation
 *
 */

function cleardatabaseconfirm() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor;

displayheader("Clear Database Confirmation");


?>

<br>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Clear Database Confirmation</b><br></font>
</td></tr><tr><td align="center" valign="middle">

<font size="2"><br></font>
<font size="3" face="Arial" color="<? echo $textcolor ?>">
<b>Please confirm you wish to:</b><br><br>
<font size="4">Clear (Delete) the Guestbook Database.</font><br><br>
<b><u>WARNING:</u></b><i> This action will permanently remove<br>
all posts from your guestbook and delete the data files.</i></font><br><br>

<table cellpadding="5" cellspacing="0" border="1"><tr>
<td bgcolor="#00bb00" width="100" align="center">
<a href="admin.php?action=clearconfirmed">
<font size="2" face="Arial" color="#ffffff"><b>&nbsp; CONFIRM &nbsp;</b></font></a></td>

<td bgcolor="#ea0000" width="100" align="center">
<a href="admin.php?action=dbconfigure">
<font size="2" face="Arial" color="#ffffff"><b>&nbsp; CANCEL &nbsp;</b></font></a></td>
</tr></table><br>

</td></tr></table>
</td></tr></table><br>
<?

displayfooter("false");

exit;

} # End of function - Clear Database Confirmation




/*
 * 
 * Function: Reset IP Log Confirmation
 *
 */

function cleariplogconfirm() {

global $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor;

displayheader("Reset IP Log Confirmation");


?>

<br>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Reset IP Log Confirmation</b><br></font>
</td></tr><tr><td align="center" valign="middle">

<font size="2"><br></font>
<font size="3" face="Arial" color="<? echo $textcolor ?>">
<b>Please confirm you wish to:</b><br><br>
<font size="4">Reset (Clear) the IP Log.</font><br><br>
<b><u>WARNING:</u></b><i> This action will clear all current IP Addresses from the IP Log.<br>
This log is used to prevent guestbook flooding (multiple posts).</i></font><br><br>

<table cellpadding="5" cellspacing="0" border="1"><tr>
<td bgcolor="#00bb00" width="100" align="center">
<a href="admin.php?action=cleariplogconfirmed">
<font size="2" face="Arial" color="#ffffff"><b>&nbsp; CONFIRM &nbsp;</b></font></a></td>

<td bgcolor="#ea0000" width="100" align="center">
<a href="admin.php">
<font size="2" face="Arial" color="#ffffff"><b>&nbsp; CANCEL &nbsp;</b></font></a></td>
</tr></table><br>

</td></tr></table>
</td></tr></table><br>
<?

displayfooter("false");

exit;

} # End of function - Clear IP Log Confirmation




/*
 * 
 * Function: Check for Updates
 *
 */

function updatecheck() {

global $bodycolor, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $version;

displayheader("Check for Version Updates");

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="#ffffff" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Check for Version Updates</b><br></font>
</td></tr><tr><td align="center">
<font size="3" face="Arial" color="#000000">You are running version: <b><? echo $version ?></b><br><br>
Version Status:<br></font><image src="http://diamond-back.com/software/guestbook/<? echo $version ?>.gif">
</td></tr><tr><td>
<font size="2" face="Arial" color="#000000"><b>Status Definitions:</b><br><br>
<font color="#10ac5c"><b>No Update Required</b></font>
<i> - You are running the most current version and do not need to update.</i><br><br>
<font color="#f49500"><b>Update Available</b></font>
<i> - There is a newer version of the program available but it is not necessary for you to update at this time. The newer version may contain 
enhanced features.</i><br><br>
<font color="#ff0000"><b>Update Recommended</b></font>
<i> - There is a version of the program containing error or security fixes, you should update as soon as possible!</i><br><br>
For more information on the most current version, please visit:<br>
<a href="http://diamond-back.com/software/guestbook/current.php">
<font color="#0000ff">http://diamond-back.com/software/guestbook/current.php</font></a></font>
</td></tr></table>
</td></tr></table><br>
<?

displayfooter("true");

exit;

} # End of function - Check for Updates




/*
 * 
 * Function: Edit Record
 *
 */

function editrecord($record_number, $record_data, $page) {

global $displayadd1, $displayadd2, $displayadd3, $displayuin, $foundoptions, 
$bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $browser, $totalrecords, $perpage, $lang;

$totalpages = intval(($totalrecords - 1) / $perpage) + 1;
$recordoffset = $totalrecords - $record_number;
$pageoffset = intval(($recordoffset) / $perpage);
$onpage = $totalpages - $pageoffset;

$linebreak = chr(13) . "\n";  # Linebreak & line feed characters.

$breakchar = chr(13);

$data = explode("|", $record_data);

$record_name = stripslashes($data[0]);
$record_date = stripslashes($data[1]);
$record_email = stripslashes($data[2]);
$record_url = stripslashes($data[3]);
$record_website = stripslashes($data[4]);
$record_icq = stripslashes($data[5]);
$record_found = stripslashes($data[6]);
$record_location = stripslashes($data[7]);
$record_comments = stripslashes($data[8]);
$record_ipaddress = stripslashes($data[9]);
$record_remotehost = stripslashes($data[10]);
$record_question1 = stripslashes($data[11]);
$record_question2 = stripslashes($data[12]);
$record_question3 = stripslashes($data[13]);
$record_answer1 = stripslashes($data[14]);
$record_answer2 = stripslashes($data[15]);
$record_answer3 = stripslashes($data[16]);
$record_adminmsg = stripslashes($data[17]);
$record_uid = stripslashes($data[18]);

$new_question1 = $record_question1;
$new_question2 = $record_question2;
$new_question3 = $record_question3;

$record_comments = str_replace($breakchar, "", $record_comments);  # Strip linebreaks.
$record_comments = str_replace("\n", "", $record_comments);  # Strip linefeeds.
$record_comments = str_replace("<br>",$linebreak, $record_comments);  # Convert <br> to linebreaks.

$record_adminmsg = str_replace($breakchar, "", $record_adminmsg);  # Strip linebreaks.
$record_adminmsg = str_replace("\n", "", $record_adminmsg);  # Strip linefeeds.
$record_adminmsg = str_replace("<br>",$linebreak, $record_adminmsg);  # Convert <br> to linebreaks.

$halflength = "33"; if ($browser == "MSIE") { $halflength = "37"; } # Adjust input box length for IE
$fulllength = "70"; if ($browser == "MSIE") { $fulllength = "79"; } # Adjust input box length for IE

displayheader("Edit Record");


?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">

<form action="admin.php" method="post">
<input type="hidden" name="action" value="update">
<input type="hidden" name="record" value="<? echo $record_number ?>">
<input type="hidden" name="new_ipaddress" value="<? echo $record_ipaddress ?>">
<input type="hidden" name="new_remotehost" value="<? echo $record_remotehost ?>">
<input type="hidden" name="new_question1" value="<? echo $record_question1 ?>">
<input type="hidden" name="new_question2" value="<? echo $record_question2 ?>">
<input type="hidden" name="new_question3" value="<? echo $record_question3 ?>">
<input type="hidden" name="new_uid" value="<? echo $record_uid ?>">
<input type="hidden" name="page" value="<? echo $page ?>">

<tr><td valign="top" bgcolor="<? echo $barcolor ?>">

<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><b>Record Number: <? echo $record_number ?> (on page <? echo $onpage ?>)</b> </font>

<font size="1" face="Arial" color="<? echo $bartextcolor ?>"><br>IP Address: <? echo $record_ipaddress ?> <br>
Remote Host: <? echo $record_remotehost ?> </font>

</td><td valign="top">

<font size="2" face="Arial" color="<? echo $textcolor ?>">Date:<br></font>
<font size="3"><input type="text" name="new_date" size="<? echo $halflength ?>" maxlength="30" value="<? echo $record_date ?>"></font>

</td></tr><tr><td>


<? include("input_template.php"); # Load Input form ?>


</td></tr><tr><td colspan="2">

<font size="2" face="Arial" color="<? echo $textcolor ?>">Guestbook Administrator's Comment:<br></font>
<font size="3">
<textarea cols="68" rows="10" maxlenght="3000" name="new_adminmsg" wrap="virtual"><? echo $record_adminmsg ?></textarea>
</font>

</td></tr><tr><td colspan="2" align="center">


<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" align="center"><tr>

<td><input type="submit" value="Update"></form></td>

<td><form action="admin.php" method="post">
<input type="hidden" name="action" value="delete">
<input type="hidden" name="record" value="<? echo $record_number ?>">
<input type="hidden" name="page" value="<? echo $page ?>">
<input type="submit" value="Delete"></form></td>

</tr></table>

</td></tr></table>
</td></tr></table><br>

<?

displayfooter("true");

exit;

} # End of function - Edit Record




/*
 * 
 * Function: Display Record
 *
 */

function displayrecord ($record_number,$record_data,$page) {

global $displayadd1, $displayadd2, $displayadd3, $displayuin, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $lang;

$data = explode("|", $record_data);

$record_name = stripslashes($data[0]);
$record_date = stripslashes($data[1]);
$record_email = stripslashes($data[2]);
$record_url = stripslashes($data[3]);
$record_website = stripslashes($data[4]);
$record_icq = stripslashes($data[5]);
$record_found = stripslashes($data[6]);
$record_location = stripslashes($data[7]);
$record_comments = stripslashes($data[8]);
$record_ipaddress = stripslashes($data[9]);
$record_remotehost = stripslashes($data[10]);
$record_question1 = stripslashes($data[11]);
$record_question2 = stripslashes($data[12]);
$record_question3 = stripslashes($data[13]);
$record_answer1 = stripslashes($data[14]);
$record_answer2 = stripslashes($data[15]);
$record_answer3 = stripslashes($data[16]);
$record_adminmsg = stripslashes($data[17]);

$breakchar = chr(13);
$record_adminmsg = str_replace($breakchar, "",$record_adminmsg);  # Strip linebreaks.
$record_adminmsg = str_replace("\n", "",$record_adminmsg);  # Strip linefeeds.

include("display_template.php"); # Use template to display guestbook entry

if ($record_ipaddress != "" OR $record_remotehost != "") { # Display IP and/or Host
?>
<table cellpadding="2" cellspacing="0" border="1" bgcolor="<? echo $tablecolor ?>" align="center"><tr><td align="center">
<font size="1" face="Arial" color="<? echo $textcolor ?>">
<?	if ($record_ipaddress != "") { print "IP Address: $record_ipaddress"; }
	if ($record_remotehost != "") { print " &nbsp; Remote Host: $record_remotehost"; } ?>
</font></td></tr></table>
<? } # End If - Display IP and/or Host ?>

<table cellpadding="2" cellspacing="0" border="1" bgcolor="<? echo $tablecolor ?>" align="center"><tr>
<td align="center" width="60"><font size="2" face="Arial">
<a href="admin.php?action=edit&record=<? echo $record_number ?>&page=<? echo $page ?>">&nbsp; edit &nbsp;</a></font></td>
<td align="center" width="60"><font size="2" face="Arial">
<a href="admin.php?action=delete&record=<? echo $record_number ?>&page=<? echo $page ?>">&nbsp; delete &nbsp;</a></font>
</td></tr></table><br><br>
<?

} # End of function - Display Record




/*
 * 
 * Function: Display Search Results
 *
 */

function displaymatches($recordsfound, $max_return, $searchkey) {

global $perpage, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $homepage_title, $homepage_url, $webmaster_email, 
$totalrecords;

$number_records = sizeof($recordsfound);

displayheader("Search Results");

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>" colspan="2">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Search Results</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>">
<i>Search Key: <? echo $searchkey ?></i><br>
<i>Matches Found: <? echo $number_records ?> (Maximum records to be returned: <? echo $max_return ?>)</i><br></font>
</td></tr></table>
</td></tr></table><br>
<?

$page = "0";

for ($i = 0;$i < $number_records;$i++) { # Display all found records

	$record_number = $recordsfound[$i];
	$record_data = loadrecord($record_number);
	displayrecord($record_number,$record_data,$page);

} # End For Loop - Display all found records


displayfooter("true");

exit;

} # End of function - Display Search Results



/*
 * 
 * Function: Display Page
 *
 */

function displaypage($page) {

global $perpage, $totalrecords;

/* Calculate range of records on this page. */

if ($totalrecords == 0) { $totalpages = 0; }
else { $totalpages = intval(($totalrecords - 1) / $perpage) + 1; } # Calculate how many pages there are.

$end = $totalrecords - (($totalpages - $page) * $perpage);
$start = $end - ($perpage - 1); if ($start < 1) { $start = 1; }

$records = loadrange($start,$end);

$recordindex = sizeof($records);
for ($i = $end;$i >= $start;$i--) { displayrecord($i,$records[$recordindex],$page); $recordindex--; }

} # End of function - Display Page





/*
 * 
 * Function: Display Posts for Editing
 *
 */

function displayposts($page) {

global $totalrecords, $perpage, $bordercolor, $tablecolor, $barcolor, $textcolor, $bartextcolor, $guestbookname, $homepage_title, 
$guestbookbannerurl, $signguestbookurl1, $signguestbookurl2, $homepage_url, $webmaster_email, $totalrecords, $confirm, $lang;


if ($totalrecords == 0) { $totalpages = 0; }
else { $totalpages = intval(($totalrecords - 1) / $perpage) + 1; } # Calculate how many pages there are.

if ($page == "" OR $page > $totalpages) { $page =  $totalpages; }

$currentpage = $page;

displayheader("$guestbookname");

if ($guestbookbannerurl != "") { print "<image src=\"$guestbookbannerurl\"><br><br>\n"; } # Display banner or text
else {	print "<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\" bgcolor=\"$bordercolor\" width=\"600\" align=\"center\"><tr><td>\n";
		print "<table cellpadding=\"5\" cellspacing=\"0\" border=\"0\" bgcolor=\"$barcolor\" width=\"100%\"><tr>\n";
		print "<td bgcolor=\"$barcolor\" align=\"center\"><font size=\"6\" face=\"Arial\" color=\"$bartextcolor\"><b>$guestbookname</b></font>\n";
		print "</td></tr></table></td></tr></table><br>\n";
} # End If - Display banner or text

if ($confirm != "") { confirmmsg($confirm); }

?>
<table cellpadding="3" cellspacing="0" border="2" bgcolor="<? echo $bordercolor ?>" width="600"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%"><tr><td>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><? echo $totalrecords ?> <? echo $lang[32] ?>.</font>

</td><td>

<font size="2" face="Arial" color="<? echo $textcolor ?>">
<? echo $lang[33] ?> <? echo $currentpage ?> <? echo $lang[34] ?> <? echo $totalpages ?>.</font>

</td><td>
<? if ($currentpage < $totalpages) { ?>
<table cellpadding="1" cellspacing="0" border="1"><tr><td>
<a href="admin.php?page=<? echo $currentpage + 1 ?>&action=display">
<font size="2" face="Arial" color="<? echo $textcolor ?>"><font face="Wingdings">
&ccedil;</font> <? echo $lang[35] ?></font></a></td></tr></table>
</td><td>
<? }
	if ($currentpage > 1) { ?>
<table cellpadding="1" cellspacing="0" border="1"><tr><td>
<a href="admin.php?page=<? echo $currentpage - 1 ?>&action=display"">
<font size="2" face="Arial" color="<? echo $textcolor ?>">
<? echo $lang[36] ?> <font face="Wingdings">&egrave;</font></font></a></td></tr></table>
</td><td>
<? } ?>

<form action="admin.php" method="post">
<input type="hidden" name="action" value="display">
<font size="2" face="Arial" color="<? echo $textcolor ?>"><? echo $lang[37] ?>: </font>
<font size="2"><input type="text" name="page" size="6" maxlength="6">
<input type="submit" value="<? echo $lang[38] ?>"></font>

</td></tr></table>
</td></tr></table>

</form>

<? if ($signguestbookurl1 != "" AND $signguestbookurl2 != "") { # Use mouseover ?>
<center><a href="admin.php?action=sign" onMouseOver="iName='image1' ; Ichange('changed1') ; window.status='<? echo $lang[21] ?>';return true" 
onMouseOut="Ichange('default1') ; window.status='';return true">
<image src="<? echo $signguestbookurl1 ?>" name="image1" border="0"></a></center>

<? } elseif ($signguestbookurl1 != "") { # Use single graphic ?>
<center><a href="admin.php?action=sign"><image src="<? echo $signguestbookurl1 ?>" border="0"></a></center>

<? } else { # Use text link ?>
<table cellpadding="2" cellspacing="0" border="1" bgcolor="<? echo $tablecolor ?>" align="center"><tr><td align="center">
<font size="3" face="Arial" color="<? echo $textcolor ?>"><a href="admin.php?action=sign">&nbsp;- <? echo $lang[21] ?> -&nbsp;</a>
</font></td></tr></table>
<? } ?>
<br>

<? if ($totalpages == 0) { # No records have been entered. ?>
<table cellpadding="2" cellspacing="0" border="1" bgcolor="<? echo $tablecolor ?>" align="center"><tr><td align="center">
<font size="3" face="Arial" color="<? echo $textcolor ?>"><b><i> <? echo $lang[39] ?> </i></b></font></td></tr></table><br>
<? } else { displaypage ($page); } ?>


<table cellpadding="3" cellspacing="0" border="2" bgcolor="<? echo $bordercolor ?>" width="600"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%"><tr><td>

<font size="2" face="Arial" color="<? echo $textcolor ?>"><? echo $totalrecords ?> <? echo $lang[32] ?>.</font>

</td><td>

<font size="2" face="Arial" color="<? echo $textcolor ?>">
<? echo $lang[33] ?> <? echo $currentpage ?> <? echo $lang[34] ?> <? echo $totalpages ?>.</font>

</td><td>
<? if ($currentpage < $totalpages) { ?>
<table cellpadding="1" cellspacing="0" border="1"><tr><td>
<a href="admin.php?page=<? echo $currentpage + 1 ?>&action=display">
<font size="2" face="Arial" color="<? echo $textcolor ?>"><font face="Wingdings">
&ccedil;</font> <? echo $lang[35] ?></font></a></td></tr></table>
</td><td>
<? }
	if ($currentpage > 1) { ?>
<table cellpadding="1" cellspacing="0" border="1"><tr><td>
<a href="admin.php?page=<? echo $currentpage - 1 ?>&action=display"">
<font size="2" face="Arial" color="<? echo $textcolor ?>">
<? echo $lang[36] ?> <font face="Wingdings">&egrave;</font></font></a></td></tr></table>
</td><td>
<? } ?>

<form action="admin.php" method="post">
<input type="hidden" name="action" value="display">
<font size="2" face="Arial" color="<? echo $textcolor ?>"><? echo $lang[37] ?>: </font>
<font size="2"><input type="text" name="page" size="6" maxlength="6">
<input type="submit" value="<? echo $lang[38] ?>"></font>

</td></tr></table>
</td></tr></table>

</form>

<?

displayfooter("true");

exit;

} # End of function - Display Posts for Editing




/*
 * 
 * Function: Page Shift
 *
 */

function pageshift ($page) {

global $perpage, $totalrecords;

$pageshift = "false";

if ($totalrecords != 0) {
	$totalpagesnow = intval(($totalrecords - 1) / $perpage) + 1; # Calculate how many pages there are now.
	$totalpagesbefore = intval(($totalrecords) / $perpage) + 1; # Calculate how many pages there were before record was deleted.
	if ($totalpagesnow < $totalpagesbefore AND $page != 1) { $pageshift = "true"; }
}

if ($pageshift == "true") { return $page - 1; } else { return $page; }

} # End of function - Page Shift




/******************************************************************************
 * MAIN PROGRAM
 *****************************************************************************/

/* Turn on verbose error reporting (15) to see all warnings and errors - ONLY USED FOR TESTING, normally commented out. */
# error_reporting(15);

$version = "v1.12";

while(list($key, $value) = each($HTTP_GET_VARS)) { $$key = $value; } # Read in GET vars in case register_globals is turned off.
while(list($key, $value) = each($HTTP_POST_VARS)) { $$key = $value; } # Read in POST vars in case register_globals is turned off.
while(list($key, $value) = each($HTTP_COOKIE_VARS)) { $$key = $value; } # Read in GET vars in case register_globals is turned off.

$scriptstarttime = microtime();
$availabletime = ini_get("max_execution_time");


/* Cook raw data */

if (!isset($action)) { $action = ""; }
$action = cook($action);

if (!isset($page)) { $page = ""; }
$page = cook($page);

if (!isset($record)) { $record = ""; }
$record = cook($record);

if (!isset($uid)) { $uid = ""; }
$uid = cook($uid);

if (!isset($hyperbookpassword)) { $hyperbookpassword = ""; }
$hyperbookpassword = cook($hyperbookpassword);

if (!isset($loginpassword)) { $loginpassword = ""; }
$loginpassword = cook($loginpassword);

if (!isset($newlogin)) { $newlogin = ""; }
$newlogin = cook($newlogin);

$confirm = "";


/* Check HTTP Server Vars */

$supported_keys = array_keys($HTTP_SERVER_VARS);
$possibleadminurl = ""; if (in_array("SCRIPT_URI", $supported_keys)) { $possibleadminurl = $HTTP_SERVER_VARS["SCRIPT_URI"]; }
$possiblepath = ""; if (in_array("SCRIPT_FILENAME", $supported_keys)) { $possiblepath = $HTTP_SERVER_VARS["SCRIPT_FILENAME"]; }
if ($possiblepath == "" AND in_array("PATH_TRANSLATED", $supported_keys)) { $possiblepath = $HTTP_SERVER_VARS["PATH_TRANSLATED"]; }
$serverinfo = ""; if (in_array("SERVER_SOFTWARE", $supported_keys)) { $serverinfo = $HTTP_SERVER_VARS["SERVER_SOFTWARE"]; }

$useragent = ""; if (in_array("HTTP_USER_AGENT", $supported_keys)) { $useragent = $HTTP_SERVER_VARS["HTTP_USER_AGENT"]; }
$browser = "Netscape"; if ( strpos($useragent, "MSIE") ) { $browser = "MSIE"; } # Determine browser type



/* Check for first run */

clearstatcache();
if ( !file_exists("data/dbconfiguration.dat")) { # Check for DB Configuration file
	if ($action == "setupdatadirectory") { # Initialize Configuration files
		setupdatadirectory();
		$confirm = "Congratulations! Your guestbook has been successfully set-up. You may now access the Guestbook Configuration and 
		Color/Graphic Selection to customized the way your guestbook looks and functions. Also, please be certain to register your guestbook 
		so you can be informed of new features or critical updates.<br><br>
		Thank you for trying HyperBook, we hope you and your guests will enjoy using it.";
		$action = ""; }
	else { # Prompt for intial data
		initialsetup($possibleadminurl, $possiblepath); }
} # End If - Check for DB Configuration file


load_dbconfiguration(); # Load database parameters
load_gbconfiguration(); # Load guestbook parameters
$lang = load_language("language.conf"); # Load language configuration file


$addquestion1 = stripslashes($addquestion1);
$addquestion2 = stripslashes($addquestion2);
$addquestion3 = stripslashes($addquestion3);
$homepage_title = stripslashes($homepage_title);
$guestbookname = stripslashes($guestbookname);
$welcome_msg = stripslashes($welcome_msg);
$thankyou_msg = stripslashes($thankyou_msg);
$headertag = stripslashes($headertag);


/* Security Checkpoint */

if ( md5 ($hyperbookpassword) != $adminpass AND md5 ($loginpassword) != $adminpass) { login(); }

if ($newlogin == "true") { setcookie("hyperbookpassword", "$loginpassword", time() + $cookieexpiration); }

if ($action == "logout") { logout(); }



/* Actions */

if ($action == "configure") { configuration($possibleadminurl); }

if ($action == "updateconfig") {
	$guestbookname = $new_guestbookname;
	$homepage_title = $new_homepage_title;
	$homepage_url = $new_homepage_url;
	$webmaster_email = $new_webmaster_email;
	$adminurl = $new_adminurl;
	$notifications = $new_notifications;
	$notification_email = $new_notification_email;
	$ipcheck = $new_ipcheck;
	$perpage = $new_perpage;
	$addquestion1 = $new_addquestion1;
	$displayadd1 = $new_displayadd1;
	$addquestion2 = $new_addquestion2;
	$displayadd2 = $new_displayadd2;
	$addquestion3 = $new_addquestion3;
	$displayadd3 = $new_displayadd3;
	$displayuin = $new_displayuin;
	$displayemail = $new_displayemail;
	$welcome_msg = $new_welcome_msg;
	$thankyou_msg = $new_thankyou_msg;
	$cookieexpiration = $new_cookieexpiration;
	$bannedwords = $new_bannedwords;
	$headertag = stripslashes($new_headertag);

	$break = chr(13) . "\n";  # Linebreak & line feed characters.
	$foundoptions = explode($break, $new_foundoptions);

	configurationcheck();
	update_gbconfiguration();
	$action = "";
	$confirm = "Guestbook Configuration file has been updated.";
	}

if ($action == "colorconfigure") { colorconfiguration(); }

if ($action == "updatecolorconfig") {
	$bodycolor = $new_bodycolor; if (substr($bodycolor, 0, 1) != "#" AND $bodycolor != "") { $bodycolor = "#" . $bodycolor; }
	$bordercolor = $new_bordercolor; if (substr($bordercolor, 0, 1) != "#" AND $bordercolor != "") { $bordercolor = "#" . $bordercolor; }
	$tablecolor = $new_tablecolor; if (substr($tablecolor, 0, 1) != "#" AND $tablecolor != "") { $tablecolor = "#" . $tablecolor; }
	$barcolor = $new_barcolor; if (substr($barcolor, 0, 1) != "#" AND $barcolor != "") { $barcolor = "#" . $barcolor; }
	$textcolor = $new_textcolor; if (substr($textcolor, 0, 1) != "#" AND $textcolor != "") { $textcolor = "#" . $textcolor; }
	$bartextcolor = $new_bartextcolor; if (substr($bartextcolor, 0, 1) != "#" AND $bartextcolor != "") { $bartextcolor = "#" . $bartextcolor; }
	$linkcolor = $new_linkcolor; if (substr($linkcolor, 0, 1) != "#" AND $linkcolor != "") { $linkcolor = "#" . $linkcolor; }
	$vlinkcolor = $new_vlinkcolor; if (substr($vlinkcolor, 0, 1) != "#" AND $vlinkcolor != "") { $vlinkcolor = "#" . $vlinkcolor; }
	$alinkcolor = $new_alinkcolor; if (substr($alinkcolor, 0, 1) != "#" AND $alinkcolor != "") { $alinkcolor = "#" . $alinkcolor; }
	$hovercolor = $new_hovercolor; if (substr($hovercolor, 0, 1) == "#") { $hovercolor = substr($hovercolor, 1); }
	$backgroundimageurl = $new_backgroundimageurl;
	$guestbookbannerurl = $new_guestbookbannerurl;
	$signguestbookurl1 = $new_signguestbookurl1;
	$signguestbookurl2 = $new_signguestbookurl2;
	update_gbconfiguration();
	$confirm = "Color/Graphic Configuration has been updated.";
	colorconfiguration();
	}

if ($action == "checkdb") { dbintegritycheck(); } # Check Database

if ($action == "cleardatabase") { cleardatabaseconfirm(); } # Get confirmation

if ($action == "clearconfirmed") {  # Clear Database
	cleardatabase();
	$confirm = "The Database has been cleared (deleted).";
	$action = "dbconfigure"; # Drop back into the Database Manager
	} # End If - Clear Database

if ($action == "dbconfigure") { dbconfiguration($possiblepath); }

if ($action == "updatedbconfig") { # Update Database Configuration
	$datapath = $new_datapath;
	$perfile = $new_perfile;
	update_dbconfiguration();
	$confirm = "Database configuration has been updated.";
	$action = "";
	} # End If - Update Database Configuration

if ($action == "updatepassword") { # Update Password
	updatepassword($new_adminpass,$new2_adminpass);
	$confirm = "The Administrative Password has been changed.";
	$action = ""; } # End If - Update Password

if ($action == "changepassword") { changepassword(); }


if ($action == "preview") { # Preview
	if (!isset($new_answer1)) { $new_answer1 = ""; }
	if (!isset($new_answer2)) { $new_answer2 = ""; }
	if (!isset($new_answer3)) { $new_answer3 = ""; }
	if (!isset($new_icq)) { $new_icq = ""; }
	if (!isset($new_ipaddress)) { $new_ipaddress = ""; }
	if (!isset($new_remotehost)) { $new_remotehost = ""; }
	if (!isset($new_adminmsg)) { $new_adminmsg = ""; }
	$new_date = date("F j, Y, g:i a");
	$data[0] = wordbreak(strip_tags($new_name), 25);
	$data[1] = strip_tags($new_date);
	$data[2] = strip_tags($new_email);
	$data[3] = strip_tags($new_url);
	$data[4] = wordbreak(strip_tags($new_website), 25);
	$data[5] = strip_tags($new_icq);
	$data[6] = wordbreak(strip_tags($new_found1), 25);
	if ($new_found2 != "") { $data[6] = wordbreak(strip_tags($new_found2), 25); }
	$data[7] = wordbreak(strip_tags($new_location), 25);
	$data[8] = wordbreak(strip_tags($new_comments), 44);
	$data[9] = $new_ipaddress;
	$data[10] = $new_remotehost;
	$data[11] = wordbreak($new_question1, 44);
	$data[12] = wordbreak($new_question2, 44);
	$data[13] = wordbreak($new_question3, 44);
	$data[14] = wordbreak(strip_tags($new_answer1), 44);
	$data[15] = wordbreak(strip_tags($new_answer2), 44);
	$data[16] = wordbreak(strip_tags($new_answer3), 44);
	$data[17] = strip_tags($new_adminmsg);
	$thisrecord = recordformat($data);
	preview($thisrecord);
	} # End If - Preview


if ($action == "addpost") { # Add New Post
	if (!isset($new_answer1)) { $new_answer1 = ""; }
	if (!isset($new_answer2)) { $new_answer2 = ""; }
	if (!isset($new_answer3)) { $new_answer3 = ""; }
	if (!isset($new_icq)) { $new_icq = ""; }
	$new_date = date("F j, Y, g:i a");
       if(getenv("HTTP_X_FORWARDED_FOR")){ 
		$new_ipaddress = getenv("HTTP_X_FORWARDED_FOR"); } 
  	else{ $new_ipaddress = getenv("REMOTE_ADDR"); } 
	$new_remotehost = gethostbyaddr($new_ipaddress);
	$uidcounter++;
	$new_uid = $uidcounter;
	$data[0] = $new_name;
	$data[1] = $new_date;
	$data[2] = $new_email;
	$data[3] = $new_url;
	$data[4] = $new_website;
	$data[5] = $new_icq;
	$data[6] = $new_found;
	$data[7] = $new_location;
	$data[8] = $new_comments;
	$data[9] = $new_ipaddress;
	$data[10] = $new_remotehost;
	$data[11] = $new_question1;
	$data[12] = $new_question2;
	$data[13] = $new_question3;
	$data[14] = $new_answer1;
	$data[15] = $new_answer2;
	$data[16] = $new_answer3;
	$data[17] = $new_adminmsg;
	$data[18] = $new_uid;
	$data[19] = ""; # Scrach field for future expansion
	$data[20] = ""; # Scrach field for future expansion
	$data[21] = ""; # Scrach field for future expansion
	$data[22] = ""; # Scrach field for future expansion
	$thisrecord = recordformat($data);
	$recordnumber = addrecord($thisrecord);
	$confirm = "Post has been added to guestbook.";
	$action = "display";
	$page = "";
	} # End If - Add New Post


if ($action == "delete") { deleteconfirm($record,$page); }


if ($action == "deleteconfirmed") { # Delete a record
	delete($record);
	if ($page != "0") {
		$page = pageshift($page);
		$action = "display"; } else { $action = ""; }
	$confirm = "Post has been deleted.";
	} # End If - Delete a record


if ($action == "sign") { signguestbook(); }


if ($action == "uidsearch") { # Do a UID Search
	$uid = trim($uid);
	$record = searchdatabase($uid,"18");  # Search for matching UID in field 18
	if ($record == 0) { $confirm = "No match for UID $uid was found."; $action = ""; } # No match found, drop into main menu.
	else { $action = "edit"; } # Match found, drop into record editor.
	} # End If - Do a UID Search


if ($action == "namesearch") { # Do a name search
	$uid = trim($uid);
	$max_return = 25;
	$recordsfound = searchdatabaseall($uid,"0",$max_return);  # Search for matching names in field 0, return first 10 hits.

	if ($recordsfound == 0) { $confirm = "No match for $uid was found."; $action = ""; } # No match found, drop into main menu.
	else { # At least one match was found.
		$number_records = sizeof($recordsfound);
		if ($number_records == 1) { $record = $recordsfound[0]; $action = "edit"; } # One record found, drop directly into editor.
		else { displaymatches($recordsfound,$max_return,$uid); } # Display all matches.
	} # End If - No match found
	} # End If - Do a name search


if ($action == "edit") { # Edit a record
	$data = loadrecord($record);
	editrecord($record,$data,$page);
	} # End If - Edit a record


if ($action == "update") { # Update a record
	if (!isset($new_answer1)) { $new_answer1 = ""; }
	if (!isset($new_answer2)) { $new_answer2 = ""; }
	if (!isset($new_answer3)) { $new_answer3 = ""; }
	if (!isset($new_icq)) { $new_icq = ""; }
	$data[0] = wordbreak(strip_tags($new_name), 25);
	$data[1] = strip_tags($new_date);
	$data[2] = strip_tags($new_email);
	$data[3] = strip_tags($new_url);
	$data[4] = wordbreak(strip_tags($new_website), 25);
	$data[5] = strip_tags($new_icq);
	$data[6] = wordbreak(strip_tags($new_found2), 25);
	if ($new_found2 == "") { $data[6] = wordbreak(strip_tags($new_found1), 25); }
	$data[7] = wordbreak(strip_tags($new_location), 25);
	$data[8] = wordbreak(strip_tags($new_comments), 44);
	$data[9] = $new_ipaddress;
	$data[10] = $new_remotehost;
	$data[11] = wordbreak($new_question1, 44);
	$data[12] = wordbreak($new_question2, 44);
	$data[13] = wordbreak($new_question3, 44);
	$data[14] = wordbreak(strip_tags($new_answer1), 44);
	$data[15] = wordbreak(strip_tags($new_answer2), 44);
	$data[16] = wordbreak(strip_tags($new_answer3), 44);
	$data[17] = strip_tags($new_adminmsg);
	$data[18] = $new_uid;
	$data[19] = ""; # Scrach field for future expansion
	$data[20] = ""; # Scrach field for future expansion
	$data[21] = ""; # Scrach field for future expansion
	$data[22] = ""; # Scrach field for future expansion
	$newdata = recordformat($data);
	updaterecord($record,$newdata);
	$confirm = "Post has been updated.";
	$action = "display";
} # End If - Update a record

if ($page == "0") { $action = ""; }
if ($action == "display") { displayposts($page); } # Display Posts for Editing


if ($action == "resetip") { cleariplogconfirm(); }

if ($action == "cleariplogconfirmed") { # Reset IP Log
	resetip();
	$confirm = "IP Address Log has been reset.";
	} # End If - Reset IP Log

if ($action == "updatecheck") { updatecheck(); } # Check for updates

if ($action == "exportdatabase") { # Export Database
	exportdatabase();
	$confirm = "Export Database: All records have been saved to file \"records.dat\" in the data directory.";
	} # End If - Export Database

if ($action == "importdatabase") { # Import Database
	$number_imported = importdatabase();
	$confirm = "Import Database: $number_imported records imported.";
	} # End If - Import Database


if ($action == "register") { registerprogram(); } # Register Program

if ($action == "sendregistration") {  # Send registration e-mail
	sendregistration($reg_email, $reg_name, $reg_title, $reg_url, $reg_link, $reg_comments, $serverinfo);
	$confirm = "HyperBook registration has been sent... thank you.";
	} # End If - Register Program


if ($action == "feedback") { feedbackform(); } # Display Feedback Form

if ($action == "sendfeedback") {  # Send feedback e-mail
	sendfeedback($fb_email, $fb_name, $fb_title, $fb_url, $fb_comments, $serverinfo);
	$confirm = "Feedback has been sent... thank you.";
	} # End If - Display Feedback Form


/*
 * 
 * Default Action: Display Admin Menu
 *
 */

displayheader("Guestbook Administration");

if ($confirm != "") { confirmmsg($confirm); }

?>
<table cellpadding="3" cellspacing="0" border="0" bgcolor="<? echo $bordercolor ?>" width="600" align="center"><tr><td>
<table cellpadding="5" cellspacing="0" border="0" bgcolor="<? echo $tablecolor ?>" width="100%">
<tr><td bgcolor="<? echo $barcolor ?>">
<font size="4" face="Arial" color="<? echo $bartextcolor ?>"><b>Guestbook Administration</b><br></font>
<font size="2" face="Arial" color="<? echo $bartextcolor ?>"><i>The following functions will allow you to administrate your guestbook.</i><br></font>
</td></tr><tr><td valign="top" align="center">

<table cellpadding="5" cellspacing="2" border="2" bgcolor="<? echo $tablecolor ?>" align="left" height="225"><tr>

<td align="center"><font size="3" face="Arial" ><a href="admin.php?action=display">Display/Edit/Delete Posts</a></font></td>

<td align="center"><font size="3" face="Arial"><a href="admin.php?action=logout">Admin Log Out</a></font></td>

</tr><tr>

<td align="center"><font size="3" face="Arial"><a href="admin.php?action=configure">Guestbook Configuration</a></font></td>

<td align="center"><font size="3" face="Arial"><a href="admin.php?action=dbconfigure">Database Manager</a></font></td>

</tr><tr>

<td align="center"><font size="3" face="Arial"><a href="admin.php?action=colorconfigure">Color/Graphic Selection</a></font></td>

<td align="center"><font size="3" face="Arial"><a href="admin.php?action=changepassword">Change Password</a></font></td>

</tr><tr>

<td align="center"><font size="3" face="Arial"><a href="admin.php?action=resetip">Reset IP Address Log</a></font></td>

<td align="center"><font size="3" face="Arial"><a href="admin.php?action=updatecheck">Check for Version Updates</a></font></td>

</tr><tr>

<td align="center"><font size="3" face="Arial"><a href="admin.php?action=register">Register Program (free)</a></font></td>

<td align="center"><font size="3" face="Arial"><a href="admin.php?action=feedback">Feedback Form</a></font></td>

</tr><tr>

<td align="center" colspan="2"><font size="3" face="Arial"><a href="documentation.html">HyperBook Documentation</a></font></td>

</tr></table>


<table cellpadding="5" cellspacing="2" border="2" bgcolor="<? echo $tablecolor ?>" height="225"><tr><td>
<font size="2" face="Arial" color="<? echo $textcolor ?>"><b><i>Search for:</i></b></font>

<form action="admin.php" method="post">
<input type="hidden" name="action" value="edit">
<input type="hidden" name="page" value="0">
<font size="3"><input type="text" name="record" size="10" maxlength="10">
<input type="submit" value="Record"></font></form>

<form action="admin.php" method="post">
<input type="hidden" name="action" value="namesearch">
<input type="hidden" name="page" value="0">
<font size="3"><input type="text" name="uid" size="10" maxlength="30">
<input type="submit" value="Name"></font></form>

<form action="admin.php" method="post">
<input type="hidden" name="action" value="uidsearch">
<input type="hidden" name="page" value="0">
<font size="3"><input type="text" name="uid" size="10" maxlength="10">
<input type="submit" value="UID"></font></form>

</td></tr><tr><td align="center"><font size="2" face="Arial"><a href="index.php"><b>Open Guestbook</b></a></font>
</td></tr></table>


</td></tr></table>
</td></tr></table><br>

<?

displayfooter("false");

exit;

?>