drop table articles;
drop sequence articles_id_seq;
drop table block_ip;

create table articles(
	id SERIAL,
	time datetime,
	author varchar(128),
	email varchar(50),
	subject varchar(50),
	body varchar,
	is_parent bool default FALSE,
	subs varchar,
	parent int4,
	level int4,
	root int4,
	ip varchar(16),
	views int4,
	forum int4,
	moderation_state bool default TRUE,
	attach varchar(30),
	PRIMARY KEY(id)
);

create table block_ip(
	ip varchar,
	PRIMARY KEY(ip)
);

grant all on articles to public;
grant all on articles_id_seq to public;
grant all on block_ip to public;
