drop table if exists articles;
drop table if exists block_ip;

create table articles(
	id int PRIMARY KEY AUTO_INCREMENT,
	time datetime,
	author varchar(128),
	email varchar(50),
	subject varchar(50),
	body text,
	is_parent bool default 'f',
	subs text,
	parent int(4),
	level int(4),
	root int(4),
	ip varchar(16),
	views int(4),
	forum int(4),
	moderation_state bool default 't',
	attach varchar(30)
);

create table block_ip(
	ip text
);

grant all on articles to public;
grant all on articles_id_seq to public;
grant all on block_ip to public;
