# MySQL dump 5.13
#
# Host: mysql    Database: bestweb
#--------------------------------------------------------
# Server version	3.22.21

#
# Table structure for table 'badips'
#
CREATE TABLE badips (
  id int(11) DEFAULT '0' NOT NULL auto_increment,
  boardid int(11) DEFAULT '0' NOT NULL,
  ip varchar(64) DEFAULT '' NOT NULL,
  PRIMARY KEY (id),
  KEY boardid (boardid),
  KEY ip (ip),
  KEY boardid_2 (boardid,ip),
  UNIQUE boardid_3 (boardid,ip)
);

#
# Table structure for table 'boards'
#
CREATE TABLE boards (
  id int(11) DEFAULT '0' NOT NULL auto_increment,
  owner varchar(16) DEFAULT '' NOT NULL,
  name varchar(40) DEFAULT '' NOT NULL,
  description text,
  created datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  disabled enum('Y','N') DEFAULT 'Y' NOT NULL,
  bgcolor varchar(16) DEFAULT 'white' NOT NULL,
  bgimage varchar(255) DEFAULT '' NOT NULL,
  homeaddress varchar(255),
  homename varchar(255),
  textcolor varchar(16),
  linkcolor varchar(16),
  vlinkcolor varchar(16),
  alinkcolor varchar(16),
  header text,
  footer text,
  notags enum('Y','N') DEFAULT 'N' NOT NULL,
  rdonly enum('Y','N') DEFAULT 'N' NOT NULL,
  expiredays int(11) DEFAULT '0' NOT NULL,
  newmark varchar(100) DEFAULT '<font color=\"Red\">New!</font>',
  notify enum('Y','N') DEFAULT 'N',
  private enum('Y','N') DEFAULT 'N' NOT NULL,
  pagesize int(11) DEFAULT '20' NOT NULL,
  newdays int(11) DEFAULT '1' NOT NULL,
  tstart varchar(127) DEFAULT '<li>' NOT NULL,
  tend varchar(127) DEFAULT '</li>' NOT NULL,
  boardtarget varchar(20) DEFAULT '_self' NOT NULL,
  msgtarget varchar(20) DEFAULT '_self' NOT NULL,
  listman varchar(64),
  listcast varchar(64),
  delim varchar(40),
  view enum('webboard','guestbook','other') DEFAULT 'webboard' NOT NULL,
  topnavigator enum('Y','N') DEFAULT 'N' NOT NULL,
  keywords text,
  metadesc text,
  modtime datetime,
  PRIMARY KEY (id),
  KEY owner (owner),
  KEY name (name),
  KEY created (created),
  KEY disabled (disabled),
  KEY expiredays (expiredays),
  KEY private (private),
  KEY pagesize (pagesize),
  KEY view (view)
);

#
# Table structure for table 'coadmins'
#
CREATE TABLE coadmins (
  login varchar(16) DEFAULT '' NOT NULL,
  owner varchar(16) DEFAULT '' NOT NULL,
  pass varchar(32) DEFAULT '' NOT NULL,
  boards varchar(255) DEFAULT '' NOT NULL,
  PRIMARY KEY (login),
  KEY owner (owner)
);

#
# Table structure for table 'messages'
#
CREATE TABLE messages (
  id int(11) DEFAULT '0' NOT NULL auto_increment,
  prev int(11) DEFAULT '0' NOT NULL,
  boardid int(11) DEFAULT '0' NOT NULL,
  posted datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  author varchar(127) DEFAULT '' NOT NULL,
  subject varchar(127) DEFAULT '' NOT NULL,
  msg text,
  url varchar(255),
  email varchar(127) DEFAULT '' NOT NULL,
  urlname varchar(127),
  urlimage varchar(127),
  notify enum('Y','N','A') DEFAULT 'N' NOT NULL,
  remotehost varchar(127) DEFAULT '' NOT NULL,
  threadupdated datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  threadid int(11) DEFAULT '0' NOT NULL,
  PRIMARY KEY (id),
  KEY prev (prev),
  KEY boardid (boardid),
  KEY posted (posted),
  KEY author (author),
  KEY subject (subject),
  KEY email (email),
  KEY remotehost (remotehost),
  KEY threadupdated (threadupdated),
  KEY prev_2 (prev,boardid,posted),
  KEY prev_3 (prev,boardid),
  KEY threadid (threadid)
);

#
# Table structure for table 'msgtypes'
#
CREATE TABLE msgtypes (
  id int(11) DEFAULT '0' NOT NULL auto_increment,
  boardid int(11) DEFAULT '0' NOT NULL,
  name varchar(64) DEFAULT '' NOT NULL,
  icon varchar(255),
  PRIMARY KEY (id),
  KEY boardid (boardid),
  KEY name (name),
  UNIQUE boardid_2 (boardid,name)
);

#
# Table structure for table 'users'
#
CREATE TABLE users (
  id int(11) DEFAULT '0' NOT NULL auto_increment,
  login varchar(32) DEFAULT '' NOT NULL,
  password varchar(32) DEFAULT '' NOT NULL,
  name varchar(80) DEFAULT '' NOT NULL,
  boardid int(11) DEFAULT '0' NOT NULL,
  access set('R','W','M') DEFAULT '' NOT NULL,
  PRIMARY KEY (id),
  KEY login (login),
  KEY password (password),
  KEY boardid (boardid),
  UNIQUE login_2 (login,boardid)
);

