#!/usr/local/bin/perl -w

use DBI;
use strict;

my $DEBUG = 1;
my ($row, $msg);
my @msgid = ();
my $DBHOST = "localhost";
my $DBUSER = "";
my $DB = "";
my $DBPASS = "";

my $dbh = DBI->connect("DBI:mysql:$DB",$DBUSER,"$DBPASS");

my $SQL = "SELECT id, expiredays FROM boards WHERE expiredays > 0";

$DEBUG && print "Executing SQL: '$SQL'\n";

my $boards = $dbh->prepare($SQL) || die "Bad SQL: $SQL\n$dbh->errstr\n";
$boards->execute || die "Unable to execute query: $dbh->errstr\n"; 

while (defined($row = $boards->fetchrow_hashref)) {
  my $boardid = $row->{id};
  my $expiredays = $row->{expiredays};
  print "$boardid\t$expiredays\n";

  $SQL = "SELECT id, prev FROM messages WHERE boardid = $boardid AND " .
  	 "TO_DAYS(now()) - TO_DAYS(posted) > $expiredays";
  $DEBUG && print "Executing SQL: '$SQL'\n";
  
  my $messages = $dbh->prepare($SQL) || die "Bad SQL: '$SQL'\n$dbh->errstr\n";
  $messages->execute || die "Unable to execute query: $dbh->errstr\n";
  while (defined($msg = $messages->fetchrow_hashref)) {
    my $prev = $msg->{prev};
    my $id = $msg->{id};
    $SQL = "UPDATE messages SET prev = $prev WHERE prev = $id";
    $DEBUG && print "Executing SQL: '$SQL'\n";
    my $updated = $dbh->do($SQL) || die "Unable to update children of #$id: $dbh->errstr\n";
    $DEBUG && print "$updated messages updated\n";
    $SQL = "DELETE FROM messages WHERE id = $id";
    $DEBUG && print "Executing SQL: '$SQL'\n";
    $dbh->do($SQL) || die "Unable to delete message #$id: $dbh->errstr\n";
  }
  $messages->finish;
}
$boards->finish;
$dbh->disconnect;
