#!/usr/local/bin/perl -w

use DBI;
use Time::Local;

#########################################################################
#
# Copyright (c) 2001 TightPrices.com
#
# Notifies users that their auction has ended.
#
# Run cron job at 12:05 am everyday just after midnight.
# 
# Get all auctions that ended the day before.
# 
# If the auction had a winning bidder (e.g. a bid was greater than the
# reserve price) then locate the winner's e-mail address and the seller's
# address.
# 
# Send an e-mail to both e-mail addresses stating that the auction
# has ended.  Include the auction ad id, the title of the ad, and the
# URL to the ad.
#
# BCC the e-mail to adendingnotify@yourdomain.com
#
#########################################################################

$database    = "  ";
$connect_str = "DBI:mysql:$database:localhost";
$username    = "  ";
$passsword   = "  ";

$domain_name = "yourdomain.com';	# don't put "www." or "http://www." in front of it

$dbh = DBI->connect( $connect_str, $username, $password);

#print time();


#($Second,$Minute,$Hour,$Month_Day,$Month,$Year,$Week_Day,$IsDST) = (localtime)[0,1,2,3,4,5,6,8]; 

# print "$Month $Month_Day $Year.  $Hour:$Minute:$Second\n";

$timenow = time;
#$local_time = localtime($timenow);
#print("Starting with time of: ${local_time} - $timenow\n");

($sec,$min,$hour) = localtime($timenow);
$total_off = (${hour} * 60 * 60) + (${min} * 60) + ${sec};
$timenow -= ${total_off};
#$midnight_time = localtime($timenow);
#$mtime = $timenow;
$YesterdayEnd = $timenow;
#print("Rolled back to midnight at: ${midnight_time} - ${mtime}\n");

$timenow -= (24 * 60 * 60);
#$pmtime = $timenow;
#$prev_midnight_time = localtime($timenow);
$YesterdayBegin = $timenow;
#print("Rolled back to previous midnight at: ${prev_midnight_time} - ${pmtime}\n");

$query = "SELECT * FROM AuctionAds WHERE $YesterdayBegin <= EndDate AND EndDate < $YesterdayEnd";
$sth = $dbh->prepare($query);
$sth->execute();

while (@row = $sth->fetchrow_array) {      
   
   $AdID = $row[0];
   $SellerID = $row[1];
   $AdTitle = $row[3];
   $ReservePrice = $row[6];
   
   $MaxBidAmtQuery = "SELECT MAX(MaxBid) FROM Bids WHERE AdID=$AdID AND MaxBid >= $ReservePrice";
   $MaxBidAmtSth = $dbh->prepare($MaxBidAmtQuery);
   $MaxBidAmtSth->execute();

   if ( @MaxBidAmtRow = $MaxBidAmtSth->fetchrow_array ) 
   {  
      # Select the first equal to the maximum bid amount that was placed.

      $MaxBidAmt = $MaxBidAmtRow[0];

      if ( $MaxBidAmt )
      {
		  $FirstHighBidQuery = "SELECT UserAcctID FROM Bids WHERE AdID=$AdID AND MaxBid=$MaxBidAmt ORDER BY BidDate ASC";

		  $bidsth = $dbh->prepare($FirstHighBidQuery);
		  $bidsth->execute();

		  if ( @HighBidRow = $bidsth->fetchrow_array ) 
		  {
			 $WinnerUserID = $HighBidRow[0];

			 # We have a winner.  E-mail both the winner and the seller, and BCC it to the auction winner admin

			 $WinnerEmail = "";
			 $SellerEmail = "";

			 $EmailQuery = "SELECT Email, First, Last FROM UserAccounts WHERE UserAccountID=$WinnerUserID";
			 $EmailSth = $dbh->prepare($EmailQuery);
			 $EmailSth->execute();
         
			 if (@EmailRow = $EmailSth->fetchrow_array) {
				$WinnerEmail = $EmailRow[0];
				$WinnerFirst = $EmailRow[1];
				$WinnerLast = $EmailRow[2];
			 }
			 $EmailSth->finish;

			 $EmailQuery = "SELECT Email, First, Last FROM UserAccounts WHERE UserAccountID=$SellerID";
			 $EmailSth = $dbh->prepare($EmailQuery);
			 $EmailSth->execute();
         
			 if (@EmailRow = $EmailSth->fetchrow_array) {
				$SellerEmail = $EmailRow[0];
				$SellerFirst = $EmailRow[1];
				$SellerLast = $EmailRow[2];
			 }
			 $EmailSth->finish;

			 if ( $WinnerEmail ne "" && $SellerEmail ne "" ) {
            
				open(MAIL, "|/usr/lib/sendmail -t");

				print MAIL "To: $WinnerEmail, $SellerEmail\n";
				print MAIL "Bcc: AuctionEndNotify\@$domain_name\n";
				print MAIL "From: AuctionEndNotify\@$domain_name\n";
				print MAIL "Subject: Auction Ended: $AdTitle\n";
            
				print MAIL "\n";
				print MAIL "The auction has ended for $AdTitle.\n\n";
				print MAIL "Please contact each other to complete the transaction.\n\n";
            
				print MAIL "Buyer:  $WinnerFirst $WinnerLast ( $WinnerEmail )\n";
				print MAIL "Seller: $SellerFirst $SellerLast ( $SellerEmail )\n";

				print MAIL "\n";
				print MAIL "You may view the completed auction at this link:\n\n";

				print MAIL "  http://www.$domain_name/ViewAuctionAd.php?AdID=$AdID\n\n";

				print MAIL "Congratulations!\n\n";

				print MAIL "Thank you for using $domain_name and have a nice day!\n";
            
				close (MAIL);  
			 }
		  }

		  $bidsth->finish;
	   }

	}

   $MaxBidAmtSth->finish;
}

$sth->finish;
$dbh->disconnect;


