/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.vorbis.sampled.file;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javazoom.spi.vorbis.sampled.file.VorbisEncoding;
import javazoom.spi.vorbis.sampled.file.VorbisFileFormatType;

public class VorbisAudioFileReader
extends AudioFileReader {
    public static boolean DEBUG = false;
    public static final int BUFSIZE = 8192;
    private SyncState oy = null;
    private StreamState os = null;
    private Page og = null;
    private Packet op = null;
    private Info vi = null;
    private Comment vc = null;
    private DspState vd = null;
    private Block vb = null;
    private byte[] buffer = null;
    private int bytes = 0;
    private int format = -1;
    private int rate = 0;
    private int channels = 0;

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            audioFileFormat = this.getAudioFileFormat(fileInputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        InputStream inputStream = uRL.openStream();
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(inputStream, new ByteArrayOutputStream());
    }

    /*
     * Unable to fully structure code
     */
    protected AudioFileFormat getAudioFileFormat(InputStream var1_1, ByteArrayOutputStream var2_2) throws UnsupportedAudioFileException, IOException {
        block30: {
            if (VorbisAudioFileReader.DEBUG) {
                System.err.println("getAudioFileFormat");
            }
            this.init_jorbis();
            var3_3 = false;
            var4_4 = this.oy.buffer(8192);
            this.buffer = this.oy.data;
            try {
                this.bytes = var1_1.read(this.buffer, var4_4, 8192);
                if (VorbisAudioFileReader.DEBUG) {
                    System.err.println("Read : " + this.buffer.length);
                }
                var2_2.write(this.buffer, 0, this.buffer.length);
            }
            catch (Exception var5_5) {
                if (VorbisAudioFileReader.DEBUG) {
                    System.err.println(var5_5.getMessage());
                }
                throw new UnsupportedAudioFileException(var5_5.getMessage());
            }
            this.oy.wrote(this.bytes);
            if (this.oy.pageout(this.og) != 1) {
                if (VorbisAudioFileReader.DEBUG) {
                    System.err.println("Input does not appear to be an Ogg bitstream.");
                }
                throw new UnsupportedAudioFileException("Input does not appear to be an Ogg bitstream.");
            }
            this.os.init(this.og.serialno());
            this.os.reset();
            this.vi.init();
            this.vc.init();
            if (this.os.pagein(this.og) < 0) {
                if (VorbisAudioFileReader.DEBUG) {
                    System.err.println("Error reading first page of Ogg bitstream data.");
                }
                throw new UnsupportedAudioFileException("Error reading first page of Ogg bitstream data.");
            }
            if (this.os.packetout(this.op) != 1) {
                if (VorbisAudioFileReader.DEBUG) {
                    System.err.println("Error reading initial header packet.");
                }
                throw new UnsupportedAudioFileException("Error reading initial header packet.");
            }
            if (this.vi.synthesis_headerin(this.vc, this.op) < 0) {
                if (VorbisAudioFileReader.DEBUG) {
                    System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
                }
                throw new UnsupportedAudioFileException("This Ogg bitstream does not contain Vorbis audio data.");
            }
            var5_6 = 0;
            break block30;
            while ((var6_7 = this.oy.pageout(this.og)) != 0) {
                if (var6_7 == 1) {
                    this.os.pagein(this.og);
                    while (var5_6 < 2) {
                        var6_7 = this.os.packetout(this.op);
                        if (var6_7 == 0) break;
                        if (var6_7 == -1) {
                            if (VorbisAudioFileReader.DEBUG) {
                                System.err.println("Corrupt secondary header.  Exiting.");
                            }
                            throw new UnsupportedAudioFileException("Corrupt secondary header.  Exiting.");
                        }
                        this.vi.synthesis_headerin(this.vc, this.op);
                        ++var5_6;
                    }
                }
lbl57:
                // 5 sources

                ** while (var5_6 >= 2)
lbl58:
                // 1 sources

            }
lbl59:
            // 2 sources

            var4_4 = this.oy.buffer(8192);
            this.buffer = this.oy.data;
            try {
                this.bytes = var1_1.read(this.buffer, var4_4, 8192);
                if (VorbisAudioFileReader.DEBUG) {
                    System.err.println("Read2 : " + this.buffer.length);
                }
                var2_2.write(this.buffer, 0, this.buffer.length);
            }
            catch (Exception var6_8) {
                if (VorbisAudioFileReader.DEBUG) {
                    System.err.println(var6_8.getMessage());
                }
                throw new UnsupportedAudioFileException(var6_8.getMessage());
            }
            if (this.bytes == 0 && var5_6 < 2) {
                if (VorbisAudioFileReader.DEBUG) {
                    System.err.println("End of file before finding all Vorbis headers!");
                }
                throw new UnsupportedAudioFileException("End of file before finding all Vorbis headers!");
            }
            this.oy.wrote(this.bytes);
        }
        if (var5_6 < 2) ** GOTO lbl57
        var6_9 = this.vc.user_comments;
        var7_10 = 0;
        while (var7_10 < ((byte[][])var6_9).length) {
            if (var6_9[var7_10] == null) break;
            if (VorbisAudioFileReader.DEBUG) {
                System.err.println("Comment: " + new String(var6_9[var7_10], 0, var6_9[var7_10].length - 1));
            }
            ++var7_10;
        }
        if (VorbisAudioFileReader.DEBUG) {
            System.err.println("Bitstream is " + this.vi.channels + " channel, " + this.vi.rate + "Hz");
        }
        if (VorbisAudioFileReader.DEBUG) {
            System.err.println("Encoded by: " + new String(this.vc.vendor, 0, this.vc.vendor.length - 1) + "\n");
        }
        var6_9 = VorbisEncoding.VORBISENC;
        var7_11 = new AudioFormat((AudioFormat.Encoding)var6_9, this.vi.rate, -1, this.vi.channels, -1, -1.0f, true);
        var8_12 = VorbisFileFormatType.VORBIS;
        if (var6_9.equals(VorbisEncoding.VORBISENC)) {
            var8_12 = VorbisFileFormatType.VORBIS;
        }
        return new AudioFileFormat(var8_12, var7_11, -1);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, byteArrayOutputStream);
        if (DEBUG) {
            System.err.println("Size : " + byteArrayOutputStream.size());
        }
        SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), inputStream);
        return new AudioInputStream(sequenceInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(fileInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)fileInputStream).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)fileInputStream).close();
            throw iOException;
        }
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = uRL.openStream();
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            inputStream.close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            inputStream.close();
            throw iOException;
        }
    }

    private void init_jorbis() {
        this.oy = new SyncState();
        this.os = new StreamState();
        this.og = new Page();
        this.op = new Packet();
        this.vi = new Info();
        this.vc = new Comment();
        this.vd = new DspState();
        this.vb = new Block(this.vd);
        this.buffer = null;
        this.bytes = 0;
        this.oy.init();
    }
}

