/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.util.TCircularBuffer;

public abstract class TAsynchronousFilteredAudioInputStream
extends AudioInputStream
implements TCircularBuffer.Trigger {
    private static int DEFAULT_BUFFER_SIZE = 327670;
    protected TCircularBuffer m_circularBuffer;
    private byte[] m_abSingleByte;

    public TAsynchronousFilteredAudioInputStream(AudioInputStream audioInputStream, AudioFormat audioFormat, long l) {
        super(audioInputStream, audioFormat, l);
        this.m_circularBuffer = new TCircularBuffer(DEFAULT_BUFFER_SIZE, false, true, this);
    }

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l) {
        this(audioFormat, l, DEFAULT_BUFFER_SIZE);
    }

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l, int n) {
        super(null, audioFormat, l);
        this.m_circularBuffer = new TCircularBuffer(n, false, true, this);
    }

    public int read() throws IOException {
        int n;
        if (this.m_abSingleByte == null) {
            this.m_abSingleByte = new byte[1];
        }
        if ((n = this.read(this.m_abSingleByte)) == -1) {
            return -1;
        }
        return this.m_abSingleByte[0];
    }

    public int read(byte[] byArray) throws IOException {
        return this.m_circularBuffer.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.m_circularBuffer.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            int n = this.read();
            if (n == -1) {
                return l2;
            }
            ++l2;
        }
        return l;
    }

    public int available() throws IOException {
        return this.m_circularBuffer.availableRead();
    }

    public void close() throws IOException {
        this.m_circularBuffer.close();
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("mark not supported");
    }

    public abstract void execute();
}

