/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import org.tritonus.TDebug;
import org.tritonus.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.sampled.convert.TMatrixFormatConversionProvider;
import org.tritonus.sampled.file.MpegEncoding;

public class MpegFormatConversionProvider
extends TMatrixFormatConversionProvider {
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(MpegEncoding.MPEG1L1, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L1, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L2, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG1L3, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L1, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L2, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2L3, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L1, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L2, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MpegEncoding.MPEG2DOT5L3, 12000.0f, -1, 2, -1, -1.0f, false)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(8000.0f, 16, 1, true, false), new AudioFormat(8000.0f, 16, 1, true, true), new AudioFormat(8000.0f, 16, 2, true, false), new AudioFormat(8000.0f, 16, 2, true, true), new AudioFormat(11025.0f, 16, 1, true, false), new AudioFormat(11025.0f, 16, 1, true, true), new AudioFormat(11025.0f, 16, 2, true, false), new AudioFormat(11025.0f, 16, 2, true, true), new AudioFormat(12000.0f, 16, 1, true, false), new AudioFormat(12000.0f, 16, 1, true, true), new AudioFormat(12000.0f, 16, 2, true, false), new AudioFormat(12000.0f, 16, 2, true, true), new AudioFormat(16000.0f, 16, 1, true, false), new AudioFormat(16000.0f, 16, 1, true, true), new AudioFormat(16000.0f, 16, 2, true, false), new AudioFormat(16000.0f, 16, 2, true, true), new AudioFormat(22050.0f, 16, 1, true, false), new AudioFormat(22050.0f, 16, 1, true, true), new AudioFormat(22050.0f, 16, 2, true, false), new AudioFormat(22050.0f, 16, 2, true, true), new AudioFormat(24000.0f, 16, 1, true, false), new AudioFormat(24000.0f, 16, 1, true, true), new AudioFormat(24000.0f, 16, 2, true, false), new AudioFormat(24000.0f, 16, 2, true, true), new AudioFormat(32000.0f, 16, 1, true, false), new AudioFormat(32000.0f, 16, 1, true, true), new AudioFormat(32000.0f, 16, 2, true, false), new AudioFormat(32000.0f, 16, 2, true, true), new AudioFormat(44100.0f, 16, 1, true, false), new AudioFormat(44100.0f, 16, 1, true, true), new AudioFormat(44100.0f, 16, 2, true, false), new AudioFormat(44100.0f, 16, 2, true, true), new AudioFormat(48000.0f, 16, 1, true, false), new AudioFormat(48000.0f, 16, 1, true, true), new AudioFormat(48000.0f, 16, 2, true, false), new AudioFormat(48000.0f, 16, 2, true, true)};
    private static final boolean t = true;
    private static final boolean f = false;
    private static final boolean[][] CONVERSIONS = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};

    public MpegFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS), CONVERSIONS);
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (this.isConversionSupported(audioFormat, audioInputStream.getFormat())) {
            return new DecodedMpegAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public static class DecodedMpegAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private InputStream m_encodedStream;
        private Bitstream m_bitstream;
        private Decoder m_decoder;
        private DMAISObuffer m_oBuffer;

        public DecodedMpegAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
            super(audioInputStream, audioFormat, -1L);
            this.m_encodedStream = audioInputStream;
            this.m_bitstream = new Bitstream((InputStream)audioInputStream);
            this.m_decoder = new Decoder(null);
            this.m_oBuffer = new DMAISObuffer(audioFormat.getChannels());
            this.m_decoder.setOutputBuffer((Obuffer)this.m_oBuffer);
        }

        public void execute() {
            block6: {
                try {
                    Header header = this.m_bitstream.readFrame();
                    if (header == null) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("header is null (end of mpeg stream)");
                        }
                        this.m_circularBuffer.close();
                        return;
                    }
                    Obuffer obuffer = this.m_decoder.decodeFrame(header, this.m_bitstream);
                    this.m_bitstream.closeFrame();
                    this.m_circularBuffer.write(this.m_oBuffer.getBuffer(), 0, this.m_oBuffer.getCurrentBufferSize());
                    this.m_oBuffer.reset();
                }
                catch (BitstreamException bitstreamException) {
                    if (TDebug.TraceAudioConverter) {
                        TDebug.out(bitstreamException);
                    }
                }
                catch (DecoderException decoderException) {
                    if (!TDebug.TraceAudioConverter) break block6;
                    TDebug.out(decoderException);
                }
            }
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_encodedStream.close();
        }

        private class DMAISObuffer
        extends Obuffer {
            private int m_nChannels;
            private byte[] m_abBuffer;
            private int[] m_anBufferPointers;
            private boolean m_bIsBigEndian;

            public DMAISObuffer(int n) {
                this.m_nChannels = n;
                this.m_abBuffer = new byte[2304 * n];
                this.m_anBufferPointers = new int[n];
                this.reset();
                this.m_bIsBigEndian = DecodedMpegAudioInputStream.this.isBigEndian();
            }

            public void append(int n, short s) {
                byte by;
                byte by2;
                if (this.m_bIsBigEndian) {
                    by2 = (byte)(s >>> 8 & 0xFF);
                    by = (byte)(s & 0xFF);
                } else {
                    by2 = (byte)(s & 0xFF);
                    by = (byte)(s >>> 8 & 0xFF);
                }
                this.m_abBuffer[this.m_anBufferPointers[n]] = by2;
                this.m_abBuffer[this.m_anBufferPointers[n] + 1] = by;
                int n2 = n;
                this.m_anBufferPointers[n2] = this.m_anBufferPointers[n2] + this.m_nChannels * 2;
            }

            public void set_stop_flag() {
            }

            public void close() {
            }

            public void write_buffer(int n) {
            }

            public void clear_buffer() {
            }

            public byte[] getBuffer() {
                return this.m_abBuffer;
            }

            public int getCurrentBufferSize() {
                return this.m_anBufferPointers[0];
            }

            public void reset() {
                int n = 0;
                while (n < this.m_nChannels) {
                    this.m_anBufferPointers[n] = n * 2;
                    ++n;
                }
            }
        }
    }
}

