/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.JOrbisException;
import java.io.FileInputStream;
import java.io.InputStream;

public class VorbisFile {
    static final int CHUNKSIZE = 4096;
    static final int SEEK_SET = 0;
    InputStream datasource;
    boolean seekable = false;
    long offset;
    long end;
    SyncState oy = new SyncState();
    int links;
    long[] offsets;
    long[] dataoffsets;
    int[] serialnos;
    long[] pcmlengths;
    Info[] vi;
    Comment[] vc;
    long pcm_offset;
    boolean decode_ready = false;
    int current_serialno;
    int current_link;
    float bittrack;
    float samptrack;
    StreamState os = new StreamState();
    DspState vd = new DspState();
    Block vb = new Block(this.vd);

    public VorbisFile(String string) throws JOrbisException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            throw new JOrbisException("VorbisFile: " + exception.toString());
        }
        int n = this.open(fileInputStream, null, 0);
        if (n == -1) {
            throw new JOrbisException("VorbisFile: open return -1");
        }
    }

    public VorbisFile(InputStream inputStream, byte[] byArray, int n) throws JOrbisException {
        int n2 = this.open(inputStream, byArray, n);
        if (n2 == -1) {
            // empty if block
        }
    }

    private int get_data() {
        int n = this.oy.buffer(4096);
        byte[] byArray = this.oy.data;
        int n2 = 0;
        try {
            n2 = this.datasource.read(byArray, n, 4096);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.oy.wrote(n2);
        return n2;
    }

    private void seek_helper(int n) {
        VorbisFile.fseek64_wrap(this.datasource, n, 0);
        this.offset = n;
        this.oy.reset();
    }

    private int get_next_page(Page page, int n) {
        int n2;
        block5: {
            if (n > 0) {
                n = (int)((long)n + this.offset);
            }
            while (true) {
                if (n > 0 && this.offset >= (long)n) {
                    return -1;
                }
                n2 = this.oy.pageseek(page);
                if (n2 < 0) {
                    this.offset -= (long)n2;
                    continue;
                }
                if (n2 != 0) break block5;
                if (n == 0) {
                    return -1;
                }
                if (this.get_data() <= 0) break;
            }
            return -1;
        }
        int n3 = (int)this.offset;
        this.offset += (long)n2;
        return n3;
    }

    private int get_prev_page(Page page) {
        int n;
        int n2 = (int)this.offset;
        int n3 = -1;
        block0: while (n3 == -1) {
            this.seek_helper(n2 -= 4096);
            while (this.offset < (long)(n2 + 4096)) {
                n = this.get_next_page(page, n2 + 4096 - (int)this.offset);
                if (n == -1) continue block0;
                n3 = n;
            }
        }
        this.seek_helper((int)this.offset);
        n = this.get_next_page(page, 4096);
        if (n == -1) {
            System.err.println("Missed page fencepost at end of logical bitstream Exiting");
            System.exit(1);
        }
        return n3;
    }

    void bisect_forward_serialno(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n3;
        int n8 = n3;
        Page page = new Page();
        while (n2 < n7) {
            int n9 = n7 - n2 < 4096 ? n2 : (n2 + n7) / 2;
            this.seek_helper(n9);
            n6 = this.get_next_page(page, -1);
            if (n6 < 0 || page.serialno() != n4) {
                n7 = n9;
                if (n6 < 0) continue;
                n8 = n6;
                continue;
            }
            n2 = n6 + page.header_len + page.body_len;
        }
        this.seek_helper(n8);
        n6 = this.get_next_page(page, -1);
        if (n2 >= n3 || n6 == -1) {
            this.links = n5 + 1;
            this.offsets = new long[n5 + 2];
            this.offsets[n5 + 1] = n2;
        } else {
            this.bisect_forward_serialno(n8, (int)this.offset, n3, page.serialno(), n5 + 1);
        }
        this.offsets[n5] = n;
    }

    int fetch_headers(Info info, Comment comment, int[] nArray) {
        Page page = new Page();
        Packet packet = new Packet();
        int n = this.get_next_page(page, 4096);
        if (n == -1) {
            System.err.println("Did not find initial header for bitstream.");
            return -1;
        }
        if (nArray != null) {
            nArray[0] = page.serialno();
        }
        this.os.init(page.serialno());
        info.init();
        comment.init();
        int n2 = 0;
        while (n2 < 3) {
            this.os.pagein(page);
            while (n2 < 3) {
                int n3 = this.os.packetout(packet);
                if (n3 == 0) break;
                if (n3 == -1) {
                    System.err.println("Corrupt header in logical bitstream.");
                    info.clear();
                    comment.clear();
                    this.os.clear();
                    return -1;
                }
                if (info.synthesis_headerin(comment, packet) != 0) {
                    System.err.println("Illegal header in logical bitstream.");
                    info.clear();
                    comment.clear();
                    this.os.clear();
                    return -1;
                }
                ++n2;
            }
            if (n2 >= 3 || this.get_next_page(page, 1) >= 0) continue;
            System.err.println("Missing header in logical bitstream.");
            info.clear();
            comment.clear();
            this.os.clear();
            return -1;
        }
        return 0;
    }

    void prefetch_all_headers(Info info, Comment comment, int n) {
        Page page = new Page();
        this.vi = new Info[this.links];
        this.vc = new Comment[this.links];
        this.dataoffsets = new long[this.links];
        this.pcmlengths = new long[this.links];
        this.serialnos = new int[this.links];
        int n2 = 0;
        while (n2 < this.links) {
            block6: {
                if (info != null && comment != null && n2 == 0) {
                    this.vi[n2] = info;
                    this.vc[n2] = comment;
                    this.dataoffsets[n2] = n;
                } else {
                    this.seek_helper((int)this.offsets[n2]);
                    if (this.fetch_headers(this.vi[n2], this.vc[n2], null) == -1) {
                        System.err.println("Error opening logical bitstream #" + (n2 + 1) + "\n");
                        this.dataoffsets[n2] = -1L;
                    } else {
                        this.dataoffsets[n2] = this.offset;
                        this.os.clear();
                    }
                }
                int n3 = (int)this.offsets[n2 + 1];
                this.seek_helper(n3);
                do {
                    int n4;
                    if ((n4 = this.get_prev_page(page)) != -1) continue;
                    System.err.println("Could not find last page of logical bitstream #" + n2 + "\n");
                    this.vi[n2].clear();
                    this.vc[n2].clear();
                    break block6;
                } while (page.granulepos() == -1L);
                this.serialnos[n2] = page.serialno();
                this.pcmlengths[n2] = page.granulepos();
            }
            ++n2;
        }
    }

    int make_decode_ready() {
        if (this.decode_ready) {
            System.exit(1);
        }
        this.vd.synthesis_init(this.vi[0]);
        this.vb.init(this.vd);
        this.decode_ready = true;
        return 0;
    }

    int open_seekable() {
        Info info = new Info();
        Comment comment = new Comment();
        Page page = new Page();
        int[] nArray = new int[1];
        int n = this.fetch_headers(info, comment, nArray);
        int n2 = nArray[0];
        int n3 = (int)this.offset;
        this.os.clear();
        if (n == -1) {
            return -1;
        }
        this.seekable = true;
        VorbisFile.fseek64_wrap(this.datasource, (int)this.offset, 0);
        int n4 = (int)this.offset;
        n4 = this.get_prev_page(page);
        if (page.serialno() != n2) {
            this.bisect_forward_serialno(0, 0, n4 + 1, n2, 0);
        } else {
            this.bisect_forward_serialno(0, n4, n4 + 1, n2, 0);
        }
        this.prefetch_all_headers(info, comment, n3);
        return this.raw_seek(0);
    }

    int open_nonseekable() {
        this.links = 1;
        this.vi = new Info[this.links];
        this.vi[0] = new Info();
        this.vc = new Comment[this.links];
        this.vc[0] = new Comment();
        int[] nArray = new int[1];
        if (this.fetch_headers(this.vi[0], this.vc[0], nArray) == -1) {
            return -1;
        }
        this.current_serialno = nArray[0];
        this.make_decode_ready();
        return 0;
    }

    void decode_clear() {
        this.os.clear();
        this.vd.clear();
        this.vb.clear();
        this.decode_ready = false;
        this.bittrack = 0.0f;
        this.samptrack = 0.0f;
    }

    int process_packet(int n) {
        Page page = new Page();
        while (true) {
            Packet packet;
            int n2;
            if (this.decode_ready && (n2 = this.os.packetout(packet = new Packet())) > 0) {
                long l = packet.granulepos;
                if (this.vb.synthesis(packet) == 0) {
                    int n3 = this.vd.synthesis_pcmout(null, null);
                    this.vd.synthesis_blockin(this.vb);
                    this.samptrack += (float)(this.vd.synthesis_pcmout(null, null) - n3);
                    this.bittrack += (float)(packet.bytes * 8);
                    if (l != -1L && packet.e_o_s == 0) {
                        n3 = this.seekable ? this.current_link : 0;
                        int n4 = this.vd.synthesis_pcmout(null, null);
                        l -= (long)n4;
                        int n5 = 0;
                        while (n5 < n3) {
                            l += this.pcmlengths[n5];
                            ++n5;
                        }
                        this.pcm_offset = l;
                    }
                    return 1;
                }
            }
            if (n == 0) {
                return 0;
            }
            if (this.get_next_page(page, -1) < 0) {
                return 0;
            }
            this.bittrack += (float)(page.header_len * 8);
            if (this.decode_ready && this.current_serialno != page.serialno()) {
                this.decode_clear();
            }
            if (!this.decode_ready) {
                int n6;
                if (this.seekable) {
                    this.current_serialno = page.serialno();
                    n6 = 0;
                    while (n6 < this.links) {
                        if (this.serialnos[n6] == this.current_serialno) break;
                        ++n6;
                    }
                    if (n6 == this.links) {
                        return -1;
                    }
                    this.current_link = n6;
                    this.os.init(this.current_serialno);
                    this.os.reset();
                } else {
                    int[] nArray = new int[1];
                    this.fetch_headers(this.vi[0], this.vc[0], nArray);
                    this.current_serialno = nArray[0];
                    ++this.current_link;
                    n6 = 0;
                }
                this.make_decode_ready();
            }
            this.os.pagein(page);
        }
    }

    int clear() {
        this.vb.clear();
        this.vd.clear();
        this.os.clear();
        if (this.vi != null && this.links != 0) {
            int n = 0;
            while (n < this.links) {
                this.vi[n].clear();
                this.vc[n].clear();
                ++n;
            }
            this.vi = null;
            this.vc = null;
        }
        if (this.dataoffsets != null) {
            this.dataoffsets = null;
        }
        if (this.pcmlengths != null) {
            this.pcmlengths = null;
        }
        if (this.serialnos != null) {
            this.serialnos = null;
        }
        if (this.offsets != null) {
            this.offsets = null;
        }
        this.oy.clear();
        return 0;
    }

    static int fseek64_wrap(InputStream inputStream, int n, int n2) {
        try {
            if (n2 == 0) {
                inputStream.reset();
            }
            inputStream.skip(n);
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    int open(InputStream inputStream, byte[] byArray, int n) {
        return this.open_callbacks(inputStream, byArray, n);
    }

    int open_callbacks(InputStream inputStream, byte[] byArray, int n) {
        int n2;
        int n3 = VorbisFile.fseek64_wrap(inputStream, (int)this.offset, 0);
        this.datasource = inputStream;
        this.oy.init();
        if (byArray != null) {
            int n4 = this.oy.buffer(n);
            System.arraycopy(byArray, 0, this.oy.data, n4, n);
            this.oy.wrote(n);
        }
        if ((n2 = n3 != -1 ? this.open_seekable() : this.open_nonseekable()) != 0) {
            this.datasource = null;
            this.clear();
        }
        return n2;
    }

    public int streams() {
        return this.links;
    }

    public boolean seekable() {
        return this.seekable;
    }

    public int bitrate(int n) {
        if (n >= this.links) {
            return -1;
        }
        if (!this.seekable && n != 0) {
            return this.bitrate(0);
        }
        if (n < 0) {
            long l = 0L;
            int n2 = 0;
            while (n2 < this.links) {
                l += (this.offsets[n2 + 1] - this.dataoffsets[n2]) * 8L;
                ++n2;
            }
            return (int)Math.rint((float)l / this.time_total(-1));
        }
        if (this.seekable) {
            return (int)Math.rint((float)((this.offsets[n + 1] - this.dataoffsets[n]) * 8L) / this.time_total(n));
        }
        if (this.vi[n].bitrate_nominal > 0) {
            return this.vi[n].bitrate_nominal;
        }
        if (this.vi[n].bitrate_upper > 0) {
            if (this.vi[n].bitrate_lower > 0) {
                return (this.vi[n].bitrate_upper + this.vi[n].bitrate_lower) / 2;
            }
            return this.vi[n].bitrate_upper;
        }
        return -1;
    }

    public int bitrate_instant() {
        int n;
        int n2 = n = this.seekable ? this.current_link : 0;
        if (this.samptrack == 0.0f) {
            return -1;
        }
        int n3 = (int)((double)(this.bittrack / this.samptrack * (float)this.vi[n].rate) + 0.5);
        this.bittrack = 0.0f;
        this.samptrack = 0.0f;
        return n3;
    }

    public int serialnumber(int n) {
        if (n >= this.links) {
            return -1;
        }
        if (!this.seekable && n >= 0) {
            return this.serialnumber(-1);
        }
        if (n < 0) {
            return this.current_serialno;
        }
        return this.serialnos[n];
    }

    public long raw_total(int n) {
        if (!this.seekable || n >= this.links) {
            return -1L;
        }
        if (n < 0) {
            long l = 0L;
            int n2 = 0;
            while (n2 < this.links) {
                l += this.raw_total(n2);
                ++n2;
            }
            return l;
        }
        return this.offsets[n + 1] - this.offsets[n];
    }

    public long pcm_total(int n) {
        if (!this.seekable || n >= this.links) {
            return -1L;
        }
        if (n < 0) {
            long l = 0L;
            int n2 = 0;
            while (n2 < this.links) {
                l += this.pcm_total(n2);
                ++n2;
            }
            return l;
        }
        return this.pcmlengths[n];
    }

    public float time_total(int n) {
        if (!this.seekable || n >= this.links) {
            return -1.0f;
        }
        if (n < 0) {
            float f = 0.0f;
            int n2 = 0;
            while (n2 < this.links) {
                f += this.time_total(n2);
                ++n2;
            }
            return f;
        }
        return (float)this.pcmlengths[n] / (float)this.vi[n].rate;
    }

    public int raw_seek(int n) {
        if (!this.seekable) {
            return -1;
        }
        if (n < 0 || (long)n > this.offsets[this.links]) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        this.pcm_offset = -1L;
        this.decode_clear();
        this.seek_helper(n);
        switch (this.process_packet(1)) {
            case 0: {
                this.pcm_offset = this.pcm_total(-1);
                return 0;
            }
            case -1: {
                this.pcm_offset = -1L;
                this.decode_clear();
                return -1;
            }
        }
        while (true) {
            switch (this.process_packet(0)) {
                case 0: {
                    return 0;
                }
                case -1: {
                    this.pcm_offset = -1L;
                    this.decode_clear();
                    return -1;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public int pcm_seek(long var1_1) {
        var3_2 = -1;
        var4_3 = this.pcm_total(-1);
        if (!this.seekable) {
            return -1;
        }
        if (var1_1 < 0L || var1_1 > var4_3) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        var3_2 = this.links - 1;
        while (var3_2 >= 0) {
            if (var1_1 >= (var4_3 -= this.pcmlengths[var3_2])) break;
            --var3_2;
        }
        var6_4 = var1_1 - var4_3;
        var8_6 = (int)this.offsets[var3_2 + 1];
        var10_10 = var9_8 = (int)this.offsets[var3_2];
        var11_11 = new Page();
        while (var9_8 < var8_6) {
            var12_12 = var8_6 - var9_8 < 4096 ? var9_8 : (var8_6 + var9_8) / 2;
            this.seek_helper(var12_12);
            var13_13 = this.get_next_page(var11_11, var8_6 - var12_12);
            if (var13_13 == -1) {
                var8_6 = var12_12;
                continue;
            }
            var14_14 = var11_11.granulepos();
            if (var14_14 < var6_4) {
                var10_10 = var13_13;
                var9_8 = (int)this.offset;
                continue;
            }
            var8_6 = var12_12;
        }
        if (this.raw_seek(var10_10) != 0) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        if (this.pcm_offset >= var1_1) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        if (var1_1 <= this.pcm_total(-1)) ** GOTO lbl56
        this.pcm_offset = -1L;
        this.decode_clear();
        return -1;
lbl-1000:
        // 1 sources

        {
            var7_15 = (int)(var1_1 - this.pcm_offset);
            var8_7 = new float[1][][];
            var9_9 = new int[this.getInfo((int)-1).channels];
            var10_10 = this.vd.synthesis_pcmout(var8_7, var9_9);
            var6_5 = var8_7[0];
            if (var10_10 > var7_15) {
                var10_10 = var7_15;
            }
            this.vd.synthesis_read(var10_10);
            this.pcm_offset += (long)var10_10;
            if (var10_10 >= var7_15 || this.process_packet(1) != 0) continue;
            this.pcm_offset = this.pcm_total(-1);
lbl56:
            // 3 sources

            ** while (this.pcm_offset < var1_1)
        }
lbl57:
        // 1 sources

        return 0;
    }

    int time_seek(float f) {
        int n = -1;
        long l = this.pcm_total(-1);
        float f2 = this.time_total(-1);
        if (!this.seekable) {
            return -1;
        }
        if (f < 0.0f || f > f2) {
            this.pcm_offset = -1L;
            this.decode_clear();
            return -1;
        }
        n = this.links - 1;
        while (n >= 0) {
            l -= this.pcmlengths[n];
            if (f >= (f2 -= this.time_total(n))) break;
            --n;
        }
        long l2 = (long)((float)l + (f - f2) * (float)this.vi[n].rate);
        return this.pcm_seek(l2);
    }

    public long raw_tell() {
        return this.offset;
    }

    public long pcm_tell() {
        return this.pcm_offset;
    }

    public float time_tell() {
        int n = -1;
        long l = 0L;
        float f = 0.0f;
        if (this.seekable) {
            l = this.pcm_total(-1);
            f = this.time_total(-1);
            n = this.links - 1;
            while (n >= 0) {
                f -= this.time_total(n);
                if (this.pcm_offset >= (l -= this.pcmlengths[n])) break;
                --n;
            }
        }
        return f + (float)(this.pcm_offset - l) / (float)this.vi[n].rate;
    }

    public Info getInfo(int n) {
        if (this.seekable) {
            if (n < 0) {
                if (this.decode_ready) {
                    return this.vi[this.current_link];
                }
                return null;
            }
            if (n >= this.links) {
                return null;
            }
            return this.vi[n];
        }
        if (this.decode_ready) {
            return this.vi[0];
        }
        return null;
    }

    public Comment getComment(int n) {
        if (this.seekable) {
            if (n < 0) {
                if (this.decode_ready) {
                    return this.vc[this.current_link];
                }
                return null;
            }
            if (n >= this.links) {
                return null;
            }
            return this.vc[n];
        }
        if (this.decode_ready) {
            return this.vc[0];
        }
        return null;
    }

    int host_is_big_endian() {
        return 1;
    }

    int read(byte[] byArray, int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = this.host_is_big_endian();
        int n6 = 0;
        while (true) {
            if (this.decode_ready) {
                float[][][] fArrayArray = new float[1][][];
                int[] nArray2 = new int[this.getInfo((int)-1).channels];
                int n7 = this.vd.synthesis_pcmout(fArrayArray, nArray2);
                float[][] fArray = fArrayArray[0];
                if (n7 != 0) {
                    int n8 = this.getInfo((int)-1).channels;
                    int n9 = n3 * n8;
                    if (n7 > n / n9) {
                        n7 = n / n9;
                    }
                    if (n3 == 1) {
                        int n10 = n4 != 0 ? 0 : 128;
                        int n11 = 0;
                        while (n11 < n7) {
                            int n12 = 0;
                            while (n12 < n8) {
                                int n13 = (int)((double)fArray[n12][nArray2[n12] + n11] * 128.0 + 0.5);
                                if (n13 > 127) {
                                    n13 = 127;
                                } else if (n13 < -128) {
                                    n13 = -128;
                                }
                                byArray[n6++] = (byte)(n13 + n10);
                                ++n12;
                            }
                            ++n11;
                        }
                    } else {
                        int n14;
                        int n15 = n14 = n4 != 0 ? 0 : 32768;
                        if (n5 == n2) {
                            if (n4 != 0) {
                                int n16 = 0;
                                while (n16 < n8) {
                                    int n17 = nArray2[n16];
                                    int n18 = n16;
                                    int n19 = 0;
                                    while (n19 < n7) {
                                        int n20 = (int)((double)fArray[n16][n17 + n19] * 32768.0 + 0.5);
                                        if (n20 > Short.MAX_VALUE) {
                                            n20 = Short.MAX_VALUE;
                                        } else if (n20 < Short.MIN_VALUE) {
                                            n20 = Short.MIN_VALUE;
                                        }
                                        byArray[n18] = (byte)(n20 >>> 8);
                                        byArray[n18 + 1] = (byte)n20;
                                        n18 += n8 * 2;
                                        ++n19;
                                    }
                                    ++n16;
                                }
                            } else {
                                int n21 = 0;
                                while (n21 < n8) {
                                    float[] fArray2 = fArray[n21];
                                    int n22 = n21;
                                    int n23 = 0;
                                    while (n23 < n7) {
                                        int n24 = (int)((double)fArray2[n23] * 32768.0 + 0.5);
                                        if (n24 > Short.MAX_VALUE) {
                                            n24 = Short.MAX_VALUE;
                                        } else if (n24 < Short.MIN_VALUE) {
                                            n24 = Short.MIN_VALUE;
                                        }
                                        byArray[n22] = (byte)(n24 + n14 >>> 8);
                                        byArray[n22 + 1] = (byte)(n24 + n14);
                                        n22 += n8 * 2;
                                        ++n23;
                                    }
                                    ++n21;
                                }
                            }
                        } else if (n2 != 0) {
                            int n25 = 0;
                            while (n25 < n7) {
                                int n26 = 0;
                                while (n26 < n8) {
                                    int n27 = (int)((double)fArray[n26][n25] * 32768.0 + 0.5);
                                    if (n27 > Short.MAX_VALUE) {
                                        n27 = Short.MAX_VALUE;
                                    } else if (n27 < Short.MIN_VALUE) {
                                        n27 = Short.MIN_VALUE;
                                    }
                                    byArray[n6++] = (byte)((n27 += n14) >>> 8);
                                    byArray[n6++] = (byte)n27;
                                    ++n26;
                                }
                                ++n25;
                            }
                        } else {
                            int n28 = 0;
                            while (n28 < n7) {
                                int n29 = 0;
                                while (n29 < n8) {
                                    int n30 = (int)((double)fArray[n29][n28] * 32768.0 + 0.5);
                                    if (n30 > Short.MAX_VALUE) {
                                        n30 = Short.MAX_VALUE;
                                    } else if (n30 < Short.MIN_VALUE) {
                                        n30 = Short.MIN_VALUE;
                                    }
                                    byArray[n6++] = (byte)(n30 += n14);
                                    byArray[n6++] = (byte)(n30 >>> 8);
                                    ++n29;
                                }
                                ++n28;
                            }
                        }
                    }
                    this.vd.synthesis_read(n7);
                    this.pcm_offset += (long)n7;
                    if (nArray != null) {
                        nArray[0] = this.current_link;
                    }
                    return n7 * n9;
                }
            }
            switch (this.process_packet(1)) {
                case 0: {
                    return 0;
                }
                case -1: {
                    return -1;
                }
            }
        }
    }

    public Info[] getInfo() {
        return this.vi;
    }

    public Comment[] getComment() {
        return this.vc;
    }

    public static void main(String[] stringArray) {
        try {
            VorbisFile vorbisFile = new VorbisFile(stringArray[0]);
            int n = vorbisFile.streams();
            System.out.println("links=" + n);
            Comment[] commentArray = vorbisFile.getComment();
            Info[] infoArray = vorbisFile.getInfo();
            int n2 = 0;
            while (n2 < n) {
                System.out.println(infoArray[n2]);
                System.out.println(commentArray[n2]);
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }
}

